/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdMapTypePtr;
import org.clank.java.stdimpl.aliases.StdMapUIntType;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.DenseMapInfoPairUIntUInt;
import org.llvm.adt.SetVector;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapInfo$LikePtr;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.adt.aliases.DenseMapUIntType;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapBool;
import org.llvm.adt.aliases.StringMapEntryBool;
import org.llvm.adt.aliases.StringMapIteratorBool;
import org.llvm.adt.aliases.StringMapUInt;
import org.llvm.adt.java.ADTRTTI;
import org.llvm.mc.CodeViewContext;
import org.llvm.mc.MCAsmInfo;
import org.llvm.mc.MCCVLoc;
import org.llvm.mc.MCContextGlobals;
import org.llvm.mc.MCDwarfFile;
import org.llvm.mc.MCDwarfLineTable;
import org.llvm.mc.MCDwarfLoc;
import org.llvm.mc.MCGenDwarfLabelEntry;
import org.llvm.mc.MCLabel;
import org.llvm.mc.MCObjectFileInfo;
import org.llvm.mc.MCRegisterInfo;
import org.llvm.mc.MCSection;
import org.llvm.mc.MCSectionCOFF;
import org.llvm.mc.MCSectionELF;
import org.llvm.mc.MCSectionMachO;
import org.llvm.mc.MCStreamer;
import org.llvm.mc.MCSubtargetInfo;
import org.llvm.mc.MCSymbol;
import org.llvm.mc.MCSymbolCOFF;
import org.llvm.mc.MCSymbolELF;
import org.llvm.mc.MCSymbolMachO;
import org.llvm.mc.SectionKind;
import org.llvm.mc.impl.MCContextStatics;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.COFF;
import org.llvm.support.SMLoc;
import org.llvm.support.SourceMgr;
import org.llvm.support.SpecificBumpPtrAllocator;
import org.llvm.support.llvm;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_svector_ostream;
import org.llvm.support.sys.sys;

public class MCContext
implements Destructors.ClassWithDestructor {
    private SourceMgr SrcMgr;
    private MCAsmInfo MAI;
    private MCRegisterInfo MRI;
    private MCObjectFileInfo MOFI;
    private std_ptr.unique_ptr<CodeViewContext> CVContext;
    private BumpPtrAllocatorImpl Allocator;
    private SpecificBumpPtrAllocator<MCSectionCOFF> COFFAllocator;
    private SpecificBumpPtrAllocator<MCSectionELF> ELFAllocator;
    private SpecificBumpPtrAllocator<MCSectionMachO> MachOAllocator;
    private StringMap<MCSymbol> Symbols;
    private DenseMap<MCSectionELF, MCSymbolELF> SectionSymbols;
    private DenseMap<std_pair.pairUIntUInt, MCSymbol> LocalSymbols;
    private StringMapBool UsedNames;
    private StringMapUInt NextID;
    private DenseMapUIntType<MCLabel> Instances;
    private char.ptr SecureLogFile;
    private std_ptr.unique_ptr<raw_fd_ostream> SecureLog;
    private boolean SecureLogUsed;
    private SmallString CompilationDir;
    private std.string MainFileName;
    private std_map.mapUIntType<MCDwarfLineTable> MCDwarfLineTablesCUMap;
    private MCDwarfLoc CurrentDwarfLoc;
    private boolean DwarfLocSeen;
    private MCCVLoc CurrentCVLoc;
    private boolean CVLocSeen;
    private boolean GenDwarfForAssembly;
    private int GenDwarfFileNumber;
    private SetVector<MCSection> SectionsForRanges;
    private std.vector<MCGenDwarfLabelEntry> MCGenDwarfLabelEntries;
    private StringRef DwarfDebugFlags;
    private StringRef DwarfDebugProducer;
    private char DwarfVersion;
    private boolean AllowTemporaryLabels;
    private boolean UseNamesOnTempLabels;
    private int DwarfCompileUnitID;
    private StringMap<MCSectionMachO> MachOUniquingMap;
    private std_map.mapTypePtr<ELFSectionKey, MCSectionELF> ELFUniquingMap;
    private std_map.mapTypePtr<COFFSectionKey, MCSectionCOFF> COFFUniquingMap;
    private StringMapBool ELFRelSecNames;
    private SpecificBumpPtrAllocator<MCSubtargetInfo> MCSubtargetAllocator;
    private boolean AutoReset;
    private boolean HadError;
    public static final int GenericSectionID = -1;

    protected MCContext(MCContext $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    protected MCContext $assign(MCContext $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private int NextInstance(int LocalLabelVal) {
        type.ref Label = this.Instances.ref$at(LocalLabelVal);
        if (Label.$deref() == null) {
            Label.$set((Object)((MCLabel)MCContextGlobals.$new_uint_MCContext_uint(this, New$Mem -> new MCLabel(0))));
        }
        return ((MCLabel)Label.$deref()).incInstance();
    }

    private int GetInstance(int LocalLabelVal) {
        type.ref Label = this.Instances.ref$at(LocalLabelVal);
        if (Label.$deref() == null) {
            Label.$set((Object)((MCLabel)MCContextGlobals.$new_uint_MCContext_uint(this, New$Mem -> new MCLabel(0))));
        }
        return ((MCLabel)Label.$deref()).getInstance();
    }

    private MCSymbol createSymbolImpl(StringMapEntryBool Name2, boolean IsTemporary) {
        if (this.MOFI != null) {
            switch (this.MOFI.getObjectFileType()) {
                case IsCOFF: {
                    return (MCSymbol)MCSymbol.$new(Name2, this, New$Mem -> new MCSymbolCOFF(Name2, IsTemporary));
                }
                case IsELF: {
                    return (MCSymbol)MCSymbol.$new(Name2, this, New$Mem -> new MCSymbolELF(Name2, IsTemporary));
                }
                case IsMachO: {
                    return (MCSymbol)MCSymbol.$new(Name2, this, New$Mem -> new MCSymbolMachO(Name2, IsTemporary));
                }
            }
        }
        return (MCSymbol)MCSymbol.$new(Name2, this, New$Mem -> new MCSymbol(MCSymbol.SymbolKind.SymbolKindUnset, Name2, IsTemporary));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MCSymbol createSymbol(StringRef Name2, boolean AlwaysAddSuffix, boolean CanBeUnnamed) {
        if (CanBeUnnamed && !this.UseNamesOnTempLabels) {
            return this.createSymbolImpl(null, true);
        }
        boolean IsTemporary = CanBeUnnamed;
        if (this.AllowTemporaryLabels && !IsTemporary) {
            IsTemporary = Name2.startswith(this.MAI.getPrivateGlobalPrefix());
        }
        SmallString NewName = new SmallString(new StringRef(Name2), 128);
        boolean AddSuffix = AlwaysAddSuffix;
        uint.ref NextUniqueID = this.NextID.ref$at(Name2);
        while (true) {
            if (AddSuffix) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    NewName.resize(Name2.size());
                    $c$.clean((Object)((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(NewName))).$out_uint(NextUniqueID.$set$postInc()));
                }
                finally {
                    $c$.$destroy();
                }
            }
            std_pair.pairTypeBool<StringMapIteratorBool> NameEntry = this.UsedNames.insert((std_pair.pairTypeBool<StringRef>)new std_pair.pairTypeBool(JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)new SmallString(NewName).$StringRef(), true));
            if (NameEntry.second || !((StringMapIteratorBool)NameEntry.first).$arrow().second) {
                ((StringMapIteratorBool)NameEntry.first).$arrow().second = true;
                return this.createSymbolImpl((StringMapEntryBool)Native.$AddrOf((Object)((StringMapIteratorBool)NameEntry.first).$star()), IsTemporary);
            }
            assert (IsTemporary) : "Cannot rename non-temporary symbols";
            AddSuffix = true;
        }
    }

    private MCSymbol getOrCreateDirectionalLocalSymbol(int LocalLabelVal, int Instance) {
        type.ref Sym = this.LocalSymbols.ref$at(std.make_pair_uint_uint((int)LocalLabelVal, (int)Instance));
        if (Sym.$deref() == null) {
            Sym.$set((Object)this.createTempSymbol(false));
        }
        return (MCSymbol)Sym.$deref();
    }

    public MCContext(MCAsmInfo mai, MCRegisterInfo mri, MCObjectFileInfo mofi) {
        this(mai, mri, mofi, null, true);
    }

    public MCContext(MCAsmInfo mai, MCRegisterInfo mri, MCObjectFileInfo mofi, SourceMgr mgr) {
        this(mai, mri, mofi, mgr, true);
    }

    public MCContext(MCAsmInfo mai, MCRegisterInfo mri, MCObjectFileInfo mofi, SourceMgr mgr, boolean DoAutoReset) {
        this.SrcMgr = mgr;
        this.MAI = mai;
        this.MRI = mri;
        this.MOFI = mofi;
        this.CVContext = new std_ptr.unique_ptr();
        this.Allocator = new BumpPtrAllocatorImpl();
        this.COFFAllocator = new SpecificBumpPtrAllocator<MCSectionCOFF>(MCSectionCOFF.class);
        this.ELFAllocator = new SpecificBumpPtrAllocator<MCSectionELF>(MCSectionELF.class);
        this.MachOAllocator = new SpecificBumpPtrAllocator<MCSectionMachO>(MCSectionMachO.class);
        this.Symbols = new StringMap<MCSymbol>(this.Allocator, new MCSymbol());
        this.SectionSymbols = new DenseMap(DenseMapInfo$LikePtr.$Info(), (MCSymbolELF)null);
        this.LocalSymbols = new DenseMap<std_pair.pairUIntUInt, MCSymbol>(DenseMapInfoPairUIntUInt.$Info(), (MCSymbol)null);
        this.UsedNames = new StringMapBool(new BumpPtrAllocatorImpl(this.Allocator), false);
        this.NextID = new StringMapUInt(0);
        this.Instances = new DenseMapUIntType<MCLabel>(DenseMapInfoUInt.$Info(), (MCLabel)null);
        this.SecureLog = new std_ptr.unique_ptr();
        this.CompilationDir = new SmallString(128);
        this.MainFileName = new std.string();
        this.MCDwarfLineTablesCUMap = new std_map.mapUIntType((Object)new MCDwarfLineTable());
        this.CurrentDwarfLoc = new MCDwarfLoc(0, 0, 0, 1, 0, 0);
        this.DwarfLocSeen = false;
        this.CurrentCVLoc = new MCCVLoc(0, 0, 0, '\u0000', false, true);
        this.CVLocSeen = false;
        this.GenDwarfForAssembly = false;
        this.GenDwarfFileNumber = 0;
        this.SectionsForRanges = new SetVector<MCSection>((MCSection)null);
        this.MCGenDwarfLabelEntries = new std.vector((Object)new MCGenDwarfLabelEntry());
        this.DwarfDebugFlags = new StringRef();
        this.DwarfDebugProducer = new StringRef();
        this.DwarfVersion = Unsigned.$int2ushort((int)4);
        this.AllowTemporaryLabels = true;
        this.UseNamesOnTempLabels = true;
        this.DwarfCompileUnitID = 0;
        this.MachOUniquingMap = new StringMap<MCSectionMachO>((MCSectionMachO)null);
        this.ELFUniquingMap = new std_map.mapTypePtr();
        this.COFFUniquingMap = new std_map.mapTypePtr();
        this.ELFRelSecNames = new StringMapBool(false);
        this.MCSubtargetAllocator = new SpecificBumpPtrAllocator<MCSubtargetInfo>(MCSubtargetInfo.class);
        this.AutoReset = DoAutoReset;
        this.HadError = false;
        this.SecureLogFile = Native.$tryClone((char.ptr)((char.ptr)MCContextStatics.AsSecureLogFileName.$T()));
        this.SecureLog.$assign_nullptr_t(null);
        this.SecureLogUsed = false;
        if (this.SrcMgr != null && this.SrcMgr.getNumBuffers() != 0) {
            this.MainFileName.$assign_T$C$P(this.SrcMgr.getMemoryBuffer(this.SrcMgr.getMainFileID()).getBufferIdentifier());
        }
    }

    public void $destroy() {
        if (this.AutoReset) {
            this.reset();
        }
        this.MCSubtargetAllocator.$destroy();
        this.ELFRelSecNames.$destroy();
        this.COFFUniquingMap.$destroy();
        this.ELFUniquingMap.$destroy();
        this.MachOUniquingMap.$destroy();
        this.MCGenDwarfLabelEntries.$destroy();
        this.SectionsForRanges.$destroy();
        this.MCDwarfLineTablesCUMap.$destroy();
        this.MainFileName.$destroy();
        this.CompilationDir.$destroy();
        this.SecureLog.$destroy();
        this.Instances.$destroy();
        this.NextID.$destroy();
        this.UsedNames.$destroy();
        this.LocalSymbols.$destroy();
        this.SectionSymbols.$destroy();
        this.Symbols.$destroy();
        this.MachOAllocator.$destroy();
        this.ELFAllocator.$destroy();
        this.COFFAllocator.$destroy();
        this.Allocator.$destroy();
        this.CVContext.$destroy();
    }

    public SourceMgr getSourceManager() {
        return this.SrcMgr;
    }

    public MCAsmInfo getAsmInfo() {
        return this.MAI;
    }

    public MCRegisterInfo getRegisterInfo() {
        return this.MRI;
    }

    public MCObjectFileInfo getObjectFileInfo() {
        return this.MOFI;
    }

    public CodeViewContext getCVContext() {
        if (this.CVContext.get() == null) {
            this.CVContext.reset((Object)new CodeViewContext());
        }
        return (CodeViewContext)Native.$Deref((Object)((CodeViewContext)this.CVContext.get()));
    }

    public void setAllowTemporaryLabels(boolean Value) {
        this.AllowTemporaryLabels = Value;
    }

    public void setUseNamesOnTempLabels(boolean Value) {
        this.UseNamesOnTempLabels = Value;
    }

    public void reset() {
        this.COFFAllocator.DestroyAll();
        this.ELFAllocator.DestroyAll();
        this.MachOAllocator.DestroyAll();
        this.MCSubtargetAllocator.DestroyAll();
        this.UsedNames.clear();
        this.Symbols.clear();
        this.SectionSymbols.clear();
        this.Allocator.Reset();
        this.Instances.clear();
        this.CompilationDir.clear();
        this.MainFileName.clear();
        this.MCDwarfLineTablesCUMap.clear();
        this.SectionsForRanges.clear();
        this.MCGenDwarfLabelEntries.clear();
        this.DwarfDebugFlags.$assignMove(new StringRef());
        this.DwarfCompileUnitID = 0;
        this.CurrentDwarfLoc.$assignMove(new MCDwarfLoc(0, 0, 0, 1, 0, 0));
        this.CVContext.reset();
        this.MachOUniquingMap.clear();
        this.ELFUniquingMap.clear();
        this.COFFUniquingMap.clear();
        this.NextID.clear();
        this.AllowTemporaryLabels = true;
        this.DwarfLocSeen = false;
        this.GenDwarfForAssembly = false;
        this.GenDwarfFileNumber = 0;
        this.HadError = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCSymbol createLinkerPrivateTempSymbol() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            SmallString NameSV = new SmallString(128);
            $c$.clean((Object)((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(NameSV))).$out(this.MAI.getLinkerPrivateGlobalPrefix()).$out("tmp"));
            MCSymbol mCSymbol = this.createSymbol(NameSV.$StringRef(), true, false);
            return mCSymbol;
        }
        finally {
            $c$.$destroy();
        }
    }

    public MCSymbol createTempSymbol() {
        return this.createTempSymbol(true);
    }

    public MCSymbol createTempSymbol(boolean CanBeUnnamed) {
        return this.createTempSymbol(new Twine("tmp"), true, CanBeUnnamed);
    }

    public MCSymbol createTempSymbol(Twine Name2, boolean AlwaysAddSuffix) {
        return this.createTempSymbol(Name2, AlwaysAddSuffix, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCSymbol createTempSymbol(Twine Name2, boolean AlwaysAddSuffix, boolean CanBeUnnamed) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            SmallString NameSV = new SmallString(128);
            $c$.clean((Object)llvm.$out_raw_ostream_Twine$C(((raw_svector_ostream)$c$.track((Object)new raw_svector_ostream(NameSV))).$out(this.MAI.getPrivateGlobalPrefix()), Name2));
            MCSymbol mCSymbol = this.createSymbol(NameSV.$StringRef(), AlwaysAddSuffix, CanBeUnnamed);
            return mCSymbol;
        }
        finally {
            $c$.$destroy();
        }
    }

    public MCSymbol createDirectionalLocalSymbol(int LocalLabelVal) {
        int Instance = this.NextInstance(LocalLabelVal);
        return this.getOrCreateDirectionalLocalSymbol(LocalLabelVal, Instance);
    }

    public MCSymbol getDirectionalLocalSymbol(int LocalLabelVal, boolean Before) {
        int Instance = this.GetInstance(LocalLabelVal);
        if (!Before) {
            ++Instance;
        }
        return this.getOrCreateDirectionalLocalSymbol(LocalLabelVal, Instance);
    }

    public MCSymbol getOrCreateSymbol(Twine Name2) {
        SmallString NameSV = new SmallString(128);
        StringRef NameRef = Name2.toStringRef(NameSV);
        assert (!NameRef.empty()) : "Normal symbols cannot be unnamed!";
        type.ref<MCSymbol> Sym = this.Symbols.ref$at(NameRef);
        if (Sym.$deref() == null) {
            Sym.$set((Object)this.createSymbol(new StringRef(NameRef), false, false));
        }
        return (MCSymbol)Sym.$deref();
    }

    public MCSymbolELF getOrCreateSectionSymbol(MCSectionELF Section) {
        type.ref Sym = this.SectionSymbols.ref$at((MCSectionELF)Native.$AddrOf((Object)Section));
        if (Sym.$deref() != null) {
            return (MCSymbolELF)Sym.$deref();
        }
        StringRef Name2 = Section.getSectionName();
        StringMapIteratorBool NameIter = new StringMapIteratorBool(JavaDifferentiators.JD.Move.INSTANCE, (StringMapIteratorBool)this.UsedNames.insert((std_pair.pairTypeBool<StringRef>)std.make_pair_T_bool((Object)((StringRef)Native.$Clone((NativeCloneable)Name2)), (boolean)false)).first);
        Sym.$set((Object)((MCSymbolELF)MCSymbol.$new((StringMapEntryBool)Native.$AddrOf((Object)NameIter.$star()), this, New$Mem -> new MCSymbolELF((StringMapEntryBool)Native.$AddrOf((Object)NameIter.$star()), false))));
        return (MCSymbolELF)Sym.$deref();
    }

    public MCSymbol getOrCreateFrameAllocSymbol(StringRef FuncName, int Idx) {
        return this.getOrCreateSymbol(llvm.$add_Twine$C(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine(this.MAI.getPrivateGlobalPrefix()), new Twine(FuncName)), new Twine("$frame_escape_")), new Twine(JavaDifferentiators.JD.UInt.INSTANCE, Idx)));
    }

    public MCSymbol getOrCreateParentFrameOffsetSymbol(StringRef FuncName) {
        return this.getOrCreateSymbol(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine(this.MAI.getPrivateGlobalPrefix()), new Twine(FuncName)), new Twine("$parent_frame_offset")));
    }

    public MCSymbol getOrCreateLSDASymbol(StringRef FuncName) {
        return this.getOrCreateSymbol(llvm.$add_Twine$C(llvm.$add_Twine$C(new Twine(this.MAI.getPrivateGlobalPrefix()), new Twine("__ehtable$")), new Twine(FuncName)));
    }

    public MCSymbol lookupSymbol(Twine Name2) {
        SmallString NameSV = new SmallString(128);
        StringRef NameRef = Name2.toStringRef(NameSV);
        return this.Symbols.lookup(new StringRef(NameRef));
    }

    public StringMap<MCSymbol> getSymbols() {
        return this.Symbols;
    }

    public MCSectionMachO getMachOSection(StringRef Segment, StringRef Section, int TypeAndAttributes, int Reserved2, SectionKind Kind2) {
        return this.getMachOSection(Segment, Section, TypeAndAttributes, Reserved2, Kind2, null);
    }

    public MCSectionMachO getMachOSection(StringRef Segment, StringRef Section, int TypeAndAttributes, int Reserved2, SectionKind Kind2, char.ptr BeginSymName) {
        SmallString Name2 = new SmallString(64);
        Name2.$addassign(Segment);
        Name2.push_back((byte)44);
        Name2.$addassign(Section);
        type.ref<MCSectionMachO> Entry2 = this.MachOUniquingMap.ref$at(Name2.$StringRef());
        if (Entry2.$deref() != null) {
            return (MCSectionMachO)Entry2.$deref();
        }
        MCSymbol Begin = null;
        if (Native.$bool((Native.Native$Bool)BeginSymName)) {
            Begin = this.createTempSymbol(new Twine(BeginSymName), false);
        }
        MCSymbol Begin_final = Begin;
        return (MCSectionMachO)Entry2.$set((Object)((MCSectionMachO)Native.$new_uint_voidPtr(this.MachOAllocator.Allocate(), New$Mem -> new MCSectionMachO(new StringRef(Segment), new StringRef(Section), TypeAndAttributes, Reserved2, new SectionKind(Kind2), Begin_final))));
    }

    public MCSectionMachO getMachOSection(StringRef Segment, StringRef Section, int TypeAndAttributes, SectionKind K) {
        return this.getMachOSection(Segment, Section, TypeAndAttributes, K, (char.ptr)null);
    }

    public MCSectionMachO getMachOSection(StringRef Segment, StringRef Section, int TypeAndAttributes, SectionKind K, char.ptr BeginSymName) {
        return this.getMachOSection(new StringRef(Segment), new StringRef(Section), TypeAndAttributes, 0, new SectionKind(K), BeginSymName);
    }

    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags) {
        return this.getELFSection(Section, Type2, Flags, null);
    }

    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags, char.ptr BeginSymName) {
        return this.getELFSection(Section, Type2, Flags, 0, new Twine(NativePointer.$EMPTY), BeginSymName);
    }

    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags, int EntrySize, Twine Group) {
        return this.getELFSection(Section, Type2, Flags, EntrySize, Group, null);
    }

    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags, int EntrySize, Twine Group, char.ptr BeginSymName) {
        return this.getELFSection(Section, Type2, Flags, EntrySize, Group, -1, BeginSymName);
    }

    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags, int EntrySize, Twine Group, int UniqueID2) {
        return this.getELFSection(Section, Type2, Flags, EntrySize, Group, UniqueID2, null);
    }

    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags, int EntrySize, Twine Group, int UniqueID2, char.ptr BeginSymName) {
        MCSymbolELF GroupSym = null;
        if (!Group.isTriviallyEmpty() && !Group.str().empty()) {
            GroupSym = ADTRTTI.cast_MCSymbolELF(this.getOrCreateSymbol(Group));
        }
        return this.getELFSection(Section, Type2, Flags, EntrySize, GroupSym, UniqueID2, BeginSymName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCSectionELF getELFSection(Twine Section, int Type2, int Flags, int EntrySize, MCSymbolELF GroupSym, int UniqueID2, char.ptr BeginSymName, MCSectionELF Associated) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            StringRef Group = new StringRef(NativePointer.$EMPTY);
            if (GroupSym != null) {
                Group.$assignMove(GroupSym.getName());
            }
            std_pair.pairTypeBool IterBool = (std_pair.pairTypeBool)$c$.clean((Object)this.ELFUniquingMap.insert$T((std_pair.pairTypePtr)$c$.track((Object)std.make_pair_T_nullptr_t((Object)((ELFSectionKey)Native.$Move((NativeMoveable)((ELFSectionKey)$c$.track((Object)new ELFSectionKey(new StringRef(Section.str()), new StringRef(Group), UniqueID2))))), null))));
            std_pair.pairTypePtr Entry2 = ((StdMapTypePtr.iterator)IterBool.first).$star();
            if (!IterBool.second) {
                MCSectionELF mCSectionELF = (MCSectionELF)Entry2.second;
                return mCSectionELF;
            }
            StringRef CachedName = new StringRef(((ELFSectionKey)Entry2.first).SectionName);
            SectionKind Kind2 = new SectionKind();
            if ((Flags & 4) != 0) {
                Kind2.$assignMove(SectionKind.getText());
            } else {
                Kind2.$assignMove(SectionKind.getReadOnly());
            }
            MCSymbol Begin = null;
            if (Native.$bool((Native.Native$Bool)BeginSymName)) {
                Begin = this.createTempSymbol(new Twine(BeginSymName), false);
            }
            MCSymbol Begin_final = Begin;
            MCSectionELF Result = (MCSectionELF)Native.$new_uint_voidPtr(this.ELFAllocator.Allocate(), New$Mem -> new MCSectionELF(new StringRef(CachedName), Type2, Flags, new SectionKind(Kind2), EntrySize, GroupSym, UniqueID2, Begin_final, Associated));
            Entry2.second = Result;
            MCSectionELF mCSectionELF = Result;
            return mCSectionELF;
        }
        finally {
            $c$.$destroy();
        }
    }

    public MCSectionELF getELFNamedSection(Twine Prefix, Twine Suffix, int Type2, int Flags) {
        return this.getELFNamedSection(Prefix, Suffix, Type2, Flags, 0);
    }

    public MCSectionELF getELFNamedSection(Twine Prefix, Twine Suffix, int Type2, int Flags, int EntrySize) {
        return this.getELFSection(llvm.$add_Twine$C(llvm.$add_Twine$C(Prefix, new Twine(NativePointer.$DOT)), Suffix), Type2, Flags, EntrySize, Suffix);
    }

    public MCSectionELF createELFRelSection(Twine Name2, int Type2, int Flags, int EntrySize, MCSymbolELF Group, MCSectionELF Associated) {
        StringMapIteratorBool I = new StringMapIteratorBool();
        std_pair.pairTypeBool<StringMapIteratorBool> insert = this.ELFRelSecNames.insert((std_pair.pairTypeBool<StringRef>)new std_pair.pairTypeBool(JavaDifferentiators.JD$Pair$_U1$_U2.INSTANCE, (Object)new StringRef(new std.string(JavaDifferentiators.JD.Move.INSTANCE, Name2.str())), true));
        I.$assign((StringMapIteratorBool)insert.first);
        boolean Inserted = insert.second;
        return (MCSectionELF)Native.$new_uint_voidPtr(this.ELFAllocator.Allocate(), New$Mem -> new MCSectionELF(I.$arrow().getKey(), Type2, Flags, SectionKind.getReadOnly(), EntrySize, Group, 1, null, Associated));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameELFSection(MCSectionELF Section, StringRef Name2) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            StringRef GroupName = new StringRef();
            MCSymbolELF Group = Section.getGroup();
            if (Group != null) {
                GroupName.$assignMove(Group.getName());
            }
            int UniqueID2 = Section.getUniqueID();
            $c$.clean(this.ELFUniquingMap.erase((Object)((ELFSectionKey)$c$.track((Object)new ELFSectionKey(Section.getSectionName(), new StringRef(GroupName), UniqueID2)))));
            StdMapTypePtr.iterator I = (StdMapTypePtr.iterator)$c$.clean((Object)new StdMapTypePtr.iterator(JavaDifferentiators.JD.Move.INSTANCE, (StdMapTypePtr.iterator)this.ELFUniquingMap.insert$T((std_pair.pairTypePtr)((std_pair.pairTypePtr)$c$.track((Object)std.make_pair_T_Ptr((Object)((ELFSectionKey)Native.$Move((NativeMoveable)((ELFSectionKey)$c$.track((Object)new ELFSectionKey((StringRef)new StringRef((StringRef)Name2), (StringRef)new StringRef((StringRef)GroupName), (int)UniqueID2))))), (Object)Section)))).first));
            StringRef CachedName = new StringRef(((ELFSectionKey)I.$arrow().first).SectionName);
            Section.setSectionName(new StringRef(CachedName));
        }
        finally {
            $c$.$destroy();
        }
    }

    public MCSectionELF createELFGroupSection(MCSymbolELF Group) {
        MCSectionELF Result = (MCSectionELF)Native.$new_uint_voidPtr(this.ELFAllocator.Allocate(), New$Mem -> new MCSectionELF(new StringRef(".group"), 17, 0, SectionKind.getReadOnly(), 4, Group, -1, null, null));
        return Result;
    }

    public MCSectionCOFF getCOFFSection(StringRef Section, int Characteristics2, SectionKind Kind2, StringRef COMDATSymName, int Selection) {
        return this.getCOFFSection(Section, Characteristics2, Kind2, COMDATSymName, Selection, -1, null);
    }

    public MCSectionCOFF getCOFFSection(StringRef Section, int Characteristics2, SectionKind Kind2, StringRef COMDATSymName, int Selection, int UniqueID2) {
        return this.getCOFFSection(Section, Characteristics2, Kind2, COMDATSymName, Selection, UniqueID2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCSectionCOFF getCOFFSection(StringRef Section, int Characteristics2, SectionKind Kind2, StringRef COMDATSymName, int Selection, int UniqueID2, char.ptr BeginSymName) {
        COFFSectionKey T4 = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            MCSymbol COMDATSymbol = null;
            if (!COMDATSymName.empty()) {
                COMDATSymbol = this.getOrCreateSymbol(new Twine(COMDATSymName));
                COMDATSymName.$assignMove(COMDATSymbol.getName());
            }
            T4 = new COFFSectionKey(new StringRef(Section), new StringRef(COMDATSymName), Selection, UniqueID2);
            std_pair.pairTypeBool IterBool = (std_pair.pairTypeBool)$c$.clean((Object)this.COFFUniquingMap.insert$T((std_pair.pairTypePtr)$c$.track((Object)std.make_pair_T_nullptr_t((Object)((COFFSectionKey)Native.$Clone((NativeCloneable)T4)), null))));
            StdMapTypePtr.iterator Iter = new StdMapTypePtr.iterator((StdMapTypePtr.iterator)IterBool.first);
            if (!IterBool.second) {
                MCSectionCOFF mCSectionCOFF = (MCSectionCOFF)Iter.$arrow().second;
                return mCSectionCOFF;
            }
            MCSymbol Begin = null;
            if (Native.$bool((Native.Native$Bool)BeginSymName)) {
                Begin = this.createTempSymbol(new Twine(BeginSymName), false);
            }
            StringRef CachedName = new StringRef(((COFFSectionKey)Iter.$arrow().first).SectionName);
            MCSymbol Begin_final = Begin;
            MCSymbol COMDATSymbol_final = COMDATSymbol;
            MCSectionCOFF Result = (MCSectionCOFF)Native.$new_uint_voidPtr(this.COFFAllocator.Allocate(), New$Mem -> new MCSectionCOFF(new StringRef(CachedName), Characteristics2, COMDATSymbol_final, Selection, new SectionKind(Kind2), Begin_final));
            Iter.$arrow().second = Result;
            MCSectionCOFF mCSectionCOFF = Result;
            return mCSectionCOFF;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
            $c$.$destroy();
        }
    }

    public MCSectionCOFF getCOFFSection(StringRef Section, int Characteristics2, SectionKind Kind2) {
        return this.getCOFFSection(Section, Characteristics2, Kind2, null);
    }

    public MCSectionCOFF getCOFFSection(StringRef Section, int Characteristics2, SectionKind Kind2, char.ptr BeginSymName) {
        return this.getCOFFSection(new StringRef(Section), Characteristics2, new SectionKind(Kind2), new StringRef(NativePointer.$EMPTY), 0, -1, BeginSymName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MCSectionCOFF getCOFFSection(StringRef Section) {
        COFFSectionKey T4 = null;
        try {
            T4 = new COFFSectionKey(new StringRef(Section), new StringRef(NativePointer.$EMPTY), 0, -1);
            StdMapTypePtr.iterator Iter = this.COFFUniquingMap.find((Object)T4);
            if (Iter.$eq((Object)this.COFFUniquingMap.end())) {
                MCSectionCOFF mCSectionCOFF = null;
                return mCSectionCOFF;
            }
            MCSectionCOFF mCSectionCOFF = (MCSectionCOFF)Iter.$arrow().second;
            return mCSectionCOFF;
        }
        finally {
            if (T4 != null) {
                T4.$destroy();
            }
        }
    }

    public MCSectionCOFF getAssociativeCOFFSection(MCSectionCOFF Sec, MCSymbol KeySym) {
        return this.getAssociativeCOFFSection(Sec, KeySym, -1);
    }

    public MCSectionCOFF getAssociativeCOFFSection(MCSectionCOFF Sec, MCSymbol KeySym, int UniqueID2) {
        if (KeySym == null && UniqueID2 == -1) {
            return Sec;
        }
        int Characteristics2 = Sec.getCharacteristics();
        if (KeySym != null) {
            return this.getCOFFSection(Sec.getSectionName(), Characteristics2 |= 0x1000, Sec.getKind(), KeySym.getName(), COFF.COMDATType.IMAGE_COMDAT_SELECT_ASSOCIATIVE.getValue(), UniqueID2);
        }
        return this.getCOFFSection(Sec.getSectionName(), Characteristics2, Sec.getKind(), new StringRef(NativePointer.$EMPTY), 0, UniqueID2);
    }

    public MCSubtargetInfo getSubtargetCopy(MCSubtargetInfo STI) {
        return (MCSubtargetInfo)Native.$Deref((Object)((MCSubtargetInfo)Native.$new_uint_voidPtr(this.MCSubtargetAllocator.Allocate(), New$Mem -> new MCSubtargetInfo(STI))));
    }

    public StringRef getCompilationDir() {
        return this.CompilationDir.$StringRef();
    }

    public void setCompilationDir(StringRef S2) {
        this.CompilationDir.$assign(new StringRef(S2.str()));
    }

    public std.string getMainFileName() {
        return this.MainFileName;
    }

    public void setMainFileName(StringRef S2) {
        this.MainFileName.$assignMove(S2.$string());
    }

    public int getDwarfFile(StringRef Directory, StringRef FileName, int FileNumber, int CUID) {
        MCDwarfLineTable Table = (MCDwarfLineTable)this.MCDwarfLineTablesCUMap.$at_T$C$R(Integer.valueOf(CUID));
        return Table.getFile(Directory, FileName, FileNumber);
    }

    public boolean isValidDwarfFileNumber(int FileNumber) {
        return this.isValidDwarfFileNumber(FileNumber, 0);
    }

    public boolean isValidDwarfFileNumber(int FileNumber, int CUID) {
        SmallVectorImpl<MCDwarfFile> MCDwarfFiles = this.getMCDwarfFiles(CUID);
        if (FileNumber == 0 || Unsigned.$greatereq_uint((int)FileNumber, (int)MCDwarfFiles.size())) {
            return false;
        }
        return !MCDwarfFiles.$at$Const((int)FileNumber).Name.empty();
    }

    public std_map.mapUIntType<MCDwarfLineTable> getMCDwarfLineTables() {
        return this.MCDwarfLineTablesCUMap;
    }

    public MCDwarfLineTable getMCDwarfLineTable(int CUID) {
        return (MCDwarfLineTable)this.MCDwarfLineTablesCUMap.$at_T$C$R(Integer.valueOf(CUID));
    }

    public MCDwarfLineTable getMCDwarfLineTable$Const(int CUID) {
        StdMapUIntType.iterator I = this.MCDwarfLineTablesCUMap.find$Const(Integer.valueOf(CUID));
        assert (I.$noteq((Object)this.MCDwarfLineTablesCUMap.end$Const()));
        return (MCDwarfLineTable)I.$arrow().second;
    }

    public SmallVectorImpl<MCDwarfFile> getMCDwarfFiles() {
        return this.getMCDwarfFiles(0);
    }

    public SmallVectorImpl<MCDwarfFile> getMCDwarfFiles(int CUID) {
        return this.getMCDwarfLineTable(CUID).getMCDwarfFiles();
    }

    public SmallVectorImpl<std.string> getMCDwarfDirs() {
        return this.getMCDwarfDirs(0);
    }

    public SmallVectorImpl<std.string> getMCDwarfDirs(int CUID) {
        return this.getMCDwarfLineTable(CUID).getMCDwarfDirs();
    }

    public boolean hasMCLineSections() {
        for (std_pair.pairUIntType Table : this.MCDwarfLineTablesCUMap) {
            if (((MCDwarfLineTable)Table.second).getMCDwarfFiles$Const().empty() && ((MCDwarfLineTable)Table.second).getLabel() == null) continue;
            return true;
        }
        return false;
    }

    public int getDwarfCompileUnitID() {
        return this.DwarfCompileUnitID;
    }

    public void setDwarfCompileUnitID(int CUIndex) {
        this.DwarfCompileUnitID = CUIndex;
    }

    public void setMCLineTableCompilationDir(int CUID, StringRef CompilationDir) {
        this.getMCDwarfLineTable(CUID).setCompilationDir(new StringRef(CompilationDir));
    }

    public void setCurrentDwarfLoc(int FileNum, int Line, int Column, int Flags, int Isa, int Discriminator) {
        this.CurrentDwarfLoc.setFileNum(FileNum);
        this.CurrentDwarfLoc.setLine(Line);
        this.CurrentDwarfLoc.setColumn(Column);
        this.CurrentDwarfLoc.setFlags(Flags);
        this.CurrentDwarfLoc.setIsa(Isa);
        this.CurrentDwarfLoc.setDiscriminator(Discriminator);
        this.DwarfLocSeen = true;
    }

    public void clearDwarfLocSeen() {
        this.DwarfLocSeen = false;
    }

    public boolean getDwarfLocSeen() {
        return this.DwarfLocSeen;
    }

    public MCDwarfLoc getCurrentDwarfLoc() {
        return this.CurrentDwarfLoc;
    }

    public boolean getGenDwarfForAssembly() {
        return this.GenDwarfForAssembly;
    }

    public void setGenDwarfForAssembly(boolean Value) {
        this.GenDwarfForAssembly = Value;
    }

    public int getGenDwarfFileNumber() {
        return this.GenDwarfFileNumber;
    }

    public void setGenDwarfFileNumber(int FileNumber) {
        this.GenDwarfFileNumber = FileNumber;
    }

    public SetVector<MCSection> getGenDwarfSectionSyms() {
        return this.SectionsForRanges;
    }

    public boolean addGenDwarfSection(MCSection Sec) {
        return this.SectionsForRanges.insert(Sec);
    }

    public void finalizeDwarfSections(MCStreamer MCOS) {
        this.SectionsForRanges.remove_if((NativeCallback.BoolPredicate<MCSection>)((NativeCallback.BoolPredicate)Sec -> !MCOS.mayHaveInstructions((MCSection)Native.$Deref((Object)Sec))));
    }

    public std.vector<MCGenDwarfLabelEntry> getMCGenDwarfLabelEntries() {
        return this.MCGenDwarfLabelEntries;
    }

    public void addMCGenDwarfLabelEntry(MCGenDwarfLabelEntry E) {
        this.MCGenDwarfLabelEntries.push_back_T$C$R((Object)E);
    }

    public void setDwarfDebugFlags(StringRef S2) {
        this.DwarfDebugFlags.$assign(S2);
    }

    public StringRef getDwarfDebugFlags() {
        return new StringRef(this.DwarfDebugFlags);
    }

    public void setDwarfDebugProducer(StringRef S2) {
        this.DwarfDebugProducer.$assign(S2);
    }

    public StringRef getDwarfDebugProducer() {
        return new StringRef(this.DwarfDebugProducer);
    }

    public void setDwarfVersion(char v) {
        this.DwarfVersion = v;
    }

    public char getDwarfVersion() {
        return this.DwarfVersion;
    }

    public int getCVFile(StringRef FileName, int FileNumber) {
        return this.getCVContext().addFile(FileNumber, new StringRef(FileName)) ? FileNumber : 0;
    }

    public void setCurrentCVLoc(int FunctionId, int FileNo, int Line, int Column, boolean PrologueEnd, boolean IsStmt) {
        this.CurrentCVLoc.setFunctionId(FunctionId);
        this.CurrentCVLoc.setFileNum(FileNo);
        this.CurrentCVLoc.setLine(Line);
        this.CurrentCVLoc.setColumn(Column);
        this.CurrentCVLoc.setPrologueEnd(PrologueEnd);
        this.CurrentCVLoc.setIsStmt(IsStmt);
        this.CVLocSeen = true;
    }

    public void clearCVLocSeen() {
        this.CVLocSeen = false;
    }

    public boolean getCVLocSeen() {
        return this.CVLocSeen;
    }

    public MCCVLoc getCurrentCVLoc() {
        return this.CurrentCVLoc;
    }

    public boolean isValidCVFileNumber(int FileNumber) {
        return this.getCVContext().isValidFileNumber(FileNumber);
    }

    public char.ptr getSecureLogFile() {
        return this.SecureLogFile;
    }

    public raw_fd_ostream getSecureLog() {
        return (raw_fd_ostream)this.SecureLog.get();
    }

    public boolean getSecureLogUsed() {
        return this.SecureLogUsed;
    }

    public void setSecureLog(std_ptr.unique_ptr<raw_fd_ostream> Value) {
        this.SecureLog.$assignMove((std_ptr.unique_ptr)std.move(Value));
    }

    public void setSecureLogUsed(boolean Value) {
        this.SecureLogUsed = Value;
    }

    public Object allocate(int Size) {
        return this.allocate(Size, 8);
    }

    public Object allocate(int Size, int Align) {
        return this.Allocator.Allocate(Size, Align);
    }

    public void deallocate(Object Ptr2) {
    }

    public boolean hadError() {
        return this.HadError;
    }

    public void reportError(SMLoc Loc, Twine Msg) {
        this.HadError = true;
        if (this.SrcMgr == null) {
            llvm.report_fatal_error(Msg, false);
        }
        this.SrcMgr.PrintMessage(new SMLoc(Loc), SourceMgr.DiagKind.DK_Error, Msg);
    }

    public void reportFatalError(SMLoc Loc, Twine Msg) {
        this.reportError(new SMLoc(Loc), Msg);
        sys.RunInterruptHandlers();
        std.exit((int)1);
    }

    public String toString() {
        return "SrcMgr=" + this.SrcMgr + ", MAI=" + this.MAI + ", MRI=" + this.MRI + ", MOFI=" + this.MOFI + ", CVContext=[Unique_ptr$CodeViewContext], Allocator=[BumpPtrAllocatorImpl], COFFAllocator=" + this.COFFAllocator + ", ELFAllocator=" + this.ELFAllocator + ", MachOAllocator=" + this.MachOAllocator + ", Symbols=[StringMap$MCSymbol$BumpPtrAllocatorImpl], SectionSymbols=" + this.SectionSymbols + ", LocalSymbols=" + this.LocalSymbols + ", UsedNames=" + this.UsedNames + ", NextID=" + this.NextID + ", Instances=" + this.Instances + ", SecureLogFile=" + this.SecureLogFile + ", SecureLog=" + this.SecureLog + ", SecureLogUsed=" + this.SecureLogUsed + ", CompilationDir=" + this.CompilationDir + ", MainFileName=" + this.MainFileName + ", MCDwarfLineTablesCUMap=" + this.MCDwarfLineTablesCUMap + ", CurrentDwarfLoc=" + this.CurrentDwarfLoc + ", DwarfLocSeen=" + this.DwarfLocSeen + ", CurrentCVLoc=" + this.CurrentCVLoc + ", CVLocSeen=" + this.CVLocSeen + ", GenDwarfForAssembly=" + this.GenDwarfForAssembly + ", GenDwarfFileNumber=" + this.GenDwarfFileNumber + ", SectionsForRanges=" + this.SectionsForRanges + ", MCGenDwarfLabelEntries=" + this.MCGenDwarfLabelEntries + ", DwarfDebugFlags=" + this.DwarfDebugFlags + ", DwarfDebugProducer=" + this.DwarfDebugProducer + ", DwarfVersion=" + Unsigned.$ushort2uint((char)this.DwarfVersion) + ", AllowTemporaryLabels=" + this.AllowTemporaryLabels + ", UseNamesOnTempLabels=" + this.UseNamesOnTempLabels + ", DwarfCompileUnitID=" + this.DwarfCompileUnitID + ", MachOUniquingMap=" + this.MachOUniquingMap + ", ELFUniquingMap=" + this.ELFUniquingMap + ", COFFUniquingMap=" + this.COFFUniquingMap + ", ELFRelSecNames=" + this.ELFRelSecNames + ", MCSubtargetAllocator=" + this.MCSubtargetAllocator + ", AutoReset=" + this.AutoReset + ", HadError=" + this.HadError;
    }

    private static class COFFSectionKey
    implements Destructors.ClassWithDestructor,
    NativeCloneable<COFFSectionKey> {
        public std.string SectionName;
        public StringRef GroupName;
        public int SelectionKey;
        public int UniqueID;

        public COFFSectionKey(StringRef SectionName, StringRef GroupName, int SelectionKey, int UniqueID2) {
            this.SectionName = SectionName.$string();
            this.GroupName = new StringRef(GroupName);
            this.SelectionKey = SelectionKey;
            this.UniqueID = UniqueID2;
        }

        public boolean $less(COFFSectionKey Other) {
            if (std.$noteq_string$C((std.string)this.SectionName, (std.string)Other.SectionName)) {
                return std.$less_string$C((std.string)this.SectionName, (std.string)Other.SectionName);
            }
            if (llvm.$noteq_StringRef(this.GroupName, Other.GroupName)) {
                return llvm.$less_StringRef(this.GroupName, Other.GroupName);
            }
            if (this.SelectionKey != Other.SelectionKey) {
                return this.SelectionKey < Other.SelectionKey;
            }
            return Unsigned.$less_uint((int)this.UniqueID, (int)Other.UniqueID);
        }

        public COFFSectionKey(COFFSectionKey $Prm0) {
            this.SectionName = new std.string($Prm0.SectionName);
            this.GroupName = new StringRef($Prm0.GroupName);
            this.SelectionKey = $Prm0.SelectionKey;
            this.UniqueID = $Prm0.UniqueID;
        }

        public COFFSectionKey(JavaDifferentiators.JD.Move _dparam, COFFSectionKey $Prm0) {
            this.SectionName = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.SectionName);
            this.GroupName = new StringRef(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.GroupName);
            this.SelectionKey = $Prm0.SelectionKey;
            this.UniqueID = $Prm0.UniqueID;
        }

        public void $destroy() {
            this.SectionName.$destroy();
        }

        public COFFSectionKey clone() {
            return new COFFSectionKey(this);
        }

        public String toString() {
            return "SectionName=" + this.SectionName + ", GroupName=" + this.GroupName + ", SelectionKey=" + this.SelectionKey + ", UniqueID=" + this.UniqueID;
        }
    }

    private static class ELFSectionKey
    implements Destructors.ClassWithDestructor,
    NativeCloneable<ELFSectionKey>,
    NativeMoveable<ELFSectionKey> {
        public std.string SectionName;
        public StringRef GroupName;
        public int UniqueID;

        public ELFSectionKey(StringRef SectionName, StringRef GroupName, int UniqueID2) {
            this.SectionName = SectionName.$string();
            this.GroupName = new StringRef(GroupName);
            this.UniqueID = UniqueID2;
        }

        public boolean $less(ELFSectionKey Other) {
            if (std.$noteq_string$C((std.string)this.SectionName, (std.string)Other.SectionName)) {
                return std.$less_string$C((std.string)this.SectionName, (std.string)Other.SectionName);
            }
            if (llvm.$noteq_StringRef(this.GroupName, Other.GroupName)) {
                return llvm.$less_StringRef(this.GroupName, Other.GroupName);
            }
            return Unsigned.$less_uint((int)this.UniqueID, (int)Other.UniqueID);
        }

        public ELFSectionKey(JavaDifferentiators.JD.Move _dparam, ELFSectionKey $Prm0) {
            this.SectionName = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.SectionName);
            this.GroupName = new StringRef(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.GroupName);
            this.UniqueID = $Prm0.UniqueID;
        }

        public void $destroy() {
            this.SectionName.$destroy();
        }

        private ELFSectionKey(std.string SectionName, StringRef GroupName, int UniqueID2) {
            this.SectionName = SectionName;
            this.GroupName = GroupName;
            this.UniqueID = UniqueID2;
        }

        public ELFSectionKey clone() {
            return new ELFSectionKey(this.SectionName, this.GroupName, this.UniqueID);
        }

        public ELFSectionKey move() {
            return new ELFSectionKey(JavaDifferentiators.JD.Move.INSTANCE, this);
        }

        public String toString() {
            return "SectionName=" + this.SectionName + ", GroupName=" + this.GroupName + ", UniqueID=" + this.UniqueID;
        }
    }
}

