/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.clank.support.NativeTrace;
import org.llvm.support.llvm;

public final class llvm_config {
    private llvm_config() {
    }

    public static final String LLVM_HOST_TRIPLE() {
        assert (NativeTrace.isUnitTestMode() || NativeTrace.isStandalone()) : "This should be called only in tests or standalone Clank";
        return TripleHolder.LLVM_HOST_TRIPLE;
    }

    private static String getHostTripleSlow() {
        String llvmSrcEnv = "LLVM_SRC";
        String defaultTriple = "x86_64-unknown-linux-gnu";
        String llvmSrc = System.getenv("LLVM_SRC");
        if (llvmSrc == null) {
            llvm.errs().$out("LLVM_SRC").$out(" is not set. Using default host triple: ").$out("x86_64-unknown-linux-gnu").$out("\n").flush();
            return "x86_64-unknown-linux-gnu";
        }
        File clangFile = new File(llvmSrc + "/build/bin/clang");
        if (!clangFile.exists()) {
            llvm.errs().$out(clangFile.getAbsolutePath()).$out(" does not exist. Using default host triple: ").$out("x86_64-unknown-linux-gnu").$out("\n").flush();
            return "x86_64-unknown-linux-gnu";
        }
        ProcessBuilder builder = new ProcessBuilder(clangFile.getAbsolutePath(), "--version");
        try {
            Process process = builder.start();
            String triple = null;
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                triple = llvm_config.parseTriple(rdr);
            }
            int rc = process.waitFor();
            if (rc != 0) {
                llvm.errs().$out(clangFile.getAbsolutePath()).$out(" returned ").$out(rc).$out(". Using default host triple").$out("x86_64-unknown-linux-gnu").$out("\n").flush();
                return "x86_64-unknown-linux-gnu";
            }
            if (triple == null) {
                llvm.errs().$out("Error parsing ").$out(clangFile.getAbsolutePath()).$out(" output. Using default host triple").$out("x86_64-unknown-linux-gnu").$out("\n").flush();
                return "x86_64-unknown-linux-gnu";
            }
            return triple;
        }
        catch (IOException | InterruptedException ex) {
            llvm.errs().$out("Error launching ").$out(clangFile.getAbsolutePath()).$out(". Using default host triple: ").$out("x86_64-unknown-linux-gnu").$out("\n").flush();
            ex.printStackTrace();
            return "x86_64-unknown-linux-gnu";
        }
    }

    private static String parseTriple(BufferedReader rdr) throws IOException {
        String line = rdr.readLine();
        if (line == null || !line.startsWith("clang version ")) {
            return null;
        }
        line = rdr.readLine();
        String prefix = "Target:";
        if (line == null || !line.startsWith(prefix)) {
            return null;
        }
        return line.substring(prefix.length()).trim();
    }

    static /* synthetic */ String access$100() {
        return llvm_config.getHostTripleSlow();
    }

    private static class TripleHolder {
        private static final String LLVM_HOST_TRIPLE = llvm_config.access$100();

        private TripleHolder() {
        }
    }
}

