/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.impl;

import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Unsigned;
import org.clank.support.aliases.int;
import org.clank.support.aliases.ulong;
import org.llvm.adt.APFloat;
import org.llvm.adt.HashingGlobals;
import org.llvm.adt.lostFraction;

public final class APFloatLlvmGlobals {
    public static HashingGlobals.hash_code hash_value(APFloat Arg) {
        if (!Arg.isFiniteNonZero()) {
            return HashingGlobals.hash_combine((byte)Arg.category.getValue(), Arg.isNaN() ? Unsigned.$int2uchar((int)0) : Unsigned.$uint2uchar((boolean)Arg.sign), Arg.semantics.precision);
        }
        return HashingGlobals.hash_combine((byte)Arg.category.getValue(), Unsigned.$uint2uchar((boolean)Arg.sign), Arg.semantics.precision, Arg.exponent, HashingGlobals.hash_combine_range(Arg.significandParts$Const(), (ulong.ptr)Arg.significandParts$Const().$add(Arg.partCount())));
    }

    public static int ilogb(APFloat Arg) {
        if (Arg.isNaN()) {
            return APFloat.IlogbErrorKinds.IEK_NaN.getValue();
        }
        if (Arg.isZero()) {
            return APFloat.IlogbErrorKinds.IEK_Zero.getValue();
        }
        if (Arg.isInfinity()) {
            return APFloat.IlogbErrorKinds.IEK_Inf.getValue();
        }
        if (!Arg.isDenormal()) {
            return Arg.exponent;
        }
        APFloat Normalized = new APFloat(Arg);
        int SignificandBits = Arg.getSemantics().precision - 1;
        Normalized.exponent = (short)(Normalized.exponent + SignificandBits);
        Normalized.normalize(APFloat.roundingMode.rmNearestTiesToEven, lostFraction.lfExactlyZero);
        return Normalized.exponent - SignificandBits;
    }

    public static APFloat scalbn(APFloat X2, int Exp, APFloat.roundingMode RoundingMode) {
        short MaxExp = X2.getSemantics().maxExponent;
        short MinExp = X2.getSemantics().minExponent;
        int SignificandBits = X2.getSemantics().precision - 1;
        int MaxIncrement = MaxExp - (MinExp - SignificandBits) + 1;
        X2.exponent = (short)(X2.exponent + std.min((int)std.max((int)Exp, (int)(-MaxIncrement - 1)), (int)MaxIncrement));
        X2.normalize(RoundingMode, lostFraction.lfExactlyZero);
        if (X2.isNaN()) {
            X2.makeQuiet();
        }
        return new APFloat(JavaDifferentiators.JD.Move.INSTANCE, X2);
    }

    public static APFloat frexp(APFloat Val, int.ref Exp, APFloat.roundingMode RM) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static APFloat abs(APFloat X2) {
        X2.clearSign();
        return new APFloat(JavaDifferentiators.JD.Move.INSTANCE, X2);
    }

    public static APFloat minnum(APFloat A, APFloat B) {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public static APFloat maxnum(APFloat A, APFloat B) {
        if (A.isNaN()) {
            return new APFloat(B);
        }
        if (B.isNaN()) {
            return new APFloat(A);
        }
        return new APFloat(A.compare(B) == APFloat.cmpResult.cmpLessThan ? B : A);
    }
}

