/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.JavaIteratorLong;
import org.clank.support.aliases.NativeContainerLong;
import org.clank.support.aliases.long;
import org.clank.support.aliases.type;

public abstract class SmallVectorImplLong
extends NativeTrace.CreateDestroy$Tracker
implements Native.assignable<SmallVectorImplLong>,
Native.NativeComparable<SmallVectorImplLong>,
Native.ComparableLower,
NativeType.SizeofCapable,
NativeSwappable,
Iterable<Long>,
Native.NativeIterable<long.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorLong>,
NativeContainerLong {
    protected final long defaultValue;
    private long[] array;
    private static final long[] EMPTY = NativePointer.new$long((int)0);
    private int end;

    public final long[] $array() {
        assert (this.checkAlive());
        return this.array;
    }

    protected SmallVectorImplLong(int capacity, long defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$long((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplLong(int capacity, int initialSize, long defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplLong(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, long defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplLong(JavaDifferentiators.JD$UInt_T$C$R _dparam, int capacity, int initialSize, long value, long defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplLong(long[] array2, long defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplLong(int capacity, long.iterator<?> iter, int length, long defaultValue) {
        this(capacity, iter, (long.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplLong(int capacity, long.iterator<?> begin, long.iterator<?> end, long defaultValue) {
        this(capacity, defaultValue);
        this.append_T(begin, end);
    }

    protected SmallVectorImplLong(SmallVectorImplLong other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        int capacity = other.size();
        this.array = capacity == 0 ? EMPTY : NativePointer.new$long((int)capacity);
        this.append_T((long.iterator<?>)other.begin(), (long.iterator<?>)other.end());
    }

    protected SmallVectorImplLong(JavaDifferentiators.JD.Move _dparam, SmallVectorImplLong other) {
        assert (other.checkAlive());
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
    }

    public final SmallVectorImplLong $assign(SmallVectorImplLong other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        if (this == other) {
            return this;
        }
        this.clear();
        this.array = EMPTY;
        this.append_T((long.iterator<?>)other.begin(), (long.iterator<?>)other.end());
        return this;
    }

    public final SmallVectorImplLong $assignMove(SmallVectorImplLong other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = EMPTY;
        other.end = 0;
        return this;
    }

    public final void clear() {
        assert (this.checkAlive());
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        assert (this.checkAlive());
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, long defaultValue) {
        assert (this.checkAlive());
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((long)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, long Elt) {
        assert (this.checkAlive());
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign$T(long.iterator<?> __first, long.iterator<?> __last) {
        assert (this.checkAlive());
        this.clear();
        this.append_T(__first, __last);
    }

    public final void swap(NativeSwappable _RHS) {
        assert (this.checkAlive());
        SmallVectorImplLong RHS = (SmallVectorImplLong)_RHS;
        long[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(long elem) {
        assert (this.checkAlive());
        return this.find(elem, 0);
    }

    public final int find(long elem, int from) {
        assert (this.checkAlive());
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((long)this.array[i], (long)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(long elem) {
        assert (this.checkAlive());
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(long elem) {
        assert (this.checkAlive());
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            NativePointer.copy$Object((long[])this.array, (int)(index + 1), (long[])this.array, (int)index, (int)(this.end - index));
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final long.ptr erase(long.ptr I) {
        assert (this.checkAlive());
        assert (I.$greatereq((Object)this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less((Object)this.end())) : "Erasing at past-the-end iterator.";
        long.ptr N = I;
        std.copy((long.iterator)((long.iterator)I.$add(1)), (long.iterator)this.end(), (long.iterator)I);
        this.pop_back();
        return N;
    }

    public final long.ptr erase(long.ptr S2, long.ptr E) {
        assert (this.checkAlive());
        assert (S2.$greatereq((Object)this.begin())) : "Range to erase is out of bounds.";
        assert (S2.$lesseq((Object)E)) : "Trying to erase invalid range.";
        assert (E.$lesseq((Object)this.end())) : "Trying to erase past the end.";
        long.ptr N = S2;
        long.ptr I = (long.ptr)std.copy((long.iterator)E, (long.iterator)this.end(), (long.iterator)S2);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public long.ptr insert_iterator$T$value_T$RR(long.ptr I, long Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back_T$RR(Elt);
            return (long.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (long.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((long.iterator)I, (long.iterator)((long.iterator)this.end().$sub(1)), (long.iterator)this.end());
        I.$set(((Long)Native.$tryMove((Object)I.$star(), (Object)Elt, (boolean)this.isDataPointerLike())).longValue());
        return I;
    }

    public long.ptr insert_iterator$T_T$C$R(long.ptr I, long Elt) {
        return this.insert(I, Elt);
    }

    public long.ptr insert_iterator$T$value_T$C$R(long.ptr I, long Elt) {
        return this.insert(I, Elt);
    }

    public final long.ptr insert(long.ptr I, long Elt) {
        assert (this.checkAlive());
        if (I.$eq((Object)this.end())) {
            this.push_back(Elt);
            return (long.ptr)this.end().$sub(1);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub((abstract_iterator)this.begin());
            this.grow();
            I = (long.ptr)this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((long.iterator)I, (long.iterator)((long.iterator)this.end().$sub(1)), (long.iterator)this.end());
        I.$set(((Long)Native.$tryAssign(null, (Object)Elt, (boolean)this.isDataPointerLike())).longValue());
        return I;
    }

    public final long.ptr insert(long.ptr I, int NumToInsert, long Elt) {
        assert (this.checkAlive());
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append(NumToInsert, Elt);
            return (long.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = (long.ptr)this.begin().$add(InsertElt);
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            long.ptr OldEnd = this.end();
            this.append_T((long.iterator<?>)((long.iterator)this.end().$sub(NumToInsert)), (long.iterator<?>)this.end());
            std.copy_backward((long.iterator)I, (long.iterator)((long.iterator)OldEnd.$sub(NumToInsert)), (long.iterator)OldEnd);
            std.fill_n((long.iterator)I, (int)NumToInsert, (long)Elt);
            return I;
        }
        long.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub((abstract_iterator)I);
        std.copy((long.iterator)I, (long.iterator)OldEnd, (long.iterator)((long.ptr)this.end().$sub(NumOverwritten)));
        std.fill_n((long.iterator)I, (int)NumOverwritten, (long)Elt);
        std.fill_n((long.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (long)Elt);
        return I;
    }

    public final long.ptr insert$T(long.ptr I, long.iterator<?> From, long.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final long.ptr insert$T$value_T(long.ptr I, long.iterator<?> From, long.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert(I, From, To);
    }

    public final long.ptr insert_iterator$T_T(long.ptr I, long.iterator<?> From, long.iterator<?> To) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final long.ptr insert(long.ptr I, long.iterator<?> From, long.iterator<?> To) {
        assert (this.checkAlive());
        return this.insert_iterator$T$value_T(I, From, To);
    }

    public final long.ptr insert_iterator$T$value_T(long.ptr I, long.iterator<?> From, long.iterator<?> To) {
        int NumOverwritten;
        assert (this.checkAlive());
        int InsertElt = I.$sub((abstract_iterator)this.begin());
        if (I.$eq((Object)this.end())) {
            this.append_T(From, To);
            return (long.ptr)this.begin().$add(InsertElt);
        }
        assert (I.$greatereq((Object)this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq((Object)this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        assert (NumToInsert >= 0) : "Unexpected negative value " + NumToInsert;
        this.reserve(this.size() + NumToInsert);
        I = (long.ptr)this.begin().$add(InsertElt);
        if (NumToInsert == 0) {
            return I;
        }
        if (this.end().$sub((abstract_iterator)I) >= NumToInsert) {
            long.ptr OldEnd = this.end();
            this.append_T((long.iterator<?>)((long.iterator)this.end().$sub(NumToInsert)), (long.iterator<?>)this.end());
            std.copy_backward((long.iterator)I, (long.iterator)((long.iterator)OldEnd.$sub(NumToInsert)), (long.iterator)OldEnd);
            std.copy(From, To, (long.iterator)I);
            return I;
        }
        long.ptr OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((long.iterator)I, (long.iterator)OldEnd, (long.iterator)((long.ptr)this.end().$sub(NumOverwritten)));
        if (NumOverwritten > 0) {
            From = (long.iterator)Native.$Clone(From);
            long.ptr J = (long.ptr)Native.$Clone((NativeCloneable)I);
            for (NumOverwritten = OldEnd.$sub((abstract_iterator)I); NumOverwritten > 0; --NumOverwritten) {
                J.star$ref().$set(From.$star());
                J.$preInc();
                From.$preInc();
            }
        }
        std.copy((long.iterator)From, To, (long.iterator)OldEnd);
        return I;
    }

    public final void append_T(long.iterator<?> in_start, long.iterator<?> in_end) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        long.iterator iter = (long.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final <F> void append_T(type.iterator<?, F> in_start, type.iterator<?, F> in_end, NativeCallback.Converter<F, Long> converter) {
        assert (this.checkAlive());
        int NumInputs = std.distance(in_start, in_end);
        assert (NumInputs >= 0) : "Unexpected negative value " + NumInputs;
        if (NumInputs == 0) {
            return;
        }
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        type.iterator iter = (type.iterator)Native.$Clone(in_start);
        while (!iter.$eq(in_end)) {
            this.$set(this.end, (Long)converter.$call(iter.$star()));
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(long[] a) {
        assert (this.checkAlive());
        this.append(a, 0, a.length);
    }

    public final void append(long[] a, int fromIndex, int count) {
        assert (this.checkAlive());
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            long el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, long Elt) {
        assert (this.checkAlive());
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final void append_size_type$T$value_T$C$R(int NumInputs, long Elt) {
        this.append(NumInputs, Elt);
    }

    public final void append_size_type$T_T$C$R(int NumInputs, long Elt) {
        this.append(NumInputs, Elt);
    }

    public final boolean $eq(SmallVectorImplLong RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((long)this.array[i], (long)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplLong RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplLong)obj).checkAlive());
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplLong)obj).begin(), (Object)((SmallVectorImplLong)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        assert (this.checkAlive());
        assert (((SmallVectorImplLong)obj).checkAlive());
        return this.$less(obj) || this.$eq((SmallVectorImplLong)obj);
    }

    public final long.ref ref$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_long$ref((long[])this.array, (int)idx);
    }

    public final long $at(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final long $at$Const(int idx) {
        assert (this.checkAlive());
        return this.array[idx];
    }

    public final long $set(int idx, long value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    protected final long $set$move(int idx, long value) {
        assert (this.checkAlive());
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        assert (this.checkAlive());
        return this.size() == 0;
    }

    public final void $destroy() {
        assert (this.checkAlive());
        this.setEnd(0);
        this.set$destroyed();
    }

    public final void push_back(long val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void push_back_T$C$R(long val) {
        assert (this.checkAlive());
        this.push_back(val);
    }

    public final void push_back_T$RR(long val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set$move(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(long val) {
        assert (this.checkAlive());
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        int index = this.size();
        this.setEnd(index + 1);
        this.array[index] = val;
    }

    public final void emplace_back() {
        assert (this.checkAlive());
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        assert (this.checkAlive());
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final long pop_back_val() {
        assert (this.checkAlive());
        long val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final long.ptr begin() {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array);
    }

    public final long.ptr begin$Const() {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array);
    }

    public final long.ptr end() {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array, (int)this.end);
    }

    public final long.ptr end$Const() {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array, (int)this.end);
    }

    public final std.reverse_iteratorLong rbegin() {
        assert (this.checkAlive());
        return new std.reverse_iteratorLong((long.iterator)NativePointer.create_long$ptr((long[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorLong rbegin$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorLong((long.iterator)NativePointer.create_long$ptr((long[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorLong rend() {
        assert (this.checkAlive());
        return new std.reverse_iteratorLong((long.iterator)NativePointer.create_long$ptr((long[])this.array));
    }

    public final std.reverse_iteratorLong rend$Const() {
        assert (this.checkAlive());
        return new std.reverse_iteratorLong((long.iterator)NativePointer.create_long$ptr((long[])this.array));
    }

    public final long.ptr data() {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array);
    }

    public final long.ptr data$Const() {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array);
    }

    public final long front() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final long front$Const() {
        assert (this.checkAlive());
        return this.array[0];
    }

    public final long back() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final long back$Const() {
        assert (this.checkAlive());
        return this.array[this.end - 1];
    }

    public final long.ref ref$front() {
        assert (this.checkAlive());
        return new long.ref(){
            private final int index = 0;

            public long $deref() {
                assert (SmallVectorImplLong.this.checkAlive());
                return SmallVectorImplLong.this.array[0];
            }

            public long $set(long value) {
                assert (SmallVectorImplLong.this.checkAlive());
                ((SmallVectorImplLong)SmallVectorImplLong.this).array[0] = value;
                return value;
            }

            public long.ptr deref$ptr() {
                assert (SmallVectorImplLong.this.checkAlive());
                return (long.ptr)SmallVectorImplLong.this.data().$add(0);
            }
        };
    }

    public final long.ref ref$back() {
        assert (this.checkAlive());
        return new long.ref(){
            private final int index;
            {
                this.index = SmallVectorImplLong.this.end - 1;
            }

            public long $deref() {
                assert (SmallVectorImplLong.this.checkAlive());
                return SmallVectorImplLong.this.array[this.index];
            }

            public long $set(long value) {
                assert (SmallVectorImplLong.this.checkAlive());
                ((SmallVectorImplLong)SmallVectorImplLong.this).array[this.index] = value;
                return value;
            }

            public long.ptr deref$ptr() {
                assert (SmallVectorImplLong.this.checkAlive());
                return (long.ptr)SmallVectorImplLong.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        assert (this.checkAlive());
        return this.end;
    }

    public final int max_size() {
        assert (this.checkAlive());
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        assert (this.checkAlive());
        return this.array.length;
    }

    public final int $sizeof() {
        assert (this.checkAlive());
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        assert (this.checkAlive());
        int oneElemSize = NativeType.sizeof((long)this.defaultValue);
        for (long elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((long)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final long.ptr ptr$at(int idx) {
        assert (this.checkAlive());
        return NativePointer.create_long$ptr((long[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (this.checkAlive());
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(long.ptr _from, long.ptr _to) {
        this.destroy_range(_from.$sub((abstract_iterator)this.begin()), _to.$sub((abstract_iterator)this.begin()));
    }

    private void grow(int capacity) {
        long[] oldArray = this.array;
        this.array = NativePointer.new$long((int)capacity);
        NativePointer.copy$Object((long[])oldArray, (int)0, (long[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(long.ptr to) {
        this.setEnd(to.$sub((abstract_iterator)this.begin()));
    }

    @Override
    public Iterator<Long> iterator() {
        assert (this.checkAlive());
        return new JavaIteratorLong((long.iterator)this.begin(), (long.iterator)this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        String extra;
        String string2 = extra = super.is$destroyed() ? "DESTROYED" : "";
        if (this.end == 0) {
            return extra + "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplLong{\n");
        out.append(extra).append("end = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            long element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplLong}\n");
        return out.toString();
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

