/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.adt.aliases.DenseMapUIntType;
import org.llvm.adt.aliases.ImutAVLTreeInOrderIteratorUIntPtrType;
import org.llvm.adt.aliases.ImutAVLTreeInfoUIntPtrType;
import org.llvm.adt.aliases.ImutAVLTreeUIntPtrType;
import org.llvm.support.BumpPtrAllocatorImpl;

public class ImutAVLFactoryUIntPtrType<DataT, ValT>
implements Destructors.ClassWithDestructor {
    private final ImutAVLTreeInfoUIntPtrType<DataT, ValT> ImutInfo;
    DenseMapUIntType<ImutAVLTreeUIntPtrType<DataT, ValT>> Cache = new DenseMapUIntType<ImutAVLTreeUIntPtrType>(DenseMapInfoUInt.$Info(), (ImutAVLTreeUIntPtrType)null);
    private ADTAliases.PointerBoolPair<Object> Allocator;
    private std.vector<ImutAVLTreeUIntPtrType<DataT, ValT>> createdNodes = new std.vector((Object)((ImutAVLTreeUIntPtrType)null));
    std.vector<ImutAVLTreeUIntPtrType<DataT, ValT>> freeNodes = new std.vector((Object)((ImutAVLTreeUIntPtrType)null));

    private boolean ownsAllocator() {
        return !this.Allocator.getBool();
    }

    public BumpPtrAllocatorImpl getAllocator() {
        return (BumpPtrAllocatorImpl)Casts.reinterpret_cast(BumpPtrAllocatorImpl.class, (Object)this.Allocator.getPointer());
    }

    public ImutAVLFactoryUIntPtrType(ImutAVLTreeInfoUIntPtrType<DataT, ValT> ImutInfo) {
        this.Allocator = new ADTAliases.PointerBoolPair<Object>(Casts.reinterpret_cast_Object((Object)new BumpPtrAllocatorImpl()), false);
        this.ImutInfo = ImutInfo;
    }

    public ImutAVLFactoryUIntPtrType(ImutAVLTreeInfoUIntPtrType<DataT, ValT> ImutInfo, BumpPtrAllocatorImpl Alloc) {
        this.Allocator = new ADTAliases.PointerBoolPair<Object>(Casts.reinterpret_cast_Object((Object)Alloc), true);
        this.ImutInfo = ImutInfo;
    }

    public void $destroy() {
        if (this.ownsAllocator()) {
            Destructors.$destroy((Destructors.ClassWithDestructor)this.getAllocator());
        }
    }

    public ImutAVLTreeUIntPtrType<DataT, ValT> add(ImutAVLTreeUIntPtrType<DataT, ValT> T4, ValT V) {
        T4 = this.add_internal(V, T4);
        this.markImmutable(T4);
        this.recoverNodes();
        return T4;
    }

    public ImutAVLTreeUIntPtrType<DataT, ValT> remove(ImutAVLTreeUIntPtrType<DataT, ValT> T4, int V) {
        T4 = this.remove_internal(V, T4);
        this.markImmutable(T4);
        this.recoverNodes();
        return T4;
    }

    public ImutAVLTreeUIntPtrType<DataT, ValT> getEmptyTree() {
        return null;
    }

    protected boolean isEmpty(ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        return Native.$not(T4);
    }

    protected int getHeight(ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        return T4 != null ? T4.getHeight() : 0;
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> getLeft(ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        return T4.getLeft();
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> getRight(ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        return T4.getRight();
    }

    protected ValT getValue(ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        return T4.value;
    }

    protected static <ImutInfo> int maskCacheIndex(int I) {
        return I & 0xFFFFFFFD;
    }

    protected int incrementHeight(ImutAVLTreeUIntPtrType<DataT, ValT> L, ImutAVLTreeUIntPtrType<DataT, ValT> R2) {
        int hr;
        int hl = this.getHeight(L);
        return (Unsigned.$greater_uint((int)hl, (int)(hr = this.getHeight(R2))) ? hl : hr) + 1;
    }

    protected boolean compareTreeWithSection(ImutAVLTreeUIntPtrType<DataT, ValT> T4, ImutAVLTreeInOrderIteratorUIntPtrType<DataT, ValT> TI, ImutAVLTreeInOrderIteratorUIntPtrType<DataT, ValT> TE) {
        ImutAVLTreeInOrderIteratorUIntPtrType<DataT, ValT> I = T4.begin();
        ImutAVLTreeInOrderIteratorUIntPtrType<DataT, ValT> E = T4.end();
        while (Native.$noteq_iter(I, E)) {
            if (Native.$bool((boolean)Native.$eq_iter(TI, TE)) || Native.$not((boolean)I.$arrow().isElementEqual((ImutAVLTreeUIntPtrType)((Object)Native.$star(TI))))) {
                return false;
            }
            I.$preInc();
            TI.$preInc();
        }
        return true;
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> createNode(ImutAVLTreeUIntPtrType<DataT, ValT> L, ValT V, ImutAVLTreeUIntPtrType<DataT, ValT> R2) {
        ImutAVLTreeUIntPtrType<DataT, ValT> T4;
        BumpPtrAllocatorImpl A = this.getAllocator();
        if (!this.freeNodes.empty()) {
            T4 = (ImutAVLTreeUIntPtrType<DataT, ValT>)((Object)this.freeNodes.back());
            this.freeNodes.pop_back();
            T4.reset$Destroyed();
            assert (Native.$bool((T4 != L ? 1 : 0) != 0));
            assert (Native.$bool((T4 != R2 ? 1 : 0) != 0));
        } else {
            T4 = (ImutAVLTreeUIntPtrType)((Object)A.$RegisterCreated(new ImutAVLTreeUIntPtrType<DataT, ValT>(this.ImutInfo)));
        }
        T4 = T4.$ImutAVLTree(this, L, R2, V, this.incrementHeight(L, R2));
        this.createdNodes.push_back(T4);
        return T4;
    }

    void pushBackDestroyedNode(ImutAVLTreeUIntPtrType<DataT, ValT> Released) {
        assert (Released.is$Destroyed());
        this.freeNodes.push_back(Released);
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> createNode(ImutAVLTreeUIntPtrType<DataT, ValT> newLeft, ImutAVLTreeUIntPtrType<DataT, ValT> oldTree, ImutAVLTreeUIntPtrType<DataT, ValT> newRight) {
        return this.createNode(newLeft, this.getValue(oldTree), newRight);
    }

    protected void recoverNodes() {
        int i = 0;
        int n = this.createdNodes.size();
        while (Unsigned.$less_uint((int)i, (int)n)) {
            ImutAVLTreeUIntPtrType N = (ImutAVLTreeUIntPtrType)((Object)this.createdNodes.$at(i));
            if (Native.$bool((boolean)N.isMutable()) && Native.$bool((boolean)Native.$eq((int)N.refCount, (int)0))) {
                N.destroy();
            }
            ++i;
        }
        this.createdNodes.clear();
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> balanceTree(ImutAVLTreeUIntPtrType<DataT, ValT> L, ValT V, ImutAVLTreeUIntPtrType<DataT, ValT> R2) {
        int hr;
        int hl = this.getHeight(L);
        if (Unsigned.$greater_uint((int)hl, (int)((hr = this.getHeight(R2)) + 2))) {
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(L)))) : "Left tree cannot be empty to have a height >= 2";
            ImutAVLTreeUIntPtrType<DataT, ValT> LL = this.getLeft(L);
            ImutAVLTreeUIntPtrType<DataT, ValT> LR = this.getRight(L);
            if (Native.$greatereq((int)this.getHeight(LL), (int)this.getHeight(LR))) {
                return this.createNode(LL, L, this.createNode(LR, V, R2));
            }
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(LR)))) : "LR cannot be empty because it has a height >= 1";
            ImutAVLTreeUIntPtrType<DataT, ValT> LRL = this.getLeft(LR);
            ImutAVLTreeUIntPtrType<DataT, ValT> LRR = this.getRight(LR);
            return this.createNode(this.createNode(LL, L, LRL), LR, this.createNode(LRR, V, R2));
        }
        if (Unsigned.$greater_uint((int)hr, (int)(hl + 2))) {
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(R2)))) : "Right tree cannot be empty to have a height >= 2";
            ImutAVLTreeUIntPtrType<DataT, ValT> RL = this.getLeft(R2);
            ImutAVLTreeUIntPtrType<DataT, ValT> RR2 = this.getRight(R2);
            if (Native.$greatereq((int)this.getHeight(RR2), (int)this.getHeight(RL))) {
                return this.createNode(this.createNode(L, V, RL), R2, RR2);
            }
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(RL)))) : "RL cannot be empty because it has a height >= 1";
            ImutAVLTreeUIntPtrType<DataT, ValT> RLL = this.getLeft(RL);
            ImutAVLTreeUIntPtrType<DataT, ValT> RLR = this.getRight(RL);
            return this.createNode(this.createNode(L, V, RLL), RL, this.createNode(RLR, R2, RR2));
        }
        return this.createNode(L, V, R2);
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> add_internal(ValT V, ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        int KCurrent;
        if (this.isEmpty(T4)) {
            return this.createNode(T4, V, T4);
        }
        assert (Native.$bool((boolean)Native.$not((boolean)T4.isMutable())));
        int K = this.ImutInfo.KeyOfValue(V);
        if (this.ImutInfo.isEqual(K, KCurrent = this.ImutInfo.KeyOfValue(this.getValue(T4)))) {
            return this.createNode(this.getLeft(T4), V, this.getRight(T4));
        }
        if (this.ImutInfo.isLess(K, KCurrent)) {
            return this.balanceTree(this.add_internal(V, this.getLeft(T4)), this.getValue(T4), this.getRight(T4));
        }
        return this.balanceTree(this.getLeft(T4), this.getValue(T4), this.add_internal(V, this.getRight(T4)));
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> remove_internal(int K, ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        if (this.isEmpty(T4)) {
            return T4;
        }
        assert (Native.$bool((boolean)Native.$not((boolean)T4.isMutable())));
        int KCurrent = this.ImutInfo.KeyOfValue(this.getValue(T4));
        if (this.ImutInfo.isEqual(K, KCurrent)) {
            return this.combineTrees(this.getLeft(T4), this.getRight(T4));
        }
        if (this.ImutInfo.isLess(K, KCurrent)) {
            return this.balanceTree(this.remove_internal(K, this.getLeft(T4)), this.getValue(T4), this.getRight(T4));
        }
        return this.balanceTree(this.getLeft(T4), this.getValue(T4), this.remove_internal(K, this.getRight(T4)));
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> combineTrees(ImutAVLTreeUIntPtrType<DataT, ValT> L, ImutAVLTreeUIntPtrType<DataT, ValT> R2) {
        if (this.isEmpty(L)) {
            return R2;
        }
        if (this.isEmpty(R2)) {
            return L;
        }
        type.ref OldNode = NativePointer.create_type$ref();
        ImutAVLTreeUIntPtrType<DataT, ValT> newRight = this.removeMinBinding(R2, OldNode);
        return this.balanceTree(L, this.getValue((ImutAVLTreeUIntPtrType)((Object)OldNode.$deref())), newRight);
    }

    protected ImutAVLTreeUIntPtrType<DataT, ValT> removeMinBinding(ImutAVLTreeUIntPtrType<DataT, ValT> T4, type.ref<ImutAVLTreeUIntPtrType<DataT, ValT>> Noderemoved) {
        assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(T4))));
        if (this.isEmpty(this.getLeft(T4))) {
            Noderemoved.$set(T4);
            return this.getRight(T4);
        }
        return this.balanceTree(this.removeMinBinding(this.getLeft(T4), Noderemoved), this.getValue(T4), this.getRight(T4));
    }

    protected void markImmutable(ImutAVLTreeUIntPtrType<DataT, ValT> T4) {
        if (Native.$not(T4) || Native.$not((boolean)T4.isMutable())) {
            return;
        }
        T4.markImmutable();
        this.markImmutable(this.getLeft(T4));
        this.markImmutable(this.getRight(T4));
    }

    public ImutAVLTreeUIntPtrType<DataT, ValT> getCanonicalTree(ImutAVLTreeUIntPtrType<DataT, ValT> TNew) {
        if (Native.$not(TNew)) {
            return null;
        }
        if (TNew.IsCanonicalized) {
            return TNew;
        }
        int digest = TNew.computeDigest();
        type.ref entry = this.Cache.ref$at(ImutAVLFactoryUIntPtrType.maskCacheIndex(digest));
        if (entry.$deref() != null) {
            ImutAVLTreeUIntPtrType T4 = (ImutAVLTreeUIntPtrType)((Object)entry.$deref());
            while (T4 != null) {
                ImutAVLTreeInOrderIteratorUIntPtrType TE;
                ImutAVLTreeInOrderIteratorUIntPtrType TI = T4.begin();
                if (!Native.$not((boolean)this.compareTreeWithSection(TNew, TI, TE = T4.end())) && !Native.$noteq_iter(TI, TE)) {
                    if (Native.$eq((int)TNew.refCount, (int)0)) {
                        TNew.destroy();
                    }
                    return T4;
                }
                T4 = T4.next;
            }
            ((ImutAVLTreeUIntPtrType)((Object)entry.$deref())).prev = TNew;
            TNew.next = (ImutAVLTreeUIntPtrType)((Object)entry.$deref());
        }
        entry.$set(TNew);
        TNew.IsCanonicalized = true;
        return TNew;
    }

    public String toString() {
        return "Cache=" + this.Cache.size() + ", Allocator=" + NativeTrace.getIdentityStr(this.Allocator) + ", createdNodes=" + this.createdNodes.size() + ", freeNodes=" + this.freeNodes.size();
    }
}

