/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.adt.aliases.DenseMapUIntType;
import org.llvm.adt.aliases.ImutAVLTreeInOrderIteratorPtrTypeType;
import org.llvm.adt.aliases.ImutAVLTreeInfoPtrTypeType;
import org.llvm.adt.aliases.ImutAVLTreePtrTypeType;
import org.llvm.support.BumpPtrAllocatorImpl;

public class ImutAVLFactoryPtrTypeType<KeyT, DataT, ValT>
implements Destructors.ClassWithDestructor {
    private final ImutAVLTreeInfoPtrTypeType<KeyT, DataT, ValT> ImutInfo;
    DenseMapUIntType<ImutAVLTreePtrTypeType<KeyT, DataT, ValT>> Cache = new DenseMapUIntType<ImutAVLTreePtrTypeType>(DenseMapInfoUInt.$Info(), (ImutAVLTreePtrTypeType)null);
    private ADTAliases.PointerBoolPair<Object> Allocator;
    private std.vector<ImutAVLTreePtrTypeType<KeyT, DataT, ValT>> createdNodes = new std.vector((Object)((ImutAVLTreePtrTypeType)null));
    std.vector<ImutAVLTreePtrTypeType<KeyT, DataT, ValT>> freeNodes = new std.vector((Object)((ImutAVLTreePtrTypeType)null));

    private boolean ownsAllocator() {
        return !this.Allocator.getBool();
    }

    public BumpPtrAllocatorImpl getAllocator() {
        return (BumpPtrAllocatorImpl)Casts.reinterpret_cast(BumpPtrAllocatorImpl.class, (Object)this.Allocator.getPointer());
    }

    public ImutAVLFactoryPtrTypeType(ImutAVLTreeInfoPtrTypeType<KeyT, DataT, ValT> ImutInfo) {
        this.Allocator = new ADTAliases.PointerBoolPair<Object>(Casts.reinterpret_cast_Object((Object)new BumpPtrAllocatorImpl()), false);
        this.ImutInfo = ImutInfo;
    }

    public ImutAVLFactoryPtrTypeType(ImutAVLTreeInfoPtrTypeType<KeyT, DataT, ValT> ImutInfo, BumpPtrAllocatorImpl Alloc) {
        this.Allocator = new ADTAliases.PointerBoolPair<Object>(Casts.reinterpret_cast_Object((Object)Alloc), true);
        this.ImutInfo = ImutInfo;
    }

    public void $destroy() {
        if (this.ownsAllocator()) {
            Destructors.$destroy((Destructors.ClassWithDestructor)this.getAllocator());
        }
    }

    public ImutAVLTreePtrTypeType<KeyT, DataT, ValT> add(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4, ValT V) {
        T4 = this.add_internal(V, T4);
        this.markImmutable(T4);
        this.recoverNodes();
        return T4;
    }

    public ImutAVLTreePtrTypeType<KeyT, DataT, ValT> remove(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4, KeyT V) {
        T4 = this.remove_internal(V, T4);
        this.markImmutable(T4);
        this.recoverNodes();
        return T4;
    }

    public ImutAVLTreePtrTypeType<KeyT, DataT, ValT> getEmptyTree() {
        return null;
    }

    protected boolean isEmpty(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        return Native.$not(T4);
    }

    protected int getHeight(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        return T4 != null ? T4.getHeight() : 0;
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> getLeft(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        return T4.getLeft();
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> getRight(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        return T4.getRight();
    }

    protected ValT getValue(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        return T4.value;
    }

    protected static <ImutInfo> int maskCacheIndex(int I) {
        return I & 0xFFFFFFFD;
    }

    protected int incrementHeight(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> L, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> R2) {
        int hr;
        int hl = this.getHeight(L);
        return (Unsigned.$greater_uint((int)hl, (int)(hr = this.getHeight(R2))) ? hl : hr) + 1;
    }

    protected boolean compareTreeWithSection(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4, ImutAVLTreeInOrderIteratorPtrTypeType<KeyT, DataT, ValT> TI, ImutAVLTreeInOrderIteratorPtrTypeType<KeyT, DataT, ValT> TE) {
        ImutAVLTreeInOrderIteratorPtrTypeType<KeyT, DataT, ValT> I = T4.begin();
        ImutAVLTreeInOrderIteratorPtrTypeType<KeyT, DataT, ValT> E = T4.end();
        while (Native.$noteq_iter(I, E)) {
            if (Native.$bool((boolean)Native.$eq_iter(TI, TE)) || Native.$not((boolean)I.$arrow().isElementEqual((ImutAVLTreePtrTypeType)((Object)Native.$star(TI))))) {
                return false;
            }
            I.$preInc();
            TI.$preInc();
        }
        return true;
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> createNode(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> L, ValT V, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> R2) {
        ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4;
        BumpPtrAllocatorImpl A = this.getAllocator();
        if (!this.freeNodes.empty()) {
            T4 = (ImutAVLTreePtrTypeType<KeyT, DataT, ValT>)((Object)this.freeNodes.back());
            this.freeNodes.pop_back();
            T4.reset$Destroyed();
            assert (Native.$bool((T4 != L ? 1 : 0) != 0));
            assert (Native.$bool((T4 != R2 ? 1 : 0) != 0));
        } else {
            T4 = (ImutAVLTreePtrTypeType)((Object)A.$RegisterCreated(new ImutAVLTreePtrTypeType<KeyT, DataT, ValT>(this.ImutInfo)));
        }
        T4 = T4.$ImutAVLTree(this, L, R2, V, this.incrementHeight(L, R2));
        this.createdNodes.push_back(T4);
        return T4;
    }

    void pushBackDestroyedNode(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> Released) {
        assert (Released.is$Destroyed());
        this.freeNodes.push_back(Released);
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> createNode(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> newLeft, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> oldTree, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> newRight) {
        return this.createNode(newLeft, this.getValue(oldTree), newRight);
    }

    protected void recoverNodes() {
        int i = 0;
        int n = this.createdNodes.size();
        while (Unsigned.$less_uint((int)i, (int)n)) {
            ImutAVLTreePtrTypeType N = (ImutAVLTreePtrTypeType)((Object)this.createdNodes.$at(i));
            if (Native.$bool((boolean)N.isMutable()) && Native.$bool((boolean)Native.$eq((int)N.refCount, (int)0))) {
                N.destroy();
            }
            ++i;
        }
        this.createdNodes.clear();
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> balanceTree(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> L, ValT V, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> R2) {
        int hr;
        int hl = this.getHeight(L);
        if (Unsigned.$greater_uint((int)hl, (int)((hr = this.getHeight(R2)) + 2))) {
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(L)))) : "Left tree cannot be empty to have a height >= 2";
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> LL = this.getLeft(L);
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> LR = this.getRight(L);
            if (Native.$greatereq((int)this.getHeight(LL), (int)this.getHeight(LR))) {
                return this.createNode(LL, L, this.createNode(LR, V, R2));
            }
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(LR)))) : "LR cannot be empty because it has a height >= 1";
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> LRL = this.getLeft(LR);
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> LRR = this.getRight(LR);
            return this.createNode(this.createNode(LL, L, LRL), LR, this.createNode(LRR, V, R2));
        }
        if (Unsigned.$greater_uint((int)hr, (int)(hl + 2))) {
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(R2)))) : "Right tree cannot be empty to have a height >= 2";
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> RL = this.getLeft(R2);
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> RR2 = this.getRight(R2);
            if (Native.$greatereq((int)this.getHeight(RR2), (int)this.getHeight(RL))) {
                return this.createNode(this.createNode(L, V, RL), R2, RR2);
            }
            assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(RL)))) : "RL cannot be empty because it has a height >= 1";
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> RLL = this.getLeft(RL);
            ImutAVLTreePtrTypeType<KeyT, DataT, ValT> RLR = this.getRight(RL);
            return this.createNode(this.createNode(L, V, RLL), RL, this.createNode(RLR, R2, RR2));
        }
        return this.createNode(L, V, R2);
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> add_internal(ValT V, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        KeyT KCurrent;
        if (this.isEmpty(T4)) {
            return this.createNode(T4, V, T4);
        }
        assert (Native.$bool((boolean)Native.$not((boolean)T4.isMutable())));
        KeyT K = this.ImutInfo.KeyOfValue(V);
        if (this.ImutInfo.isEqual(K, KCurrent = this.ImutInfo.KeyOfValue(this.getValue(T4)))) {
            return this.createNode(this.getLeft(T4), V, this.getRight(T4));
        }
        if (this.ImutInfo.isLess(K, KCurrent)) {
            return this.balanceTree(this.add_internal(V, this.getLeft(T4)), this.getValue(T4), this.getRight(T4));
        }
        return this.balanceTree(this.getLeft(T4), this.getValue(T4), this.add_internal(V, this.getRight(T4)));
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> remove_internal(KeyT K, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        if (this.isEmpty(T4)) {
            return T4;
        }
        assert (Native.$bool((boolean)Native.$not((boolean)T4.isMutable())));
        KeyT KCurrent = this.ImutInfo.KeyOfValue(this.getValue(T4));
        if (this.ImutInfo.isEqual(K, KCurrent)) {
            return this.combineTrees(this.getLeft(T4), this.getRight(T4));
        }
        if (this.ImutInfo.isLess(K, KCurrent)) {
            return this.balanceTree(this.remove_internal(K, this.getLeft(T4)), this.getValue(T4), this.getRight(T4));
        }
        return this.balanceTree(this.getLeft(T4), this.getValue(T4), this.remove_internal(K, this.getRight(T4)));
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> combineTrees(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> L, ImutAVLTreePtrTypeType<KeyT, DataT, ValT> R2) {
        if (this.isEmpty(L)) {
            return R2;
        }
        if (this.isEmpty(R2)) {
            return L;
        }
        type.ref OldNode = NativePointer.create_type$ref();
        ImutAVLTreePtrTypeType<KeyT, DataT, ValT> newRight = this.removeMinBinding(R2, OldNode);
        return this.balanceTree(L, this.getValue((ImutAVLTreePtrTypeType)((Object)OldNode.$deref())), newRight);
    }

    protected ImutAVLTreePtrTypeType<KeyT, DataT, ValT> removeMinBinding(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4, type.ref<ImutAVLTreePtrTypeType<KeyT, DataT, ValT>> Noderemoved) {
        assert (Native.$bool((boolean)Native.$not((boolean)this.isEmpty(T4))));
        if (this.isEmpty(this.getLeft(T4))) {
            Noderemoved.$set(T4);
            return this.getRight(T4);
        }
        return this.balanceTree(this.removeMinBinding(this.getLeft(T4), Noderemoved), this.getValue(T4), this.getRight(T4));
    }

    protected void markImmutable(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> T4) {
        if (Native.$not(T4) || Native.$not((boolean)T4.isMutable())) {
            return;
        }
        T4.markImmutable();
        this.markImmutable(this.getLeft(T4));
        this.markImmutable(this.getRight(T4));
    }

    public ImutAVLTreePtrTypeType<KeyT, DataT, ValT> getCanonicalTree(ImutAVLTreePtrTypeType<KeyT, DataT, ValT> TNew) {
        if (Native.$not(TNew)) {
            return null;
        }
        if (TNew.IsCanonicalized) {
            return TNew;
        }
        int digest = TNew.computeDigest();
        type.ref entry = this.Cache.ref$at(ImutAVLFactoryPtrTypeType.maskCacheIndex(digest));
        if (entry.$deref() != null) {
            ImutAVLTreePtrTypeType T4 = (ImutAVLTreePtrTypeType)((Object)entry.$deref());
            while (T4 != null) {
                ImutAVLTreeInOrderIteratorPtrTypeType TE;
                ImutAVLTreeInOrderIteratorPtrTypeType TI = T4.begin();
                if (!Native.$not((boolean)this.compareTreeWithSection(TNew, TI, TE = T4.end())) && !Native.$noteq_iter(TI, TE)) {
                    if (Native.$eq((int)TNew.refCount, (int)0)) {
                        TNew.destroy();
                    }
                    return T4;
                }
                T4 = T4.next;
            }
            ((ImutAVLTreePtrTypeType)((Object)entry.$deref())).prev = TNew;
            TNew.next = (ImutAVLTreePtrTypeType)((Object)entry.$deref());
        }
        entry.$set(TNew);
        TNew.IsCanonicalized = true;
        return TNew;
    }

    public String toString() {
        return "Cache=" + this.Cache.size() + ", Allocator=" + NativeTrace.getIdentityStr(this.Allocator) + ", createdNodes=" + this.createdNodes.size() + ", freeNodes=" + this.freeNodes.size();
    }
}

