/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.clank.support.type;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.aliases.ImmutableMap;
import org.llvm.adt.aliases.ImutAVLFactory;
import org.llvm.adt.aliases.ImutAVLTree;
import org.llvm.adt.aliases.ImutAVLValueIterator;

public class ImmutableMapRef<KeyT, DataT>
extends NativeTrace.CreateDestroy$Tracker
implements Destructors.ClassWithDestructor,
Native.NativeComparable<ImmutableMapRef>,
Native.NativeIterable<iterator<KeyT, DataT>>,
Iterable<std_pair.pairTypeType<KeyT, DataT>>,
FoldingSetTrait.Profilable {
    protected ImutAVLTree<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> Root;
    protected ImutAVLFactory<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> Factory;

    public ImmutableMapRef(ImutAVLTree<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> R2, ImutAVLFactory<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> F) {
        this.Root = R2;
        this.Factory = F;
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableMapRef(ImmutableMap<KeyT, DataT> X2, ImmutableMap.Factory<KeyT, DataT> F) {
        assert (X2.checkAlive());
        this.Root = X2.getRootWithoutRetain();
        this.Factory = F.getTreeFactory();
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableMapRef(ImmutableMapRef<KeyT, DataT> X2) {
        assert (X2.checkAlive());
        this.Root = X2.Root;
        this.Factory = X2.Factory;
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public ImmutableMapRef<KeyT, DataT> $assign(ImmutableMapRef<KeyT, DataT> X2) {
        assert (X2.checkAlive());
        assert (this.checkAlive());
        if (this.Root != X2.Root) {
            if (X2.Root != null) {
                X2.Root.retain();
            }
            if (this.Root != null) {
                this.Root.release();
            }
            this.Root = X2.Root;
            this.Factory = X2.Factory;
        }
        return this;
    }

    public void $destroy() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.release();
        }
        super.set$destroyed();
    }

    public static <KeyT, DataT> ImmutableMapRef<KeyT, DataT> getEmptyMap(ImutAVLFactory<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> F) {
        return new ImmutableMapRef<KeyT, DataT>(null, F);
    }

    public void manualRetain() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.retain();
        }
    }

    public void manualRelease() {
        assert (this.checkAlive());
        if (this.Root != null) {
            this.Root.release();
        }
    }

    public ImmutableMapRef<KeyT, DataT> add(KeyT K, DataT D) {
        assert (this.checkAlive());
        ImutAVLTree<KeyT, DataT, std_pair.pairTypeType> NewT = this.Factory.add(this.Root, new std_pair.pairTypeType(K, D));
        return new ImmutableMapRef<KeyT, DataT>(NewT, this.Factory);
    }

    public ImmutableMapRef<KeyT, DataT> remove(KeyT K) {
        assert (this.checkAlive());
        ImutAVLTree<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> NewT = this.Factory.remove(this.Root, K);
        return new ImmutableMapRef<KeyT, DataT>(NewT, this.Factory);
    }

    public boolean contains(KeyT K) {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.contains(K) : false;
    }

    public ImmutableMap<KeyT, DataT> asImmutableMap() {
        assert (this.checkAlive());
        return new ImmutableMap<KeyT, DataT>(this.Factory.getCanonicalTree(this.Root));
    }

    public boolean $eq(ImmutableMapRef<KeyT, DataT> RHS) {
        assert (this.checkAlive());
        return this.Root != null && RHS.Root != null ? this.Root.isEqual(RHS.Root) : this.Root == RHS.Root;
    }

    public boolean $noteq(ImmutableMapRef<KeyT, DataT> RHS) {
        assert (this.checkAlive());
        return this.Root != null && RHS.Root != null ? this.Root.isNotEqual(RHS.Root) : this.Root != RHS.Root;
    }

    public boolean isEmpty() {
        assert (this.checkAlive());
        return this.Root == null;
    }

    public void verify() {
        throw new UnsupportedOperationException("Why verify is called?");
    }

    public iterator<KeyT, DataT> begin() {
        assert (this.checkAlive());
        return new iterator(this.Root);
    }

    public iterator<KeyT, DataT> end() {
        assert (this.checkAlive());
        return new iterator();
    }

    public type.ptr<DataT> lookup(KeyT K) {
        ImutAVLTree<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> T4;
        assert (this.checkAlive());
        if (this.Root != null && (T4 = this.Root.find(K)) != null) {
            final std_pair.pairTypeType<KeyT, DataT> value = T4.getValue();
            return new type.ptr.inout<DataT>(value){

                protected DataT $star$impl() {
                    return value.second;
                }

                protected DataT $set$impl(DataT V) {
                    value.second = V;
                    return value.second;
                }

                public boolean $isNull() {
                    return false;
                }

                public boolean $bool() {
                    return true;
                }
            };
        }
        return null;
    }

    public std_pair.pairTypeType<KeyT, DataT> getMaxElement() {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.getMaxElement().getValue() : null;
    }

    public int getHeight() {
        assert (this.checkAlive());
        return this.Root != null ? this.Root.getHeight() : 0;
    }

    public static <KeyT, DataT> void Profile(FoldingSetNodeID ID, ImmutableMapRef<KeyT, DataT> M) {
        assert (M.checkAlive());
        ID.AddPointer(M.Root);
    }

    @Override
    public void Profile(FoldingSetNodeID ID) {
        assert (this.checkAlive());
        ImmutableMapRef.Profile(ID, this);
    }

    @Override
    public Iterator<std_pair.pairTypeType<KeyT, DataT>> iterator() {
        assert (this.checkAlive());
        return new JavaIterator((type.iterator)this.begin(), (type.iterator)this.end());
    }

    public String toString() {
        StringBuilder out = new StringBuilder(super.is$destroyed() ? "DESTROYED " : "");
        int idx = 0;
        for (std_pair.pairTypeType<KeyT, DataT> entry : this) {
            out.append("\n[").append(idx++).append("] {");
            out.append(entry.first).append("} => {");
            out.append(entry.second).append("}");
        }
        return "ImmutableMapRef" + out.toString();
    }

    final boolean checkAlive() {
        return this.check$Alive();
    }

    public static class iterator<KeyT, DataT>
    extends ImutAVLValueIterator<std_pair.pairTypeType<KeyT, DataT>> {
        private iterator() {
        }

        private iterator(ImutAVLTree<KeyT, DataT, std_pair.pairTypeType<KeyT, DataT>> Tree) {
            super(Tree);
        }

        public KeyT getKey() {
            return (KeyT)((std_pair.pairTypeType)this.$star()).first;
        }

        public DataT getData() {
            return (DataT)((std_pair.pairTypeType)this.$star()).second;
        }

        private iterator(iterator<KeyT, DataT> $Prm0) {
            super($Prm0);
        }

        @Override
        public iterator<KeyT, DataT> clone() {
            return new iterator<KeyT, DataT>(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

