/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapBaseTypeBool;
import org.llvm.support.llvm;

public class DenseMapTypeBool<KeyT>
extends DenseMapBaseTypeBool<DenseMapTypeBool<KeyT>, KeyT>
implements Native.assignable<DenseMapTypeBool<KeyT>>,
Iterable<std_pair.pairTypeBool<KeyT>>,
NativeCloneable<DenseMapTypeBool<KeyT>>,
Destructors.ClassWithDestructor {
    private std_pair.pairTypeBool<KeyT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;

    public DenseMapTypeBool(DenseMapInfo<KeyT> keyInfo, boolean defaultValue) {
        this(keyInfo, 0, defaultValue);
    }

    public DenseMapTypeBool(DenseMapInfo<KeyT> keyInfo, int NumInitBuckets, boolean defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public DenseMapTypeBool(DenseMapTypeBool<KeyT> other) {
        super(other.keyInfoT, other.defaultValue);
        assert (other.checkAlive());
        this.init(0);
        this.copyFrom(other);
    }

    public DenseMapTypeBool(JavaDifferentiators.JD.Move _dparam, DenseMapTypeBool<KeyT> other) {
        super(other.keyInfoT, other.defaultValue);
        assert (other.checkAlive());
        this.init(0);
        this.swap(other);
    }

    public DenseMapTypeBool(DenseMapInfo<KeyT> keyInfo, type.iterator<?, std_pair.pairTypeBool<KeyT>> I, type.iterator<?, std_pair.pairTypeBool<KeyT>> E, boolean defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        assert (this.checkAlive());
        this.destroyAll();
        super.set$destroyed();
    }

    public void swap(DenseMapTypeBool<KeyT> RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        std_pair.pairTypeBool<KeyT>[] BucketsOther = RHS.Buckets;
        RHS.Buckets = this.Buckets;
        this.Buckets = BucketsOther;
        int NumBucketsOther = RHS.NumBuckets;
        RHS.NumBuckets = this.NumBuckets;
        this.NumBuckets = NumBucketsOther;
        int NumEntriesOther = RHS.NumEntries;
        RHS.NumEntries = this.NumEntries;
        this.NumEntries = NumEntriesOther;
        int NumTombstonesOther = RHS.NumTombstones;
        RHS.NumTombstones = this.NumTombstones;
        this.NumTombstones = NumTombstonesOther;
    }

    public DenseMapTypeBool<KeyT> $assign(DenseMapTypeBool<KeyT> other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(DenseMapTypeBool<KeyT> other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(int InitBuckets) {
        assert (this.checkAlive());
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(int AtLeast) {
        assert (this.checkAlive());
        int OldNumBuckets = this.NumBuckets;
        std_pair.pairTypeBool<KeyT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)llvm.NextPowerOf2(AtLeast - 1)));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        assert (this.checkAlive());
        int OldNumEntries = this.NumEntries;
        this.destroyAll();
        int NewNumBuckets = 0;
        if (OldNumEntries != 0) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        assert (this.checkAlive());
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        assert (this.checkAlive());
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        assert (this.checkAlive());
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        assert (this.checkAlive());
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std_pair.pairTypeBool<KeyT>> getBuckets() {
        assert (this.checkAlive());
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std_pair.pairTypeBool<KeyT>[] $Buckets() {
        assert (this.checkAlive());
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        assert (this.checkAlive());
        return this.NumBuckets;
    }

    private boolean allocateBuckets(int Num) {
        this.NumBuckets = Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std_pair.pairTypeBool[] bucketsArray = new std_pair.pairTypeBool[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = this.isKeyPointerLike() ? new std_pair.pairPtrBool() : new std_pair.pairTypeBool();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    @Override
    public Iterator<std_pair.pairTypeBool<KeyT>> iterator() {
        assert (this.checkAlive());
        return new JavaIterator(this.begin(), this.end());
    }

    public DenseMapTypeBool<KeyT> clone() {
        assert (this.checkAlive());
        return new DenseMapTypeBool<KeyT>(this);
    }

    public String toString() {
        return "DenseMap{NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + ", Buckets=[\n" + this.BucketsToString(this.Buckets) + "\n]}";
    }
}

