/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMap;

public class DenseMapIteratorPtrType<KeyT, ValueT>
implements type.iterator<DenseMapIteratorPtrType<KeyT, ValueT>, std_pair.pairPtrType<KeyT, ValueT>> {
    private final DenseMapInfo<KeyT> keyInfoT;
    private std_pair.pairPtrType<KeyT, ValueT>[] Buckets;
    private int Ptr;
    private int End;
    private static final int INVALID_INDEX = Integer.MAX_VALUE;

    public DenseMapIteratorPtrType() {
        this.keyInfoT = null;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorPtrType(DenseMapInfo<KeyT> keyInfoT) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Integer.MAX_VALUE;
        this.End = Integer.MAX_VALUE;
        this.Buckets = null;
    }

    public DenseMapIteratorPtrType(DenseMapInfo<KeyT> keyInfoT, std_pair.pairPtrType<KeyT, ValueT>[] Buckets, int Pos, int E) {
        this(keyInfoT, Buckets, Pos, E, false);
    }

    public DenseMapIteratorPtrType(DenseMapInfo<KeyT> keyInfoT, std_pair.pairPtrType<KeyT, ValueT>[] Buckets, int Pos, int E, boolean NoAdvance) {
        this.keyInfoT = keyInfoT;
        this.Ptr = Pos;
        this.End = E;
        this.Buckets = Buckets;
        if (!NoAdvance) {
            this.AdvancePastEmptyBuckets();
        }
    }

    public DenseMapIteratorPtrType<KeyT, ValueT> $assignMove(DenseMapIteratorPtrType<KeyT, ValueT> other) {
        this.End = other.End;
        this.Buckets = other.Buckets;
        this.Ptr = other.Ptr;
        return this;
    }

    public DenseMapIteratorPtrType(DenseMapIteratorPtrType<KeyT, ValueT> I) {
        this.keyInfoT = I.keyInfoT;
        this.Ptr = I.Ptr;
        this.End = I.End;
        this.Buckets = I.Buckets;
    }

    public DenseMapIteratorPtrType(JavaDifferentiators.JD.Move INSTANCE, DenseMapIteratorPtrType<KeyT, ValueT> $Prm0) {
        this.keyInfoT = $Prm0.keyInfoT;
        this.End = $Prm0.End;
        this.Buckets = $Prm0.Buckets;
        this.Ptr = $Prm0.Ptr;
        $Prm0.End = Integer.MAX_VALUE;
        $Prm0.Ptr = Integer.MAX_VALUE;
        $Prm0.Buckets = null;
    }

    public std_pair.pairPtrType<KeyT, ValueT> $star() {
        return this.Buckets[this.Ptr];
    }

    public type.ref<std_pair.pairPtrType<KeyT, ValueT>> star$ref() {
        return new type.ref<std_pair.pairPtrType<KeyT, ValueT>>(){
            int localPtr;
            {
                this.localPtr = DenseMapIteratorPtrType.this.Ptr;
            }

            public std_pair.pairPtrType<KeyT, ValueT> $deref() {
                return DenseMapIteratorPtrType.this.Buckets[this.localPtr];
            }

            public std_pair.pairPtrType<KeyT, ValueT> $set(std_pair.pairPtrType<KeyT, ValueT> value) {
                std_pair.pairPtrType pairPtrType2 = value;
                ((DenseMapIteratorPtrType)DenseMapIteratorPtrType.this).Buckets[this.localPtr] = pairPtrType2;
                return pairPtrType2;
            }

            public type.ptr<std_pair.pairPtrType<KeyT, ValueT>> deref$ptr() {
                return NativePointer.create_type$ptr((Object[])DenseMapIteratorPtrType.this.Buckets, (int)this.localPtr);
            }
        };
    }

    public std_pair.pairPtrType<KeyT, ValueT> $arrow() {
        return this.$star();
    }

    public boolean $eq(DenseMapIteratorPtrType<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr == RHS.Ptr;
    }

    public boolean $noteq(DenseMapIteratorPtrType<KeyT, ValueT> RHS) {
        assert (this.Buckets == RHS.Buckets);
        return this.Ptr != RHS.Ptr;
    }

    public DenseMapIteratorPtrType<KeyT, ValueT> $preInc() {
        ++this.Ptr;
        this.AdvancePastEmptyBuckets();
        return this;
    }

    public DenseMapIteratorPtrType<KeyT, ValueT> $postInc() {
        DenseMapIteratorPtrType<KeyT, ValueT> tmp = new DenseMapIteratorPtrType<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
        this.$preInc();
        return tmp;
    }

    public final DenseMapIteratorPtrType<KeyT, ValueT> $postInc(int I) {
        assert (I == 0) : "" + I;
        return this.$postInc();
    }

    private void AdvancePastEmptyBuckets() {
        Object Empty = this.keyInfoT.getEmptyKey();
        Object Tombstone = this.keyInfoT.getTombstoneKey();
        while (this.Ptr != this.End && (this.Buckets[this.Ptr].first == Empty || this.Buckets[this.Ptr].first == Tombstone)) {
            ++this.Ptr;
        }
    }

    public int $sub(DenseMapIteratorPtrType<KeyT, ValueT> iter) {
        return std.distance(iter, (abstract_iterator)this, (JavaDifferentiators.JD$FAKE)JavaDifferentiators.JD$FAKE.TRAILING);
    }

    public DenseMapIteratorPtrType<KeyT, ValueT> clone() {
        return new DenseMapIteratorPtrType<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public DenseMapIteratorPtrType<KeyT, ValueT> const_clone() {
        return new DenseMapIteratorPtrType<KeyT, ValueT>(this.keyInfoT, this.Buckets, this.Ptr, this.End, true);
    }

    public boolean $eq(Object other) {
        if (other instanceof DenseMapIteratorPtrType) {
            return Native.$eq((int)this.Ptr, (int)((DenseMapIteratorPtrType)other).Ptr);
        }
        return false;
    }

    public boolean $noteq(Object other) {
        if (other instanceof DenseMapIteratorPtrType) {
            return Native.$noteq((int)this.Ptr, (int)((DenseMapIteratorPtrType)other).Ptr);
        }
        return true;
    }

    public String toString() {
        String msg = NativeTrace.getIdentityStr(this.keyInfoT);
        if (this.Ptr == this.End) {
            msg = "<" + (this.Ptr == Integer.MAX_VALUE ? "INVALID:" : "END:") + msg + ">";
        } else {
            StringBuilder out = new StringBuilder(msg);
            DenseMap.BucketToString(out, this.Ptr, this.Buckets[this.Ptr], this.keyInfoT.isKeyPointerLike(), false);
            msg = out.toString();
        }
        return msg;
    }
}

