/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.support.NativeTrace;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.StringRef;
import org.llvm.support.llvm;

public class DenseMapInfoStringRef
implements DenseMapInfo<StringRef> {
    private static final DenseMapInfoStringRef $INFO = new DenseMapInfoStringRef();
    private final boolean allowCompareWithEmptyAndTombstone;
    protected final Object emptyKey;
    protected final Object tombstoneKey;

    public static DenseMapInfoStringRef $Info() {
        return $INFO;
    }

    public DenseMapInfoStringRef() {
        this(new StringRef(), new StringRef());
    }

    public DenseMapInfoStringRef(Object emptyKey, Object tombstoneKey) {
        this(emptyKey, tombstoneKey, false);
    }

    public DenseMapInfoStringRef(Object emptyKey, Object tombstoneKey, boolean allowCompareWithEmptyAndTombstone) {
        this.emptyKey = emptyKey;
        this.tombstoneKey = tombstoneKey;
        this.allowCompareWithEmptyAndTombstone = allowCompareWithEmptyAndTombstone;
        assert (this.tombstoneKey != this.emptyKey) : "emptyKey [" + this.emptyKey + "] must be different from tombstoneKey [" + this.tombstoneKey + "]";
        assert (emptyKey != null) : "emptyKey marker must be non null";
        assert (tombstoneKey != null) : "tombstoneKey marker must be non null";
    }

    @Override
    public final Object getEmptyKey() {
        return this.emptyKey;
    }

    @Override
    public final Object getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public int getHashValue(StringRef Key) {
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.emptyKey) : "Key: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.tombstoneKey) : "Key: must not be called for tombstoneKey";
        assert (this.checkKey(Key));
        return llvm.HashString(Key);
    }

    @Override
    public int getHashValueAlt(Object AltKey) {
        assert (AltKey != this.emptyKey) : "AltKey: must not be called for emptyKey";
        assert (AltKey != this.tombstoneKey) : "AltKey: must not be called for tombstoneKey";
        throw new UnsupportedOperationException("Override to support alternative Key types with hash same as Key");
    }

    @Override
    public boolean isEqual(StringRef LHS, StringRef RHS) {
        assert (this.allowCompareWithEmptyAndTombstone || LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        assert (this.allowCompareWithEmptyAndTombstone || RHS != this.emptyKey) : "RHS: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || RHS != this.tombstoneKey) : "RHS: must not be called for tombstoneKey";
        assert (this.checkKey(LHS));
        assert (this.checkKey(RHS));
        return llvm.$eq_StringRef(LHS, RHS);
    }

    @Override
    public boolean isEqualAlt(Object AltKey, StringRef Key) {
        assert (AltKey != this.emptyKey) : "AltKey: must not be called for emptyKey";
        assert (AltKey != this.tombstoneKey) : "AltKey: must not be called for tombstoneKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.emptyKey) : "Key: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.tombstoneKey) : "Key: must not be called for tombstoneKey";
        assert (this.checkKey(Key));
        throw new UnsupportedOperationException("Override to support alternative Key types comparable with Key");
    }

    @Override
    public boolean isKeyPointerLike() {
        return false;
    }

    protected boolean checkKey(Object Key) {
        return this.checkKeyImpl(Key, false);
    }

    protected boolean checkAltKey(Object AltKey) {
        return this.checkKeyImpl(AltKey, true);
    }

    protected boolean checkKeyImpl(Object Key, boolean altKey) {
        if (!NativeTrace.isDebugMode()) {
            NativeTrace.printStackTraceOnce((Throwable)new Exception("must be called inside assert"));
            return true;
        }
        assert (Key != null);
        return true;
    }
}

