/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.support.NativeTrace;

public class DenseMapInfoLong {
    private static final DenseMapInfoLong $INFO = new DenseMapInfoLong();
    private final boolean allowCompareWithEmptyAndTombstone;
    protected final long emptyKey;
    protected final long tombstoneKey;

    public static DenseMapInfoLong $Info() {
        return $INFO;
    }

    public DenseMapInfoLong() {
        this(-1L, -2L);
    }

    public DenseMapInfoLong(long emptyKey, long tombstoneKey) {
        this(emptyKey, tombstoneKey, false);
    }

    public DenseMapInfoLong(long emptyKey, long tombstoneKey, boolean allowCompareWithEmptyAndTombstone) {
        this.emptyKey = emptyKey;
        this.tombstoneKey = tombstoneKey;
        this.allowCompareWithEmptyAndTombstone = allowCompareWithEmptyAndTombstone;
        assert (this.tombstoneKey != this.emptyKey) : "emptyKey [" + this.emptyKey + "] must be different from tombstoneKey [" + this.tombstoneKey + "]";
    }

    public final long getEmptyKey() {
        return this.emptyKey;
    }

    public final long getTombstoneKey() {
        return this.tombstoneKey;
    }

    public int getHashValue(long Key) {
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.emptyKey) : "Key: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.tombstoneKey) : "Key: must not be called for tombstoneKey";
        return (int)(Key * 37L);
    }

    public int getHashValueAlt(Object AltKey) {
        throw new UnsupportedOperationException("Override to support alternative Key types with hash same as Key");
    }

    public boolean isEqual(long LHS, long RHS) {
        assert (this.allowCompareWithEmptyAndTombstone || LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        assert (this.allowCompareWithEmptyAndTombstone || RHS != this.emptyKey) : "RHS: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || RHS != this.tombstoneKey) : "RHS: must not be called for tombstoneKey";
        return LHS == RHS;
    }

    public boolean isEqualAlt(Object AltKey, long Key) {
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.emptyKey) : "Key: must not be called for emptyKey";
        assert (this.allowCompareWithEmptyAndTombstone || Key != this.tombstoneKey) : "Key: must not be called for tombstoneKey";
        throw new UnsupportedOperationException("Override to support alternative Key types comparable with Key");
    }

    public boolean isKeyPointerLike() {
        return true;
    }

    protected boolean checkKey(Object Key) {
        return this.checkKeyImpl(Key, false);
    }

    protected boolean checkAltKey(Object AltKey) {
        return this.checkKeyImpl(AltKey, true);
    }

    protected boolean checkKeyImpl(Object Key, boolean altKey) {
        if (!NativeTrace.isDebugMode()) {
            NativeTrace.printStackTraceOnce((Throwable)new Exception("must be called inside assert"));
            return true;
        }
        return true;
    }
}

