/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ulong;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapBaseTypeULong;
import org.llvm.adt.aliases.DenseMapIteratorTypeULong;

public abstract class DenseMapBaseTypeULong<DerivedT, KeyT>
extends NativeTrace.CreateDestroy$Tracker
implements NativeType.SizeofCapable {
    protected final long defaultValue;
    protected final DenseMapInfo<KeyT> keyInfoT;
    protected final Object emptyKey;
    protected final Object tombstoneKey;
    static final int INVALID_INDEX = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_MASK = Integer.MAX_VALUE;
    private static final int CANDIDATE_INDEX_FLAG = Integer.MIN_VALUE;

    protected DenseMapBaseTypeULong(DenseMapInfo<KeyT> keyInfo, long defaultValue) {
        this.keyInfoT = keyInfo;
        this.defaultValue = defaultValue;
        this.emptyKey = this.keyInfoT.getEmptyKey();
        this.tombstoneKey = keyInfo.getTombstoneKey();
        assert (this.emptyKey != null && this.tombstoneKey != null) : "empty/tombstoneKey key marker must be non null " + this.keyInfoT;
        assert (this.keyInfoT.getEmptyKey() == this.emptyKey) : "empty key must be persistent between calls" + this.keyInfoT;
        assert (this.keyInfoT.getTombstoneKey() == this.tombstoneKey) : "tombstone key must be persistent between calls" + this.keyInfoT;
        assert (this.emptyKey != this.tombstoneKey) : "EmptyKey must be different from TombstoneKey:" + keyInfo;
    }

    public DenseMapIteratorTypeULong<KeyT> begin() {
        assert (this.checkAlive());
        return this.empty() ? this.end() : new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), 0, this.getNumBuckets());
    }

    public DenseMapIteratorTypeULong<KeyT> end() {
        assert (this.checkAlive());
        return new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), this.getNumBuckets(), this.getNumBuckets(), true);
    }

    public final DenseMapIteratorTypeULong<KeyT> begin$Const() {
        assert (this.checkAlive());
        return this.begin();
    }

    public final DenseMapIteratorTypeULong<KeyT> end$Const() {
        assert (this.checkAlive());
        return this.end();
    }

    public boolean empty() {
        assert (this.checkAlive());
        return this.getNumEntries() == 0;
    }

    public int size() {
        assert (this.checkAlive());
        return this.getNumEntries();
    }

    public void resize(int Size) {
        assert (this.checkAlive());
        if (Size >= this.getNumBuckets()) {
            this.grow(Size);
        }
    }

    public void clear() {
        if (this.getNumEntries() == 0 && this.getNumTombstones() == 0) {
            assert (this.checkAlive());
            return;
        }
        if (this.getNumEntries() * 4 < this.getNumBuckets() && this.getNumBuckets() > 64) {
            this.shrink_and_clear();
            return;
        }
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        std_pair.pairTypeULong<KeyT>[] Buckets = this.$Buckets();
        int P2 = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P2, (int)E)) {
            if (Buckets[P2].first != EmptyKey) {
                if (Buckets[P2].first != TombstoneKey) {
                    if (!this.isDataPointerLike()) {
                        Native.destroy((long)Buckets[P2].second);
                    }
                    this.decrementNumEntries();
                }
                Buckets[P2].first = EmptyKey;
            }
            ++P2;
        }
        this.setNumTombstones(0);
    }

    public int count(KeyT Val) {
        assert (this.checkAlive());
        return this.LookupBucketFor(Val, true) == Integer.MAX_VALUE ? 0 : 1;
    }

    public DenseMapIteratorTypeULong<KeyT> find(KeyT Val) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public final DenseMapIteratorTypeULong<KeyT> find$Const(KeyT Val) {
        assert (this.checkAlive());
        return this.find(Val);
    }

    public <LookupKeyT> DenseMapIteratorTypeULong<KeyT> find_as(LookupKeyT Val) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketForAltKey(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true);
        }
        return this.end();
    }

    public final <LookupKeyT> DenseMapIteratorTypeULong<KeyT> find_as$Const(LookupKeyT AltKey) {
        assert (this.checkAlive());
        return this.find_as(AltKey);
    }

    public final <LookupKeyT> DenseMapIteratorTypeULong<KeyT> find_as_T$C$R(LookupKeyT AltKey) {
        assert (this.checkAlive());
        return this.find_as(AltKey);
    }

    public long lookup(KeyT Val) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(Val, true);
        if (TheBucket != Integer.MAX_VALUE) {
            return this.$Buckets()[TheBucket].second;
        }
        return Native.$tryClone((long)this.defaultValue);
    }

    public final std_pair.pairTypeBool<DenseMapIteratorTypeULong<KeyT>> insert_pair$KeyT$ValueT(std_pair.pairTypeULong<KeyT> KV) {
        assert (this.checkAlive());
        return this.insert(KV);
    }

    public std_pair.pairTypeBool<DenseMapIteratorTypeULong<KeyT>> insert(std_pair.pairTypeULong<KeyT> KV) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(KV.first, false);
        assert (TheBucket != Integer.MAX_VALUE);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(KV.first, KV.second, TheBucket & Integer.MAX_VALUE);
            return std.make_pair_T_bool(new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)true);
        }
        return std.make_pair_T_bool(new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)false);
    }

    public <LookupKeyT> std_pair.pairTypeBool<DenseMapIteratorTypeULong<KeyT>> insert_as(std_pair.pairTypeULong<KeyT> KV, LookupKeyT AltKey) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketForAltKey(AltKey, false);
        assert (TheBucket != Integer.MAX_VALUE);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucketAltKey(KV.first, KV.second, AltKey, TheBucket & Integer.MAX_VALUE);
            return std.make_pair_T_bool(new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)true);
        }
        return std.make_pair_T_bool(new DenseMapIteratorTypeULong<KeyT>(this.keyInfoT, this.$Buckets(), TheBucket, this.getNumBuckets(), true), (boolean)false);
    }

    public void insert(type.iterator<?, std_pair.pairTypeULong<KeyT>> I, type.iterator<?, std_pair.pairTypeULong<KeyT>> E) {
        assert (this.checkAlive());
        while (Native.$noteq_iter(I, E)) {
            this.insert((std_pair.pairTypeULong)I.$star());
            I.$preInc();
        }
    }

    public boolean erase(KeyT Val) {
        assert (this.checkAlive());
        int TheBucketIdx = this.LookupBucketFor(Val, true);
        if (TheBucketIdx == Integer.MAX_VALUE) {
            return false;
        }
        std_pair.pairTypeULong<KeyT> TheBucket = this.$Buckets()[TheBucketIdx];
        if (!this.isDataPointerLike()) {
            Native.destroy((long)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
        return true;
    }

    public void erase(DenseMapIteratorTypeULong<KeyT> I) {
        assert (this.checkAlive());
        std_pair.pairTypeULong<KeyT> TheBucket = I.$arrow();
        if (!this.isDataPointerLike()) {
            Native.destroy((long)TheBucket.second);
        }
        TheBucket.first = this.getTombstoneKey();
        this.decrementNumEntries();
        this.incrementNumTombstones();
    }

    public std_pair.pairTypeULong<KeyT> FindAndConstruct(KeyT Key) {
        assert (this.checkAlive());
        int TheBucket = this.LookupBucketFor(Key, false);
        if (TheBucket < 0) {
            TheBucket = this.InsertIntoBucket(Key, this.defaultValue, TheBucket & Integer.MAX_VALUE);
        }
        return this.$Buckets()[TheBucket];
    }

    public long $at(KeyT Key) {
        assert (this.checkAlive());
        return this.FindAndConstruct(Key).second;
    }

    public long $at_T1$C$R(KeyT Key) {
        assert (this.checkAlive());
        return this.FindAndConstruct(Key).second;
    }

    public long $at_T1$RR(KeyT Key) {
        assert (this.checkAlive());
        return this.FindAndConstruct(Key).second;
    }

    public long $set(KeyT Key, long Val) {
        assert (this.checkAlive());
        this.FindAndConstruct(Key).second = Val;
        return this.FindAndConstruct(Key).second;
    }

    public ulong.ref ref$at_T1$C$R(KeyT Key) {
        return this.ref$at(Key);
    }

    public ulong.ref ref$at(KeyT Key) {
        assert (this.checkAlive());
        return new ulong.ref_IMPL(Key, this);
    }

    public boolean isPointerIntoBucketsArray(Object Ptr2) {
        assert (this.checkAlive());
        if (Ptr2 != null && this.getBuckets() != null && this.getBucketsEnd() != null) {
            if (Ptr2 instanceof ulong.ref_IMPL) {
                return ((ulong.ref_IMPL)Ptr2).map == this;
            }
            if (Ptr2 instanceof type.ptr) {
                type.ptr Check = (type.ptr)Ptr2;
                return Native.$is_array_based((type.ptr)Check) && Check.$array() == this.$Buckets();
            }
        }
        return false;
    }

    public void.ptr getPointerIntoBucketsArray() {
        assert (this.checkAlive());
        return this.getBuckets();
    }

    protected void destroyAll() {
        assert (this.checkAlive());
        if (this.getNumBuckets() == 0) {
            return;
        }
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        std_pair.pairTypeULong<KeyT>[] Buckets = this.$Buckets();
        int P2 = 0;
        int E = this.getNumBuckets();
        while (Native.$noteq((int)P2, (int)E)) {
            if (Buckets[P2].first != EmptyKey && Buckets[P2].first != TombstoneKey) {
                if (!this.isDataPointerLike()) {
                    Native.destroy((long)Buckets[P2].second);
                }
                if (!this.isKeyPointerLike()) {
                    Native.destroy((Object)Buckets[P2].first);
                }
            }
            ++P2;
        }
    }

    protected void initEmpty() {
        assert (this.checkAlive());
        this.setNumEntries(0);
        this.setNumTombstones(0);
        Object EmptyKey = this.getEmptyKey();
        std_pair.pairTypeULong<KeyT>[] Buckets = this.$Buckets();
        int E = this.getNumBuckets();
        for (int B = 0; B != E; ++B) {
            Buckets[B].first = EmptyKey;
        }
    }

    protected void moveFromOldBuckets(std_pair.pairTypeULong<KeyT>[] OldBucketsBegin, int Num) {
        assert (this.checkAlive());
        this.initEmpty();
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        std_pair.pairTypeULong<KeyT>[] Buckets = this.$Buckets();
        int E = Num;
        for (int B = 0; B != Num; ++B) {
            std_pair.pairTypeULong<KeyT> oldPair = OldBucketsBegin[B];
            Object OldKey = oldPair.first;
            if (OldKey == EmptyKey || OldKey == TombstoneKey) continue;
            int DestBucketIdx = this.LookupBucketFor(OldKey, false);
            assert (DestBucketIdx != Integer.MAX_VALUE) : "Key already in new map?";
            assert (DestBucketIdx < 0) : "Key " + System.identityHashCode(OldKey) + " already in new map?" + System.identityHashCode(Buckets[DestBucketIdx]) + ":\nWhen Inserting Key=" + OldKey + "\nFound In Map=" + Buckets[DestBucketIdx];
            assert ((DestBucketIdx &= Integer.MAX_VALUE) >= 0);
            assert (DestBucketIdx != Integer.MAX_VALUE);
            std_pair.pairTypeULong<KeyT> DestBucket = Buckets[DestBucketIdx];
            DestBucket.first = OldKey;
            DestBucket.second = oldPair.second;
            this.incrementNumEntries();
        }
    }

    protected <OtherBaseT> void copyFrom(DenseMapBaseTypeULong<OtherBaseT, KeyT> other) {
        assert (this.checkAlive());
        assert (other.checkAlive());
        this.setNumEntries(other.getNumEntries());
        this.setNumTombstones(other.getNumTombstones());
        std_pair.pairTypeULong<KeyT>[] ourBuckets = this.$Buckets();
        std_pair.pairTypeULong<KeyT>[] otherBuckets = other.$Buckets();
        for (int i = 0; i < this.getNumBuckets(); ++i) {
            ourBuckets[i].first = otherBuckets[i].first;
            if (ourBuckets[i].first == this.getEmptyKey() || ourBuckets[i].first == this.getTombstoneKey()) continue;
            if (!this.isKeyPointerLike()) {
                ourBuckets[i].first = Native.$tryClone((Object)otherBuckets[i].first);
            }
            ourBuckets[i].second = this.isDataPointerLike() ? otherBuckets[i].second : Native.$tryClone((long)otherBuckets[i].second);
        }
    }

    protected void swap(DenseMapBaseTypeULong<DerivedT, KeyT> RHS) {
        assert (this.checkAlive());
        assert (RHS.checkAlive());
        int tmp = RHS.getNumEntries();
        RHS.setNumEntries(this.getNumEntries());
        this.setNumEntries(tmp);
        tmp = RHS.getNumTombstones();
        RHS.setNumTombstones(this.getNumTombstones());
        this.setNumTombstones(tmp);
    }

    protected int getHashValue(KeyT Val) {
        assert (this.checkAlive());
        return this.keyInfoT.getHashValue(Val);
    }

    protected <LookupKeyT> int getHashValueAlt(LookupKeyT Val) {
        assert (this.checkAlive());
        return this.keyInfoT.getHashValueAlt(Val);
    }

    protected final Object getEmptyKey() {
        assert (this.checkAlive());
        return this.emptyKey;
    }

    protected final Object getTombstoneKey() {
        assert (this.checkAlive());
        return this.tombstoneKey;
    }

    protected abstract int getNumEntries();

    protected abstract void setNumEntries(int var1);

    private void incrementNumEntries() {
        this.setNumEntries(this.getNumEntries() + 1);
    }

    private void decrementNumEntries() {
        this.setNumEntries(this.getNumEntries() - 1);
    }

    protected abstract int getNumTombstones();

    protected abstract void setNumTombstones(int var1);

    private void incrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() + 1);
    }

    private void decrementNumTombstones() {
        this.setNumTombstones(this.getNumTombstones() - 1);
    }

    protected abstract type.ptr<std_pair.pairTypeULong<KeyT>> getBuckets();

    protected abstract std_pair.pairTypeULong<KeyT>[] $Buckets();

    protected abstract int getNumBuckets();

    private type.ptr<std_pair.pairTypeULong<KeyT>> getBucketsEnd() {
        return NativePointer.create_type$ptr((Object[])this.$Buckets(), (int)this.getNumBuckets());
    }

    protected abstract void grow(int var1);

    protected abstract void shrink_and_clear();

    private int InsertIntoBucket(KeyT Key, long Value, int TheBucketIndex) {
        TheBucketIndex = this.InsertIntoBucketImpl(Key, TheBucketIndex);
        std_pair.pairTypeULong<KeyT> TheBucket = this.$Buckets()[TheBucketIndex];
        assert (Key != this.emptyKey);
        assert (Key != this.tombstoneKey);
        TheBucket.first = Key;
        TheBucket.second = Value;
        return TheBucketIndex;
    }

    private int InsertIntoBucketImpl(KeyT Key, int TheBucket) {
        int NumBuckets;
        int NewNumEntries = this.getNumEntries() + 1;
        if (NewNumEntries * 4 >= (NumBuckets = this.getNumBuckets()) * 3) {
            this.grow(NumBuckets * 2);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
            NumBuckets = this.getNumBuckets();
        } else if (Native.$lesseq((int)(NumBuckets - (NewNumEntries + this.getNumTombstones())), (int)(NumBuckets / 8))) {
            this.grow(NumBuckets);
            TheBucket = this.LookupBucketFor(Key, false) & Integer.MAX_VALUE;
        }
        assert (TheBucket != Integer.MAX_VALUE);
        this.incrementNumEntries();
        Object EmptyKey = this.getEmptyKey();
        if (this.$Buckets()[TheBucket].first != EmptyKey) {
            this.decrementNumTombstones();
        }
        return TheBucket;
    }

    private <LookupKeyT> int InsertIntoBucketAltKey(KeyT Key, long Value, LookupKeyT AltKey, int TheBucketIndex) {
        TheBucketIndex = this.InsertIntoBucketAltKeyImpl(AltKey, TheBucketIndex);
        std_pair.pairTypeULong<KeyT> TheBucket = this.$Buckets()[TheBucketIndex];
        assert (Key != this.emptyKey);
        assert (Key != this.tombstoneKey);
        TheBucket.first = Key;
        TheBucket.second = Value;
        return TheBucketIndex;
    }

    private <LookupKeyT> int InsertIntoBucketAltKeyImpl(LookupKeyT AltKey, int TheBucket) {
        int NumBuckets;
        int NewNumEntries = this.getNumEntries() + 1;
        if (NewNumEntries * 4 >= (NumBuckets = this.getNumBuckets()) * 3) {
            this.grow(NumBuckets * 2);
            TheBucket = this.LookupBucketForAltKey(AltKey, false) & Integer.MAX_VALUE;
            NumBuckets = this.getNumBuckets();
        } else if (Native.$lesseq((int)(NumBuckets - (NewNumEntries + this.getNumTombstones())), (int)(NumBuckets / 8))) {
            this.grow(NumBuckets);
            TheBucket = this.LookupBucketForAltKey(AltKey, false) & Integer.MAX_VALUE;
        }
        assert (TheBucket != Integer.MAX_VALUE);
        this.incrementNumEntries();
        Object EmptyKey = this.getEmptyKey();
        if (this.$Buckets()[TheBucket].first != EmptyKey) {
            this.decrementNumTombstones();
        }
        return TheBucket;
    }

    private int LookupBucketFor(KeyT Key, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std_pair.pairTypeULong<KeyT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        assert (Key != EmptyKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        assert (Key != TombstoneKey) : "Empty/Tombstone value shouldn't be inserted into map!";
        int BucketNo = this.getHashValue(Key) & NumBuckets - 1;
        int ProbeAmt = 1;
        while (true) {
            std_pair.pairTypeULong<KeyT> ThisBucket = Buckets[BucketNo];
            if (ThisBucket.first == EmptyKey) {
                int Bucket2;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket2 = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket2 >= 0 && Bucket2 != Integer.MAX_VALUE);
                return Bucket2 | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey) {
                if (FoundTombstone == Integer.MAX_VALUE) {
                    FoundTombstone = BucketNo;
                }
            } else if (this.keyInfoT.isEqual(Key, ThisBucket.first)) {
                return BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    private <LookupKeyT> int LookupBucketForAltKey(LookupKeyT AltKey, boolean onlyExisting) {
        int NumBuckets = this.getNumBuckets();
        if (NumBuckets == 0) {
            if (onlyExisting) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        std_pair.pairTypeULong<KeyT>[] Buckets = this.$Buckets();
        int FoundTombstone = Integer.MAX_VALUE;
        Object EmptyKey = this.getEmptyKey();
        Object TombstoneKey = this.getTombstoneKey();
        int BucketNo = this.getHashValueAlt(AltKey) & NumBuckets - 1;
        int ProbeAmt = 1;
        while (true) {
            std_pair.pairTypeULong<KeyT> ThisBucket = Buckets[BucketNo];
            if (ThisBucket.first == EmptyKey) {
                int Bucket2;
                if (onlyExisting) {
                    return Integer.MAX_VALUE;
                }
                int n = Bucket2 = FoundTombstone != Integer.MAX_VALUE ? FoundTombstone : BucketNo;
                assert (Bucket2 >= 0 && Bucket2 != Integer.MAX_VALUE);
                return Bucket2 | Integer.MIN_VALUE;
            }
            if (ThisBucket.first == TombstoneKey) {
                if (FoundTombstone == Integer.MAX_VALUE) {
                    FoundTombstone = BucketNo;
                }
            } else if (this.keyInfoT.isEqualAlt(AltKey, ThisBucket.first)) {
                return BucketNo;
            }
            BucketNo += ProbeAmt++;
            BucketNo &= NumBuckets - 1;
        }
    }

    public int getMemorySize() {
        assert (this.checkAlive());
        return this.getNumBuckets() * NativeType.sizeof(type.ptr.class);
    }

    public int $sizeof() {
        assert (this.checkAlive());
        return this.getMemorySize();
    }

    protected final boolean isDataPointerLike() {
        return false;
    }

    protected final boolean isKeyPointerLike() {
        return this.keyInfoT.isKeyPointerLike();
    }

    protected String BucketsToString(std_pair.pairTypeULong<KeyT>[] Buckets) {
        String destroyed;
        String string2 = destroyed = this.is$destroyed() ? "DESTROYED" : "";
        if (Buckets == null) {
            return destroyed + "<null>";
        }
        int idx = 0;
        StringBuilder out = new StringBuilder(destroyed);
        for (std_pair.pairTypeULong<KeyT> Bucket2 : Buckets) {
            if (Bucket2.first == this.getTombstoneKey() || Bucket2.first == this.getEmptyKey()) continue;
            DenseMapBaseTypeULong.BucketToString(out, idx, Bucket2, this.isKeyPointerLike(), this.isDataPointerLike());
        }
        return out.toString();
    }

    protected static void BucketToString(StringBuilder out, int idx, std_pair.pairTypeULong Bucket2, boolean isKeyPointerLike, boolean isDataPointerLike) {
        out.append("\n[").append(NativeTrace.formatNumber((long)idx++, (int)2)).append("]");
        out.append("{").append(isKeyPointerLike ? NativeTrace.getIdentityStr((Object)Bucket2.first) : "" + Bucket2.first);
        out.append("}=>{").append(isDataPointerLike ? NativeTrace.getIdentityStr((Object)Bucket2.second) : "" + Bucket2.second);
        out.append("}");
    }

    protected final boolean checkAlive() {
        return this.check$Alive();
    }
}

