/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.llvm;

public class ArrayRefChar
implements Iterable<Byte>,
Native.NativePOD<ArrayRefChar>,
Native.NativeIterable<char.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorChar>,
NativeMoveable<ArrayRefChar> {
    private static final ArrayRefChar NONE;
    private char.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefChar None() {
        return NONE;
    }

    public ArrayRefChar move() {
        return new ArrayRefChar(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefChar() {
        this(false);
    }

    public ArrayRefChar(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_char$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefChar(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_char$ptr((byte[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(byte OneElt) {
        this(OneElt, false);
    }

    public ArrayRefChar(byte OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefChar(/*const*/char$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefChar(byte OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_char$ptr((byte[])NativePointer.new$char$elem((byte)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(byte[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefChar(byte[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_char$ptr((byte[])data), length, isDataPointerLike);
    }

    public ArrayRefChar(char.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefChar(char.ptr data, int length, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(char.ptr begin, char.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefChar(char.ptr begin, char.ptr end, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefChar(SmallVectorImplChar Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefChar(SmallVectorImplChar Vec, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefChar(std.vectorChar Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefChar(std.vectorChar Vec, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefChar(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefChar(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)((char.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefChar(byte[] Arr) {
        this(Arr, false);
    }

    public ArrayRefChar(byte[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_char$ptr((byte[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefChar(ArrayRefChar other) {
        this.Data = Native.$tryConstClone((char.ptr)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefChar(JavaDifferentiators.JD.Convertible _param, ArrayRefChar other, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefChar(JavaDifferentiators.JD.Convertible _param, SmallVectorImplChar Vec, boolean isDataPointerLike) {
        this.Data = Native.$tryConstClone((char.ptr)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefChar(JavaDifferentiators.JD.Move _dparam, ArrayRefChar other) {
        assert (other != NONE) : "use new ArrayRefChar<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public char.ptr begin() {
        return this.Data;
    }

    public char.ptr end() {
        return this.Length == 0 ? this.Data : (char.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorChar rbegin() {
        return new std.reverse_iteratorChar((char.iterator)this.end());
    }

    public std.reverse_iteratorChar rend() {
        return new std.reverse_iteratorChar((char.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public char.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public byte front() {
        return this.Data.$at(0);
    }

    public byte back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefChar copy(Class<Byte> cls, NativeMemory.Allocator A) {
        char.ptr Buff = NativePointer.create_const_char$ptr((byte[])NativePointer.new$char(cls, (int)this.Length));
        std.copy((char.iterator)this.begin(), (char.iterator)this.end(), (char.iterator)Buff);
        return new ArrayRefChar(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefChar RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        char.ptr L = Native.$tryClone((char.ptr)this.begin());
        char.ptr LE = this.end();
        char.ptr R2 = Native.$tryClone((char.ptr)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((byte)L.$star(), (byte)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefChar slice(int N) {
        return new ArrayRefChar((char.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefChar slice(int N, int M) {
        return new ArrayRefChar((char.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefChar drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefChar drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public byte $at(int Index) {
        return this.Data.$at(Index);
    }

    public byte $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public char.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public char.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (char.ptr)this.Data.$add(Index);
    }

    public char.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public char.ref ref$at(int Index) {
        return ((char.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorChar vec() {
        return new std.vectorChar((char.iterator)this.Data, (char.iterator)this.end(), 0);
    }

    public std.vectorChar $vector() {
        return new std.vectorChar((char.iterator)this.Data, (char.iterator)this.end(), 0);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((byte)this.$at(i), (byte)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefChar $assign(ArrayRefChar other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefChar $assignMove(ArrayRefChar other) {
        assert (other != NONE) : "use new ArrayRefChar<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        char.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefChar clone() {
        if (this.getClass() != ArrayRefChar.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefChar(this);
    }

    public boolean $eq(ArrayRefChar other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Byte> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefChar obj;
        NONE = obj = new ArrayRefChar(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Byte> {
        private final char.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(char.ptr Data, int Length) {
            this.localData = Native.$tryClone((char.ptr)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Byte next() {
            Byte val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public byte TPtr;

        public TRefOrNothing() {
            this.TPtr = 0;
        }

        public TRefOrNothing(byte TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

