/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMemory;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.uint;
import org.llvm.adt.NoneType;
import org.llvm.adt.aliases.SmallVectorImplBool;
import org.llvm.support.llvm;

public class ArrayRefBool
implements Iterable<Boolean>,
Native.NativePOD<ArrayRefBool>,
Native.NativeIterable<bool.ptr>,
Native.NativeReverseIterable<std.reverse_iteratorBool>,
NativeMoveable<ArrayRefBool> {
    private static final ArrayRefBool NONE;
    private bool.ptr Data;
    private int Length;
    protected final boolean isDataPointerLike;
    private static final ArrayRefIterator EMPTY;

    public static ArrayRefBool None() {
        return NONE;
    }

    public ArrayRefBool move() {
        return new ArrayRefBool(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public ArrayRefBool() {
        this(false);
    }

    public ArrayRefBool(boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_bool$ptr((boolean[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefBool(NoneType $Prm0) {
        this($Prm0, false);
    }

    public ArrayRefBool(NoneType $Prm0, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_bool$ptr((boolean[])null);
        this.Length = 0;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefBool(boolean OneElt, int len, boolean isDataPointerLike) {
        this(OneElt, isDataPointerLike);
        assert (len == 1) : "you meant call to ArrayRefBool(/*const*/bool$ptr /*P*/ data, int len, boolean isDataPointerLike)?";
    }

    public ArrayRefBool(boolean OneElt, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_bool$ptr((boolean[])NativePointer.new$bool$elem((boolean)OneElt));
        this.Length = 1;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefBool(boolean[] data, int length) {
        this(data, length, false);
    }

    public ArrayRefBool(boolean[] data, int length, boolean isDataPointerLike) {
        this(NativePointer.create_const_bool$ptr((boolean[])data), length, isDataPointerLike);
    }

    public ArrayRefBool(bool.ptr data, int length) {
        this(data, length, false);
    }

    public ArrayRefBool(bool.ptr data, int length, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)data);
        this.Length = length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefBool(bool.ptr begin, bool.ptr end) {
        this(begin, end, false);
    }

    public ArrayRefBool(bool.ptr begin, bool.ptr end, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)begin);
        this.Length = std.distance((abstract_iterator)begin, (abstract_iterator)end);
        this.isDataPointerLike = isDataPointerLike;
    }

    public <U> ArrayRefBool(SmallVectorImplBool Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <U> ArrayRefBool(SmallVectorImplBool Vec, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public <A> ArrayRefBool(std.vectorBool Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public <A> ArrayRefBool(std.vectorBool Vec, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefBool(std.vectorString Vec) {
        this(Vec, Vec.isDataPointerLike());
    }

    public ArrayRefBool(std.vectorString Vec, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)((bool.ptr)Vec.data()));
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
        assert (!isDataPointerLike);
    }

    public ArrayRefBool(boolean[] Arr) {
        this(Arr, false);
    }

    public ArrayRefBool(boolean[] Arr, boolean isDataPointerLike) {
        this.Data = NativePointer.create_const_bool$ptr((boolean[])Arr);
        this.Length = Arr.length;
        this.isDataPointerLike = isDataPointerLike;
    }

    public ArrayRefBool(ArrayRefBool other) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefBool(JavaDifferentiators.JD.Convertible _param, ArrayRefBool other, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)other.Data);
        this.Length = other.size();
        assert (other.isDataPointerLike == isDataPointerLike);
        this.isDataPointerLike = other.isDataPointerLike;
    }

    public ArrayRefBool(JavaDifferentiators.JD.Convertible _param, SmallVectorImplBool Vec, boolean isDataPointerLike) {
        this.Data = (bool.ptr)Native.$tryConstClone((Object)Vec.data());
        this.Length = Vec.size();
        this.isDataPointerLike = isDataPointerLike;
        assert (isDataPointerLike == Vec.isDataPointerLike());
    }

    public ArrayRefBool(JavaDifferentiators.JD.Move _dparam, ArrayRefBool other) {
        assert (other != NONE) : "use new ArrayRefBool<>(true/false) instead?";
        this.Data = other.Data;
        this.Length = other.Length;
        this.isDataPointerLike = other.isDataPointerLike;
        other.Data = null;
        other.Length = 0;
    }

    public bool.ptr begin() {
        return this.Data;
    }

    public bool.ptr end() {
        return this.Length == 0 ? this.Data : (bool.ptr)this.Data.$add(this.Length);
    }

    public std.reverse_iteratorBool rbegin() {
        return new std.reverse_iteratorBool((bool.iterator)this.end());
    }

    public std.reverse_iteratorBool rend() {
        return new std.reverse_iteratorBool((bool.iterator)this.begin());
    }

    public boolean empty() {
        return this.Length == 0;
    }

    public bool.ptr data() {
        return this.Data;
    }

    public int size() {
        return this.Length;
    }

    public boolean front() {
        return this.Data.$at(0);
    }

    public boolean back() {
        return this.Data.$at(this.Length - 1);
    }

    public ArrayRefBool copy(Class<Boolean> cls, NativeMemory.Allocator A) {
        bool.ptr Buff = NativePointer.create_const_bool$ptr((boolean[])NativePointer.new$bool((int)this.Length));
        std.copy((bool.iterator)this.begin(), (bool.iterator)this.end(), (bool.iterator)Buff);
        return new ArrayRefBool(Buff, this.Length, this.isDataPointerLike);
    }

    public boolean equals(ArrayRefBool RHS) {
        if (Native.$noteq((int)this.Length, (int)RHS.Length)) {
            return false;
        }
        bool.ptr L = (bool.ptr)Native.$tryClone((NativeCloneable)this.begin());
        bool.ptr LE = this.end();
        bool.ptr R2 = (bool.ptr)Native.$tryClone((NativeCloneable)RHS.begin());
        while (L.$noteq((Object)LE)) {
            if (!Native.$eq((boolean)L.$star(), (boolean)R2.$star(), (boolean)this.isDataPointerLike)) {
                return false;
            }
            L.$preInc();
            R2.$preInc();
        }
        return true;
    }

    public ArrayRefBool slice(int N) {
        return new ArrayRefBool((bool.ptr)this.data().$add(N), this.size() - N, this.isDataPointerLike);
    }

    public ArrayRefBool slice(int N, int M) {
        return new ArrayRefBool((bool.ptr)this.data().$add(N), M, this.isDataPointerLike);
    }

    public ArrayRefBool drop_back() {
        return this.drop_back(1);
    }

    public ArrayRefBool drop_back(int N) {
        assert (this.size() >= N) : "Dropping more elements than exist";
        return this.slice(0, this.size() - N);
    }

    public boolean $at(int Index) {
        return this.Data.$at(Index);
    }

    public boolean $at(uint.ref Index) {
        return this.Data.$at(Index.$deref());
    }

    public bool.ptr ptr$at(uint.ref Index) {
        return this.ptr$at(Index.$deref());
    }

    public bool.ptr ptr$at(int Index) {
        return Index == 0 ? this.Data : (bool.ptr)this.Data.$add(Index);
    }

    public bool.ref ref$at(uint.ref Index) {
        return this.ref$at(Index.$deref());
    }

    public bool.ref ref$at(int Index) {
        return ((bool.ptr)this.Data.$add(Index)).star$ref();
    }

    public std.vectorBool vec() {
        return new std.vectorBool((bool.iterator)this.Data, (bool.iterator)this.end(), false);
    }

    public std.vectorBool $vector() {
        return new std.vectorBool((bool.iterator)this.Data, (bool.iterator)this.end(), false);
    }

    public boolean equals(TRefOrNothing ... Args) {
        if (Args.length > 16) {
            throw new IllegalArgumentException("Too many arguments passed!");
        }
        if (this.size() != llvm.array_lengthof(Args)) {
            return false;
        }
        int e = this.size();
        for (int i = 0; i != e; ++i) {
            if (!Native.$noteq((boolean)this.$at(i), (boolean)Args[i].TPtr, (boolean)this.isDataPointerLike)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.Length == 0) {
            return "<Empty>";
        }
        StringBuilder out = new StringBuilder("\nArRef{");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.Length + 1)) + "d";
        for (int i = 0; i < this.Length; ++i) {
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append("{").append(this.$at(i)).append("}\n");
        }
        out.append("}ArRef\n");
        return out.toString();
    }

    public ArrayRefBool $assign(ArrayRefBool other) {
        this.Data = other.Data;
        this.Length = other.Length;
        return this;
    }

    public ArrayRefBool $assignMove(ArrayRefBool other) {
        assert (other != NONE) : "use new ArrayRefBool<>(" + this.isDataPointerLike + ") instead?";
        assert (this.isDataPointerLike == other.isDataPointerLike);
        bool.ptr DataTmp = this.Data;
        int LengthTmp = this.Length;
        this.Data = other.Data;
        this.Length = other.Length;
        other.Data = null;
        other.Length = 0;
        return this;
    }

    public ArrayRefBool clone() {
        if (this.getClass() != ArrayRefBool.class) {
            throw new UnsupportedOperationException("Must be overridden in derived " + this.getClass());
        }
        return new ArrayRefBool(this);
    }

    public boolean $eq(ArrayRefBool other) {
        return this.equals(other);
    }

    @Override
    public Iterator<Boolean> iterator() {
        return this.Length == 0 ? EMPTY : new ArrayRefIterator(this.Data, this.Length);
    }

    static {
        ArrayRefBool obj;
        NONE = obj = new ArrayRefBool(NoneType.None);
        EMPTY = new ArrayRefIterator(null, 0);
    }

    private static final class ArrayRefIterator
    implements Iterator<Boolean> {
        private final bool.ptr localData;
        private final int localLength;
        private int pos = 0;

        public ArrayRefIterator(bool.ptr Data, int Length) {
            this.localData = (bool.ptr)Native.$tryClone((NativeCloneable)Data);
            this.localLength = Length;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.localLength;
        }

        @Override
        public Boolean next() {
            Boolean val = this.localData.$star();
            this.localData.$preInc();
            ++this.pos;
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TRefOrNothing {
        public boolean TPtr;

        public TRefOrNothing() {
            this.TPtr = false;
        }

        public TRefOrNothing(boolean TRef) {
            this.TPtr = TRef;
        }

        public String toString() {
            return "TPtr=" + this.TPtr;
        }
    }
}

