/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.impl.StringRefStatics;
import org.llvm.support.impl.TripleStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.target.ARM;

public class Triple
implements Destructors.ClassWithDestructor,
Native.NativeComparable<Triple>,
NativeCloneable<Triple> {
    private std.string Data;
    private ArchType Arch;
    private SubArchType SubArch;
    private VendorType Vendor;
    private OSType OS;
    private EnvironmentType Environment;
    private ObjectFormatType ObjectFormat;

    public Triple() {
        this.Data = new std.string();
        this.Arch = ArchType.valueOf(0);
        this.Vendor = VendorType.valueOf(0);
        this.OS = OSType.valueOf(0);
        this.Environment = EnvironmentType.valueOf(0);
        this.ObjectFormat = ObjectFormatType.valueOf(0);
    }

    public Triple(Twine Str) {
        this.Data = Str.str();
        this.Arch = ArchType.UnknownArch;
        this.SubArch = SubArchType.NoSubArch;
        this.Vendor = VendorType.UnknownVendor;
        this.OS = OSType.UnknownOS;
        this.Environment = EnvironmentType.UnknownEnvironment;
        this.ObjectFormat = ObjectFormatType.UnknownObjectFormat;
        SmallVector<StringRef> Components = new SmallVector<StringRef>(4, new StringRef());
        new StringRef(this.Data).split(Components, StringRef.R$MINUS, 3);
        if (Unsigned.$greater_uint((int)Components.size(), (int)0)) {
            this.Arch = TripleStatics.parseArch((StringRef)Components.$at(0));
            this.SubArch = TripleStatics.parseSubArch((StringRef)Components.$at(0));
            if (Unsigned.$greater_uint((int)Components.size(), (int)1)) {
                this.Vendor = TripleStatics.parseVendor((StringRef)Components.$at(1));
                if (Unsigned.$greater_uint((int)Components.size(), (int)2)) {
                    this.OS = TripleStatics.parseOS((StringRef)Components.$at(2));
                    if (Unsigned.$greater_uint((int)Components.size(), (int)3)) {
                        this.Environment = TripleStatics.parseEnvironment((StringRef)Components.$at(3));
                        this.ObjectFormat = TripleStatics.parseFormat((StringRef)Components.$at(3));
                    }
                }
            }
        }
        if (this.ObjectFormat == ObjectFormatType.UnknownObjectFormat) {
            this.ObjectFormat = TripleStatics.getDefaultFormat(this);
        }
    }

    public Triple(Twine ArchStr, Twine VendorStr, Twine OSStr) {
        this.Data = llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(ArchStr, new Twine(JavaDifferentiators.JD$Char.INSTANCE, 45)), VendorStr), new Twine(JavaDifferentiators.JD$Char.INSTANCE, 45)), OSStr).str();
        this.Arch = TripleStatics.parseArch(new StringRef(ArchStr.str()));
        this.SubArch = TripleStatics.parseSubArch(new StringRef(ArchStr.str()));
        this.Vendor = TripleStatics.parseVendor(new StringRef(VendorStr.str()));
        this.OS = TripleStatics.parseOS(new StringRef(OSStr.str()));
        this.Environment = EnvironmentType.valueOf(0);
        this.ObjectFormat = ObjectFormatType.UnknownObjectFormat;
        this.ObjectFormat = TripleStatics.getDefaultFormat(this);
    }

    public Triple(Twine ArchStr, Twine VendorStr, Twine OSStr, Twine EnvironmentStr) {
        this.Data = llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(ArchStr, new Twine(JavaDifferentiators.JD$Char.INSTANCE, 45)), VendorStr), new Twine(JavaDifferentiators.JD$Char.INSTANCE, 45)), OSStr), new Twine(JavaDifferentiators.JD$Char.INSTANCE, 45)), EnvironmentStr).str();
        this.Arch = TripleStatics.parseArch(new StringRef(ArchStr.str()));
        this.SubArch = TripleStatics.parseSubArch(new StringRef(ArchStr.str()));
        this.Vendor = TripleStatics.parseVendor(new StringRef(VendorStr.str()));
        this.OS = TripleStatics.parseOS(new StringRef(OSStr.str()));
        this.Environment = TripleStatics.parseEnvironment(new StringRef(EnvironmentStr.str()));
        this.ObjectFormat = TripleStatics.parseFormat(new StringRef(EnvironmentStr.str()));
        if (this.ObjectFormat == ObjectFormatType.UnknownObjectFormat) {
            this.ObjectFormat = TripleStatics.getDefaultFormat(this);
        }
    }

    public boolean $eq(Triple Other) {
        return this.Arch == Other.Arch && this.SubArch == Other.SubArch && this.Vendor == Other.Vendor && this.OS == Other.OS && this.Environment == Other.Environment && this.ObjectFormat == Other.ObjectFormat;
    }

    public static std.string normalize(StringRef Str) {
        boolean IsMinGW32 = false;
        boolean IsCygwin = false;
        SmallVector<StringRef> Components = new SmallVector<StringRef>(4, new StringRef());
        Str.split(Components, StringRef.R$MINUS);
        ArchType Arch = ArchType.UnknownArch;
        if (Unsigned.$greater_uint((int)Components.size(), (int)0)) {
            Arch = TripleStatics.parseArch((StringRef)Components.$at(0));
        }
        VendorType Vendor = VendorType.UnknownVendor;
        if (Unsigned.$greater_uint((int)Components.size(), (int)1)) {
            Vendor = TripleStatics.parseVendor((StringRef)Components.$at(1));
        }
        OSType OS = OSType.UnknownOS;
        if (Unsigned.$greater_uint((int)Components.size(), (int)2)) {
            OS = TripleStatics.parseOS((StringRef)Components.$at(2));
            IsCygwin = ((StringRef)Components.$at(2)).startswith("cygwin");
            IsMinGW32 = ((StringRef)Components.$at(2)).startswith("mingw");
        }
        EnvironmentType Environment2 = EnvironmentType.UnknownEnvironment;
        if (Unsigned.$greater_uint((int)Components.size(), (int)3)) {
            Environment2 = TripleStatics.parseEnvironment((StringRef)Components.$at(3));
        }
        ObjectFormatType ObjectFormat = ObjectFormatType.UnknownObjectFormat;
        if (Unsigned.$greater_uint((int)Components.size(), (int)4)) {
            ObjectFormat = TripleStatics.parseFormat((StringRef)Components.$at(4));
        }
        boolean[] Found = NativePointer.new$bool((int)4);
        Found[0] = Arch != ArchType.UnknownArch;
        Found[1] = Vendor != VendorType.UnknownVendor;
        Found[2] = OS != OSType.UnknownOS;
        Found[3] = Environment2 != EnvironmentType.UnknownEnvironment;
        block6: for (int Pos = 0; Pos != llvm.array_lengthof(Found); ++Pos) {
            if (Found[Pos]) continue;
            for (int Idx = 0; Idx != Components.size(); ++Idx) {
                int i;
                StringRef CurrentComponent;
                if (Unsigned.$less_uint((int)Idx, (int)llvm.array_lengthof(Found)) && Found[Idx]) continue;
                boolean Valid = false;
                StringRef Comp = new StringRef((StringRef)Components.$at(Idx));
                switch (Pos) {
                    default: {
                        throw new llvm_unreachable("unexpected component type!");
                    }
                    case 0: {
                        Arch = TripleStatics.parseArch(Comp);
                        Valid = Arch != ArchType.UnknownArch;
                        break;
                    }
                    case 1: {
                        Vendor = TripleStatics.parseVendor(Comp);
                        Valid = Vendor != VendorType.UnknownVendor;
                        break;
                    }
                    case 2: {
                        OS = TripleStatics.parseOS(Comp);
                        IsCygwin = Comp.startswith("cygwin");
                        IsMinGW32 = Comp.startswith("mingw");
                        Valid = OS != OSType.UnknownOS || IsCygwin || IsMinGW32;
                        break;
                    }
                    case 3: {
                        Environment2 = TripleStatics.parseEnvironment(Comp);
                        boolean bl = Valid = Environment2 != EnvironmentType.UnknownEnvironment;
                        if (Valid) break;
                        ObjectFormat = TripleStatics.parseFormat(Comp);
                        boolean bl2 = Valid = ObjectFormat != ObjectFormatType.UnknownObjectFormat;
                    }
                }
                if (!Valid) continue;
                if (Unsigned.$less_uint((int)Pos, (int)Idx)) {
                    CurrentComponent = new StringRef(NativePointer.$EMPTY);
                    StringRefStatics.swap(CurrentComponent, (StringRef)Components.$at(Idx));
                    i = Pos;
                    while (!CurrentComponent.empty()) {
                        while (Unsigned.$less_uint((int)i, (int)llvm.array_lengthof(Found)) && Found[i]) {
                            ++i;
                        }
                        StringRefStatics.swap(CurrentComponent, (StringRef)Components.$at(i));
                        ++i;
                    }
                } else if (Unsigned.$greater_uint((int)Pos, (int)Idx)) {
                    do {
                        CurrentComponent = new StringRef(NativePointer.$EMPTY);
                        i = Idx;
                        while (Unsigned.$less_uint((int)i, (int)Components.size())) {
                            StringRefStatics.swap(CurrentComponent, (StringRef)Components.$at(i));
                            if (CurrentComponent.empty()) break;
                            while (Unsigned.$less_uint((int)(++i), (int)llvm.array_lengthof(Found)) && Found[i]) {
                            }
                        }
                        if (!CurrentComponent.empty()) {
                            Components.push_back(CurrentComponent);
                        }
                        while (Unsigned.$less_uint((int)(++Idx), (int)llvm.array_lengthof(Found)) && Found[Idx]) {
                        }
                    } while (Unsigned.$less_uint((int)Idx, (int)Pos));
                }
                assert (Unsigned.$less_uint((int)Pos, (int)Components.size()) && llvm.$eq_StringRef((StringRef)Components.$at(Pos), Comp)) : "Component moved wrong!";
                Found[Pos] = true;
                continue block6;
            }
        }
        std.string NormalizedEnvironment = new std.string();
        if (Environment2 == EnvironmentType.Android && ((StringRef)Components.$at(3)).startswith("androideabi")) {
            StringRef AndroidVersion = ((StringRef)Components.$at(3)).drop_front(std.strlen((char.ptr)NativePointer.$((String)"androideabi")));
            if (AndroidVersion.empty()) {
                ((StringRef)Components.$at(3)).$assignMove("android");
            } else {
                NormalizedEnvironment.$assignMove(new Twine("android", AndroidVersion).str());
                ((StringRef)Components.$at(3)).$assignMove(new StringRef(NormalizedEnvironment));
            }
        }
        if (OS == OSType.Win32) {
            Components.resize(4);
            ((StringRef)Components.$at(2)).$assignMove("windows");
            if (Environment2 == EnvironmentType.UnknownEnvironment) {
                if (ObjectFormat == ObjectFormatType.UnknownObjectFormat || ObjectFormat == ObjectFormatType.COFF) {
                    ((StringRef)Components.$at(3)).$assignMove("msvc");
                } else {
                    ((StringRef)Components.$at(3)).$assignMove(TripleStatics.getObjectFormatTypeName(ObjectFormat));
                }
            }
        } else if (IsMinGW32) {
            Components.resize(4);
            ((StringRef)Components.$at(2)).$assignMove("windows");
            ((StringRef)Components.$at(3)).$assignMove("gnu");
        } else if (IsCygwin) {
            Components.resize(4);
            ((StringRef)Components.$at(2)).$assignMove("windows");
            ((StringRef)Components.$at(3)).$assignMove("cygnus");
        }
        if ((IsMinGW32 || IsCygwin || OS == OSType.Win32 && Environment2 != EnvironmentType.UnknownEnvironment) && ObjectFormat != ObjectFormatType.UnknownObjectFormat && ObjectFormat != ObjectFormatType.COFF) {
            Components.resize(5);
            ((StringRef)Components.$at(4)).$assignMove(TripleStatics.getObjectFormatTypeName(ObjectFormat));
        }
        std.string Normalized = new std.string();
        int e = Components.size();
        for (int i = 0; i != e; ++i) {
            if (i != 0) {
                Normalized.$addassign((byte)45);
            }
            llvm.$addassign_str_StringRef(Normalized, (StringRef)Components.$at(i));
        }
        return Normalized;
    }

    public std.string normalize() {
        return Triple.normalize(new StringRef(this.Data));
    }

    public ArchType getArch() {
        return this.Arch;
    }

    public SubArchType getSubArch() {
        return this.SubArch;
    }

    public VendorType getVendor() {
        return this.Vendor;
    }

    public OSType getOS() {
        return this.OS;
    }

    public boolean hasEnvironment() {
        return llvm.$noteq_StringRef(this.getEnvironmentName(), "");
    }

    public EnvironmentType getEnvironment() {
        return this.Environment;
    }

    public void getEnvironmentVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        StringRef EnvironmentTypeName;
        StringRef EnvironmentName = this.getEnvironmentName();
        if (EnvironmentName.startswith(EnvironmentTypeName = new StringRef(Triple.getEnvironmentTypeName(this.getEnvironment())))) {
            EnvironmentName.$assignMove(EnvironmentName.substr(EnvironmentTypeName.size()));
        }
        TripleStatics.parseVersionFromName(EnvironmentName, Major, Minor, Micro);
    }

    public ObjectFormatType getObjectFormat() {
        return this.ObjectFormat;
    }

    public void getOSVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        StringRef OSTypeName;
        StringRef OSName = this.getOSName();
        if (OSName.startswith(OSTypeName = new StringRef(Triple.getOSTypeName(this.getOS())))) {
            OSName.$assign$substr(OSTypeName.size());
        }
        TripleStatics.parseVersionFromName(OSName, Major, Minor, Micro);
    }

    public int getOSMajorVersion() {
        uint.ref Maj = NativePointer.create_uint$ref();
        uint.ref Min = NativePointer.create_uint$ref();
        uint.ref Micro = NativePointer.create_uint$ref();
        this.getOSVersion(Maj, Min, Micro);
        return Maj.$deref();
    }

    public boolean getMacOSXVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        this.getOSVersion(Major, Minor, Micro);
        switch (this.getOS()) {
            default: {
                throw new llvm_unreachable("unexpected OS for Darwin triple");
            }
            case Darwin: {
                if (Major.$deref() == 0) {
                    Major.$set(8);
                }
                if (Unsigned.$less_uint((int)Major.$deref(), (int)4)) {
                    return false;
                }
                Micro.$set(0);
                Minor.$set(Major.$deref() - 4);
                Major.$set(10);
                break;
            }
            case MacOSX: {
                if (Major.$deref() == 0) {
                    Major.$set(10);
                    Minor.$set(4);
                }
                if (Major.$deref() == 10) break;
                return false;
            }
            case IOS: 
            case TvOS: 
            case WatchOS: {
                Major.$set(10);
                Minor.$set(4);
                Micro.$set(0);
            }
        }
        return true;
    }

    public void getiOSVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        switch (this.getOS()) {
            default: {
                throw new llvm_unreachable("unexpected OS for Darwin triple");
            }
            case Darwin: 
            case MacOSX: {
                Major.$set(5);
                Minor.$set(0);
                Micro.$set(0);
                break;
            }
            case IOS: 
            case TvOS: {
                this.getOSVersion(Major, Minor, Micro);
                if (Major.$deref() != 0) break;
                Major.$set(this.getArch() == ArchType.aarch64 ? 7 : 5);
                break;
            }
            case WatchOS: {
                throw new llvm_unreachable("conflicting triple info");
            }
        }
    }

    public void getWatchOSVersion(uint.ref Major, uint.ref Minor, uint.ref Micro) {
        switch (this.getOS()) {
            default: {
                throw new llvm_unreachable("unexpected OS for Darwin triple");
            }
            case Darwin: 
            case MacOSX: {
                Major.$set(2);
                Minor.$set(0);
                Micro.$set(0);
                break;
            }
            case WatchOS: {
                this.getOSVersion(Major, Minor, Micro);
                if (Major.$deref() != 0) break;
                Major.$set(2);
                break;
            }
            case IOS: {
                throw new llvm_unreachable("conflicting triple info");
            }
        }
    }

    public std.string str() {
        return this.Data;
    }

    public std.string getTriple() {
        return this.Data;
    }

    public StringRef getArchName() {
        return (StringRef)new StringRef((std.string)this.Data).split((byte)45).first;
    }

    public StringRef getVendorName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)45).second;
        return (StringRef)Tmp.split((byte)45).first;
    }

    public StringRef getOSName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)45).second;
        Tmp.$assignMove((StringRef)Tmp.split((byte)45).second);
        return (StringRef)Tmp.split((byte)45).first;
    }

    public StringRef getEnvironmentName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)45).second;
        Tmp.$assignMove((StringRef)Tmp.split((byte)45).second);
        return (StringRef)Tmp.split((byte)45).second;
    }

    public StringRef getOSAndEnvironmentName() {
        StringRef Tmp = (StringRef)new StringRef((std.string)this.Data).split((byte)45).second;
        return (StringRef)Tmp.split((byte)45).second;
    }

    public boolean isArch64Bit() {
        return TripleStatics.getArchPointerBitWidth(this.getArch()) == 64;
    }

    public boolean isArch32Bit() {
        return TripleStatics.getArchPointerBitWidth(this.getArch()) == 32;
    }

    public boolean isArch16Bit() {
        return TripleStatics.getArchPointerBitWidth(this.getArch()) == 16;
    }

    public boolean isOSVersionLT(int Major) {
        return this.isOSVersionLT(Major, 0, 0);
    }

    public boolean isOSVersionLT(int Major, int Minor) {
        return this.isOSVersionLT(Major, Minor, 0);
    }

    public boolean isOSVersionLT(int Major, int Minor, int Micro) {
        int[] LHS = NativePointer.new$uint((int)3);
        this.getOSVersion(NativePointer.create_uint$ref((int[])LHS, (int)0), NativePointer.create_uint$ref((int[])LHS, (int)1), NativePointer.create_uint$ref((int[])LHS, (int)2));
        if (LHS[0] != Major) {
            return Unsigned.$less_uint((int)LHS[0], (int)Major);
        }
        if (LHS[1] != Minor) {
            return Unsigned.$less_uint((int)LHS[1], (int)Minor);
        }
        if (LHS[2] != Micro) {
            return Unsigned.$less_uint((int)LHS[1], (int)Micro);
        }
        return false;
    }

    public boolean isOSVersionLT(Triple Other) {
        int[] RHS = NativePointer.new$uint((int)3);
        Other.getOSVersion(NativePointer.create_uint$ref((int[])RHS, (int)0), NativePointer.create_uint$ref((int[])RHS, (int)1), NativePointer.create_uint$ref((int[])RHS, (int)2));
        return this.isOSVersionLT(RHS[0], RHS[1], RHS[2]);
    }

    public boolean isMacOSXVersionLT(int Major) {
        return this.isMacOSXVersionLT(Major, 0, 0);
    }

    public boolean isMacOSXVersionLT(int Major, int Minor) {
        return this.isMacOSXVersionLT(Major, Minor, 0);
    }

    public boolean isMacOSXVersionLT(int Major, int Minor, int Micro) {
        assert (this.isMacOSX()) : "Not an OS X triple!";
        if (this.getOS() == OSType.MacOSX) {
            return this.isOSVersionLT(Major, Minor, Micro);
        }
        assert (Major == 10) : "Unexpected major version";
        return this.isOSVersionLT(Minor + 4, Micro, 0);
    }

    public boolean isMacOSX() {
        return this.getOS() == OSType.Darwin || this.getOS() == OSType.MacOSX;
    }

    public boolean isiOS() {
        return this.getOS() == OSType.IOS || this.isTvOS();
    }

    public boolean isTvOS() {
        return this.getOS() == OSType.TvOS;
    }

    public boolean isWatchOS() {
        return this.getOS() == OSType.WatchOS;
    }

    public boolean isWatchABI() {
        return this.getSubArch() == SubArchType.ARMSubArch_v7k;
    }

    public boolean isOSDarwin() {
        return this.isMacOSX() || this.isiOS() || this.isWatchOS();
    }

    public boolean isOSNetBSD() {
        return this.getOS() == OSType.NetBSD;
    }

    public boolean isOSOpenBSD() {
        return this.getOS() == OSType.OpenBSD;
    }

    public boolean isOSFreeBSD() {
        return this.getOS() == OSType.FreeBSD;
    }

    public boolean isOSDragonFly() {
        return this.getOS() == OSType.DragonFly;
    }

    public boolean isOSSolaris() {
        return this.getOS() == OSType.Solaris;
    }

    public boolean isOSBitrig() {
        return this.getOS() == OSType.Bitrig;
    }

    public boolean isOSIAMCU() {
        return this.getOS() == OSType.ELFIAMCU;
    }

    public boolean isGNUEnvironment() {
        EnvironmentType Env = this.getEnvironment();
        return Env == EnvironmentType.GNU || Env == EnvironmentType.GNUABI64 || Env == EnvironmentType.GNUEABI || Env == EnvironmentType.GNUEABIHF || Env == EnvironmentType.GNUX32;
    }

    public boolean isWindowsMSVCEnvironment() {
        return this.getOS() == OSType.Win32 && (this.getEnvironment() == EnvironmentType.UnknownEnvironment || this.getEnvironment() == EnvironmentType.MSVC);
    }

    public boolean isKnownWindowsMSVCEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.MSVC;
    }

    public boolean isWindowsCoreCLREnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.CoreCLR;
    }

    public boolean isWindowsItaniumEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.Itanium;
    }

    public boolean isWindowsCygwinEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.Cygnus;
    }

    public boolean isWindowsGNUEnvironment() {
        return this.getOS() == OSType.Win32 && this.getEnvironment() == EnvironmentType.GNU;
    }

    public boolean isOSCygMing() {
        return this.isWindowsCygwinEnvironment() || this.isWindowsGNUEnvironment();
    }

    public boolean isOSMSVCRT() {
        return this.isWindowsMSVCEnvironment() || this.isWindowsGNUEnvironment() || this.isWindowsItaniumEnvironment();
    }

    public boolean isOSWindows() {
        return this.getOS() == OSType.Win32;
    }

    public boolean isOSNaCl() {
        return this.getOS() == OSType.NaCl;
    }

    public boolean isOSLinux() {
        return this.getOS() == OSType.Linux;
    }

    public boolean isOSKFreeBSD() {
        return this.getOS() == OSType.KFreeBSD;
    }

    public boolean isOSGlibc() {
        return this.getOS() == OSType.Linux || this.getOS() == OSType.KFreeBSD;
    }

    public boolean isOSBinFormatELF() {
        return this.getObjectFormat() == ObjectFormatType.ELF;
    }

    public boolean isOSBinFormatCOFF() {
        return this.getObjectFormat() == ObjectFormatType.COFF;
    }

    public boolean isOSBinFormatMachO() {
        return this.getObjectFormat() == ObjectFormatType.MachO;
    }

    public boolean isPS4CPU() {
        return this.getArch() == ArchType.x86_64 && this.getVendor() == VendorType.SCEI && this.getOS() == OSType.PS4;
    }

    public boolean isPS4() {
        return this.getVendor() == VendorType.SCEI && this.getOS() == OSType.PS4;
    }

    public boolean isAndroid() {
        return this.getEnvironment() == EnvironmentType.Android;
    }

    public boolean isMusl() {
        return this.getEnvironment() == EnvironmentType.Musl || this.getEnvironment() == EnvironmentType.MuslEABI || this.getEnvironment() == EnvironmentType.MuslEABIHF;
    }

    public boolean isNVPTX() {
        return this.getArch() == ArchType.nvptx || this.getArch() == ArchType.nvptx64;
    }

    public boolean supportsCOMDAT() {
        return !this.isOSBinFormatMachO();
    }

    public void setArch(ArchType Kind2) {
        this.setArchName(new StringRef(Triple.getArchTypeName(Kind2)));
    }

    public void setVendor(VendorType Kind2) {
        this.setVendorName(new StringRef(Triple.getVendorTypeName(Kind2)));
    }

    public void setOS(OSType Kind2) {
        this.setOSName(new StringRef(Triple.getOSTypeName(Kind2)));
    }

    public void setEnvironment(EnvironmentType Kind2) {
        if (this.ObjectFormat == TripleStatics.getDefaultFormat(this)) {
            this.setEnvironmentName(new StringRef(Triple.getEnvironmentTypeName(Kind2)));
            return;
        }
        this.setEnvironmentName(new StringRef(llvm.$add_Twine(llvm.$add_Twine(new Twine(Triple.getEnvironmentTypeName(Kind2)), new Twine(NativePointer.$MINUS)), new Twine(TripleStatics.getObjectFormatTypeName(this.ObjectFormat))).str()));
    }

    public void setObjectFormat(ObjectFormatType Kind2) {
        if (this.Environment == EnvironmentType.UnknownEnvironment) {
            this.setEnvironmentName(new StringRef(TripleStatics.getObjectFormatTypeName(Kind2)));
            return;
        }
        this.setEnvironmentName(new StringRef(llvm.$add_Twine(llvm.$add_Twine(new Twine(Triple.getEnvironmentTypeName(this.Environment)), new Twine(NativePointer.$MINUS)), new Twine(TripleStatics.getObjectFormatTypeName(Kind2))).str()));
    }

    public void setTriple(Twine Str) {
        this.$assignMove(new Triple(Str));
    }

    public void setArchName(StringRef Str) {
        SmallString Triple2 = new SmallString(64);
        Triple2.$addassign(Str);
        Triple2.$addassign("-");
        Triple2.$addassign(this.getVendorName());
        Triple2.$addassign("-");
        Triple2.$addassign(this.getOSAndEnvironmentName());
        this.setTriple(new Twine(Triple2));
    }

    public void setVendorName(StringRef Str) {
        this.setTriple(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_StringRef_char$ptr$C(this.getArchName(), NativePointer.$MINUS), new Twine(Str)), new Twine(NativePointer.$MINUS)), new Twine(this.getOSAndEnvironmentName())));
    }

    public void setOSName(StringRef Str) {
        if (this.hasEnvironment()) {
            this.setTriple(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_StringRef_char$ptr$C(this.getArchName(), NativePointer.$MINUS), new Twine(this.getVendorName())), new Twine(NativePointer.$MINUS)), new Twine(Str)), new Twine(NativePointer.$MINUS)), new Twine(this.getEnvironmentName())));
        } else {
            this.setTriple(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_StringRef_char$ptr$C(this.getArchName(), NativePointer.$MINUS), new Twine(this.getVendorName())), new Twine(NativePointer.$MINUS)), new Twine(Str)));
        }
    }

    public void setEnvironmentName(StringRef Str) {
        this.setTriple(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_StringRef_char$ptr$C(this.getArchName(), NativePointer.$MINUS), new Twine(this.getVendorName())), new Twine(NativePointer.$MINUS)), new Twine(this.getOSName())), new Twine(NativePointer.$MINUS)), new Twine(Str)));
    }

    public void setOSAndEnvironmentName(StringRef Str) {
        this.setTriple(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_Twine(llvm.$add_StringRef_char$ptr$C(this.getArchName(), NativePointer.$MINUS), new Twine(this.getVendorName())), new Twine(NativePointer.$MINUS)), new Twine(Str)));
    }

    public Triple get32BitArchVariant() {
        Triple T4 = new Triple(this);
        switch (this.getArch()) {
            case UnknownArch: 
            case amdgcn: 
            case avr: 
            case bpfel: 
            case bpfeb: 
            case msp430: 
            case systemz: 
            case ppc64le: {
                T4.setArch(ArchType.UnknownArch);
                break;
            }
            case amdil: 
            case hsail: 
            case spir: 
            case arm: 
            case armeb: 
            case hexagon: 
            case kalimba: 
            case le32: 
            case mips: 
            case mipsel: 
            case nvptx: 
            case ppc: 
            case r600: 
            case sparc: 
            case sparcel: 
            case tce: 
            case thumb: 
            case thumbeb: 
            case x86: 
            case xcore: 
            case lanai: 
            case shave: 
            case wasm32: 
            case renderscript32: {
                break;
            }
            case aarch64: {
                T4.setArch(ArchType.arm);
                break;
            }
            case aarch64_be: {
                T4.setArch(ArchType.armeb);
                break;
            }
            case le64: {
                T4.setArch(ArchType.le32);
                break;
            }
            case mips64: {
                T4.setArch(ArchType.mips);
                break;
            }
            case mips64el: {
                T4.setArch(ArchType.mipsel);
                break;
            }
            case nvptx64: {
                T4.setArch(ArchType.nvptx);
                break;
            }
            case ppc64: {
                T4.setArch(ArchType.ppc);
                break;
            }
            case sparcv9: {
                T4.setArch(ArchType.sparc);
                break;
            }
            case x86_64: {
                T4.setArch(ArchType.x86);
                break;
            }
            case amdil64: {
                T4.setArch(ArchType.amdil);
                break;
            }
            case hsail64: {
                T4.setArch(ArchType.hsail);
                break;
            }
            case spir64: {
                T4.setArch(ArchType.spir);
                break;
            }
            case wasm64: {
                T4.setArch(ArchType.wasm32);
                break;
            }
            case renderscript64: {
                T4.setArch(ArchType.renderscript32);
            }
        }
        return T4;
    }

    public Triple get64BitArchVariant() {
        Triple T4 = new Triple(this);
        switch (this.getArch()) {
            case UnknownArch: 
            case avr: 
            case msp430: 
            case hexagon: 
            case kalimba: 
            case r600: 
            case sparcel: 
            case tce: 
            case xcore: 
            case lanai: 
            case shave: {
                T4.setArch(ArchType.UnknownArch);
                break;
            }
            case amdgcn: 
            case bpfel: 
            case bpfeb: 
            case systemz: 
            case ppc64le: 
            case aarch64: 
            case aarch64_be: 
            case le64: 
            case mips64: 
            case mips64el: 
            case nvptx64: 
            case ppc64: 
            case sparcv9: 
            case x86_64: 
            case amdil64: 
            case hsail64: 
            case spir64: 
            case wasm64: 
            case renderscript64: {
                break;
            }
            case arm: {
                T4.setArch(ArchType.aarch64);
                break;
            }
            case armeb: {
                T4.setArch(ArchType.aarch64_be);
                break;
            }
            case le32: {
                T4.setArch(ArchType.le64);
                break;
            }
            case mips: {
                T4.setArch(ArchType.mips64);
                break;
            }
            case mipsel: {
                T4.setArch(ArchType.mips64el);
                break;
            }
            case nvptx: {
                T4.setArch(ArchType.nvptx64);
                break;
            }
            case ppc: {
                T4.setArch(ArchType.ppc64);
                break;
            }
            case sparc: {
                T4.setArch(ArchType.sparcv9);
                break;
            }
            case x86: {
                T4.setArch(ArchType.x86_64);
                break;
            }
            case amdil: {
                T4.setArch(ArchType.amdil64);
                break;
            }
            case hsail: {
                T4.setArch(ArchType.hsail64);
                break;
            }
            case spir: {
                T4.setArch(ArchType.spir64);
                break;
            }
            case thumb: {
                T4.setArch(ArchType.aarch64);
                break;
            }
            case thumbeb: {
                T4.setArch(ArchType.aarch64_be);
                break;
            }
            case wasm32: {
                T4.setArch(ArchType.wasm64);
                break;
            }
            case renderscript32: {
                T4.setArch(ArchType.renderscript64);
            }
        }
        return T4;
    }

    public Triple getBigEndianArchVariant() {
        Triple T4 = new Triple(this);
        if (!this.isLittleEndian()) {
            return T4;
        }
        switch (this.getArch()) {
            case UnknownArch: 
            case amdgcn: 
            case avr: 
            case msp430: 
            case amdil: 
            case hsail: 
            case spir: 
            case arm: 
            case hexagon: 
            case kalimba: 
            case le32: 
            case nvptx: 
            case r600: 
            case thumb: 
            case x86: 
            case xcore: 
            case shave: 
            case wasm32: 
            case renderscript32: 
            case le64: 
            case nvptx64: 
            case x86_64: 
            case amdil64: 
            case hsail64: 
            case spir64: 
            case wasm64: 
            case renderscript64: {
                T4.setArch(ArchType.UnknownArch);
                break;
            }
            case aarch64: {
                T4.setArch(ArchType.aarch64_be);
                break;
            }
            case bpfel: {
                T4.setArch(ArchType.bpfeb);
                break;
            }
            case mips64el: {
                T4.setArch(ArchType.mips64);
                break;
            }
            case mipsel: {
                T4.setArch(ArchType.mips);
                break;
            }
            case ppc64le: {
                T4.setArch(ArchType.ppc64);
                break;
            }
            case sparcel: {
                T4.setArch(ArchType.sparc);
                break;
            }
            default: {
                throw new llvm_unreachable("getBigEndianArchVariant: unknown triple.");
            }
        }
        return T4;
    }

    public Triple getLittleEndianArchVariant() {
        Triple T4 = new Triple(this);
        if (this.isLittleEndian()) {
            return T4;
        }
        switch (this.getArch()) {
            case UnknownArch: 
            case systemz: 
            case armeb: 
            case ppc: 
            case tce: 
            case thumbeb: 
            case lanai: 
            case sparcv9: {
                T4.setArch(ArchType.UnknownArch);
                break;
            }
            case aarch64_be: {
                T4.setArch(ArchType.aarch64);
                break;
            }
            case bpfeb: {
                T4.setArch(ArchType.bpfel);
                break;
            }
            case mips64: {
                T4.setArch(ArchType.mips64el);
                break;
            }
            case mips: {
                T4.setArch(ArchType.mipsel);
                break;
            }
            case ppc64: {
                T4.setArch(ArchType.ppc64le);
                break;
            }
            case sparc: {
                T4.setArch(ArchType.sparcel);
                break;
            }
            default: {
                throw new llvm_unreachable("getLittleEndianArchVariant: unknown triple.");
            }
        }
        return T4;
    }

    public StringRef getARMCPUForArch() {
        return this.getARMCPUForArch(new StringRef());
    }

    public StringRef getARMCPUForArch(StringRef MArch) {
        if (MArch.empty()) {
            MArch.$assignMove(this.getArchName());
        }
        MArch.$assignMove(ARM.getCanonicalArchName(MArch));
        switch (this.getOS()) {
            case FreeBSD: 
            case NetBSD: {
                if (MArch.empty() || !llvm.$eq_StringRef(MArch, "v6")) break;
                return new StringRef("arm1176jzf-s");
            }
            case Win32: {
                return new StringRef("cortex-a9");
            }
            case MacOSX: 
            case IOS: 
            case TvOS: 
            case WatchOS: {
                if (!llvm.$eq_StringRef(MArch, "v7k")) break;
                return new StringRef("cortex-a7");
            }
        }
        if (MArch.empty()) {
            return new StringRef();
        }
        StringRef CPU = ARM.getDefaultCPU(MArch);
        if (!CPU.empty()) {
            return CPU;
        }
        switch (this.getOS()) {
            case NetBSD: {
                switch (this.getEnvironment()) {
                    case GNUEABIHF: 
                    case GNUEABI: 
                    case EABIHF: 
                    case EABI: {
                        return new StringRef("arm926ej-s");
                    }
                }
                return new StringRef("strongarm");
            }
            case NaCl: {
                return new StringRef("cortex-a8");
            }
        }
        switch (this.getEnvironment()) {
            case GNUEABIHF: 
            case EABIHF: 
            case MuslEABIHF: {
                return new StringRef("arm1176jzf-s");
            }
        }
        return new StringRef("arm7tdmi");
    }

    public boolean isLittleEndian() {
        switch (this.getArch()) {
            case amdgcn: 
            case avr: 
            case bpfel: 
            case msp430: 
            case ppc64le: 
            case amdil: 
            case hsail: 
            case spir: 
            case arm: 
            case hexagon: 
            case kalimba: 
            case le32: 
            case mipsel: 
            case nvptx: 
            case r600: 
            case sparcel: 
            case thumb: 
            case x86: 
            case xcore: 
            case shave: 
            case wasm32: 
            case renderscript32: 
            case aarch64: 
            case le64: 
            case mips64el: 
            case nvptx64: 
            case x86_64: 
            case amdil64: 
            case hsail64: 
            case spir64: 
            case wasm64: 
            case renderscript64: {
                return true;
            }
        }
        return false;
    }

    public static char.ptr getArchTypeName(ArchType Kind2) {
        switch (Kind2) {
            case UnknownArch: {
                return NativePointer.$unknown;
            }
            case aarch64: {
                return NativePointer.$((String)"aarch64");
            }
            case aarch64_be: {
                return NativePointer.$((String)"aarch64_be");
            }
            case arm: {
                return NativePointer.$((String)"arm");
            }
            case armeb: {
                return NativePointer.$((String)"armeb");
            }
            case avr: {
                return NativePointer.$((String)"avr");
            }
            case bpfel: {
                return NativePointer.$((String)"bpfel");
            }
            case bpfeb: {
                return NativePointer.$((String)"bpfeb");
            }
            case hexagon: {
                return NativePointer.$((String)"hexagon");
            }
            case mips: {
                return NativePointer.$((String)"mips");
            }
            case mipsel: {
                return NativePointer.$((String)"mipsel");
            }
            case mips64: {
                return NativePointer.$((String)"mips64");
            }
            case mips64el: {
                return NativePointer.$((String)"mips64el");
            }
            case msp430: {
                return NativePointer.$((String)"msp430");
            }
            case ppc64: {
                return NativePointer.$((String)"powerpc64");
            }
            case ppc64le: {
                return NativePointer.$((String)"powerpc64le");
            }
            case ppc: {
                return NativePointer.$((String)"powerpc");
            }
            case r600: {
                return NativePointer.$((String)"r600");
            }
            case amdgcn: {
                return NativePointer.$((String)"amdgcn");
            }
            case sparc: {
                return NativePointer.$((String)"sparc");
            }
            case sparcv9: {
                return NativePointer.$((String)"sparcv9");
            }
            case sparcel: {
                return NativePointer.$((String)"sparcel");
            }
            case systemz: {
                return NativePointer.$((String)"s390x");
            }
            case tce: {
                return NativePointer.$((String)"tce");
            }
            case thumb: {
                return NativePointer.$((String)"thumb");
            }
            case thumbeb: {
                return NativePointer.$((String)"thumbeb");
            }
            case x86: {
                return NativePointer.$((String)"i386");
            }
            case x86_64: {
                return NativePointer.$((String)"x86_64");
            }
            case xcore: {
                return NativePointer.$((String)"xcore");
            }
            case nvptx: {
                return NativePointer.$((String)"nvptx");
            }
            case nvptx64: {
                return NativePointer.$((String)"nvptx64");
            }
            case le32: {
                return NativePointer.$((String)"le32");
            }
            case le64: {
                return NativePointer.$((String)"le64");
            }
            case amdil: {
                return NativePointer.$((String)"amdil");
            }
            case amdil64: {
                return NativePointer.$((String)"amdil64");
            }
            case hsail: {
                return NativePointer.$((String)"hsail");
            }
            case hsail64: {
                return NativePointer.$((String)"hsail64");
            }
            case spir: {
                return NativePointer.$((String)"spir");
            }
            case spir64: {
                return NativePointer.$((String)"spir64");
            }
            case kalimba: {
                return NativePointer.$((String)"kalimba");
            }
            case lanai: {
                return NativePointer.$((String)"lanai");
            }
            case shave: {
                return NativePointer.$((String)"shave");
            }
            case wasm32: {
                return NativePointer.$((String)"wasm32");
            }
            case wasm64: {
                return NativePointer.$((String)"wasm64");
            }
            case renderscript32: {
                return NativePointer.$((String)"renderscript32");
            }
            case renderscript64: {
                return NativePointer.$((String)"renderscript64");
            }
        }
        throw new llvm_unreachable("Invalid ArchType!");
    }

    public static char.ptr getArchTypePrefix(ArchType Kind2) {
        switch (Kind2) {
            default: {
                return null;
            }
            case aarch64: 
            case aarch64_be: {
                return NativePointer.$((String)"aarch64");
            }
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                return NativePointer.$((String)"arm");
            }
            case avr: {
                return NativePointer.$((String)"avr");
            }
            case ppc64le: 
            case ppc: 
            case ppc64: {
                return NativePointer.$((String)"ppc");
            }
            case mips: 
            case mipsel: 
            case mips64: 
            case mips64el: {
                return NativePointer.$((String)"mips");
            }
            case hexagon: {
                return NativePointer.$((String)"hexagon");
            }
            case amdgcn: {
                return NativePointer.$((String)"amdgcn");
            }
            case r600: {
                return NativePointer.$((String)"r600");
            }
            case bpfel: 
            case bpfeb: {
                return NativePointer.$((String)"bpf");
            }
            case sparc: 
            case sparcel: 
            case sparcv9: {
                return NativePointer.$((String)"sparc");
            }
            case systemz: {
                return NativePointer.$((String)"s390");
            }
            case x86: 
            case x86_64: {
                return NativePointer.$((String)"x86");
            }
            case xcore: {
                return NativePointer.$((String)"xcore");
            }
            case nvptx: {
                return NativePointer.$((String)"nvvm");
            }
            case nvptx64: {
                return NativePointer.$((String)"nvvm");
            }
            case le32: {
                return NativePointer.$((String)"le32");
            }
            case le64: {
                return NativePointer.$((String)"le64");
            }
            case amdil: 
            case amdil64: {
                return NativePointer.$((String)"amdil");
            }
            case hsail: 
            case hsail64: {
                return NativePointer.$((String)"hsail");
            }
            case spir: 
            case spir64: {
                return NativePointer.$((String)"spir");
            }
            case kalimba: {
                return NativePointer.$((String)"kalimba");
            }
            case lanai: {
                return NativePointer.$((String)"lanai");
            }
            case shave: {
                return NativePointer.$((String)"shave");
            }
            case wasm32: 
            case wasm64: 
        }
        return NativePointer.$((String)"wasm");
    }

    public static char.ptr getVendorTypeName(VendorType Kind2) {
        switch (Kind2) {
            case UnknownVendor: {
                return NativePointer.$unknown;
            }
            case Apple: {
                return NativePointer.$((String)"apple");
            }
            case PC: {
                return NativePointer.$((String)"pc");
            }
            case SCEI: {
                return NativePointer.$((String)"scei");
            }
            case BGP: {
                return NativePointer.$((String)"bgp");
            }
            case BGQ: {
                return NativePointer.$((String)"bgq");
            }
            case Freescale: {
                return NativePointer.$((String)"fsl");
            }
            case IBM: {
                return NativePointer.$((String)"ibm");
            }
            case ImaginationTechnologies: {
                return NativePointer.$((String)"img");
            }
            case MipsTechnologies: {
                return NativePointer.$((String)"mti");
            }
            case NVIDIA: {
                return NativePointer.$((String)"nvidia");
            }
            case CSR: {
                return NativePointer.$((String)"csr");
            }
            case Myriad: {
                return NativePointer.$((String)"myriad");
            }
            case AMD: {
                return NativePointer.$((String)"amd");
            }
            case Mesa: {
                return NativePointer.$((String)"mesa");
            }
        }
        throw new llvm_unreachable("Invalid VendorType!");
    }

    public static char.ptr getOSTypeName(OSType Kind2) {
        switch (Kind2) {
            case UnknownOS: {
                return NativePointer.$unknown;
            }
            case CloudABI: {
                return NativePointer.$((String)"cloudabi");
            }
            case Darwin: {
                return NativePointer.$((String)"darwin");
            }
            case DragonFly: {
                return NativePointer.$((String)"dragonfly");
            }
            case FreeBSD: {
                return NativePointer.$((String)"freebsd");
            }
            case IOS: {
                return NativePointer.$((String)"ios");
            }
            case KFreeBSD: {
                return NativePointer.$((String)"kfreebsd");
            }
            case Linux: {
                return NativePointer.$((String)"linux");
            }
            case Lv2: {
                return NativePointer.$((String)"lv2");
            }
            case MacOSX: {
                return NativePointer.$((String)"macosx");
            }
            case NetBSD: {
                return NativePointer.$((String)"netbsd");
            }
            case OpenBSD: {
                return NativePointer.$((String)"openbsd");
            }
            case Solaris: {
                return NativePointer.$((String)"solaris");
            }
            case Win32: {
                return NativePointer.$((String)"windows");
            }
            case Haiku: {
                return NativePointer.$((String)"haiku");
            }
            case Minix: {
                return NativePointer.$((String)"minix");
            }
            case RTEMS: {
                return NativePointer.$((String)"rtems");
            }
            case NaCl: {
                return NativePointer.$((String)"nacl");
            }
            case CNK: {
                return NativePointer.$((String)"cnk");
            }
            case Bitrig: {
                return NativePointer.$((String)"bitrig");
            }
            case AIX: {
                return NativePointer.$((String)"aix");
            }
            case CUDA: {
                return NativePointer.$((String)"cuda");
            }
            case NVCL: {
                return NativePointer.$((String)"nvcl");
            }
            case AMDHSA: {
                return NativePointer.$((String)"amdhsa");
            }
            case PS4: {
                return NativePointer.$((String)"ps4");
            }
            case ELFIAMCU: {
                return NativePointer.$((String)"elfiamcu");
            }
            case TvOS: {
                return NativePointer.$((String)"tvos");
            }
            case WatchOS: {
                return NativePointer.$((String)"watchos");
            }
            case Mesa3D: {
                return NativePointer.$((String)"mesa3d");
            }
        }
        throw new llvm_unreachable("Invalid OSType");
    }

    public static char.ptr getEnvironmentTypeName(EnvironmentType Kind2) {
        switch (Kind2) {
            case UnknownEnvironment: {
                return NativePointer.$unknown;
            }
            case GNU: {
                return NativePointer.$((String)"gnu");
            }
            case GNUABI64: {
                return NativePointer.$((String)"gnuabi64");
            }
            case GNUEABIHF: {
                return NativePointer.$((String)"gnueabihf");
            }
            case GNUEABI: {
                return NativePointer.$((String)"gnueabi");
            }
            case GNUX32: {
                return NativePointer.$((String)"gnux32");
            }
            case CODE16: {
                return NativePointer.$((String)"code16");
            }
            case EABI: {
                return NativePointer.$((String)"eabi");
            }
            case EABIHF: {
                return NativePointer.$((String)"eabihf");
            }
            case Android: {
                return NativePointer.$((String)"android");
            }
            case Musl: {
                return NativePointer.$((String)"musl");
            }
            case MuslEABI: {
                return NativePointer.$((String)"musleabi");
            }
            case MuslEABIHF: {
                return NativePointer.$((String)"musleabihf");
            }
            case MSVC: {
                return NativePointer.$((String)"msvc");
            }
            case Itanium: {
                return NativePointer.$((String)"itanium");
            }
            case Cygnus: {
                return NativePointer.$((String)"cygnus");
            }
            case AMDOpenCL: {
                return NativePointer.$((String)"amdopencl");
            }
            case CoreCLR: {
                return NativePointer.$((String)"coreclr");
            }
        }
        throw new llvm_unreachable("Invalid EnvironmentType!");
    }

    public static ArchType getArchTypeForLLVMName(StringRef Name2) {
        ArchType BPFArch = TripleStatics.parseBPFArch(Name2);
        return new StringSwitch<ArchType>(Name2).Case("aarch64", ArchType.aarch64).Case("aarch64_be", ArchType.aarch64_be).Case("arm64", ArchType.aarch64).Case("arm", ArchType.arm).Case("armeb", ArchType.armeb).Case("avr", ArchType.avr).StartsWith("bpf", BPFArch).Case("mips", ArchType.mips).Case("mipsel", ArchType.mipsel).Case("mips64", ArchType.mips64).Case("mips64el", ArchType.mips64el).Case("msp430", ArchType.msp430).Case("ppc64", ArchType.ppc64).Case("ppc32", ArchType.ppc).Case("ppc", ArchType.ppc).Case("ppc64le", ArchType.ppc64le).Case("r600", ArchType.r600).Case("amdgcn", ArchType.amdgcn).Case("hexagon", ArchType.hexagon).Case("sparc", ArchType.sparc).Case("sparcel", ArchType.sparcel).Case("sparcv9", ArchType.sparcv9).Case("systemz", ArchType.systemz).Case("tce", ArchType.tce).Case("thumb", ArchType.thumb).Case("thumbeb", ArchType.thumbeb).Case("x86", ArchType.x86).Case("x86-64", ArchType.x86_64).Case("xcore", ArchType.xcore).Case("nvptx", ArchType.nvptx).Case("nvptx64", ArchType.nvptx64).Case("le32", ArchType.le32).Case("le64", ArchType.le64).Case("amdil", ArchType.amdil).Case("amdil64", ArchType.amdil64).Case("hsail", ArchType.hsail).Case("hsail64", ArchType.hsail64).Case("spir", ArchType.spir).Case("spir64", ArchType.spir64).Case("kalimba", ArchType.kalimba).Case("lanai", ArchType.lanai).Case("shave", ArchType.shave).Case("wasm32", ArchType.wasm32).Case("wasm64", ArchType.wasm64).Case("renderscript32", ArchType.renderscript32).Case("renderscript64", ArchType.renderscript64).Default(ArchType.UnknownArch);
    }

    public Triple(Triple $Prm0) {
        this.Data = new std.string($Prm0.Data);
        this.Arch = $Prm0.Arch;
        this.SubArch = $Prm0.SubArch;
        this.Vendor = $Prm0.Vendor;
        this.OS = $Prm0.OS;
        this.Environment = $Prm0.Environment;
        this.ObjectFormat = $Prm0.ObjectFormat;
    }

    public Triple $assign(Triple $Prm0) {
        this.Data.$assign($Prm0.Data);
        this.Arch = $Prm0.Arch;
        this.SubArch = $Prm0.SubArch;
        this.Vendor = $Prm0.Vendor;
        this.OS = $Prm0.OS;
        this.Environment = $Prm0.Environment;
        this.ObjectFormat = $Prm0.ObjectFormat;
        return this;
    }

    public void $destroy() {
        this.Data.$destroy();
    }

    public Triple(JavaDifferentiators.JD.Move _dparam, Triple $Prm0) {
        this.Data = new std.string(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Data);
        this.Arch = $Prm0.Arch;
        this.SubArch = $Prm0.SubArch;
        this.Vendor = $Prm0.Vendor;
        this.OS = $Prm0.OS;
        this.Environment = $Prm0.Environment;
        this.ObjectFormat = $Prm0.ObjectFormat;
    }

    public Triple $assignMove(Triple $Prm0) {
        this.Data.$assignMove($Prm0.Data);
        this.Arch = $Prm0.Arch;
        this.SubArch = $Prm0.SubArch;
        this.Vendor = $Prm0.Vendor;
        this.OS = $Prm0.OS;
        this.Environment = $Prm0.Environment;
        this.ObjectFormat = $Prm0.ObjectFormat;
        return this;
    }

    public Triple clone() {
        return new Triple(this);
    }

    public String toString() {
        return "Data=" + this.Data + ", Arch=" + (Object)((Object)this.Arch) + ", SubArch=" + (Object)((Object)this.SubArch) + ", Vendor=" + (Object)((Object)this.Vendor) + ", OS=" + (Object)((Object)this.OS) + ", Environment=" + (Object)((Object)this.Environment) + ", ObjectFormat=" + (Object)((Object)this.ObjectFormat);
    }

    public static final class ObjectFormatType
    extends Enum<ObjectFormatType>
    implements Native.ComparableLower {
        public static final /* enum */ ObjectFormatType UnknownObjectFormat = new ObjectFormatType(0);
        public static final /* enum */ ObjectFormatType COFF = new ObjectFormatType(UnknownObjectFormat.getValue() + 1);
        public static final /* enum */ ObjectFormatType ELF = new ObjectFormatType(COFF.getValue() + 1);
        public static final /* enum */ ObjectFormatType MachO = new ObjectFormatType(ELF.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ObjectFormatType[] $VALUES;

        public static ObjectFormatType[] values() {
            return (ObjectFormatType[])$VALUES.clone();
        }

        public static ObjectFormatType valueOf(String name) {
            return Enum.valueOf(ObjectFormatType.class, name);
        }

        public static ObjectFormatType valueOf(int val) {
            ObjectFormatType out;
            ObjectFormatType objectFormatType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ObjectFormatType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ObjectFormatType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ObjectFormatType)((Object)obj)).value);
        }

        static {
            $VALUES = new ObjectFormatType[]{UnknownObjectFormat, COFF, ELF, MachO};
        }

        private static final class Values {
            private static final ObjectFormatType[] VALUES;
            private static final ObjectFormatType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ObjectFormatType kind : ObjectFormatType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ObjectFormatType[min < 0 ? 1 - min : 0];
                VALUES = new ObjectFormatType[max >= 0 ? 1 + max : 0];
                for (ObjectFormatType kind : ObjectFormatType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ObjectFormatType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ObjectFormatType)kind).value] = kind;
                }
            }
        }
    }

    public static final class EnvironmentType
    extends Enum<EnvironmentType>
    implements Native.ComparableLower {
        public static final /* enum */ EnvironmentType UnknownEnvironment = new EnvironmentType(0);
        public static final /* enum */ EnvironmentType GNU = new EnvironmentType(UnknownEnvironment.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUABI64 = new EnvironmentType(GNU.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUEABI = new EnvironmentType(GNUABI64.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUEABIHF = new EnvironmentType(GNUEABI.getValue() + 1);
        public static final /* enum */ EnvironmentType GNUX32 = new EnvironmentType(GNUEABIHF.getValue() + 1);
        public static final /* enum */ EnvironmentType CODE16 = new EnvironmentType(GNUX32.getValue() + 1);
        public static final /* enum */ EnvironmentType EABI = new EnvironmentType(CODE16.getValue() + 1);
        public static final /* enum */ EnvironmentType EABIHF = new EnvironmentType(EABI.getValue() + 1);
        public static final /* enum */ EnvironmentType Android = new EnvironmentType(EABIHF.getValue() + 1);
        public static final /* enum */ EnvironmentType Musl = new EnvironmentType(Android.getValue() + 1);
        public static final /* enum */ EnvironmentType MuslEABI = new EnvironmentType(Musl.getValue() + 1);
        public static final /* enum */ EnvironmentType MuslEABIHF = new EnvironmentType(MuslEABI.getValue() + 1);
        public static final /* enum */ EnvironmentType MSVC = new EnvironmentType(MuslEABIHF.getValue() + 1);
        public static final /* enum */ EnvironmentType Itanium = new EnvironmentType(MSVC.getValue() + 1);
        public static final /* enum */ EnvironmentType Cygnus = new EnvironmentType(Itanium.getValue() + 1);
        public static final /* enum */ EnvironmentType AMDOpenCL = new EnvironmentType(Cygnus.getValue() + 1);
        public static final /* enum */ EnvironmentType CoreCLR = new EnvironmentType(AMDOpenCL.getValue() + 1);
        public static final /* enum */ EnvironmentType LastEnvironmentType = new EnvironmentType(CoreCLR.getValue());
        private final int value;
        private static final /* synthetic */ EnvironmentType[] $VALUES;

        public static EnvironmentType[] values() {
            return (EnvironmentType[])$VALUES.clone();
        }

        public static EnvironmentType valueOf(String name) {
            return Enum.valueOf(EnvironmentType.class, name);
        }

        public static EnvironmentType valueOf(int val) {
            EnvironmentType out;
            EnvironmentType environmentType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private EnvironmentType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((EnvironmentType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((EnvironmentType)((Object)obj)).value);
        }

        static {
            $VALUES = new EnvironmentType[]{UnknownEnvironment, GNU, GNUABI64, GNUEABI, GNUEABIHF, GNUX32, CODE16, EABI, EABIHF, Android, Musl, MuslEABI, MuslEABIHF, MSVC, Itanium, Cygnus, AMDOpenCL, CoreCLR, LastEnvironmentType};
        }

        private static final class Values {
            private static final EnvironmentType[] VALUES;
            private static final EnvironmentType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (EnvironmentType kind : EnvironmentType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new EnvironmentType[min < 0 ? 1 - min : 0];
                VALUES = new EnvironmentType[max >= 0 ? 1 + max : 0];
                for (EnvironmentType kind : EnvironmentType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((EnvironmentType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((EnvironmentType)kind).value] = kind;
                }
            }
        }
    }

    public static final class OSType
    extends Enum<OSType>
    implements Native.ComparableLower {
        public static final /* enum */ OSType UnknownOS = new OSType(0);
        public static final /* enum */ OSType CloudABI = new OSType(UnknownOS.getValue() + 1);
        public static final /* enum */ OSType Darwin = new OSType(CloudABI.getValue() + 1);
        public static final /* enum */ OSType DragonFly = new OSType(Darwin.getValue() + 1);
        public static final /* enum */ OSType FreeBSD = new OSType(DragonFly.getValue() + 1);
        public static final /* enum */ OSType IOS = new OSType(FreeBSD.getValue() + 1);
        public static final /* enum */ OSType KFreeBSD = new OSType(IOS.getValue() + 1);
        public static final /* enum */ OSType Linux = new OSType(KFreeBSD.getValue() + 1);
        public static final /* enum */ OSType Lv2 = new OSType(Linux.getValue() + 1);
        public static final /* enum */ OSType MacOSX = new OSType(Lv2.getValue() + 1);
        public static final /* enum */ OSType NetBSD = new OSType(MacOSX.getValue() + 1);
        public static final /* enum */ OSType OpenBSD = new OSType(NetBSD.getValue() + 1);
        public static final /* enum */ OSType Solaris = new OSType(OpenBSD.getValue() + 1);
        public static final /* enum */ OSType Win32 = new OSType(Solaris.getValue() + 1);
        public static final /* enum */ OSType Haiku = new OSType(Win32.getValue() + 1);
        public static final /* enum */ OSType Minix = new OSType(Haiku.getValue() + 1);
        public static final /* enum */ OSType RTEMS = new OSType(Minix.getValue() + 1);
        public static final /* enum */ OSType NaCl = new OSType(RTEMS.getValue() + 1);
        public static final /* enum */ OSType CNK = new OSType(NaCl.getValue() + 1);
        public static final /* enum */ OSType Bitrig = new OSType(CNK.getValue() + 1);
        public static final /* enum */ OSType AIX = new OSType(Bitrig.getValue() + 1);
        public static final /* enum */ OSType CUDA = new OSType(AIX.getValue() + 1);
        public static final /* enum */ OSType NVCL = new OSType(CUDA.getValue() + 1);
        public static final /* enum */ OSType AMDHSA = new OSType(NVCL.getValue() + 1);
        public static final /* enum */ OSType PS4 = new OSType(AMDHSA.getValue() + 1);
        public static final /* enum */ OSType ELFIAMCU = new OSType(PS4.getValue() + 1);
        public static final /* enum */ OSType TvOS = new OSType(ELFIAMCU.getValue() + 1);
        public static final /* enum */ OSType WatchOS = new OSType(TvOS.getValue() + 1);
        public static final /* enum */ OSType Mesa3D = new OSType(WatchOS.getValue() + 1);
        public static final /* enum */ OSType LastOSType = new OSType(Mesa3D.getValue());
        private final int value;
        private static final /* synthetic */ OSType[] $VALUES;

        public static OSType[] values() {
            return (OSType[])$VALUES.clone();
        }

        public static OSType valueOf(String name) {
            return Enum.valueOf(OSType.class, name);
        }

        public static OSType valueOf(int val) {
            OSType out;
            OSType oSType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private OSType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((OSType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((OSType)((Object)obj)).value);
        }

        static {
            $VALUES = new OSType[]{UnknownOS, CloudABI, Darwin, DragonFly, FreeBSD, IOS, KFreeBSD, Linux, Lv2, MacOSX, NetBSD, OpenBSD, Solaris, Win32, Haiku, Minix, RTEMS, NaCl, CNK, Bitrig, AIX, CUDA, NVCL, AMDHSA, PS4, ELFIAMCU, TvOS, WatchOS, Mesa3D, LastOSType};
        }

        private static final class Values {
            private static final OSType[] VALUES;
            private static final OSType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (OSType kind : OSType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new OSType[min < 0 ? 1 - min : 0];
                VALUES = new OSType[max >= 0 ? 1 + max : 0];
                for (OSType kind : OSType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((OSType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((OSType)kind).value] = kind;
                }
            }
        }
    }

    public static final class VendorType
    extends Enum<VendorType>
    implements Native.ComparableLower {
        public static final /* enum */ VendorType UnknownVendor = new VendorType(0);
        public static final /* enum */ VendorType Apple = new VendorType(UnknownVendor.getValue() + 1);
        public static final /* enum */ VendorType PC = new VendorType(Apple.getValue() + 1);
        public static final /* enum */ VendorType SCEI = new VendorType(PC.getValue() + 1);
        public static final /* enum */ VendorType BGP = new VendorType(SCEI.getValue() + 1);
        public static final /* enum */ VendorType BGQ = new VendorType(BGP.getValue() + 1);
        public static final /* enum */ VendorType Freescale = new VendorType(BGQ.getValue() + 1);
        public static final /* enum */ VendorType IBM = new VendorType(Freescale.getValue() + 1);
        public static final /* enum */ VendorType ImaginationTechnologies = new VendorType(IBM.getValue() + 1);
        public static final /* enum */ VendorType MipsTechnologies = new VendorType(ImaginationTechnologies.getValue() + 1);
        public static final /* enum */ VendorType NVIDIA = new VendorType(MipsTechnologies.getValue() + 1);
        public static final /* enum */ VendorType CSR = new VendorType(NVIDIA.getValue() + 1);
        public static final /* enum */ VendorType Myriad = new VendorType(CSR.getValue() + 1);
        public static final /* enum */ VendorType AMD = new VendorType(Myriad.getValue() + 1);
        public static final /* enum */ VendorType Mesa = new VendorType(AMD.getValue() + 1);
        public static final /* enum */ VendorType LastVendorType = new VendorType(Mesa.getValue());
        private final int value;
        private static final /* synthetic */ VendorType[] $VALUES;

        public static VendorType[] values() {
            return (VendorType[])$VALUES.clone();
        }

        public static VendorType valueOf(String name) {
            return Enum.valueOf(VendorType.class, name);
        }

        public static VendorType valueOf(int val) {
            VendorType out;
            VendorType vendorType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private VendorType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((VendorType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((VendorType)((Object)obj)).value);
        }

        static {
            $VALUES = new VendorType[]{UnknownVendor, Apple, PC, SCEI, BGP, BGQ, Freescale, IBM, ImaginationTechnologies, MipsTechnologies, NVIDIA, CSR, Myriad, AMD, Mesa, LastVendorType};
        }

        private static final class Values {
            private static final VendorType[] VALUES;
            private static final VendorType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (VendorType kind : VendorType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new VendorType[min < 0 ? 1 - min : 0];
                VALUES = new VendorType[max >= 0 ? 1 + max : 0];
                for (VendorType kind : VendorType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((VendorType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((VendorType)kind).value] = kind;
                }
            }
        }
    }

    public static final class SubArchType
    extends Enum<SubArchType>
    implements Native.ComparableLower {
        public static final /* enum */ SubArchType NoSubArch = new SubArchType(0);
        public static final /* enum */ SubArchType ARMSubArch_v8_2a = new SubArchType(NoSubArch.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v8_1a = new SubArchType(ARMSubArch_v8_2a.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v8 = new SubArchType(ARMSubArch_v8_1a.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v8m_baseline = new SubArchType(ARMSubArch_v8.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v8m_mainline = new SubArchType(ARMSubArch_v8m_baseline.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7 = new SubArchType(ARMSubArch_v8m_mainline.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7em = new SubArchType(ARMSubArch_v7.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7m = new SubArchType(ARMSubArch_v7em.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7s = new SubArchType(ARMSubArch_v7m.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v7k = new SubArchType(ARMSubArch_v7s.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6 = new SubArchType(ARMSubArch_v7k.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6m = new SubArchType(ARMSubArch_v6.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6k = new SubArchType(ARMSubArch_v6m.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v6t2 = new SubArchType(ARMSubArch_v6k.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v5 = new SubArchType(ARMSubArch_v6t2.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v5te = new SubArchType(ARMSubArch_v5.getValue() + 1);
        public static final /* enum */ SubArchType ARMSubArch_v4t = new SubArchType(ARMSubArch_v5te.getValue() + 1);
        public static final /* enum */ SubArchType KalimbaSubArch_v3 = new SubArchType(ARMSubArch_v4t.getValue() + 1);
        public static final /* enum */ SubArchType KalimbaSubArch_v4 = new SubArchType(KalimbaSubArch_v3.getValue() + 1);
        public static final /* enum */ SubArchType KalimbaSubArch_v5 = new SubArchType(KalimbaSubArch_v4.getValue() + 1);
        private final int value;
        private static final /* synthetic */ SubArchType[] $VALUES;

        public static SubArchType[] values() {
            return (SubArchType[])$VALUES.clone();
        }

        public static SubArchType valueOf(String name) {
            return Enum.valueOf(SubArchType.class, name);
        }

        public static SubArchType valueOf(int val) {
            SubArchType out;
            SubArchType subArchType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SubArchType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((SubArchType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((SubArchType)((Object)obj)).value);
        }

        static {
            $VALUES = new SubArchType[]{NoSubArch, ARMSubArch_v8_2a, ARMSubArch_v8_1a, ARMSubArch_v8, ARMSubArch_v8m_baseline, ARMSubArch_v8m_mainline, ARMSubArch_v7, ARMSubArch_v7em, ARMSubArch_v7m, ARMSubArch_v7s, ARMSubArch_v7k, ARMSubArch_v6, ARMSubArch_v6m, ARMSubArch_v6k, ARMSubArch_v6t2, ARMSubArch_v5, ARMSubArch_v5te, ARMSubArch_v4t, KalimbaSubArch_v3, KalimbaSubArch_v4, KalimbaSubArch_v5};
        }

        private static final class Values {
            private static final SubArchType[] VALUES;
            private static final SubArchType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SubArchType kind : SubArchType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new SubArchType[min < 0 ? 1 - min : 0];
                VALUES = new SubArchType[max >= 0 ? 1 + max : 0];
                for (SubArchType kind : SubArchType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((SubArchType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((SubArchType)kind).value] = kind;
                }
            }
        }
    }

    public static final class ArchType
    extends Enum<ArchType>
    implements Native.ComparableLower {
        public static final /* enum */ ArchType UnknownArch = new ArchType(0);
        public static final /* enum */ ArchType arm = new ArchType(UnknownArch.getValue() + 1);
        public static final /* enum */ ArchType armeb = new ArchType(arm.getValue() + 1);
        public static final /* enum */ ArchType aarch64 = new ArchType(armeb.getValue() + 1);
        public static final /* enum */ ArchType aarch64_be = new ArchType(aarch64.getValue() + 1);
        public static final /* enum */ ArchType avr = new ArchType(aarch64_be.getValue() + 1);
        public static final /* enum */ ArchType bpfel = new ArchType(avr.getValue() + 1);
        public static final /* enum */ ArchType bpfeb = new ArchType(bpfel.getValue() + 1);
        public static final /* enum */ ArchType hexagon = new ArchType(bpfeb.getValue() + 1);
        public static final /* enum */ ArchType mips = new ArchType(hexagon.getValue() + 1);
        public static final /* enum */ ArchType mipsel = new ArchType(mips.getValue() + 1);
        public static final /* enum */ ArchType mips64 = new ArchType(mipsel.getValue() + 1);
        public static final /* enum */ ArchType mips64el = new ArchType(mips64.getValue() + 1);
        public static final /* enum */ ArchType msp430 = new ArchType(mips64el.getValue() + 1);
        public static final /* enum */ ArchType ppc = new ArchType(msp430.getValue() + 1);
        public static final /* enum */ ArchType ppc64 = new ArchType(ppc.getValue() + 1);
        public static final /* enum */ ArchType ppc64le = new ArchType(ppc64.getValue() + 1);
        public static final /* enum */ ArchType r600 = new ArchType(ppc64le.getValue() + 1);
        public static final /* enum */ ArchType amdgcn = new ArchType(r600.getValue() + 1);
        public static final /* enum */ ArchType sparc = new ArchType(amdgcn.getValue() + 1);
        public static final /* enum */ ArchType sparcv9 = new ArchType(sparc.getValue() + 1);
        public static final /* enum */ ArchType sparcel = new ArchType(sparcv9.getValue() + 1);
        public static final /* enum */ ArchType systemz = new ArchType(sparcel.getValue() + 1);
        public static final /* enum */ ArchType tce = new ArchType(systemz.getValue() + 1);
        public static final /* enum */ ArchType thumb = new ArchType(tce.getValue() + 1);
        public static final /* enum */ ArchType thumbeb = new ArchType(thumb.getValue() + 1);
        public static final /* enum */ ArchType x86 = new ArchType(thumbeb.getValue() + 1);
        public static final /* enum */ ArchType x86_64 = new ArchType(x86.getValue() + 1);
        public static final /* enum */ ArchType xcore = new ArchType(x86_64.getValue() + 1);
        public static final /* enum */ ArchType nvptx = new ArchType(xcore.getValue() + 1);
        public static final /* enum */ ArchType nvptx64 = new ArchType(nvptx.getValue() + 1);
        public static final /* enum */ ArchType le32 = new ArchType(nvptx64.getValue() + 1);
        public static final /* enum */ ArchType le64 = new ArchType(le32.getValue() + 1);
        public static final /* enum */ ArchType amdil = new ArchType(le64.getValue() + 1);
        public static final /* enum */ ArchType amdil64 = new ArchType(amdil.getValue() + 1);
        public static final /* enum */ ArchType hsail = new ArchType(amdil64.getValue() + 1);
        public static final /* enum */ ArchType hsail64 = new ArchType(hsail.getValue() + 1);
        public static final /* enum */ ArchType spir = new ArchType(hsail64.getValue() + 1);
        public static final /* enum */ ArchType spir64 = new ArchType(spir.getValue() + 1);
        public static final /* enum */ ArchType kalimba = new ArchType(spir64.getValue() + 1);
        public static final /* enum */ ArchType shave = new ArchType(kalimba.getValue() + 1);
        public static final /* enum */ ArchType lanai = new ArchType(shave.getValue() + 1);
        public static final /* enum */ ArchType wasm32 = new ArchType(lanai.getValue() + 1);
        public static final /* enum */ ArchType wasm64 = new ArchType(wasm32.getValue() + 1);
        public static final /* enum */ ArchType renderscript32 = new ArchType(wasm64.getValue() + 1);
        public static final /* enum */ ArchType renderscript64 = new ArchType(renderscript32.getValue() + 1);
        public static final /* enum */ ArchType LastArchType = new ArchType(renderscript64.getValue());
        private final int value;
        private static final /* synthetic */ ArchType[] $VALUES;

        public static ArchType[] values() {
            return (ArchType[])$VALUES.clone();
        }

        public static ArchType valueOf(String name) {
            return Enum.valueOf(ArchType.class, name);
        }

        public static ArchType valueOf(int val) {
            ArchType out;
            ArchType archType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ArchType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ArchType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ArchType)((Object)obj)).value);
        }

        static {
            $VALUES = new ArchType[]{UnknownArch, arm, armeb, aarch64, aarch64_be, avr, bpfel, bpfeb, hexagon, mips, mipsel, mips64, mips64el, msp430, ppc, ppc64, ppc64le, r600, amdgcn, sparc, sparcv9, sparcel, systemz, tce, thumb, thumbeb, x86, x86_64, xcore, nvptx, nvptx64, le32, le64, amdil, amdil64, hsail, hsail64, spir, spir64, kalimba, shave, lanai, wasm32, wasm64, renderscript32, renderscript64, LastArchType};
        }

        private static final class Values {
            private static final ArchType[] VALUES;
            private static final ArchType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ArchType kind : ArchType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ArchType[min < 0 ? 1 - min : 0];
                VALUES = new ArchType[max >= 0 ? 1 + max : 0];
                for (ArchType kind : ArchType.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((ArchType)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((ArchType)kind).value] = kind;
                }
            }
        }
    }
}

