/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;

public class StringSwitch<T> {
    private final StringRef Str;
    private T Result;

    public StringSwitch(StringRef S2) {
        this.Str = S2;
        this.Result = null;
    }

    public StringSwitch(String S2) {
        this(new StringRef(S2));
    }

    public StringSwitch(char.ptr S2) {
        this(new StringRef(S2));
    }

    public StringSwitch(std.string S2) {
        this(new StringRef(S2));
    }

    public StringSwitch<T> Case(int StrLen, String ConstStr, T Value) {
        assert (ConstStr.length() + 1 == StrLen) : "Must be the same length as " + (StrLen - 1) + "but [" + ConstStr + "] == " + ConstStr.length();
        return this.Case(ConstStr, Value);
    }

    public StringSwitch<T> Case(String S2, T Value) {
        if (this.Result == null && this.Str.$equals(S2)) {
            this.Result = Native.$AddrOf(Value);
        }
        return this;
    }

    public StringSwitch<T> EndsWith(String S2, T Value) {
        if (this.Result == null && this.Str.endswith(S2)) {
            this.Result = Native.$AddrOf(Value);
        }
        return this;
    }

    public StringSwitch<T> StartsWith(String S2, T Value) {
        if (this.Result == null && this.Str.startswith(S2)) {
            this.Result = Native.$AddrOf(Value);
        }
        return this;
    }

    public StringSwitch<T> Cases(int S0Len, int S1Len, String S0, String S1, T Value) {
        return this.Case(S0Len, S0, Value).Case(S1Len, S1, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, T Value) {
        return this.Case(S0, Value).Case(S1, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, String S2, T Value) {
        return this.Case(S0, Value).Case(S1, Value).Case(S2, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, String S2, String S3, T Value) {
        return this.Case(S0, Value).Case(S1, Value).Case(S2, Value).Case(S3, Value);
    }

    public StringSwitch<T> Cases(String S0, String S1, String S2, String S3, String S4, T Value) {
        return this.Case(S0, Value).Case(S1, Value).Case(S2, Value).Case(S3, Value).Case(S4, Value);
    }

    public T Default(T Value) {
        if (this.Result != null) {
            return (T)Native.$Deref(this.Result);
        }
        return Value;
    }

    public T $T1() {
        assert (this.Result != null) : "Fell off the end of a string-switch";
        return (T)Native.$Deref(this.Result);
    }
}

