/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std_atomics;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.support.ValgrindGlobals;
import org.llvm.support.impl.StatisticStatics;
import org.llvm.support.sys.SmartScopedLock;
import org.llvm.support.sys.sys;

public class Statistic {
    public char.ptr DebugType;
    public char.ptr Name;
    public char.ptr Desc;
    public std_atomics.atomicUInt Value;
    public boolean Initialized;

    public Statistic(char.ptr DebugType2, char.ptr Name2, char.ptr Desc, int Value, boolean Initialized) {
        this.DebugType = DebugType2;
        this.Name = Name2;
        this.Desc = Desc;
        this.Value = new std_atomics.atomicUInt(Value);
        this.Initialized = Initialized;
    }

    public int getValue() {
        return this.Value.load(std_atomics.memory_order.memory_order_relaxed);
    }

    public char.ptr getDebugType() {
        return this.DebugType;
    }

    public char.ptr getName() {
        return this.Name;
    }

    public char.ptr getDesc() {
        return this.Desc;
    }

    public void construct(char.ptr debugtype, char.ptr name, char.ptr desc2) {
        this.DebugType = Native.$tryClone((char.ptr)debugtype);
        this.Name = Native.$tryClone((char.ptr)name);
        this.Desc = Native.$tryClone((char.ptr)desc2);
        this.Value.$assign(0);
        this.Initialized = false;
    }

    public int $uint() {
        return this.getValue();
    }

    public Statistic $assign(int Val) {
        this.Value.store(Val, std_atomics.memory_order.memory_order_relaxed);
        return this.init();
    }

    public Statistic $preInc() {
        this.Value.fetch_add(1, std_atomics.memory_order.memory_order_relaxed);
        return this.init();
    }

    public int $postInc(int $Prm0) {
        this.init();
        return this.Value.fetch_add(1, std_atomics.memory_order.memory_order_relaxed);
    }

    public Statistic $preDec() {
        this.Value.fetch_sub(1, std_atomics.memory_order.memory_order_relaxed);
        return this.init();
    }

    public int $postDec(int $Prm0) {
        this.init();
        return this.Value.fetch_sub(1, std_atomics.memory_order.memory_order_relaxed);
    }

    public Statistic $addassign(int V) {
        if (V == 0) {
            return this;
        }
        this.Value.fetch_add(V, std_atomics.memory_order.memory_order_relaxed);
        return this.init();
    }

    public Statistic $minusassign(int V) {
        if (V == 0) {
            return this;
        }
        this.Value.fetch_sub(V, std_atomics.memory_order.memory_order_relaxed);
        return this.init();
    }

    protected Statistic init() {
        boolean tmp = this.Initialized;
        sys.MemoryFence();
        if (!tmp) {
            this.RegisterStatistic();
        }
        ValgrindGlobals.AnnotateHappensAfter("${LLVM_SRC}/llvm/include/llvm/ADT/Statistic.h", 156, this);
        return this;
    }

    protected void RegisterStatistic() {
        SmartScopedLock Writer2 = null;
        try {
            Writer2 = new SmartScopedLock(true, StatisticStatics.StatLock.$star());
            if (!this.Initialized) {
                if (((Boolean)StatisticStatics.Enabled.$T()).booleanValue()) {
                    StatisticStatics.StatInfo.$arrow().addStatistic(this);
                }
                ValgrindGlobals.AnnotateHappensBefore("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 78, this);
                sys.MemoryFence();
                ValgrindGlobals.AnnotateIgnoreWritesBegin("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 81);
                this.Initialized = true;
                ValgrindGlobals.AnnotateIgnoreWritesEnd("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 83);
            }
        }
        finally {
            if (Writer2 != null) {
                Writer2.$destroy();
            }
        }
    }

    public String toString() {
        return "DebugType=" + this.DebugType + ", Name=" + this.Name + ", Desc=" + this.Desc + ", Value=" + this.Value + ", Initialized=" + this.Initialized;
    }
}

