/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Comparator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.type;
import org.llvm.adt.aliases.SmallVector;

public class SmallSet<T>
implements Destructors.ClassWithDestructor,
NativeCloneable<SmallSet> {
    private final int N;
    private final Comparator<T> C;
    private SmallVector<T> Vector;
    private std.setPtr<T> Set;

    public SmallSet(int N, T defaultValue, Comparator<T> C2) {
        this.N = N;
        this.C = C2;
        this.Vector = new SmallVector<T>(N, defaultValue);
        assert (defaultValue != null || C2 == Native.Comparator$JavaRef()) : "This SmallSet is only for Value-types. May be SmallSetT$PLess$T$P should be used instead?";
        if (C2 == null) {
            assert (defaultValue instanceof Native.ComparableLower) : "comparator must be specified for " + NativeTrace.getIdentityStr(defaultValue);
            C2 = std.COMPARE_LOWER_COMPARATOR;
        }
        this.Set = new std.setPtr((Comparator)C2);
    }

    public SmallSet(SmallSet<T> other) {
        this.N = other.N;
        this.C = other.C;
        this.Vector = new SmallVector<T>(other.Vector);
        this.Set = new std.setPtr(other.Set);
    }

    public boolean empty() {
        return this.Vector.empty() && this.Set.empty();
    }

    public int size() {
        return this.isSmall() ? this.Vector.size() : this.Set.size();
    }

    public int count(T V) {
        if (this.isSmall()) {
            return Native.$noteq_iter(this.vfind(V), this.Vector.end()) ? 1 : 0;
        }
        return this.Set.count(V) ? 1 : 0;
    }

    public boolean insert(T V) {
        if (!this.isSmall()) {
            return this.Set.insert(V).second;
        }
        type.ptr<T> I = this.vfind(V);
        if (Native.$noteq_iter(I, this.Vector.end())) {
            return false;
        }
        if (this.Vector.size() < this.N) {
            this.Vector.push_back(V);
            return true;
        }
        while (!this.Vector.empty()) {
            this.Set.insert(this.Vector.back());
            this.Vector.pop_back();
        }
        this.Set.insert(V);
        return true;
    }

    public <IterT extends type.iterator<?, T>> void insert(IterT I, IterT E) {
        while (Native.$noteq_iter(I, E)) {
            this.insert(Native.$Deref((Object)I.$star()));
            I.$preInc();
        }
    }

    public boolean erase(T V) {
        if (!this.isSmall()) {
            return this.Set.erase(V);
        }
        type.ptr I = this.Vector.begin();
        type.ptr E = this.Vector.end();
        while (Native.$noteq_iter(I, E)) {
            if (this.$areEqual(I.$star(), V)) {
                this.Vector.erase(I);
                return true;
            }
            I.$preInc();
        }
        return false;
    }

    public void clear() {
        this.Vector.clear();
        this.Set.clear();
    }

    private boolean isSmall() {
        return this.Set.empty();
    }

    private type.ptr<T> vfind(T V) {
        type.ptr I = this.Vector.begin();
        type.ptr E = this.Vector.end();
        while (Native.$noteq_iter(I, E)) {
            if (this.$areEqual(I.$star(), V)) {
                return I;
            }
            I.$preInc();
        }
        return this.Vector.end();
    }

    public void $destroy() {
        this.Vector.$destroy();
        this.Set.$destroy();
    }

    public SmallSet clone() {
        return new SmallSet<T>(this);
    }

    private boolean $areEqual(T o1, T o2) {
        if (this.C != null) {
            return this.C.compare(o1, o2) == 0;
        }
        return Native.$eq(o1, o2);
    }
}

