/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeSwappable;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.support.llvm;

public class SmallPtrSetImplBase<PtrType>
implements Destructors.ClassWithDestructor,
NativeSwappable {
    protected final DenseMapInfo<PtrType> KeyInfo;
    private final Object EmptyKey;
    private final Object TombstoneKey;
    protected type.ptr<PtrType> SmallArray;
    protected type.ptr<PtrType> CurArray;
    protected int CurArraySize;
    protected int NumElements;
    protected int NumTombstones;

    protected SmallPtrSetImplBase(type.ptr<PtrType> SmallStorage, SmallPtrSetImplBase<PtrType> that) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        if (super.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
        } else {
            this.CurArray = std.malloc((int)that.CurArraySize);
            assert (this.CurArray != null) : "Failed to allocate memory?";
        }
        this.CurArraySize = that.CurArraySize;
        std.memcpy(this.CurArray, that.CurArray, (int)this.CurArraySize, (boolean)true);
        this.NumElements = that.NumElements;
        this.NumTombstones = that.NumTombstones;
        this.KeyInfo = that.KeyInfo;
        this.EmptyKey = that.EmptyKey;
        this.TombstoneKey = that.TombstoneKey;
    }

    protected SmallPtrSetImplBase(type.ptr<PtrType> SmallStorage, int SmallSize, SmallPtrSetImplBase<PtrType> that) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        this.CurArraySize = that.CurArraySize;
        this.NumElements = that.NumElements;
        this.NumTombstones = that.NumTombstones;
        this.KeyInfo = that.KeyInfo;
        this.EmptyKey = that.EmptyKey;
        this.TombstoneKey = that.TombstoneKey;
        if (super.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            std.memcpy(this.CurArray, that.CurArray, (int)this.CurArraySize, (boolean)true);
        } else {
            this.CurArray = (type.ptr)Native.$tryClone(that.CurArray);
            that.CurArray = (type.ptr)Native.$tryClone(that.SmallArray);
        }
        that.CurArraySize = SmallSize;
        assert (Native.$eq_ptr(that.CurArray, that.SmallArray));
        that.NumElements = 0;
        that.NumTombstones = 0;
    }

    protected SmallPtrSetImplBase(DenseMapInfo<PtrType> KeyInfo, type.ptr<PtrType> SmallStorage, int SmallSize) {
        this.SmallArray = (type.ptr)Native.$tryClone(SmallStorage);
        this.CurArray = (type.ptr)Native.$tryClone(SmallStorage);
        this.CurArraySize = SmallSize;
        this.KeyInfo = KeyInfo;
        assert (SmallSize != 0 && (SmallSize & SmallSize - 1) == 0) : "Initial size must be a power of two!";
        this.EmptyKey = KeyInfo.getEmptyKey();
        assert (this.EmptyKey == KeyInfo.getEmptyKey()) : "empty key must be persistent between calls" + KeyInfo;
        this.TombstoneKey = KeyInfo.getTombstoneKey();
        assert (this.TombstoneKey == KeyInfo.getTombstoneKey()) : "tombstone key must be persistent between calls" + KeyInfo;
        assert (this.EmptyKey != this.TombstoneKey) : "EmptyKey must be different from TombstoneKey:" + this.KeyInfo;
        this.clear();
    }

    public void $destroy() {
        if (!this.isSmall()) {
            std.free(this.CurArray);
        }
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public int size() {
        return this.NumElements;
    }

    public void clear() {
        if (!this.isSmall() && Unsigned.$less_uint((int)(this.NumElements * 4), (int)this.CurArraySize) && Unsigned.$greater_uint((int)this.CurArraySize, (int)32)) {
            this.shrink_and_clear();
            return;
        }
        std.memset(this.CurArray, (Object)this.getEmptyMarker(), (int)this.CurArraySize);
        this.NumElements = 0;
        this.NumTombstones = 0;
    }

    protected Object getTombstoneMarker() {
        return this.TombstoneKey;
    }

    protected Object getEmptyMarker() {
        return this.EmptyKey;
    }

    protected std_pair.pairTypeBool<type.ptr<PtrType>> insert_imp(PtrType Ptr2) {
        if (this.isSmall()) {
            int E = this.NumElements;
            for (int APtr = 0; APtr != E; ++APtr) {
                Object CurKey = this.SmallArray.$at(APtr);
                assert (CurKey != this.getEmptyMarker()) : "empty markers are only at the end of array";
                assert (CurKey != this.getTombstoneMarker()) : "no tombstones markers in small array";
                if (!this.KeyInfo.isEqual(Ptr2, CurKey)) continue;
                return std.make_pair_T_bool((Object)((type.ptr)this.SmallArray.$add(APtr)), (boolean)false);
            }
            if (Unsigned.$less_uint((int)this.NumElements, (int)this.CurArraySize)) {
                this.SmallArray.$set(this.NumElements++, Ptr2);
                return std.make_pair_T_bool((Object)((type.ptr)this.SmallArray.$add(this.NumElements - 1)), (boolean)true);
            }
        }
        if (Unsigned.$greatereq_uint((int)(this.NumElements * 4), (int)(this.CurArraySize * 3))) {
            this.Grow(Unsigned.$less_uint((int)this.CurArraySize, (int)64) ? 128 : this.CurArraySize * 2);
        } else if (Unsigned.$less_uint((int)(this.CurArraySize - (this.NumElements + this.NumTombstones)), (int)(this.CurArraySize / 8))) {
            this.Grow(this.CurArraySize);
        }
        type.ptr<PtrType> Bucket2 = this.FindBucketFor(Ptr2);
        Object CurKey = Bucket2.$star();
        if (CurKey != this.getTombstoneMarker() && CurKey != this.getEmptyMarker()) {
            assert (this.KeyInfo.isEqual(Ptr2, CurKey)) : "" + Ptr2 + " vs. " + CurKey;
            return std.make_pair_T_bool(Bucket2, (boolean)false);
        }
        if (CurKey == this.getTombstoneMarker()) {
            --this.NumTombstones;
        }
        Bucket2.$set(this.$cloneIfNeeded(Ptr2));
        ++this.NumElements;
        return std.make_pair_T_bool(Bucket2, (boolean)true);
    }

    protected boolean erase_imp(PtrType Ptr2) {
        if (this.isSmall()) {
            int E = this.NumElements;
            for (int APtr = 0; APtr != E; ++APtr) {
                Object CurKey = this.SmallArray.$at(APtr);
                assert (CurKey != this.getEmptyMarker()) : "empty markers are only at the end of array";
                assert (CurKey != this.getTombstoneMarker()) : "no tombstones markers in small array";
                if (!this.KeyInfo.isEqual(Ptr2, CurKey)) continue;
                this.SmallArray.$set(APtr, this.SmallArray.$at(E - 1));
                this.SmallArray.$set(E - 1, this.getEmptyMarker());
                --this.NumElements;
                return true;
            }
            return false;
        }
        type.ptr<PtrType> Bucket2 = this.FindBucketFor(Ptr2);
        Object CurKey = Bucket2.$star();
        if (CurKey == this.getTombstoneMarker() || CurKey == this.getEmptyMarker()) {
            return false;
        }
        assert (this.KeyInfo.isEqual(Ptr2, CurKey)) : "Not in the set? " + CurKey + " vs " + Ptr2;
        Bucket2.$set(this.getTombstoneMarker());
        --this.NumElements;
        ++this.NumTombstones;
        return true;
    }

    protected boolean count_imp(PtrType Ptr2) {
        if (this.isSmall()) {
            int E = this.NumElements;
            for (int APtr = 0; APtr != E; ++APtr) {
                Object CurKey = this.SmallArray.$at(APtr);
                assert (CurKey != this.getEmptyMarker()) : "empty markers are only at the end of array";
                assert (CurKey != this.getTombstoneMarker()) : "no tombstones markers in small array";
                if (!this.KeyInfo.isEqual(Ptr2, CurKey)) continue;
                return true;
            }
            return false;
        }
        type.ptr<PtrType> Bucket2 = this.FindBucketFor(Ptr2);
        Object CurKey = Bucket2.$star();
        if (CurKey == this.getTombstoneMarker() || CurKey == this.getEmptyMarker()) {
            return false;
        }
        assert (this.KeyInfo.isEqual(Ptr2, CurKey)) : "Not in the set? " + CurKey + " vs " + Ptr2;
        return true;
    }

    private boolean isSmall() {
        return Native.$eq_ptr(this.CurArray, this.SmallArray);
    }

    private type.ptr<PtrType> FindBucketFor(PtrType Ptr2) {
        int Bucket2 = this.KeyInfo.getHashValue(Ptr2) & this.CurArraySize - 1;
        int ArraySize = this.CurArraySize;
        int ProbeAmt = 1;
        type.ptr<PtrType> Array = this.CurArray;
        type.ptr Tombstone = null;
        Object CurKey;
        while ((CurKey = Array.$at(Bucket2)) != this.getEmptyMarker()) {
            if (CurKey == this.getTombstoneMarker()) {
                if (Tombstone == null) {
                    Tombstone = (type.ptr)Array.$add(Bucket2);
                }
            } else if (this.KeyInfo.isEqual(Ptr2, CurKey)) {
                return (type.ptr)Array.$add(Bucket2);
            }
            Bucket2 = Bucket2 + ProbeAmt++ & ArraySize - 1;
        }
        return Tombstone != null ? Tombstone : (type.ptr)Array.$add(Bucket2);
    }

    private void shrink_and_clear() {
        assert (!this.isSmall()) : "Can't shrink a small set!";
        std.free(this.CurArray);
        this.CurArraySize = Unsigned.$greater_uint((int)this.NumElements, (int)16) ? 1 << llvm.Log2_32_Ceil(this.NumElements) + 1 : 32;
        this.NumTombstones = 0;
        this.NumElements = 0;
        this.CurArray = std.malloc((int)this.CurArraySize);
        assert (this.CurArray != null) : "Failed to allocate memory?";
        std.memset(this.CurArray, (Object)this.getEmptyMarker(), (int)this.CurArraySize);
    }

    private void Grow(int NewSize) {
        int OldSize = this.CurArraySize;
        type.ptr OldBuckets = (type.ptr)Native.$tryClone(this.CurArray);
        boolean WasSmall = this.isSmall();
        this.CurArray = std.malloc((int)NewSize);
        assert (this.CurArray != null) : "Failed to allocate memory?";
        this.CurArraySize = NewSize;
        std.memset(this.CurArray, (Object)this.getEmptyMarker(), (int)NewSize);
        if (WasSmall) {
            int E = this.NumElements;
            for (int APtr = 0; APtr != E; ++APtr) {
                Object Elt = this.SmallArray.$at(APtr);
                assert (Elt != this.getEmptyMarker()) : "empty markers are only at the end of array";
                assert (Elt != this.getTombstoneMarker()) : "no tombstones markers in small array";
                type.ptr<Object> BucketFor = this.FindBucketFor(Elt);
                assert (BucketFor.$star() == this.getEmptyMarker() || BucketFor.$star() == this.getTombstoneMarker()) : "must find free bucket for " + Elt + " vs. " + BucketFor;
                BucketFor.$set(Elt);
            }
        } else {
            type.ptr BucketPtr = (type.ptr)Native.$tryClone((NativeCloneable)OldBuckets);
            type.ptr E = (type.ptr)OldBuckets.$add(OldSize);
            while (Native.$noteq_ptr((void.ptr)BucketPtr, (void.ptr)E)) {
                Object Elt = BucketPtr.$star();
                if (Elt != this.getTombstoneMarker() && Elt != this.getEmptyMarker()) {
                    type.ptr<Object> BucketFor = this.FindBucketFor(Elt);
                    assert (BucketFor.$star() == this.getEmptyMarker() || BucketFor.$star() == this.getTombstoneMarker()) : "must find free bucket for " + Elt + " vs. " + BucketFor;
                    BucketFor.$set(Elt);
                }
                BucketPtr.$preInc();
            }
            std.free((Object)OldBuckets);
            this.NumTombstones = 0;
        }
    }

    private void $assign(SmallPtrSetImplBase<PtrType> RHS) {
        throw new UnsupportedOperationException("Deleted");
    }

    public void swap(NativeSwappable _RHS) {
        SmallPtrSetImplBase RHS = (SmallPtrSetImplBase)_RHS;
        if (this == Native.$AddrOf((Object)RHS)) {
            return;
        }
        if (!this.isSmall() && !RHS.isSmall()) {
            type.ptr<PtrType> tmpPtr = this.CurArray;
            this.CurArray = RHS.CurArray;
            RHS.CurArray = tmpPtr;
            int tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.NumTombstones;
            this.NumTombstones = RHS.NumTombstones;
            RHS.NumTombstones = tmp;
            return;
        }
        if (!this.isSmall() && RHS.isSmall()) {
            std.copy(RHS.SmallArray, (type.iterator)((type.iterator)RHS.SmallArray.$add(RHS.CurArraySize)), this.SmallArray);
            int tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            RHS.CurArray = (type.ptr)Native.$tryClone(this.CurArray);
            RHS.NumTombstones = this.NumTombstones;
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            this.NumTombstones = 0;
            return;
        }
        if (this.isSmall() && !RHS.isSmall()) {
            std.copy(this.SmallArray, (type.iterator)((type.iterator)this.SmallArray.$add(this.CurArraySize)), RHS.SmallArray);
            int tmp = this.NumElements;
            this.NumElements = RHS.NumElements;
            RHS.NumElements = tmp;
            tmp = this.CurArraySize;
            this.CurArraySize = RHS.CurArraySize;
            RHS.CurArraySize = tmp;
            this.CurArray = (type.ptr)Native.$tryClone(RHS.CurArray);
            this.NumTombstones = RHS.NumTombstones;
            RHS.CurArray = (type.ptr)Native.$tryClone(RHS.SmallArray);
            RHS.NumTombstones = 0;
            return;
        }
        assert (this.isSmall() && RHS.isSmall());
        assert (this.CurArraySize == RHS.CurArraySize);
        std.swap_ranges(this.SmallArray, (type.iterator)((type.ptr)this.SmallArray.$add(this.CurArraySize)), RHS.SmallArray);
        int tmp = this.NumElements;
        this.NumElements = RHS.NumElements;
        RHS.NumElements = tmp;
    }

    protected void CopyFrom(SmallPtrSetImplBase<PtrType> RHS) {
        assert (Native.$AddrOf(RHS) != this) : "Self-copy should be handled by the caller.";
        if (this.isSmall() && super.isSmall()) assert (this.CurArraySize == RHS.CurArraySize) : "Cannot assign sets with different small sizes";
        if (super.isSmall()) {
            if (!this.isSmall()) {
                std.free(this.CurArray);
            }
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
        } else if (this.CurArraySize != RHS.CurArraySize) {
            if (this.isSmall()) {
                this.CurArray = std.malloc((int)RHS.CurArraySize);
            } else {
                type.ptr Arr = std.realloc(this.CurArray, (int)this.CurArraySize, (int)RHS.CurArraySize);
                if (Arr == null) {
                    std.free(this.CurArray);
                }
                this.CurArray = (type.ptr)Native.$tryClone((NativeCloneable)Arr);
            }
            assert (this.CurArray != null) : "Failed to allocate memory?";
        }
        this.CurArraySize = RHS.CurArraySize;
        std.memcpy(this.CurArray, RHS.CurArray, (int)this.CurArraySize, (boolean)true);
        this.NumElements = RHS.NumElements;
        this.NumTombstones = RHS.NumTombstones;
    }

    protected void MoveFrom(int SmallSize, SmallPtrSetImplBase<PtrType> RHS) {
        assert (Native.$AddrOf(RHS) != this) : "Self-move should be handled by the caller.";
        if (!this.isSmall()) {
            std.free(this.CurArray);
        }
        if (super.isSmall()) {
            this.CurArray = (type.ptr)Native.$tryClone(this.SmallArray);
            std.memcpy(this.CurArray, RHS.CurArray, (int)RHS.CurArraySize, (boolean)true);
        } else {
            this.CurArray = (type.ptr)Native.$tryClone(RHS.CurArray);
            RHS.CurArray = (type.ptr)Native.$tryClone(RHS.SmallArray);
        }
        this.CurArraySize = RHS.CurArraySize;
        this.NumElements = RHS.NumElements;
        this.NumTombstones = RHS.NumTombstones;
        RHS.CurArraySize = SmallSize;
        assert (Native.$eq_ptr(RHS.CurArray, RHS.SmallArray));
        RHS.NumElements = 0;
        RHS.NumTombstones = 0;
    }

    private PtrType $cloneIfNeeded(PtrType Ptr2) {
        return (PtrType)(Ptr2 instanceof void.ptr ? Native.$tryClone(Ptr2) : Ptr2);
    }

    public String toString() {
        StringBuilder out = new StringBuilder("SmallArray=");
        out.append(this.isSmall() ? "YES" : "NO");
        out.append(", NumElements=").append(this.NumElements);
        out.append(", CurArraySize=").append(this.CurArraySize);
        out.append(", NumTombstones=").append(this.NumTombstones);
        int idx = 0;
        for (int i = 0; i < this.CurArraySize; ++i) {
            if (this.CurArray.$at(i) == this.getEmptyMarker() || this.CurArray.$at(i) == this.getTombstoneMarker()) continue;
            out.append("\n [").append(NativeTrace.formatNumber((long)idx++, (int)2)).append("] ");
            out.append("{").append(this.CurArray.$at(i)).append("}");
        }
        return out.toString();
    }
}

