/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativeSwappable;
import org.clank.support.aliases.type;
import org.llvm.adt.NoneType;

public class Optional<T>
implements Destructors.ClassWithDestructor,
Native.Native$Bool,
NativeSwappable,
NativeCloneable<Optional<T>>,
NativeMoveable<Optional<T>> {
    private T storage;
    private boolean hasVal;

    public Optional(NoneType $Prm0) {
        this.hasVal = false;
    }

    public Optional() {
        this.hasVal = false;
    }

    public Optional(JavaDifferentiators.JD.T.RR _dparam, T y) {
        this.hasVal = true;
        assert (y != null) : "May be OptionalPtr should be used for keeping null-pointers?";
        this.storage = Native.$tryMove(y);
    }

    public Optional(JavaDifferentiators.JD.T.C.R _dparam, T y) {
        this.hasVal = true;
        this.storage = Native.$tryClone(y);
    }

    public Optional(Optional<T> O) {
        this.hasVal = O.hasVal;
        if (this.hasVal) {
            this.storage = Native.$tryClone(O.storage);
        }
    }

    public static <T> Optional<T> create(T y) {
        return y != null ? new Optional<T>(JavaDifferentiators.JD.T.C.R.INSTANCE, y) : new Optional<T>();
    }

    public static <T> Optional<T> createFromPtr(type.ptr<T> y) {
        assert (y == null || y.$star() != null) : "Expected pure null or non-null referencing pointer";
        return y != null ? new Optional<Object>(JavaDifferentiators.JD.T.RR.INSTANCE, Native.$Deref((Object)y.$star())) : new Optional<T>();
    }

    public Optional<T> $assign(T y) {
        this.storage = Native.$tryClone(y);
        this.hasVal = true;
        return this;
    }

    public Optional<T> $assign(Optional<T> O) {
        if (!O.$bool()) {
            this.reset();
        } else {
            this.storage = Native.$tryClone(O.storage);
            this.hasVal = O.hasVal;
        }
        return this;
    }

    public Optional<T> $assignMove(Optional<T> O) {
        if (!O.$bool()) {
            this.reset();
        } else {
            this.storage = Native.$tryMove(this.storage, O.storage, (boolean)false);
            this.hasVal = O.hasVal;
            O.hasVal = false;
            O.storage = null;
        }
        return this;
    }

    public void reset() {
        if (this.hasVal) {
            Native.destroy(this.storage);
            this.hasVal = false;
        }
    }

    public void $destroy() {
        this.reset();
    }

    public T getPointer() {
        assert (this.hasVal);
        return this.storage;
    }

    public type.ref<T> getPointer$Ref() {
        assert (this.hasVal);
        return new type.ref<T>(){

            public T $deref() {
                assert (Optional.this.hasVal);
                return Optional.this.storage;
            }

            public T $set(T value) {
                assert (Optional.this.hasVal);
                Optional.this.storage = Native.$tryAssign((Object)Optional.this.storage, value, (boolean)false);
                return Optional.this.storage;
            }
        };
    }

    public T getValue() {
        assert (this.hasVal);
        return this.getPointer();
    }

    public T getValue$Const() {
        assert (this.hasVal);
        return this.getPointer();
    }

    public T getValueOr(T value) {
        return this.hasValue() ? this.getValue() : value;
    }

    public boolean $bool() {
        return this.hasVal;
    }

    public boolean hasValue() {
        return this.hasVal;
    }

    public T $arrow() {
        return this.getPointer();
    }

    public T $arrow$Const() {
        return this.getPointer();
    }

    public T $star() {
        assert (this.hasVal);
        return this.getPointer();
    }

    public T $star$Const() {
        assert (this.hasVal);
        return this.getPointer();
    }

    public Optional<T> $assign_T$C$R(T other) {
        this.storage = Native.$tryClone(other);
        this.hasVal = true;
        return this;
    }

    public Optional<T> $assign_T$RR(T other) {
        this.storage = Native.$tryMove(this.storage, other, (boolean)false);
        this.hasVal = true;
        return this;
    }

    public void swap(NativeSwappable RHS) {
        Optional other = (Optional)RHS;
        if (this.storage instanceof NativeSwappable && other.storage instanceof NativeSwappable) {
            ((NativeSwappable)this.storage).swap((NativeSwappable)other.storage);
        } else {
            T myStorage = this.storage;
            this.storage = other.storage;
            other.storage = myStorage;
        }
        boolean myHasVal = this.hasVal;
        this.hasVal = other.hasVal;
        other.hasVal = myHasVal;
    }

    public Optional<T> clone() {
        return new Optional<T>(this);
    }

    public Optional<T> move() {
        return new Optional<T>().$assignMove(this);
    }

    public void emplace(T ... Args) {
        this.reset();
        this.hasVal = true;
        assert (Args.length <= 1);
        this.storage = Args.length > 0 ? Args[0] : null;
    }

    public String toString() {
        if (!this.hasVal) {
            return "NO_VALUE";
        }
        return "storage=[" + this.storage + "]";
    }
}

