/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Objects;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeFoldingSetTrait;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.FoldingSetNodeIDRef;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.PointerIntPair;
import org.llvm.adt.PointerUnionBase;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.sys;

public class FoldingSetNodeID
implements NativeFoldingSetTrait.NativeFoldingSetNodeID,
Destructors.ClassWithDestructor,
Native.NativeComparable<FoldingSetNodeID> {
    private SmallVectorUInt Bits;

    public FoldingSetNodeID() {
        this.Bits = new SmallVectorUInt(32, 0);
    }

    public FoldingSetNodeID(FoldingSetNodeIDRef Ref) {
        this.Bits = new SmallVectorUInt(32, (uint.iterator<?>)Ref.getData(), (uint.iterator<?>)((uint.iterator)Ref.getData().$add(Ref.getSize())), 0);
    }

    public void AddPointer(type.ptr<?> Ptr2) {
        this.Bits.push_back(Objects.hash(System.identityHashCode(Ptr2.$array()), Ptr2.$index()));
    }

    public void AddPointer(Object Ptr2) {
        if (Ptr2 instanceof PointerUnionBase) {
            this.AddPointer((PointerUnionBase)Ptr2);
        } else if (Ptr2 instanceof PointerIntPair) {
            this.AddPointer((PointerIntPair)Ptr2);
        } else if (Ptr2 instanceof ADTAliases.PointerInt2Pair) {
            this.AddPointer((ADTAliases.PointerInt2Pair)Ptr2);
        } else if (Ptr2 instanceof ADTAliases.PointerEnum2Pair) {
            this.AddPointer((ADTAliases.PointerEnum2Pair)Ptr2);
        } else if (Ptr2 instanceof ADTAliases.PointerBoolPair) {
            this.AddPointer((ADTAliases.PointerBoolPair)Ptr2);
        } else {
            if (Ptr2 instanceof void.ptr) {
                throw new UnsupportedOperationException("AddPointer? Please, handle differently in client:" + NativeTrace.getIdentityStr((Object)Ptr2));
            }
            if (Ptr2 instanceof Number) {
                throw new UnsupportedOperationException("AddPointer?" + NativeTrace.getIdentityStr((Object)Ptr2) + ". If this is void* to uintptr_p, please handle it manuall y in client i.e. by calling AddInteger_uint");
            }
            this.Bits.push_back(System.identityHashCode(Ptr2));
        }
    }

    public void AddPointer(PointerUnionBase Ptr2) {
        Ptr2.ProfilePointerUnion(this);
    }

    public void AddPointer(PointerIntPair Ptr2) {
        Ptr2.ProfilePointerIntPair(this);
    }

    public void AddPointer(ADTAliases.PointerInt2Pair Ptr2) {
        Ptr2.ProfilePointerIntPair(this);
    }

    public void AddPointer(ADTAliases.PointerEnum2Pair Ptr2) {
        Ptr2.ProfilePointerIntPair(this);
    }

    public void AddPointer(ADTAliases.PointerBoolPair Ptr2) {
        Ptr2.ProfilePointerIntPair(this);
    }

    public void AddInteger_int(int I) {
        this.Bits.push_back(I);
    }

    public void AddInteger_uint(int I) {
        this.Bits.push_back(I);
    }

    public void AddInteger_long(long I) {
        this.AddInteger_ulong(I);
    }

    public void AddInteger_ulong(long I) {
        if (NativeType.sizeof(Long.TYPE) == NativeType.sizeof(Integer.TYPE)) {
            this.AddInteger_uint((int)I);
        } else if (NativeType.sizeof(Long.TYPE) == NativeType.sizeof(Long.TYPE)) {
            this.AddInteger_ullong(Unsigned.$ulong2ullong((long)I));
        } else {
            throw new llvm_unreachable("unexpected sizeof(long)");
        }
    }

    public void AddInteger_llong(long I) {
        this.AddInteger_ullong(I);
    }

    public void AddInteger_ullong(long I) {
        this.AddInteger_uint((int)I);
        if (Unsigned.$uint2ullong((int)((int)I)) != I) {
            this.Bits.push_back((int)(I >>> 32));
        }
    }

    public void AddBoolean(boolean B) {
        this.AddInteger_uint(B ? 1 : 0);
    }

    public void AddString(StringRef String2) {
        int V;
        int Size = String2.size();
        this.Bits.push_back(Size);
        if (Size == 0) {
            return;
        }
        int Units = Size / 4;
        int Pos = 0;
        uint.ptr Base = (uint.ptr)Native.$tryClone((NativeCloneable)((uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)String2.data())));
        assert (sys.IsBigEndianHost || sys.IsLittleEndianHost) : NativePointer.$((String)"Unexpected host endianness");
        if (sys.IsBigEndianHost) {
            Pos += 4;
            while (Unsigned.$lesseq_uint((int)Pos, (int)Size)) {
                V = Unsigned.$uchar2int((byte)String2.$at(Pos - 4)) << 24 | Unsigned.$uchar2int((byte)String2.$at(Pos - 3)) << 16 | Unsigned.$uchar2int((byte)String2.$at(Pos - 2)) << 8 | Unsigned.$uchar2int((byte)String2.$at(Pos - 1));
                this.Bits.push_back(V);
                Pos += 4;
            }
        } else {
            Pos += 4;
            while (Unsigned.$lesseq_uint((int)Pos, (int)Size)) {
                V = Unsigned.$uchar2int((byte)String2.$at(Pos - 1)) << 24 | Unsigned.$uchar2int((byte)String2.$at(Pos - 2)) << 16 | Unsigned.$uchar2int((byte)String2.$at(Pos - 3)) << 8 | Unsigned.$uchar2int((byte)String2.$at(Pos - 4));
                this.Bits.push_back(V);
                Pos += 4;
            }
        }
        V = 0;
        switch (Pos - Size) {
            case 1: {
                V = V << 8 | Unsigned.$uchar2uint((byte)String2.$at(Size - 3));
            }
            case 2: {
                V = V << 8 | Unsigned.$uchar2uint((byte)String2.$at(Size - 2));
            }
            case 3: {
                V = V << 8 | Unsigned.$uchar2uint((byte)String2.$at(Size - 1));
                break;
            }
            default: {
                return;
            }
        }
        this.Bits.push_back(V);
    }

    public void AddNodeID(FoldingSetNodeID ID) {
        this.Bits.append_T((uint.iterator<?>)ID.Bits.begin(), (uint.iterator<?>)ID.Bits.end());
    }

    public <T> void Add(FoldingSetTrait<T> trait, T x) {
        trait.Profile(x, this);
    }

    public void clear() {
        this.Bits.clear();
    }

    public int ComputeHash() {
        return new FoldingSetNodeIDRef(this.Bits.data(), this.Bits.size()).ComputeHash();
    }

    public boolean $eq(FoldingSetNodeID RHS) {
        return this.$eq(new FoldingSetNodeIDRef(RHS.Bits.data(), RHS.Bits.size()));
    }

    public boolean $eq(FoldingSetNodeIDRef RHS) {
        return new FoldingSetNodeIDRef(this.Bits.data(), this.Bits.size()).$eq(RHS);
    }

    public boolean $noteq(FoldingSetNodeID RHS) {
        return !this.$eq(RHS);
    }

    public boolean $noteq(FoldingSetNodeIDRef RHS) {
        return !this.$eq(RHS);
    }

    public boolean $less(FoldingSetNodeID RHS) {
        return Native.$Deref((boolean)this.$less(new FoldingSetNodeIDRef(RHS.Bits.data(), RHS.Bits.size())));
    }

    public boolean $less(FoldingSetNodeIDRef RHS) {
        return new FoldingSetNodeIDRef(this.Bits.data(), this.Bits.size()).$less(RHS);
    }

    public FoldingSetNodeIDRef Intern(BumpPtrAllocatorImpl Allocator2) {
        uint.ptr New = (uint.ptr)Casts.reinterpret_cast(uint.ptr.class, (void.ptr)Native.$tryClone((char.ptr)Allocator2.Allocate(this.Bits.size() * NativeType.sizeof(Integer.TYPE))));
        std.uninitialized_copy((uint.iterator)this.Bits.begin(), (uint.iterator)this.Bits.end(), (uint.iterator)New);
        return new FoldingSetNodeIDRef(New, this.Bits.size());
    }

    public FoldingSetNodeID(FoldingSetNodeID $Prm0) {
        this.Bits = new SmallVectorUInt($Prm0.Bits);
    }

    public void $destroy() {
        this.Bits.$destroy();
    }

    public FoldingSetNodeID $assign(FoldingSetNodeID $Prm0) {
        this.Bits.$assign($Prm0.Bits);
        return this;
    }

    public FoldingSetNodeID $assignMove(FoldingSetNodeID $Prm0) {
        this.Bits.$assignMove($Prm0.Bits);
        return this;
    }

    public String toString() {
        return "Bits=" + this.Bits;
    }

    public void Add(FoldingSetTrait.Profilable Obj) {
        if (Obj != null) {
            Obj.Profile(this);
        }
    }

    public void Add(NativeFoldingSetTrait.NativeProfilable Obj) {
        if (Obj != null) {
            Obj.Profile((NativeFoldingSetTrait.NativeFoldingSetNodeID)this);
        }
    }

    public void Add(Object Pos) {
        throw new UnsupportedOperationException("Must be FoldingSetTrait.Profilable OR NativeFoldingSetTrait.NativeProfilable OR use one of Add* alternatives " + NativeTrace.getIdentityStr((Object)Pos));
    }
}

