/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.ContextualFoldingSetTrait;
import org.llvm.adt.DefaultContextualFoldingSetTrait;
import org.llvm.adt.DefaultFoldingSetTrait;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.impl.FoldingSetStatics;
import org.llvm.support.llvm;

public abstract class FoldingSetImpl<T>
implements Iterable<T>,
Destructors.ClassWithDestructor {
    protected type.ptr<T> Buckets;
    protected int NumBuckets;
    protected int NumNodes;
    private static final String NODE_ERROR_MSG = "Forgot to derive from FoldingSetImpl.NodeImpl\n OR \nadd 'private final FoldingSetImpl.NodeImpl $nodeImpl = new FoldingSetImpl.NodeImpl()'? ";

    protected void anchor() {
    }

    protected FoldingSetImpl() {
        this(6);
    }

    protected FoldingSetImpl(int Log2InitSize) {
        assert (Unsigned.$less_uint((int)5, (int)Log2InitSize) && Unsigned.$less_uint((int)Log2InitSize, (int)32)) : "Initial hash table size out of range";
        this.NumBuckets = 1 << Log2InitSize;
        this.Buckets = Native.$toConst(FoldingSetStatics.AllocateBuckets(this.NumBuckets));
        this.NumNodes = 0;
    }

    protected FoldingSetImpl(JavaDifferentiators.JD.Move _dparam, FoldingSetImpl Arg) {
        this.Buckets = (type.ptr)Native.$tryConstClone(Arg.Buckets);
        this.NumBuckets = Arg.NumBuckets;
        this.NumNodes = Arg.NumNodes;
        Arg.Buckets = null;
        Arg.NumBuckets = 0;
        Arg.NumNodes = 0;
    }

    protected FoldingSetImpl $assignMove(FoldingSetImpl RHS) {
        std.free(this.Buckets);
        this.Buckets = (type.ptr)Native.$tryConstClone(RHS.Buckets);
        this.NumBuckets = RHS.NumBuckets;
        this.NumNodes = RHS.NumNodes;
        RHS.Buckets = null;
        RHS.NumBuckets = 0;
        RHS.NumNodes = 0;
        return this;
    }

    public void $destroy() {
        std.free(this.Buckets);
    }

    public void clear() {
        std.memset(this.Buckets, null, (int)(this.NumBuckets * 1));
        this.Buckets.$set(this.NumBuckets, (Object)FoldingSetStatics.EMPTY_NODE);
        this.NumNodes = 0;
    }

    public boolean RemoveNode(Node N) {
        type.ptr Bucket2;
        Object Ptr2 = N.getNextInBucket();
        if (Ptr2 == null) {
            return false;
        }
        --this.NumNodes;
        N.SetNextInBucket(null);
        Object NodeNextPtr = Ptr2;
        while (true) {
            Node NodeInBucket;
            if ((NodeInBucket = FoldingSetStatics.GetNextPtr(Ptr2)) != null) {
                Ptr2 = NodeInBucket.getNextInBucket();
                if (!Native.$eq((Object)Ptr2, (Object)N, (boolean)true)) continue;
                NodeInBucket.SetNextInBucket(NodeNextPtr);
                return true;
            }
            Bucket2 = (type.ptr)Native.$tryClone(FoldingSetStatics.GetBucketPtr(Ptr2));
            if (Native.$eq((Object)(Ptr2 = Bucket2.$star()), (Object)N, (boolean)true)) break;
        }
        Bucket2.$set(NodeNextPtr);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node GetOrInsertNode(Node N) {
        FoldingSetNodeID ID = null;
        try {
            ID = new FoldingSetNodeID();
            this.GetNodeProfile(N, ID);
            type.ref IP = NativePointer.create_type$null$ref(null);
            Node E = this.FindNodeOrInsertPosImpl(ID, IP);
            if (E != null) {
                Node node2 = E;
                return node2;
            }
            this.InsertNode(N, (type.ptr)IP.$deref());
            Node node3 = N;
            return node3;
        }
        finally {
            if (ID != null) {
                ID.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node FindNodeOrInsertPosImpl(FoldingSetNodeID ID, type.ref<type.ptr<T>> InsertPos) {
        FoldingSetNodeID TempID = null;
        try {
            Node NodeInBucket;
            int IDHash = ID.ComputeHash();
            type.ptr Bucket2 = (type.ptr)Native.$tryClone(FoldingSetStatics.GetBucketFor(IDHash, this.Buckets, this.NumBuckets));
            Object Probe = Bucket2.$star();
            InsertPos.$set(null);
            TempID = new FoldingSetNodeID();
            while ((NodeInBucket = FoldingSetStatics.GetNextPtr(Probe)) != null) {
                if (this.NodeEquals(NodeInBucket, ID, IDHash, TempID)) {
                    Node node2 = NodeInBucket;
                    return node2;
                }
                TempID.clear();
                Probe = NodeInBucket.getNextInBucket();
            }
            InsertPos.$set((Object)Bucket2);
            Node node3 = null;
            return node3;
        }
        finally {
            if (TempID != null) {
                TempID.$destroy();
            }
        }
    }

    public void InsertNode(Node N, type.ptr<? extends T> InsertPos) {
        assert (N.getNextInBucket() == null);
        if (Unsigned.$greater_uint((int)(this.NumNodes + 1), (int)(this.NumBuckets * 2))) {
            this.GrowHashTable();
            FoldingSetNodeID TempID = new FoldingSetNodeID();
            InsertPos = (type.ptr)Native.$tryClone(FoldingSetStatics.GetBucketFor(this.ComputeNodeHash(N, TempID), this.Buckets, this.NumBuckets));
        }
        ++this.NumNodes;
        type.ptr Bucket2 = (type.ptr)Native.$tryClone(InsertPos);
        Object Next = Bucket2.$star();
        if (Next == null) {
            Next = Bucket2;
        }
        N.SetNextInBucket(Next);
        Bucket2.$set((Object)N);
        if (NativeTrace.isDebugMode()) {
            FoldingSetNodeID TempID = new FoldingSetNodeID();
            this.GetNodeProfile(N, TempID);
            type.ref TmpInsertPos = NativePointer.create_type$null$ref(null);
            Node Found = this.FindNodeOrInsertPosImpl(TempID, TmpInsertPos);
            assert (Found == N) : "incorrect Profile? found\n " + Found + "\n right after insert:\n " + N;
        }
    }

    public void InsertNode(Node N) {
        Node Inserted = this.GetOrInsertNode(N);
        assert (Inserted == N) : "Node already inserted!";
    }

    public int size() {
        return this.NumNodes;
    }

    public boolean empty() {
        return this.NumNodes == 0;
    }

    public void reserve(int EltCount) {
        if (Unsigned.$less_uint((int)EltCount, (int)this.capacity())) {
            return;
        }
        this.GrowBucketCount(Unsigned.$ulong2uint((long)AdtsupportLlvmGlobals.PowerOf2Floor(Unsigned.$uint2ulong((int)EltCount))));
    }

    public int capacity() {
        return this.NumBuckets * 2;
    }

    private void GrowHashTable() {
        this.GrowBucketCount(this.NumBuckets * 2);
    }

    private void GrowBucketCount(int NewBucketCount) {
        assert (Unsigned.$greater_uint((int)NewBucketCount, (int)this.NumBuckets)) : "Can't shrink a folding set with GrowBucketCount";
        assert (llvm.isPowerOf2_32(NewBucketCount)) : "Bad bucket count!";
        type.ptr OldBuckets = (type.ptr)Native.$tryClone(this.Buckets);
        int OldNumBuckets = this.NumBuckets;
        this.NumBuckets = NewBucketCount;
        this.Buckets = Native.$toConst(FoldingSetStatics.AllocateBuckets(this.NumBuckets));
        this.NumNodes = 0;
        FoldingSetNodeID TempID = new FoldingSetNodeID();
        for (int i = 0; i != OldNumBuckets; ++i) {
            Node NodeInBucket;
            Object Probe = OldBuckets.$at(i);
            if (Probe == null) continue;
            while ((NodeInBucket = FoldingSetStatics.GetNextPtr(Probe)) != null) {
                Probe = NodeInBucket.getNextInBucket();
                NodeInBucket.SetNextInBucket(null);
                this.InsertNode(NodeInBucket, FoldingSetStatics.GetBucketFor(this.ComputeNodeHash(NodeInBucket, TempID), this.Buckets, this.NumBuckets));
                TempID.clear();
            }
        }
        std.free((Object)OldBuckets);
    }

    protected abstract void GetNodeProfile(Node var1, FoldingSetNodeID var2);

    protected abstract boolean NodeEquals(Node var1, FoldingSetNodeID var2, int var3, FoldingSetNodeID var4);

    protected abstract int ComputeNodeHash(Node var1, FoldingSetNodeID var2);

    @Override
    public abstract Iterator<T> iterator();

    public String toString() {
        String msg = "Buckets=" + NativeTrace.getIdentityStr(this.Buckets) + ", NumBuckets=" + this.NumBuckets + ", NumNodes=" + this.NumNodes;
        StringBuilder out = new StringBuilder(msg);
        int idx = 0;
        for (T elem : this) {
            out.append("\n[").append(NativeTrace.formatNumber((long)idx++, (int)2)).append("]");
            out.append("{").append(elem).append("}");
        }
        return out.toString();
    }

    public static class ContextualNodeImpl<Ctx>
    extends NodeImpl {
        private static final ContextualFoldingSetTrait CONTEXTUAL_TRAIT = new DefaultContextualFoldingSetTrait();

        public void Profile(FoldingSetNodeID ID, Ctx C2) {
            throw new UnsupportedOperationException("Please, implement Profile(ID, C) in " + this.getClass() + " or use another FoldingSetTrait!");
        }

        public static <T, Ctx> ContextualFoldingSetTrait<T, Ctx> $ContextualTrait() {
            return CONTEXTUAL_TRAIT;
        }
    }

    public static class NodeImpl {
        private static final FoldingSetTrait TRAIT = new DefaultFoldingSetTrait();
        private Object NextInFoldingSetBucket;

        public static <T> FoldingSetTrait<T> $Trait() {
            return TRAIT;
        }

        public NodeImpl() {
            this.NextInFoldingSetBucket = null;
        }

        public final void $Node() {
            assert (this instanceof NodeImpl) : "it is expected to be called only by FoldingSetImpl.Node sublcasses";
        }

        public final void $Node(Node other) {
            assert (this instanceof NodeImpl) : "it is expected to be called only by FoldingSetImpl.Node sublcasses";
            assert (other instanceof NodeImpl) : "it is expected to be called only by FoldingSetImpl.Node sublcasses";
            assert (this.NextInFoldingSetBucket == null) : "must be called on detached nodes";
        }

        public Object getNextInBucket() {
            return this.NextInFoldingSetBucket;
        }

        public void SetNextInBucket(Object N) {
            this.NextInFoldingSetBucket = N;
        }

        public void Profile(FoldingSetNodeID ID) {
            throw new UnsupportedOperationException("Please, implement Profile in " + this.getClass() + " or use another FoldingSetTrait!");
        }

        protected NodeImpl(Node $Prm0) {
            this.NextInFoldingSetBucket = $Prm0.getNextInBucket();
        }

        public String toString() {
            return "";
        }
    }

    public static interface ContextualNode<Ctx>
    extends Node {
        default public void Profile(FoldingSetNodeID ID, Ctx C2) {
            throw new UnsupportedOperationException("Please, implement Profile(ID, C) in " + this.getClass() + " or use another FoldingSetTrait!");
        }
    }

    public static interface Node
    extends FoldingSetTrait.Profilable {
        default public void $Node() {
            throw new UnsupportedOperationException(FoldingSetImpl.NODE_ERROR_MSG + this.getClass());
        }

        default public void $Node(Node other) {
            throw new UnsupportedOperationException(FoldingSetImpl.NODE_ERROR_MSG + this.getClass());
        }

        default public void $destroy$Node() {
            this.$destroy$NodeImpl();
        }

        default public void $destroy$NodeImpl() {
        }

        default public Object getNextInBucket() {
            return this.$nodeImpl().getNextInBucket();
        }

        default public void SetNextInBucket(Object N) {
            this.$nodeImpl().SetNextInBucket(N);
        }

        @Override
        default public void Profile(FoldingSetNodeID ID) {
            throw new UnsupportedOperationException("Forgot to generate Profile method? " + this.getClass());
        }

        default public NodeImpl $nodeImpl() {
            throw new UnsupportedOperationException(FoldingSetImpl.NODE_ERROR_MSG + this.getClass());
        }
    }
}

