/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.NativeTrace;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoPair;
import org.llvm.adt.aliases.DenseMapInfoInt;

public class DenseMapInfoPairIntInt
implements DenseMapInfo<std_pair.pairIntInt> {
    private final DenseMapInfoInt FirstInfo;
    private final DenseMapInfoInt SecondInfo;
    private final std_pair.pairIntInt emptyKey;
    private final std_pair.pairIntInt tombstoneKey;

    public DenseMapInfoPairIntInt(DenseMapInfoInt FirstInfo, DenseMapInfoInt SecondInfo) {
        this.FirstInfo = FirstInfo;
        this.SecondInfo = SecondInfo;
        this.emptyKey = std.make_pair_int_int((int)FirstInfo.getEmptyKey(), (int)SecondInfo.getEmptyKey());
        this.tombstoneKey = std.make_pair_int_int((int)FirstInfo.getTombstoneKey(), (int)SecondInfo.getTombstoneKey());
        NativeTrace.printStackTraceOnce((Throwable)new Exception("Consider use of DenseMapInfoLong and wrap_int_int_pair for perf reasons"));
    }

    @Override
    public Object getEmptyKey() {
        return this.emptyKey;
    }

    @Override
    public Object getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public int getHashValue(std_pair.pairIntInt PairVal) {
        assert (PairVal != this.emptyKey) : "must not be called for emptyKey";
        assert (PairVal != this.tombstoneKey) : "must not be called for tombstoneKey";
        return DenseMapInfoPair.combineTwoHashes(this.FirstInfo.getHashValue(PairVal.first), this.SecondInfo.getHashValue(PairVal.second));
    }

    @Override
    public boolean isEqual(std_pair.pairIntInt LHS, std_pair.pairIntInt RHS) {
        assert (LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        assert (RHS != this.emptyKey) : "RHS: must not be called for emptyKey";
        assert (RHS != this.tombstoneKey) : "RHS: must not be called for tombstoneKey";
        return this.FirstInfo.isEqual(LHS.first, RHS.first) && this.SecondInfo.isEqual(LHS.second, RHS.second);
    }

    @Override
    public boolean isKeyPointerLike() {
        return false;
    }
}

