/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativeMoveable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.clank.support.aliases.ulong;
import org.clank.support.ulong;
import org.clank.support.void;
import org.llvm.adt.APInt$__toString$$;
import org.llvm.adt.APInt$sqrt$$;
import org.llvm.adt.APIntOps;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRefULong;
import org.llvm.support.impl.APIntStatics;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class APInt<T extends APInt>
implements FoldingSetTrait.Profilable,
Destructors.ClassWithDestructor,
Native.NativePOD<T>,
NativeMoveable<T> {
    private int BitWidth;
    public long VAL;
    public ulong.ptr pVal;
    public static final int APINT_BITS_PER_WORD = NativeType.sizeof$uint64() * 8;
    public static final int APINT_WORD_SIZE = NativeType.sizeof$uint64();

    public APInt(ulong.ptr val, int bits) {
        this.BitWidth = bits;
        this.pVal = val;
    }

    public boolean isSingleWord() {
        return Unsigned.$lesseq_uint_int((int)this.BitWidth, (int)APINT_BITS_PER_WORD);
    }

    private static int whichWord(int bitPosition) {
        return Unsigned.$div_uint_int((int)bitPosition, (int)APINT_BITS_PER_WORD);
    }

    private static int whichBit(int bitPosition) {
        return Unsigned.$rem_uint_int((int)bitPosition, (int)APINT_BITS_PER_WORD);
    }

    private static long maskBit(int bitPosition) {
        return 1L << APInt.whichBit(bitPosition);
    }

    private APInt clearUnusedBits() {
        int wordBits = Unsigned.$rem_uint_int((int)this.BitWidth, (int)APINT_BITS_PER_WORD);
        if (wordBits == 0) {
            return this;
        }
        long mask = -1L >>> APINT_BITS_PER_WORD - wordBits;
        if (this.isSingleWord()) {
            this.VAL &= mask;
        } else {
            this.pVal.$set$andassign(this.getNumWords() - 1, mask);
        }
        return this;
    }

    private long getWord(int bitPosition) {
        return this.isSingleWord() ? this.VAL : this.pVal.$at(APInt.whichWord(bitPosition));
    }

    private void fromString(int numbits, StringRef str, byte radix) {
        boolean isNeg;
        assert (!str.empty()) : "Invalid string length";
        assert (Unsigned.$uchar2int((byte)radix) == 10 || Unsigned.$uchar2int((byte)radix) == 8 || Unsigned.$uchar2int((byte)radix) == 16 || Unsigned.$uchar2int((byte)radix) == 2 || Unsigned.$uchar2int((byte)radix) == 36) : "Radix should be 2, 8, 10, 16, or 36!";
        char.ptr p = Native.$tryClone((char.ptr)str.begin());
        int slen = str.size();
        boolean bl = isNeg = p.$star() == 45;
        if (p.$star() == 45 || p.$star() == 43) {
            p.$postInc();
            assert (--slen != 0) : "String is only a sign, needs a value.";
        }
        assert (Unsigned.$lesseq_uint((int)slen, (int)numbits) || Unsigned.$uchar2int((byte)radix) != 2) : "Insufficient bit width";
        assert (Unsigned.$lesseq_uint((int)((slen - 1) * 3), (int)numbits) || Unsigned.$uchar2int((byte)radix) != 8) : "Insufficient bit width";
        assert (Unsigned.$lesseq_uint((int)((slen - 1) * 4), (int)numbits) || Unsigned.$uchar2int((byte)radix) != 16) : "Insufficient bit width";
        assert (Unsigned.$lesseq_uint((int)Unsigned.$div_uint((int)((slen - 1) * 64), (int)22), (int)numbits) || Unsigned.$uchar2int((byte)radix) != 10) : "Insufficient bit width";
        if (!this.isSingleWord()) {
            this.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(this.getNumWords()));
        }
        int shift = Unsigned.$uchar2int((byte)radix) == 16 ? 4 : (Unsigned.$uchar2int((byte)radix) == 8 ? 3 : (Unsigned.$uchar2int((byte)radix) == 2 ? 1 : 0));
        APInt<T> apdigit = new APInt<T>(this.getBitWidth(), 0L);
        APInt<T> apradix = new APInt<T>(this.getBitWidth(), Unsigned.$uchar2ulong((byte)radix));
        char.ptr e = Native.$tryClone((char.ptr)str.end());
        while (Native.$noteq_ptr((void.ptr)p, (void.ptr)e)) {
            int digit = APIntStatics.getDigit(p.$star(), radix);
            assert (Unsigned.$less_uint_uchar((int)digit, (byte)radix)) : "Invalid character in digit string";
            if (Unsigned.$greater_uint((int)slen, (int)1)) {
                if (shift != 0) {
                    Native.$Deref((Object)this.$lshiftassign(shift));
                } else {
                    Native.$Deref((Object)this.$starassign(apradix));
                }
            }
            if (apdigit.isSingleWord()) {
                apdigit.VAL = Unsigned.$uint2ulong((int)digit);
            } else {
                apdigit.pVal.$set(0, Unsigned.$uint2ulong((int)digit));
            }
            Native.$Deref((Object)this.$addassign(apdigit));
            p.$preInc();
        }
        if (isNeg) {
            this.$preDec();
            this.flipAllBits();
        }
    }

    private static void divide(APInt LHS, int lhsWords, APInt RHS, int rhsWords, APInt Quotient, APInt Remainder) {
        long tmp;
        assert (Unsigned.$greatereq_uint((int)lhsWords, (int)rhsWords)) : "Fractional result";
        long mask = -1L >>> NativeType.sizeof$uint32() * 8;
        int n = rhsWords * 2;
        int m = lhsWords * 2 - n;
        uint.ptr SPACE = NativePointer.create_uint$ptr((int[])NativePointer.new$uint((int)128));
        uint.ptr U = null;
        uint.ptr V = null;
        uint.ptr Q = null;
        uint.ptr R2 = null;
        if (Unsigned.$lesseq_uint((int)((Remainder != null ? 4 : 3) * n + 2 * m + 1), (int)128)) {
            U = (uint.ptr)Native.$AddrOf((Object)((uint.ptr)SPACE.$add(0)));
            V = (uint.ptr)Native.$AddrOf((Object)((uint.ptr)SPACE.$add(m + n + 1)));
            Q = (uint.ptr)Native.$AddrOf((Object)((uint.ptr)SPACE.$add(m + n + 1 + n)));
            if (Remainder != null) {
                R2 = (uint.ptr)Native.$AddrOf((Object)((uint.ptr)SPACE.$add(m + n + 1 + n + (m + n))));
            }
        } else {
            U = NativePointer.create_uint$ptr((int[])NativePointer.new$uint((int)(m + n + 1)));
            V = NativePointer.create_uint$ptr((int[])NativePointer.new$uint((int)n));
            Q = NativePointer.create_uint$ptr((int[])NativePointer.new$uint((int)(m + n)));
            if (Remainder != null) {
                R2 = NativePointer.create_uint$ptr((int[])NativePointer.new$uint((int)n));
            }
        }
        std.memset((uint.ptr)U, (int)0, (int)((m + n + 1) * NativeType.sizeof$uint32()));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)lhsWords)) {
            tmp = LHS.getNumWords() == 1 ? LHS.VAL : LHS.pVal.$at(i);
            U.$set(i * 2, Unsigned.$ullong2uint((long)(tmp & mask)));
            U.$set(i * 2 + 1, Unsigned.$ulong2uint((long)(tmp >>> NativeType.sizeof$uint32() * 8)));
            ++i;
        }
        U.$set(m + n, 0);
        std.memset((uint.ptr)V, (int)0, (int)(n * NativeType.sizeof$uint32()));
        i = 0;
        while (Unsigned.$less_uint((int)i, (int)rhsWords)) {
            tmp = RHS.getNumWords() == 1 ? RHS.VAL : RHS.pVal.$at(i);
            V.$set(i * 2, Unsigned.$ullong2uint((long)(tmp & mask)));
            V.$set(i * 2 + 1, Unsigned.$ulong2uint((long)(tmp >>> NativeType.sizeof$uint32() * 8)));
            ++i;
        }
        std.memset((uint.ptr)Q, (int)0, (int)((m + n) * NativeType.sizeof$uint32()));
        if (Remainder != null) {
            std.memset((uint.ptr)R2, (int)0, (int)(n * NativeType.sizeof$uint32()));
        }
        i = n;
        while (Unsigned.$greater_uint((int)i, (int)0) && V.$at(i - 1) == 0) {
            --n;
            ++m;
            --i;
        }
        i = m + n;
        while (Unsigned.$greater_uint((int)i, (int)0) && U.$at(i - 1) == 0) {
            --m;
            --i;
        }
        assert (n != 0) : "Divide by zero?";
        if (n == 1) {
            int divisor = V.$at(0);
            int remainder = 0;
            for (int i2 = m + n - 1; i2 >= 0; --i2) {
                long partial_dividend = Unsigned.$uint2ulong((int)remainder) << 32 | Unsigned.$uint2ullong((int)U.$at(i2));
                if (partial_dividend == 0L) {
                    Q.$set(i2, 0);
                    remainder = 0;
                    continue;
                }
                if (Unsigned.$less_ulong_uint((long)partial_dividend, (int)divisor)) {
                    Q.$set(i2, 0);
                    remainder = (int)partial_dividend;
                    continue;
                }
                if (partial_dividend == Unsigned.$uint2ullong((int)divisor)) {
                    Q.$set(i2, 1);
                    remainder = 0;
                    continue;
                }
                Q.$set(i2, (int)Unsigned.$div_ulong_uint((long)partial_dividend, (int)divisor));
                remainder = (int)(partial_dividend - Unsigned.$uint2ullong((int)(Q.$at(i2) * divisor)));
            }
            if (R2 != null) {
                R2.$set(0, remainder);
            }
        } else {
            APIntStatics.KnuthDiv(U, V, Q, R2, m, n);
        }
        if (Quotient != null) {
            if (Quotient.BitWidth != LHS.BitWidth) {
                if (Quotient.isSingleWord()) {
                    Quotient.VAL = 0L;
                } else {
                    Destructors.$destroyArray((Object)Quotient.pVal);
                }
                Quotient.BitWidth = LHS.BitWidth;
                if (!Quotient.isSingleWord()) {
                    Quotient.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(Quotient.getNumWords()));
                }
            } else {
                Quotient.clearAllBits();
            }
            if (lhsWords == 1) {
                long tmp2 = Unsigned.$uint2ulong((int)Q.$at(0)) | Unsigned.$uint2ulong((int)Q.$at(1)) << APINT_BITS_PER_WORD / 2;
                if (Quotient.isSingleWord()) {
                    Quotient.VAL = tmp2;
                } else {
                    Quotient.pVal.$set(0, tmp2);
                }
            } else {
                assert (!Quotient.isSingleWord()) : "Quotient APInt not large enough";
                i = 0;
                while (Unsigned.$less_uint((int)i, (int)lhsWords)) {
                    Quotient.pVal.$set(i, Unsigned.$uint2ulong((int)Q.$at(i * 2)) | Unsigned.$uint2ulong((int)Q.$at(i * 2 + 1)) << APINT_BITS_PER_WORD / 2);
                    ++i;
                }
            }
        }
        if (Remainder != null) {
            if (Remainder.BitWidth != RHS.BitWidth) {
                if (Remainder.isSingleWord()) {
                    Remainder.VAL = 0L;
                } else {
                    Destructors.$destroyArray((Object)Remainder.pVal);
                }
                Remainder.BitWidth = RHS.BitWidth;
                if (!Remainder.isSingleWord()) {
                    Remainder.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(Remainder.getNumWords()));
                }
            } else {
                Remainder.clearAllBits();
            }
            if (rhsWords == 1) {
                long tmp3 = Unsigned.$uint2ulong((int)R2.$at(0)) | Unsigned.$uint2ulong((int)R2.$at(1)) << APINT_BITS_PER_WORD / 2;
                if (Remainder.isSingleWord()) {
                    Remainder.VAL = tmp3;
                } else {
                    Remainder.pVal.$set(0, tmp3);
                }
            } else {
                assert (!Remainder.isSingleWord()) : "Remainder APInt not large enough";
                i = 0;
                while (Unsigned.$less_uint((int)i, (int)rhsWords)) {
                    Remainder.pVal.$set(i, Unsigned.$uint2ulong((int)R2.$at(i * 2)) | Unsigned.$uint2ulong((int)R2.$at(i * 2 + 1)) << APINT_BITS_PER_WORD / 2);
                    ++i;
                }
            }
        }
        if (Native.$noteq_ptr((void.ptr)U, (void.ptr)((void.ptr)Native.$AddrOf((Object)SPACE)))) {
            Destructors.$destroyArray((Object)U);
            Destructors.$destroyArray((Object)V);
            Destructors.$destroyArray((Object)Q);
            Destructors.$destroyArray((Object)R2);
        }
    }

    private void initSlowCase(int numBits, long val, boolean isSigned) {
        this.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(APInt.getNumWords(numBits)));
        this.pVal.$set(0, val);
        if (isSigned && val < 0L) {
            for (int i = 1; i < APInt.getNumWords(numBits); ++i) {
                this.pVal.$set(i, -1L);
            }
        }
    }

    private void initFromArray(ArrayRefULong bigVal) {
        assert (this.BitWidth != 0) : "Bitwidth too small";
        assert (bigVal.data() != null) : "Null pointer detected!";
        if (this.isSingleWord()) {
            this.VAL = bigVal.$at(0);
        } else {
            this.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getClearedMemory(this.getNumWords()));
            int words = std.min((int)bigVal.size(), (int)this.getNumWords());
            std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)bigVal.data(), (int)(words * APINT_WORD_SIZE));
        }
        this.clearUnusedBits();
    }

    private void initSlowCase(APInt that) {
        this.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(this.getNumWords()));
        std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)that.pVal, (int)(this.getNumWords() * APINT_WORD_SIZE));
    }

    private APInt shlSlowCase(int shiftAmt) {
        if (shiftAmt == this.BitWidth) {
            return new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, this.BitWidth, 0L);
        }
        if (shiftAmt == 0) {
            return new APInt<T>(this);
        }
        ulong.ptr val = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)this.getNumWords()));
        if (Unsigned.$less_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD)) {
            long carry = 0L;
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
                val.$set(i, this.pVal.$at(i) << shiftAmt | carry);
                carry = this.pVal.$at(i) >>> APINT_BITS_PER_WORD - shiftAmt;
                ++i;
            }
            APInt<T> Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            return Result;
        }
        int wordShift = Unsigned.$rem_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD);
        int offset = Unsigned.$div_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD);
        if (wordShift == 0) {
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)offset)) {
                val.$set(i, 0L);
                ++i;
            }
            i = offset;
            while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
                val.$set(i, this.pVal.$at(i - offset));
                ++i;
            }
            APInt<T> Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            return Result;
        }
        int i = this.getNumWords() - 1;
        while (Unsigned.$greater_uint((int)i, (int)offset)) {
            val.$set(i, this.pVal.$at(i - offset) << wordShift | this.pVal.$at(i - offset - 1) >>> APINT_BITS_PER_WORD - wordShift);
            --i;
        }
        val.$set(offset, this.pVal.$at(0) << wordShift);
        i = 0;
        while (Unsigned.$less_uint((int)i, (int)offset)) {
            val.$set(i, 0L);
            ++i;
        }
        APInt<T> Result = new APInt<T>(val, this.BitWidth);
        super.clearUnusedBits();
        return Result;
    }

    private APInt AndSlowCase(APInt RHS) {
        int numWords = this.getNumWords();
        ulong.ptr val = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(numWords));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)numWords)) {
            val.$set(i, this.pVal.$at(i) & RHS.pVal.$at(i));
            ++i;
        }
        return new APInt<T>(val, this.getBitWidth());
    }

    private APInt OrSlowCase(APInt RHS) {
        int numWords = this.getNumWords();
        ulong.ptr val = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(numWords));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)numWords)) {
            val.$set(i, this.pVal.$at(i) | RHS.pVal.$at(i));
            ++i;
        }
        return new APInt<T>(val, this.getBitWidth());
    }

    private APInt XorSlowCase(APInt RHS) {
        int numWords = this.getNumWords();
        ulong.ptr val = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(numWords));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)numWords)) {
            val.$set(i, this.pVal.$at(i) ^ RHS.pVal.$at(i));
            ++i;
        }
        APInt<T> Result = new APInt<T>(val, this.getBitWidth());
        super.clearUnusedBits();
        return Result;
    }

    private APInt AssignSlowCase(APInt RHS) {
        if (this == Native.$AddrOf((Object)RHS)) {
            return this;
        }
        if (this.BitWidth == RHS.getBitWidth()) {
            assert (!this.isSingleWord());
            std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)RHS.pVal, (int)(this.getNumWords() * APINT_WORD_SIZE));
            return this;
        }
        if (this.isSingleWord()) {
            assert (!RHS.isSingleWord());
            this.VAL = 0L;
            this.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(RHS.getNumWords()));
            std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)RHS.pVal, (int)(RHS.getNumWords() * APINT_WORD_SIZE));
        } else if (this.getNumWords() == RHS.getNumWords()) {
            std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)RHS.pVal, (int)(RHS.getNumWords() * APINT_WORD_SIZE));
        } else if (RHS.isSingleWord()) {
            Destructors.$destroyArray((Object)this.pVal);
            this.VAL = RHS.VAL;
        } else {
            Destructors.$destroyArray((Object)this.pVal);
            this.pVal = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(RHS.getNumWords()));
            std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)RHS.pVal, (int)(RHS.getNumWords() * APINT_WORD_SIZE));
        }
        this.BitWidth = RHS.BitWidth;
        return this.clearUnusedBits();
    }

    private boolean EqualSlowCase(APInt RHS) {
        int n2;
        int n1 = this.getActiveBits();
        if (n1 != (n2 = RHS.getActiveBits())) {
            return false;
        }
        if (n1 <= APINT_BITS_PER_WORD) {
            return this.pVal.$at(0) == RHS.pVal.$at(0);
        }
        for (int i = APInt.whichWord(n1 - 1); i >= 0; --i) {
            if (this.pVal.$at(i) == RHS.pVal.$at(i)) continue;
            return false;
        }
        return true;
    }

    private boolean EqualSlowCase(long Val) {
        int n = this.getActiveBits();
        if (Unsigned.$lesseq_uint_int((int)n, (int)APINT_BITS_PER_WORD)) {
            return this.pVal.$at(0) == Val;
        }
        return false;
    }

    private int countLeadingZerosSlowCase() {
        int Count;
        long MSWMask;
        int BitsInMSW = this.BitWidth % APINT_BITS_PER_WORD;
        if (BitsInMSW != 0) {
            MSWMask = (1L << BitsInMSW) - 1L;
        } else {
            MSWMask = -1L;
            BitsInMSW = APINT_BITS_PER_WORD;
        }
        int i = this.getNumWords();
        long MSW = this.pVal.$at(i - 1) & MSWMask;
        if (MSW != 0L) {
            Count = llvm.countLeadingZeros(MSW) - (APINT_BITS_PER_WORD - BitsInMSW);
        } else {
            Count = BitsInMSW;
            --i;
            while (i > 0) {
                if (this.pVal.$at(i - 1) == 0L) {
                    Count += APINT_BITS_PER_WORD;
                } else {
                    Count += llvm.countLeadingZeros(this.pVal.$at(i - 1));
                    break;
                }
                --i;
            }
        }
        return Count;
    }

    private int countTrailingOnesSlowCase() {
        int Count = 0;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.getNumWords()) && this.pVal.$at(i) == -1L) {
            Count += APINT_BITS_PER_WORD;
            ++i;
        }
        if (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
            Count += llvm.CountTrailingOnes_64(this.pVal.$at(i));
        }
        return std.min_uint((int)Count, (int)this.BitWidth);
    }

    private int countPopulationSlowCase() {
        int Count = 0;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
            Count += llvm.CountPopulation_64(this.pVal.$at(i));
            ++i;
        }
        return Count;
    }

    public APInt(JavaDifferentiators.JD.UInt_ULong _dparam, int numBits, long val) {
        this(_dparam, numBits, val, false);
    }

    public APInt(JavaDifferentiators.JD.UInt_ULong _dparam, int numBits, long val, boolean isSigned) {
        this.BitWidth = numBits;
        this.VAL = 0L;
        assert (this.BitWidth != 0) : "bitwidth too small " + this.BitWidth;
        if (this.isSingleWord()) {
            this.VAL = val;
        } else {
            this.initSlowCase(numBits, val, isSigned);
        }
        this.clearUnusedBits();
    }

    public APInt(int numBits, long val) {
        this(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, val);
    }

    public APInt(int numBits, ArrayRefULong bigVal) {
        assert (numBits >= 0) : "BitWidth must not be negatove: " + numBits;
        this.BitWidth = numBits;
        this.VAL = 0L;
        this.initFromArray(bigVal);
    }

    public APInt(int numBits, int NumWords, ulong.ptr $bigVal) {
        this(numBits, llvm.makeArrayRef$ULong($bigVal, NumWords));
    }

    public APInt(JavaDifferentiators.JD.UInt_UInt _dparam, int numBits, int numWords, long[] bigVal) {
        assert (numBits >= 0) : "must be non negative " + numBits;
        assert (numWords >= 0) : "must be non negative " + numWords;
        this.BitWidth = numBits;
        this.VAL = 0L;
        this.initFromArray(llvm.makeArrayRef$ULong(bigVal, numWords));
    }

    public APInt(int numBits, int numWords, long[] bigVal) {
        this(JavaDifferentiators.JD.UInt_UInt.INSTANCE, numBits, numWords, bigVal);
    }

    public APInt(int numbits, StringRef Str, byte radix) {
        this.BitWidth = numbits;
        this.VAL = 0L;
        assert (this.BitWidth != 0) : "Bitwidth too small";
        this.fromString(numbits, Str, radix);
    }

    public APInt(int numbits, StringRef Str, int radix) {
        this(numbits, Str, Unsigned.$uint2uchar((int)radix));
    }

    public APInt(int numbits, String Str, int radix) {
        this(numbits, new StringRef(Str), Unsigned.$uint2uchar((int)radix));
    }

    public APInt(APInt that) {
        this.BitWidth = that.BitWidth;
        this.VAL = 0L;
        if (this.isSingleWord()) {
            this.VAL = that.VAL;
        } else {
            this.initSlowCase(that);
        }
    }

    public APInt(JavaDifferentiators.JD.Move _dparam, APInt that) {
        this.BitWidth = that.BitWidth;
        this.VAL = that.VAL;
        this.pVal = that.pVal;
        that.BitWidth = 0;
        that.pVal = null;
    }

    public void $destroy() {
        if (this.needsCleanup()) {
            Destructors.$destroyArray((Object)this.pVal);
        }
    }

    public APInt() {
        this.BitWidth = 1;
        this.VAL = 0L;
    }

    public boolean needsCleanup() {
        return !this.isSingleWord();
    }

    @Override
    public void Profile(FoldingSetNodeID ID) {
        ID.AddInteger_uint(this.BitWidth);
        if (this.isSingleWord()) {
            ID.AddInteger_ullong(this.VAL);
            return;
        }
        int NumWords = this.getNumWords();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)NumWords)) {
            ID.AddInteger_ullong(this.pVal.$at(i));
            ++i;
        }
    }

    public boolean isNegative() {
        return this.$at(this.BitWidth - 1);
    }

    public boolean isNonNegative() {
        return !this.isNegative();
    }

    public boolean isStrictlyPositive() {
        return this.isNonNegative() && !Native.$Deref((boolean)this.$not());
    }

    public boolean isAllOnesValue() {
        if (this.isSingleWord()) {
            return this.VAL == -1L >>> APINT_BITS_PER_WORD - this.BitWidth;
        }
        return this.countPopulationSlowCase() == this.BitWidth;
    }

    public boolean isMaxValue() {
        return this.isAllOnesValue();
    }

    public boolean isMaxSignedValue() {
        return this.BitWidth == 1 ? this.VAL == 0L : !this.isNegative() && this.countPopulation() == this.BitWidth - 1;
    }

    public boolean isMinValue() {
        return Native.$Deref((boolean)this.$not());
    }

    public boolean isMinSignedValue() {
        return this.BitWidth == 1 ? this.VAL == 1L : this.isNegative() && this.isPowerOf2();
    }

    public boolean isIntN(int N) {
        assert (N != 0) : "N == 0 ???";
        return Unsigned.$lesseq_uint((int)this.getActiveBits(), (int)N);
    }

    public boolean isSignedIntN(int N) {
        assert (N != 0) : "N == 0 ???";
        return Unsigned.$lesseq_uint((int)this.getMinSignedBits(), (int)N);
    }

    public boolean isPowerOf2() {
        if (this.isSingleWord()) {
            return llvm.isPowerOf2_64(this.VAL);
        }
        return this.countPopulationSlowCase() == 1;
    }

    public boolean isSignBit() {
        return this.isMinSignedValue();
    }

    public boolean getBoolValue() {
        return !Native.$Deref((boolean)this.$not());
    }

    public long getLimitedValue() {
        return this.getLimitedValue(-1L);
    }

    public long getLimitedValue(long Limit) {
        return Unsigned.$greater_uint((int)this.getActiveBits(), (int)64) || Unsigned.$greater_ulong((long)this.getZExtValue(), (long)Limit) ? Limit : this.getZExtValue();
    }

    public boolean isSplat(int SplatSizeInBits) {
        assert (Unsigned.$rem_uint((int)this.getBitWidth(), (int)SplatSizeInBits) == 0) : "SplatSizeInBits must divide width!";
        return this.$eq(this.rotl(SplatSizeInBits));
    }

    public static APInt getMaxValue(int numBits) {
        return APInt.getAllOnesValue(numBits);
    }

    public static APInt getSignedMaxValue(int numBits) {
        APInt API = APInt.getAllOnesValue(numBits);
        API.clearBit(numBits - 1);
        return API;
    }

    public static APInt getMinValue(int numBits) {
        return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, 0L);
    }

    public static APInt getSignedMinValue(int numBits) {
        APInt API = new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, 0L);
        API.setBit(numBits - 1);
        return API;
    }

    public static APInt getSignBit(int BitWidth) {
        return APInt.getSignedMinValue(BitWidth);
    }

    public static APInt getAllOnesValue(int numBits) {
        return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, -1L, true);
    }

    public static APInt getNullValue(int numBits) {
        return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, 0L);
    }

    public APInt getHiBits(int numBits) {
        return APIntOps.lshr(this, this.BitWidth - numBits);
    }

    public APInt getLoBits(int numBits) {
        return APIntOps.lshr(APIntOps.shl(this, this.BitWidth - numBits), this.BitWidth - numBits);
    }

    public static APInt getOneBitSet(int numBits, int BitNo) {
        APInt Res = new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, 0L);
        Res.setBit(BitNo);
        return Res;
    }

    public static APInt getBitsSet(int numBits, int loBit, int hiBit) {
        assert (Unsigned.$lesseq_uint((int)hiBit, (int)numBits)) : "hiBit out of range";
        assert (Unsigned.$less_uint((int)loBit, (int)numBits)) : "loBit out of range";
        if (Unsigned.$less_uint((int)hiBit, (int)loBit)) {
            return APInt.getLowBitsSet(numBits, hiBit).$bitor(APInt.getHighBitsSet(numBits, numBits - loBit));
        }
        return APInt.getLowBitsSet(numBits, hiBit - loBit).shl(loBit);
    }

    public static APInt getHighBitsSet(int numBits, int hiBitsSet) {
        assert (Unsigned.$lesseq_uint((int)hiBitsSet, (int)numBits)) : "Too many bits to set!";
        if (hiBitsSet == 0) {
            return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, 0L);
        }
        int shiftAmt = numBits - hiBitsSet;
        if (Unsigned.$lesseq_uint_int((int)numBits, (int)APINT_BITS_PER_WORD)) {
            return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, -1L << shiftAmt);
        }
        return APInt.getAllOnesValue(numBits).shl(shiftAmt);
    }

    public static APInt getLowBitsSet(int numBits, int loBitsSet) {
        assert (Unsigned.$lesseq_uint((int)loBitsSet, (int)numBits)) : "Too many bits to set!";
        if (loBitsSet == 0) {
            return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, 0L);
        }
        if (loBitsSet == APINT_BITS_PER_WORD) {
            return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, -1L);
        }
        if (Unsigned.$lesseq_uint_int((int)loBitsSet, (int)APINT_BITS_PER_WORD)) {
            return new APInt(JavaDifferentiators.JD.UInt_ULong.INSTANCE, numBits, -1L >>> APINT_BITS_PER_WORD - loBitsSet);
        }
        return APInt.getAllOnesValue(numBits).lshr(numBits - loBitsSet);
    }

    public static APInt getSplat(int NewLen, APInt V) {
        assert (Unsigned.$greatereq_uint((int)NewLen, (int)V.getBitWidth())) : "Can't splat to smaller bit width!";
        APInt Val = V.zextOrSelf(NewLen);
        int I = V.getBitWidth();
        while (Unsigned.$less_uint((int)I, (int)NewLen)) {
            Val.$orassign(Val.$out(I));
            I <<= 1;
        }
        return Val;
    }

    public static boolean isSameValue(APInt I1, APInt I2) {
        if (I1.getBitWidth() == I2.getBitWidth()) {
            return I1.$eq(I2);
        }
        if (Unsigned.$greater_uint((int)I1.getBitWidth(), (int)I2.getBitWidth())) {
            return I1.$eq(I2.zext(I1.getBitWidth()));
        }
        return I1.zext(I2.getBitWidth()).$eq(I2);
    }

    public ulong.ptr getRawData() {
        if (this.isSingleWord()) {
            return new ulong.ptr.inout(this){

                protected long $star$impl() {
                    return APInt.this.VAL;
                }

                protected long $set$impl(long value) {
                    APInt.this.VAL = value;
                    return APInt.this.VAL;
                }
            };
        }
        return (ulong.ptr)this.pVal.$add(0);
    }

    public APInt $postInc(int $Prm0) {
        APInt<T> API = new APInt<T>(this);
        this.$preInc();
        return API;
    }

    public APInt $preInc() {
        if (this.isSingleWord()) {
            ++this.VAL;
        } else {
            APIntStatics.add_1(this.pVal, this.pVal, this.getNumWords(), 1L);
        }
        return this.clearUnusedBits();
    }

    public APInt $postDec(int $Prm0) {
        APInt<T> API = new APInt<T>(this);
        this.$preDec();
        return API;
    }

    public APInt $preDec() {
        if (this.isSingleWord()) {
            --this.VAL;
        } else {
            APIntStatics.sub_1(this.pVal, this.getNumWords(), 1L);
        }
        return this.clearUnusedBits();
    }

    public APInt $bitnot() {
        APInt<T> Result = new APInt<T>(this);
        Result.flipAllBits();
        return Result;
    }

    public APInt $sub() {
        APInt<T> Result = new APInt<T>(this);
        Result.flipAllBits();
        Result.$preInc();
        return Result;
    }

    public boolean $not() {
        if (this.isSingleWord()) {
            return this.VAL == 0L;
        }
        for (int i = 0; i != this.getNumWords(); ++i) {
            if (this.pVal.$at(i) == 0L) continue;
            return false;
        }
        return true;
    }

    public APInt $assign(APInt RHS) {
        if (this.isSingleWord() && RHS.isSingleWord()) {
            this.VAL = RHS.VAL;
            this.BitWidth = RHS.BitWidth;
            return this.clearUnusedBits();
        }
        return this.AssignSlowCase(RHS);
    }

    public APInt $assignMove(APInt that) {
        if (!this.isSingleWord()) {
            if (this == Native.$AddrOf((Object)that)) {
                return this;
            }
            Destructors.$destroyArray((Object)this.pVal);
        }
        this.VAL = that.VAL;
        this.pVal = that.pVal;
        that.pVal = null;
        int ThatBitWidth = that.BitWidth;
        that.BitWidth = 0;
        this.BitWidth = ThatBitWidth;
        return this;
    }

    public APInt $assign(long RHS) {
        if (this.isSingleWord()) {
            this.VAL = RHS;
        } else {
            this.pVal.$set(0, RHS);
            std.memset((ulong.ptr)((ulong.ptr)this.pVal.$add(1)), (long)0L, (int)((this.getNumWords() - 1) * APINT_WORD_SIZE));
        }
        return this.clearUnusedBits();
    }

    public APInt $assign(boolean RHS) {
        return this.$assign(RHS ? 1L : 0L);
    }

    public APInt $andassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL &= RHS.VAL;
            return this;
        }
        int numWords = this.getNumWords();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)numWords)) {
            this.pVal.$set$andassign(i, RHS.pVal.$at(i));
            ++i;
        }
        return this;
    }

    public APInt $orassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL |= RHS.VAL;
            return this;
        }
        int numWords = this.getNumWords();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)numWords)) {
            this.pVal.$set$orassign(i, RHS.pVal.$at(i));
            ++i;
        }
        return this;
    }

    public APInt $orassign(long RHS) {
        if (this.isSingleWord()) {
            this.VAL |= RHS;
            this.clearUnusedBits();
        } else {
            this.pVal.$set$orassign(0, RHS);
        }
        return this;
    }

    public APInt $xorassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL ^= RHS.VAL;
            this.clearUnusedBits();
            return this;
        }
        int numWords = this.getNumWords();
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)numWords)) {
            this.pVal.$set$xorassign(i, RHS.pVal.$at(i));
            ++i;
        }
        return this.clearUnusedBits();
    }

    public APInt $starassign(APInt RHS) {
        int rhsWords;
        int lhsWords;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL *= RHS.VAL;
            this.clearUnusedBits();
            return this;
        }
        int lhsBits = this.getActiveBits();
        int n = lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
        if (lhsWords == 0) {
            return this;
        }
        int rhsBits = RHS.getActiveBits();
        int n2 = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
        if (rhsWords == 0) {
            this.clearAllBits();
            return this;
        }
        int destWords = rhsWords + lhsWords;
        ulong.ptr dest = (ulong.ptr)Native.$tryClone((NativeCloneable)APIntStatics.getMemory(destWords));
        APIntStatics.mul(dest, this.pVal, lhsWords, RHS.pVal, rhsWords);
        this.clearAllBits();
        int wordsToCopy = Unsigned.$greatereq_uint((int)destWords, (int)this.getNumWords()) ? this.getNumWords() : destWords;
        std.memcpy((ulong.ptr)this.pVal, (ulong.ptr)dest, (int)(wordsToCopy * APINT_WORD_SIZE));
        this.clearUnusedBits();
        Destructors.$destroyArray((Object)dest);
        return this;
    }

    public APInt $addassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL += RHS.VAL;
        } else {
            APIntStatics.add(this.pVal, this.pVal, RHS.pVal, this.getNumWords());
        }
        return this.clearUnusedBits();
    }

    public APInt $minusassign(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            this.VAL -= RHS.VAL;
        } else {
            APIntStatics.sub(this.pVal, this.pVal, RHS.pVal, this.getNumWords());
        }
        return this.clearUnusedBits();
    }

    public APInt $lshiftassign(int shiftAmt) {
        this.$assignMove(this.shl(shiftAmt));
        return this;
    }

    public APInt $bitand(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.getBitWidth(), this.VAL & RHS.VAL);
        }
        return this.AndSlowCase(RHS);
    }

    public APInt And(APInt RHS) {
        return this.$bitand(RHS);
    }

    public APInt $bitor(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.getBitWidth(), this.VAL | RHS.VAL);
        }
        return this.OrSlowCase(RHS);
    }

    public APInt Or(APInt RHS) {
        return this.$bitor(RHS);
    }

    public APInt $bitxor(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL ^ RHS.VAL);
        }
        return this.XorSlowCase(RHS);
    }

    public APInt Xor(APInt RHS) {
        return this.$bitxor(RHS);
    }

    public APInt $star(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL * RHS.VAL);
        }
        APInt<T> Result = new APInt<T>(this);
        Result.$starassign(RHS);
        return Result;
    }

    public APInt $add(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL + RHS.VAL);
        }
        APInt<T> Result = new APInt<T>(this.BitWidth, 0L);
        APIntStatics.add(Result.pVal, this.pVal, RHS.pVal, this.getNumWords());
        super.clearUnusedBits();
        return Result;
    }

    public APInt $add(long RHS) {
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL + RHS);
        }
        APInt<T> Result = new APInt<T>(this);
        APIntStatics.add_1(Result.pVal, Result.pVal, this.getNumWords(), RHS);
        super.clearUnusedBits();
        return Result;
    }

    public APInt $sub(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL - RHS.VAL);
        }
        APInt<T> Result = new APInt<T>(this.BitWidth, 0L);
        APIntStatics.sub(Result.pVal, this.pVal, RHS.pVal, this.getNumWords());
        super.clearUnusedBits();
        return Result;
    }

    public APInt $sub(long RHS) {
        if (this.isSingleWord()) {
            return new APInt<T>(this.BitWidth, this.VAL - RHS);
        }
        APInt<T> Result = new APInt<T>(this);
        APIntStatics.sub_1(Result.pVal, this.getNumWords(), RHS);
        super.clearUnusedBits();
        return Result;
    }

    public APInt $out(int Bits) {
        return this.shl(Bits);
    }

    public APInt $out(APInt Bits) {
        return this.shl(Bits);
    }

    public APInt ashr(int shiftAmt) {
        int i;
        assert (Unsigned.$lesseq_uint((int)shiftAmt, (int)this.BitWidth)) : "Invalid shift amount";
        if (shiftAmt == 0) {
            return this;
        }
        if (this.isSingleWord()) {
            if (shiftAmt == this.BitWidth) {
                return new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, this.BitWidth, 0L);
            }
            int SignBit = APINT_BITS_PER_WORD - this.BitWidth;
            return new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, this.BitWidth, this.VAL << SignBit >>> SignBit >>> shiftAmt);
        }
        if (shiftAmt == this.BitWidth) {
            if (this.isNegative()) {
                return new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, this.BitWidth, -1L, true);
            }
            return new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, this.BitWidth, 0L);
        }
        ulong.ptr val = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)this.getNumWords()));
        int wordShift = Unsigned.$rem_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD);
        int offset = Unsigned.$div_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD);
        int breakWord = this.getNumWords() - 1 - offset;
        int bitsInWord = APInt.whichBit(this.BitWidth);
        if (bitsInWord == 0) {
            bitsInWord = APINT_BITS_PER_WORD;
        }
        if (wordShift == 0) {
            i = 0;
            while (Unsigned.$lesseq_uint((int)i, (int)breakWord)) {
                val.$set(i, this.pVal.$at(i + offset));
                ++i;
            }
            if (this.isNegative() && Unsigned.$less_uint_int((int)bitsInWord, (int)APINT_BITS_PER_WORD)) {
                val.$set$orassign(breakWord, -1L << bitsInWord);
            }
        } else {
            i = 0;
            while (Unsigned.$less_uint((int)i, (int)breakWord)) {
                val.$set(i, this.pVal.$at(i + offset) >>> wordShift | this.pVal.$at(i + offset + 1) << APINT_BITS_PER_WORD - wordShift);
                ++i;
            }
            val.$set(breakWord, this.pVal.$at(breakWord + offset) >>> wordShift);
            if (this.isNegative()) {
                if (Unsigned.$greater_uint((int)wordShift, (int)bitsInWord)) {
                    if (Unsigned.$greater_uint((int)breakWord, (int)0)) {
                        val.$set$orassign(breakWord - 1, -1L << APINT_BITS_PER_WORD - (wordShift - bitsInWord));
                    }
                    val.$set$orassign(breakWord, -1L);
                } else {
                    val.$set$orassign(breakWord, -1L << bitsInWord - wordShift);
                }
            }
        }
        long fillValue = this.isNegative() ? -1L : 0L;
        int i2 = breakWord + 1;
        while (Unsigned.$less_uint((int)i2, (int)this.getNumWords())) {
            val.$set(i2, fillValue);
            ++i2;
        }
        APInt<T> Result = new APInt<T>(val, this.BitWidth);
        super.clearUnusedBits();
        return Result;
    }

    public APInt lshr(int shiftAmt) {
        if (this.isSingleWord()) {
            if (Unsigned.$greatereq_uint((int)shiftAmt, (int)this.BitWidth)) {
                return new APInt<T>(this.BitWidth, 0L);
            }
            return new APInt<T>(this.BitWidth, this.VAL >>> shiftAmt);
        }
        if (Unsigned.$greatereq_uint((int)shiftAmt, (int)this.BitWidth)) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (shiftAmt == 0) {
            return new APInt<T>(this);
        }
        ulong.ptr val = NativePointer.create_ulong$ptr((long[])NativePointer.new$ulong((int)this.getNumWords()));
        if (Unsigned.$less_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD)) {
            APIntStatics.lshrNear(val, this.pVal, this.getNumWords(), shiftAmt);
            APInt<T> Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            return Result;
        }
        int wordShift = Unsigned.$rem_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD);
        int offset = Unsigned.$div_uint_int((int)shiftAmt, (int)APINT_BITS_PER_WORD);
        if (wordShift == 0) {
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)(this.getNumWords() - offset))) {
                val.$set(i, this.pVal.$at(i + offset));
                ++i;
            }
            i = this.getNumWords() - offset;
            while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
                val.$set(i, 0L);
                ++i;
            }
            APInt<T> Result = new APInt<T>(val, this.BitWidth);
            super.clearUnusedBits();
            return Result;
        }
        int breakWord = this.getNumWords() - offset - 1;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)breakWord)) {
            val.$set(i, this.pVal.$at(i + offset) >>> wordShift | this.pVal.$at(i + offset + 1) << APINT_BITS_PER_WORD - wordShift);
            ++i;
        }
        val.$set(breakWord, this.pVal.$at(breakWord + offset) >>> wordShift);
        i = breakWord + 1;
        while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
            val.$set(i, 0L);
            ++i;
        }
        APInt<T> Result = new APInt<T>(val, this.BitWidth);
        super.clearUnusedBits();
        return Result;
    }

    public APInt shl(int shiftAmt) {
        assert (Unsigned.$lesseq_uint((int)shiftAmt, (int)this.BitWidth)) : "Invalid shift amount";
        if (this.isSingleWord()) {
            if (Unsigned.$greatereq_uint((int)shiftAmt, (int)this.BitWidth)) {
                return new APInt<T>(this.BitWidth, 0L);
            }
            return new APInt<T>(this.BitWidth, this.VAL << shiftAmt);
        }
        return this.shlSlowCase(shiftAmt);
    }

    public APInt rotl(int rotateAmt) {
        if ((rotateAmt = Unsigned.$rem_uint((int)rotateAmt, (int)this.BitWidth)) == 0) {
            return new APInt<T>(this);
        }
        return this.shl(rotateAmt).$bitor(this.lshr(this.BitWidth - rotateAmt));
    }

    public APInt rotr(int rotateAmt) {
        if ((rotateAmt = Unsigned.$rem_uint((int)rotateAmt, (int)this.BitWidth)) == 0) {
            return new APInt<T>(this);
        }
        return this.lshr(rotateAmt).$bitor(this.shl(this.BitWidth - rotateAmt));
    }

    public APInt ashr(APInt shiftAmt) {
        return this.ashr((int)shiftAmt.getLimitedValue(Unsigned.$uint2ulong((int)this.BitWidth)));
    }

    public APInt lshr(APInt shiftAmt) {
        return this.lshr((int)shiftAmt.getLimitedValue(Unsigned.$uint2ulong((int)this.BitWidth)));
    }

    public APInt shl(APInt shiftAmt) {
        return this.shl((int)shiftAmt.getLimitedValue(Unsigned.$uint2ulong((int)this.BitWidth)));
    }

    public APInt rotl(APInt rotateAmt) {
        return this.rotl((int)rotateAmt.getLimitedValue(Unsigned.$uint2ulong((int)this.BitWidth)));
    }

    public APInt rotr(APInt rotateAmt) {
        return this.rotr((int)rotateAmt.getLimitedValue(Unsigned.$uint2ulong((int)this.BitWidth)));
    }

    public APInt udiv(APInt RHS) {
        int lhsWords;
        int rhsWords;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            assert (RHS.VAL != 0L) : "Divide by zero?";
            return new APInt<T>(this.BitWidth, Unsigned.$div_ulong((long)this.VAL, (long)RHS.VAL));
        }
        int rhsBits = RHS.getActiveBits();
        int n = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
        assert (rhsWords != 0) : "Divided by zero???";
        int lhsBits = this.getActiveBits();
        int n2 = lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
        if (lhsWords == 0) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (Unsigned.$less_uint((int)lhsWords, (int)rhsWords) || this.ult(RHS)) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (this.$eq(RHS)) {
            return new APInt<T>(this.BitWidth, 1L);
        }
        if (lhsWords == 1 && rhsWords == 1) {
            return new APInt<T>(this.BitWidth, Unsigned.$div_ulong((long)this.pVal.$at(0), (long)RHS.pVal.$at(0)));
        }
        APInt<T> Quotient = new APInt<T>(1, 0L);
        APInt.divide(this, lhsWords, RHS, rhsWords, (APInt)Native.$AddrOf(Quotient), null);
        return Quotient;
    }

    public APInt sdiv(APInt RHS) {
        if (this.isNegative()) {
            if (RHS.isNegative()) {
                return this.$sub().udiv(RHS.$sub());
            }
            return this.$sub().udiv(RHS).$sub();
        }
        if (RHS.isNegative()) {
            return this.udiv(RHS.$sub()).$sub();
        }
        return this.udiv(RHS);
    }

    public APInt urem(APInt RHS) {
        int rhsWords;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (this.isSingleWord()) {
            assert (RHS.VAL != 0L) : "Remainder by zero?";
            return new APInt<T>(this.BitWidth, Unsigned.$rem_ulong((long)this.VAL, (long)RHS.VAL));
        }
        int lhsBits = this.getActiveBits();
        int lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
        int rhsBits = RHS.getActiveBits();
        int n = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
        assert (rhsWords != 0) : "Performing remainder operation by zero ???";
        if (lhsWords == 0) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (Unsigned.$less_uint((int)lhsWords, (int)rhsWords) || this.ult(RHS)) {
            return new APInt<T>(this);
        }
        if (this.$eq(RHS)) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (lhsWords == 1) {
            return new APInt<T>(this.BitWidth, Unsigned.$rem_ulong((long)this.pVal.$at(0), (long)RHS.pVal.$at(0)));
        }
        APInt<T> Remainder = new APInt<T>(1, 0L);
        APInt.divide(this, lhsWords, RHS, rhsWords, null, (APInt)Native.$AddrOf(Remainder));
        return Remainder;
    }

    public APInt srem(APInt RHS) {
        if (this.isNegative()) {
            if (RHS.isNegative()) {
                return this.$sub().urem(RHS.$sub()).$sub();
            }
            return this.$sub().urem(RHS).$sub();
        }
        if (RHS.isNegative()) {
            return this.urem(RHS.$sub());
        }
        return this.urem(RHS);
    }

    public static void udivrem(APInt LHS, APInt RHS, APInt Quotient, APInt Remainder) {
        int rhsWords;
        assert (LHS.BitWidth == RHS.BitWidth) : "Bit widths must be the same";
        if (LHS.isSingleWord()) {
            assert (RHS.VAL != 0L) : "Divide by zero?";
            long QuotVal = Unsigned.$div_ulong((long)LHS.VAL, (long)RHS.VAL);
            long RemVal = Unsigned.$rem_ulong((long)LHS.VAL, (long)RHS.VAL);
            Quotient.$assignMove(new APInt(LHS.BitWidth, QuotVal));
            Remainder.$assignMove(new APInt(LHS.BitWidth, RemVal));
            return;
        }
        int lhsBits = LHS.getActiveBits();
        int lhsWords = lhsBits == 0 ? 0 : APInt.whichWord(lhsBits - 1) + 1;
        int rhsBits = RHS.getActiveBits();
        int n = rhsWords = rhsBits == 0 ? 0 : APInt.whichWord(rhsBits - 1) + 1;
        if (lhsWords == 0) {
            Quotient.$assign(0L);
            Remainder.$assign(0L);
            return;
        }
        if (Unsigned.$less_uint((int)lhsWords, (int)rhsWords) || LHS.ult(RHS)) {
            Remainder.$assign(LHS);
            Quotient.$assign(0L);
            return;
        }
        if (LHS.$eq(RHS)) {
            Quotient.$assign(1L);
            Remainder.$assign(0L);
            return;
        }
        if (lhsWords == 1 && rhsWords == 1) {
            long lhsValue = LHS.isSingleWord() ? LHS.VAL : LHS.pVal.$at(0);
            long rhsValue = RHS.isSingleWord() ? RHS.VAL : RHS.pVal.$at(0);
            Quotient.$assignMove(new APInt(LHS.getBitWidth(), Unsigned.$div_ulong((long)lhsValue, (long)rhsValue)));
            Remainder.$assignMove(new APInt(LHS.getBitWidth(), Unsigned.$rem_ulong((long)lhsValue, (long)rhsValue)));
            return;
        }
        APInt.divide(LHS, lhsWords, RHS, rhsWords, (APInt)Native.$AddrOf((Object)Quotient), (APInt)Native.$AddrOf((Object)Remainder));
    }

    public static void sdivrem(APInt LHS, APInt RHS, APInt Quotient, APInt Remainder) {
        if (LHS.isNegative()) {
            if (RHS.isNegative()) {
                APInt.udivrem(LHS.$sub(), RHS.$sub(), Quotient, Remainder);
            } else {
                APInt.udivrem(LHS.$sub(), RHS, Quotient, Remainder);
                Quotient.$assignMove(Quotient.$sub());
            }
            Remainder.$assignMove(Remainder.$sub());
        } else if (RHS.isNegative()) {
            APInt.udivrem(LHS, RHS.$sub(), Quotient, Remainder);
            Quotient.$assignMove(Quotient.$sub());
        } else {
            APInt.udivrem(LHS, RHS, Quotient, Remainder);
        }
    }

    public APInt sadd_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = (APInt)Native.$Deref((Object)this.$add(RHS));
        Overflow.$set(this.isNonNegative() == RHS.isNonNegative() && Res.isNonNegative() != this.isNonNegative());
        return Res;
    }

    public APInt uadd_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = (APInt)Native.$Deref((Object)this.$add(RHS));
        Overflow.$set(Res.ult(RHS));
        return Res;
    }

    public APInt ssub_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = (APInt)Native.$Deref((Object)this.$sub(RHS));
        Overflow.$set(this.isNonNegative() != RHS.isNonNegative() && Res.isNonNegative() != this.isNonNegative());
        return Res;
    }

    public APInt usub_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = (APInt)Native.$Deref((Object)this.$sub(RHS));
        Overflow.$set(Res.ugt(this));
        return Res;
    }

    public APInt sdiv_ov(APInt RHS, bool.ref Overflow) {
        Overflow.$set(this.isMinSignedValue() && RHS.isAllOnesValue());
        return this.sdiv(RHS);
    }

    public APInt smul_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = (APInt)Native.$Deref((Object)this.$star(RHS));
        if (this.$noteq(0L) && RHS.$noteq(0L)) {
            Overflow.$set(Res.sdiv(RHS).$noteq(this) || Res.sdiv(this).$noteq(RHS));
        } else {
            Overflow.$set(false);
        }
        return Res;
    }

    public APInt umul_ov(APInt RHS, bool.ref Overflow) {
        APInt Res = (APInt)Native.$Deref((Object)this.$star(RHS));
        if (this.$noteq(0L) && RHS.$noteq(0L)) {
            Overflow.$set(Res.udiv(RHS).$noteq(this) || Res.udiv(this).$noteq(RHS));
        } else {
            Overflow.$set(false);
        }
        return Res;
    }

    public APInt sshl_ov(APInt ShAmt, bool.ref Overflow) {
        Overflow.$set(ShAmt.uge(Unsigned.$uint2ulong((int)this.getBitWidth())));
        if (Overflow.$deref()) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        if (this.isNonNegative()) {
            Overflow.$set(ShAmt.uge(Unsigned.$uint2ulong((int)this.countLeadingZeros())));
        } else {
            Overflow.$set(ShAmt.uge(Unsigned.$uint2ulong((int)this.countLeadingOnes())));
        }
        return (APInt)Native.$Deref((Object)this.$out(ShAmt));
    }

    public APInt ushl_ov(APInt ShAmt, bool.ref Overflow) {
        Overflow.$set(ShAmt.uge(Unsigned.$uint2ulong((int)this.getBitWidth())));
        if (Overflow.$deref()) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        Overflow.$set(ShAmt.ugt(Unsigned.$uint2ulong((int)this.countLeadingZeros())));
        return (APInt)Native.$Deref((Object)this.$out(ShAmt));
    }

    public boolean $at(int bitPosition) {
        assert (Unsigned.$less_uint((int)bitPosition, (int)this.getBitWidth())) : "Bit position out of bounds!";
        return (APInt.maskBit(bitPosition) & (this.isSingleWord() ? this.VAL : this.pVal.$at(APInt.whichWord(bitPosition)))) != 0L;
    }

    public boolean $eq(APInt RHS) {
        assert (this.BitWidth == RHS.BitWidth) : "Comparison requires equal bit widths";
        if (this.isSingleWord()) {
            return this.VAL == RHS.VAL;
        }
        return this.EqualSlowCase(RHS);
    }

    public boolean $eq(long Val) {
        if (this.isSingleWord()) {
            return this.VAL == Val;
        }
        return this.EqualSlowCase(Val);
    }

    public boolean eq(APInt RHS) {
        return this.$eq(RHS);
    }

    public boolean $noteq(APInt RHS) {
        return !this.$eq(RHS);
    }

    public boolean $noteq(long Val) {
        return !this.$eq(Val);
    }

    public boolean ne(APInt RHS) {
        return !this.$eq(RHS);
    }

    public boolean ult(APInt RHS) {
        int topWord;
        int n2;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be same for comparison";
        if (this.isSingleWord()) {
            return Unsigned.$less_ulong((long)this.VAL, (long)RHS.VAL);
        }
        int n1 = this.getActiveBits();
        if (Unsigned.$less_uint((int)n1, (int)(n2 = RHS.getActiveBits()))) {
            return true;
        }
        if (Unsigned.$less_uint((int)n2, (int)n1)) {
            return false;
        }
        if (Unsigned.$lesseq_uint_int((int)n1, (int)APINT_BITS_PER_WORD) && Unsigned.$lesseq_uint_int((int)n2, (int)APINT_BITS_PER_WORD)) {
            return Unsigned.$less_ulong((long)this.pVal.$at(0), (long)RHS.pVal.$at(0));
        }
        for (int i = topWord = APInt.whichWord(std.max((int)n1, (int)n2) - 1); i >= 0; --i) {
            if (Unsigned.$greater_ulong((long)this.pVal.$at(i), (long)RHS.pVal.$at(i))) {
                return false;
            }
            if (!Unsigned.$less_ulong((long)this.pVal.$at(i), (long)RHS.pVal.$at(i))) continue;
            return true;
        }
        return false;
    }

    public boolean ult(long RHS) {
        return Unsigned.$greater_uint((int)this.getActiveBits(), (int)64) ? false : Unsigned.$less_ulong((long)this.getZExtValue(), (long)RHS);
    }

    public boolean slt(APInt RHS) {
        boolean rhsNeg;
        assert (this.BitWidth == RHS.BitWidth) : "Bit widths must be same for comparison";
        if (this.isSingleWord()) {
            long rhsSext;
            long lhsSext = llvm.SignExtend64(this.VAL, this.BitWidth);
            return lhsSext < (rhsSext = llvm.SignExtend64(RHS.VAL, this.BitWidth));
        }
        boolean lhsNeg = this.isNegative();
        if (lhsNeg != (rhsNeg = RHS.isNegative())) {
            return lhsNeg;
        }
        return this.ult(RHS);
    }

    public boolean slt(long RHS) {
        return Unsigned.$greater_uint((int)this.getMinSignedBits(), (int)64) ? this.isNegative() : this.getSExtValue() < RHS;
    }

    public boolean ule(APInt RHS) {
        return this.ult(RHS) || this.eq(RHS);
    }

    public boolean ule(long RHS) {
        return !this.ugt(RHS);
    }

    public boolean sle(APInt RHS) {
        return this.slt(RHS) || this.eq(RHS);
    }

    public boolean sle(long RHS) {
        return !this.sgt(RHS);
    }

    public boolean ugt(APInt RHS) {
        return !this.ult(RHS) && !this.eq(RHS);
    }

    public boolean ugt(long RHS) {
        return Unsigned.$greater_uint((int)this.getActiveBits(), (int)64) ? true : Unsigned.$greater_ulong((long)this.getZExtValue(), (long)RHS);
    }

    public boolean sgt(APInt RHS) {
        return !this.slt(RHS) && !this.eq(RHS);
    }

    public boolean sgt(long RHS) {
        return Unsigned.$greater_uint((int)this.getMinSignedBits(), (int)64) ? !this.isNegative() : this.getSExtValue() > RHS;
    }

    public boolean uge(APInt RHS) {
        return !this.ult(RHS);
    }

    public boolean uge(long RHS) {
        return !this.ult(RHS);
    }

    public boolean sge(APInt RHS) {
        return !this.slt(RHS);
    }

    public boolean sge(long RHS) {
        return !this.slt(RHS);
    }

    public boolean intersects(APInt RHS) {
        return this.$bitand(RHS).$noteq(0L);
    }

    public APInt trunc(int width) {
        int i;
        assert (Unsigned.$less_uint((int)width, (int)this.BitWidth)) : "Invalid APInt Truncate request";
        assert (width != 0) : "Can't truncate to 0 bits";
        if (Unsigned.$lesseq_uint_int((int)width, (int)APINT_BITS_PER_WORD)) {
            return new APInt<T>(width, this.getRawData().$at(0));
        }
        APInt<T> Result = new APInt<T>(APIntStatics.getMemory(APInt.getNumWords(width)), width);
        for (i = 0; i != Unsigned.$div_uint_int((int)width, (int)APINT_BITS_PER_WORD); ++i) {
            Result.pVal.$set(i, this.pVal.$at(i));
        }
        int bits = Unsigned.$rem_uint_int((int)(0 - width), (int)APINT_BITS_PER_WORD);
        if (bits != 0) {
            Result.pVal.$set(i, this.pVal.$at(i) << bits >>> bits);
        }
        return Result;
    }

    public APInt sext(int width) {
        int i;
        assert (Unsigned.$greater_uint((int)width, (int)this.BitWidth)) : "Invalid APInt SignExtend request";
        if (Unsigned.$lesseq_uint_int((int)width, (int)APINT_BITS_PER_WORD)) {
            long val = this.VAL << APINT_BITS_PER_WORD - this.BitWidth;
            return new APInt<T>(width, (val >>= width - this.BitWidth) >>> APINT_BITS_PER_WORD - width);
        }
        APInt<T> Result = new APInt<T>(APIntStatics.getMemory(APInt.getNumWords(width)), width);
        long word = 0L;
        for (i = 0; i != Unsigned.$div_uint_int((int)this.BitWidth, (int)APINT_BITS_PER_WORD); ++i) {
            word = this.getRawData().$at(i);
            Result.pVal.$set(i, word);
        }
        int bits = Unsigned.$rem_uint_int((int)(0 - this.BitWidth), (int)APINT_BITS_PER_WORD);
        word = bits != 0 ? this.getRawData().$at(i) << bits >> bits : (word >>= APINT_BITS_PER_WORD - 1);
        while (i != Unsigned.$div_uint_int((int)width, (int)APINT_BITS_PER_WORD)) {
            Result.pVal.$set(i, word);
            word >>= APINT_BITS_PER_WORD - 1;
            ++i;
        }
        bits = Unsigned.$rem_uint_int((int)(0 - width), (int)APINT_BITS_PER_WORD);
        if (bits != 0) {
            Result.pVal.$set(i, word << bits >>> bits);
        }
        return Result;
    }

    public APInt zext(int width) {
        int i;
        assert (Unsigned.$greater_uint((int)width, (int)this.BitWidth)) : "Invalid APInt ZeroExtend request";
        if (Unsigned.$lesseq_uint_int((int)width, (int)APINT_BITS_PER_WORD)) {
            return new APInt<T>(width, this.VAL);
        }
        APInt<T> Result = new APInt<T>(APIntStatics.getMemory(APInt.getNumWords(width)), width);
        for (i = 0; i != this.getNumWords(); ++i) {
            Result.pVal.$set(i, this.getRawData().$at(i));
        }
        std.memset((ulong.ptr)((ulong.ptr)Result.pVal.$add(i)), (long)0L, (int)((Result.getNumWords() - i) * APINT_WORD_SIZE));
        return Result;
    }

    public APInt sextOrTrunc(int width) {
        if (Unsigned.$less_uint((int)this.BitWidth, (int)width)) {
            return this.sext(width);
        }
        if (Unsigned.$greater_uint((int)this.BitWidth, (int)width)) {
            return this.trunc(width);
        }
        return new APInt<T>(this);
    }

    public APInt zextOrTrunc(int width) {
        if (Unsigned.$less_uint((int)this.BitWidth, (int)width)) {
            return this.zext(width);
        }
        if (Unsigned.$greater_uint((int)this.BitWidth, (int)width)) {
            return this.trunc(width);
        }
        return new APInt<T>(this);
    }

    public APInt sextOrSelf(int width) {
        if (Unsigned.$less_uint((int)this.BitWidth, (int)width)) {
            return this.sext(width);
        }
        return new APInt<T>(this);
    }

    public APInt zextOrSelf(int width) {
        if (Unsigned.$less_uint((int)this.BitWidth, (int)width)) {
            return this.zext(width);
        }
        return new APInt<T>(this);
    }

    public void setAllBits() {
        if (this.isSingleWord()) {
            this.VAL = -1L;
        } else {
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
                this.pVal.$set(i, -1L);
                ++i;
            }
        }
        this.clearUnusedBits();
    }

    public void setBit(int bitPosition) {
        if (this.isSingleWord()) {
            this.VAL |= APInt.maskBit(bitPosition);
        } else {
            this.pVal.$set$orassign(APInt.whichWord(bitPosition), APInt.maskBit(bitPosition));
        }
    }

    public void clearAllBits() {
        if (this.isSingleWord()) {
            this.VAL = 0L;
        } else {
            std.memset((ulong.ptr)this.pVal, (long)0L, (int)(this.getNumWords() * APINT_WORD_SIZE));
        }
    }

    public void clearBit(int bitPosition) {
        if (this.isSingleWord()) {
            this.VAL &= APInt.maskBit(bitPosition) ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.pVal.$set$andassign(APInt.whichWord(bitPosition), APInt.maskBit(bitPosition) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void flipAllBits() {
        if (this.isSingleWord()) {
            this.VAL ^= 0xFFFFFFFFFFFFFFFFL;
        } else {
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
                this.pVal.$set$xorassign(i, -1L);
                ++i;
            }
        }
        this.clearUnusedBits();
    }

    public void flipBit(int bitPosition) {
        assert (Unsigned.$less_uint((int)bitPosition, (int)this.BitWidth)) : "Out of the bit-width range!";
        if (this.$at(bitPosition)) {
            this.clearBit(bitPosition);
        } else {
            this.setBit(bitPosition);
        }
    }

    public int getBitWidth() {
        return this.BitWidth;
    }

    public int getNumWords() {
        return APInt.getNumWords(this.BitWidth);
    }

    public static int getNumWords(int BitWidth) {
        return Unsigned.$ullong2uint((long)Unsigned.$div_ullong_int((long)(Unsigned.$uint2ulong((int)BitWidth) + Unsigned.$uint2ullong((int)APINT_BITS_PER_WORD) - 1L), (int)APINT_BITS_PER_WORD));
    }

    public int getActiveBits() {
        return this.BitWidth - this.countLeadingZeros();
    }

    public int getActiveWords() {
        int numActiveBits = this.getActiveBits();
        return numActiveBits != 0 ? APInt.whichWord(numActiveBits - 1) + 1 : 1;
    }

    public int getMinSignedBits() {
        if (this.isNegative()) {
            return this.BitWidth - this.countLeadingOnes() + 1;
        }
        return this.getActiveBits() + 1;
    }

    public long getZExtValue() {
        if (this.isSingleWord()) {
            return this.VAL;
        }
        assert (Unsigned.$lesseq_uint((int)this.getActiveBits(), (int)64)) : "Too many bits for uint64_t";
        return this.pVal.$at(0);
    }

    public long getSExtValue() {
        if (this.isSingleWord()) {
            return this.VAL << APINT_BITS_PER_WORD - this.BitWidth >> APINT_BITS_PER_WORD - this.BitWidth;
        }
        assert (Unsigned.$lesseq_uint((int)this.getMinSignedBits(), (int)64)) : "Too many bits for int64_t";
        return this.pVal.$at(0);
    }

    public static int getBitsNeeded(String str, int radix) {
        return APInt.getBitsNeeded(new StringRef(str), Unsigned.$uint2char((int)radix));
    }

    public static int getBitsNeeded(StringRef str, byte radix) {
        return APInt.getBitsNeededImpl(str, radix);
    }

    private static int getBitsNeededImpl(StringRef str, byte radix) {
        int isNegative;
        assert (!str.empty()) : "Invalid string length";
        assert (Unsigned.$uchar2int((byte)radix) == 10 || Unsigned.$uchar2int((byte)radix) == 8 || Unsigned.$uchar2int((byte)radix) == 16 || Unsigned.$uchar2int((byte)radix) == 2 || Unsigned.$uchar2int((byte)radix) == 36) : "Radix should be 2, 8, 10, 16, or 36!";
        int slen = str.size();
        char.ptr p = Native.$tryClone((char.ptr)str.begin());
        int n = isNegative = p.$star() == 45 ? 1 : 0;
        if (p.$star() == 45 || p.$star() == 43) {
            p.$postInc();
            assert (--slen != 0) : "String is only a sign, needs a value.";
        }
        if (Unsigned.$uchar2int((byte)radix) == 2) {
            return slen + isNegative;
        }
        if (Unsigned.$uchar2int((byte)radix) == 8) {
            return slen * 3 + isNegative;
        }
        if (Unsigned.$uchar2int((byte)radix) == 16) {
            return slen * 4 + isNegative;
        }
        int sufficient = Unsigned.$uchar2int((byte)radix) == 10 ? (slen == 1 ? 4 : Unsigned.$div_uint((int)(slen * 64), (int)18)) : (slen == 1 ? 7 : Unsigned.$div_uint((int)(slen * 16), (int)3));
        APInt tmp = new APInt(sufficient, new StringRef(p, slen), radix);
        int log = tmp.logBase2();
        if (log == -1) {
            return isNegative + 1;
        }
        return isNegative + log + 1;
    }

    public int countLeadingZeros() {
        if (this.isSingleWord()) {
            int unusedBits = APINT_BITS_PER_WORD - this.BitWidth;
            return llvm.countLeadingZeros(this.VAL) - unusedBits;
        }
        return this.countLeadingZerosSlowCase();
    }

    public int countLeadingOnes() {
        int shift;
        if (this.isSingleWord()) {
            return llvm.CountLeadingOnes_64(this.VAL << APINT_BITS_PER_WORD - this.BitWidth);
        }
        int highWordBits = Unsigned.$rem_uint_int((int)this.BitWidth, (int)APINT_BITS_PER_WORD);
        if (highWordBits == 0) {
            highWordBits = APINT_BITS_PER_WORD;
            shift = 0;
        } else {
            shift = APINT_BITS_PER_WORD - highWordBits;
        }
        int i = this.getNumWords() - 1;
        int Count = llvm.CountLeadingOnes_64(this.pVal.$at(i) << shift);
        if (Count == highWordBits) {
            --i;
            while (i >= 0) {
                if (this.pVal.$at(i) == -1L) {
                    Count += APINT_BITS_PER_WORD;
                } else {
                    Count += llvm.CountLeadingOnes_64(this.pVal.$at(i));
                    break;
                }
                --i;
            }
        }
        return Count;
    }

    public int getNumSignBits() {
        return this.isNegative() ? this.countLeadingOnes() : this.countLeadingZeros();
    }

    public int countTrailingZeros() {
        if (this.isSingleWord()) {
            return std.min_uint((int)llvm.countTrailingZeros_uint64_t_ZeroBehavior(this.VAL), (int)this.BitWidth);
        }
        int Count = 0;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)this.getNumWords()) && this.pVal.$at(i) == 0L) {
            Count += APINT_BITS_PER_WORD;
            ++i;
        }
        if (Unsigned.$less_uint((int)i, (int)this.getNumWords())) {
            Count += llvm.countTrailingZeros_uint64_t_ZeroBehavior(this.pVal.$at(i));
        }
        return std.min_uint((int)Count, (int)this.BitWidth);
    }

    public int countTrailingOnes() {
        if (this.isSingleWord()) {
            return llvm.CountTrailingOnes_64(this.VAL);
        }
        return this.countTrailingOnesSlowCase();
    }

    public int countPopulation() {
        if (this.isSingleWord()) {
            return llvm.CountPopulation_64(this.VAL);
        }
        return this.countPopulationSlowCase();
    }

    public void print(raw_ostream OS, boolean isSigned) {
        SmallString S2 = new SmallString(40);
        this.__toString(S2, 10, isSigned, false);
        OS.$out(S2);
    }

    public void __toString(SmallString Str, int Radix, boolean Signed) {
        this.__toString(Str, Radix, Signed, false);
    }

    public void __toString(SmallString Str, int Radix, boolean Signed, boolean formatAsCLiteral) {
        assert (Radix == 10 || Radix == 8 || Radix == 16 || Radix == 2 || Radix == 36) : "Radix should be 2, 8, 10, 16, or 36!";
        char.ptr Prefix = NativePointer.$EMPTY;
        if (formatAsCLiteral) {
            switch (Radix) {
                case 2: {
                    Prefix = Native.$tryClone((char.ptr)NativePointer.$((String)"0b"));
                    break;
                }
                case 8: {
                    Prefix = Native.$tryClone((char.ptr)NativePointer.$0);
                    break;
                }
                case 10: {
                    break;
                }
                case 16: {
                    Prefix = Native.$tryClone((char.ptr)NativePointer.$((String)"0x"));
                    break;
                }
                default: {
                    throw new llvm_unreachable("Invalid radix!");
                }
            }
        }
        if (this.$eq(0L)) {
            while (Prefix.$star() != 0) {
                Str.push_back(Prefix.$star());
                Prefix.$preInc();
            }
            Str.push_back((byte)48);
            return;
        }
        byte[] Digits = APInt$__toString$$.Digits;
        if (this.isSingleWord()) {
            long N;
            char.ptr Buffer = NativePointer.create_char$ptr((byte[])NativePointer.new$char((int)65, (byte[])new byte[0]));
            char.ptr BufPtr = (char.ptr)Buffer.$add(65);
            if (!Signed) {
                N = this.getZExtValue();
            } else {
                long I = this.getSExtValue();
                if (I >= 0L) {
                    N = I;
                } else {
                    Str.push_back((byte)45);
                    N = -I;
                }
            }
            while (Prefix.$star() != 0) {
                Str.push_back(Prefix.$star());
                Prefix.$preInc();
            }
            while (N != 0L) {
                long Digit = Unsigned.$rem_ulong_uint((long)N, (int)Radix);
                ((char.ptr)BufPtr.$preDec()).$set(Digits[(int)Digit]);
                N = Unsigned.$div_ulong_uint((long)N, (int)Radix);
            }
            Str.append(BufPtr, 65 - BufPtr.$index());
            return;
        }
        APInt<T> Tmp = new APInt<T>(this);
        if (Signed && this.isNegative()) {
            Tmp.flipAllBits();
            Tmp.$preInc();
            Str.push_back((byte)45);
        }
        while (Prefix.$star() != 0) {
            Str.push_back(Prefix.$star());
            Prefix.$preInc();
        }
        int StartDig = Str.size();
        if (Radix == 2 || Radix == 8 || Radix == 16) {
            int ShiftAmt = Radix == 16 ? 4 : (Radix == 8 ? 3 : 1);
            int MaskAmt = Radix - 1;
            while (Tmp.$noteq(0L)) {
                int Digit = (int)Tmp.getRawData().$at(0) & MaskAmt;
                Str.push_back(Digits[Digit]);
                Tmp.$assignMove(Tmp.lshr(ShiftAmt));
            }
        } else {
            APInt<T> divisor = new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, Radix == 10 ? 4 : 8, Unsigned.$uint2ulong((int)Radix));
            while (Tmp.$noteq(0L)) {
                APInt<T> APdigit = new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, 1, 0L);
                APInt<T> tmp2 = new APInt<T>(JavaDifferentiators.JD.UInt_ULong.INSTANCE, Tmp.getBitWidth(), 0L);
                APInt.divide(Tmp, Tmp.getNumWords(), divisor, divisor.getNumWords(), (APInt)Native.$AddrOf(tmp2), (APInt)Native.$AddrOf(APdigit));
                int Digit = Unsigned.$ulong2uint((long)APdigit.getZExtValue());
                assert (Unsigned.$less_uint((int)Digit, (int)Radix)) : "divide failed";
                Str.push_back(Digits[Digit]);
                Tmp.$assign(tmp2);
            }
        }
        std.reverse((char.ptr)((char.ptr)Str.begin().$add(StartDig)), (char.ptr)Str.end());
    }

    public void toStringUnsigned(SmallString Str) {
        this.toStringUnsigned(Str, 10);
    }

    public void toStringUnsigned(SmallString Str, int Radix) {
        this.__toString(Str, Radix, false, false);
    }

    public void toStringSigned(SmallString Str) {
        this.toStringSigned(Str, 10);
    }

    public void toStringSigned(SmallString Str, int Radix) {
        this.__toString(Str, Radix, true, false);
    }

    public std.string __toString() {
        return this.__toString(10, true);
    }

    public std.string __toString(int Radix) {
        return this.__toString(Radix, true);
    }

    public std.string __toString(int Radix, boolean Signed) {
        SmallString S2 = new SmallString(40);
        this.__toString(S2, Radix, Signed, false);
        return S2.str().$string();
    }

    public APInt byteSwap() {
        assert (Unsigned.$greatereq_uint((int)this.BitWidth, (int)16) && Unsigned.$rem_uint((int)this.BitWidth, (int)16) == 0) : "Cannot byteswap!";
        if (this.BitWidth == 16) {
            return new APInt<T>(this.BitWidth, Unsigned.$ushort2ulong((char)llvm.ByteSwap_16(Unsigned.$ulong2ushort((long)this.VAL))));
        }
        if (this.BitWidth == 32) {
            return new APInt<T>(this.BitWidth, Unsigned.$uint2ulong((int)llvm.ByteSwap_32(Unsigned.$ulong2uint((long)this.VAL))));
        }
        if (this.BitWidth == 48) {
            int Tmp1 = Unsigned.$ulong2uint((long)(this.VAL >>> 16));
            Tmp1 = llvm.ByteSwap_32(Tmp1);
            char Tmp2 = Unsigned.$ulong2ushort((long)this.VAL);
            Tmp2 = llvm.ByteSwap_16(Tmp2);
            return new APInt<T>(this.BitWidth, Unsigned.$ushort2ulong((char)Tmp2) << 32 | Unsigned.$uint2ullong((int)Tmp1));
        }
        if (this.BitWidth == 64) {
            return new APInt<T>(this.BitWidth, llvm.ByteSwap_64(this.VAL));
        }
        APInt<T> Result = new APInt<T>(this.getNumWords() * APINT_BITS_PER_WORD, 0L);
        int N = this.getNumWords();
        for (int I = 0; I != N; ++I) {
            Result.pVal.$set(I, llvm.ByteSwap_64(this.pVal.$at(N - I - 1)));
        }
        if (Result.BitWidth != this.BitWidth) {
            APIntStatics.lshrNear(Result.pVal, Result.pVal, this.getNumWords(), Result.BitWidth - this.BitWidth);
            Result.BitWidth = this.BitWidth;
        }
        return Result;
    }

    public APInt reverseBits() {
        throw new UnsupportedOperationException("EmptyBody");
    }

    public double roundToDouble(boolean isSigned) {
        long mantissa;
        if (this.isSingleWord() || Unsigned.$lesseq_uint_int((int)this.getActiveBits(), (int)APINT_BITS_PER_WORD)) {
            if (isSigned) {
                long sext = llvm.SignExtend64(this.getWord(0), this.BitWidth);
                return sext;
            }
            return this.getWord(0);
        }
        boolean isNeg = isSigned ? this.$at(this.BitWidth - 1) : false;
        APInt<T> Tmp = isNeg ? this.$sub() : new APInt<T>(this);
        int n = Tmp.getActiveBits();
        long exp = Unsigned.$uint2ulong((int)n);
        if (Unsigned.$greater_ulong_ullong((long)exp, (long)1023L)) {
            if (!isSigned || !isNeg) {
                return std.numeric_limitsDouble.infinity();
            }
            return -std.numeric_limitsDouble.infinity();
        }
        exp += 1023L;
        int hiWord = APInt.whichWord(n - 1);
        if (hiWord == 0) {
            mantissa = Tmp.pVal.$at(0);
            if (Unsigned.$greater_uint((int)n, (int)52)) {
                mantissa >>>= n - 52;
            }
        } else {
            assert (Unsigned.$greater_uint((int)hiWord, (int)0)) : "huh?";
            long hibits = Tmp.pVal.$at(hiWord) << 52 - Unsigned.$rem_uint_int((int)n, (int)APINT_BITS_PER_WORD);
            long lobits = Tmp.pVal.$at(hiWord - 1) >>> 11 + Unsigned.$rem_uint_int((int)n, (int)APINT_BITS_PER_WORD);
            mantissa = hibits | lobits;
        }
        long sign = isNeg ? 1L << APINT_BITS_PER_WORD - 1 : 0L;
        class Unnamed_union {
            public double D;
            public long I;

            public String toString() {
                return "D=" + this.D + ", I=" + this.I;
            }
        }
        Unnamed_union T2 = new Unnamed_union();
        T2.I = sign | exp << 52 | mantissa;
        return T2.D;
    }

    public double roundToDouble() {
        return this.roundToDouble(false);
    }

    public double signedRoundToDouble() {
        return this.roundToDouble(true);
    }

    public double bitsToDouble() {
        long I = this.isSingleWord() ? this.VAL : this.pVal.$at(0);
        double D = Double.longBitsToDouble(I);
        return D;
    }

    public float bitsToFloat() {
        int I = Unsigned.$ulong2uint((long)(this.isSingleWord() ? this.VAL : this.pVal.$at(0)));
        float F = Float.intBitsToFloat(I);
        return F;
    }

    public static APInt doubleToBits(double V) {
        long I = Double.doubleToRawLongBits(V);
        return new APInt(NativeType.sizeof(Double.TYPE) * 8, I);
    }

    public static APInt floatToBits(float V) {
        int I = Float.floatToRawIntBits(V);
        return new APInt(NativeType.sizeof(Float.TYPE) * 8, Unsigned.$uint2ulong((int)I));
    }

    public int logBase2() {
        return this.BitWidth - 1 - this.countLeadingZeros();
    }

    public int ceilLogBase2() {
        return this.BitWidth - this.$sub(1L).countLeadingZeros();
    }

    public int nearestLogBase2() {
        int lg;
        if (this.BitWidth == 1) {
            return (int)(this.VAL - 1L);
        }
        if (!this.getBoolValue()) {
            return -1;
        }
        return lg + (this.$at((lg = this.logBase2()) - 1) ? 1 : 0);
    }

    public int exactLogBase2() {
        if (!this.isPowerOf2()) {
            return -1;
        }
        return this.logBase2();
    }

    public APInt sqrt() {
        int magnitude = this.getActiveBits();
        if (Unsigned.$lesseq_uint((int)magnitude, (int)5)) {
            byte[] results = APInt$sqrt$$.results;
            return new APInt<T>(this.BitWidth, Unsigned.$uchar2ulong((byte)results[(int)(this.isSingleWord() ? this.VAL : this.pVal.$at(0))]));
        }
        if (Unsigned.$less_uint((int)magnitude, (int)52)) {
            return new APInt<T>(this.BitWidth, (long)std.round((double)std.sqrt((double)(this.isSingleWord() ? this.VAL : this.pVal.$at(0)))));
        }
        int nbits = this.BitWidth;
        int i = 4;
        APInt<T> testy = new APInt<T>(this.BitWidth, 16L);
        APInt<T> x_old = new APInt<T>(this.BitWidth, 1L);
        APInt<T> x_new = new APInt<T>(this.BitWidth, 0L);
        APInt<T> two = new APInt<T>(this.BitWidth, 2L);
        while (true) {
            if (Unsigned.$greatereq_uint((int)i, (int)nbits) || this.ule(testy)) break;
            i += 2;
            testy.$assignMove(testy.shl(2));
        }
        x_old.$assignMove(x_old.shl(Unsigned.$div_uint((int)i, (int)2)));
        while (true) {
            x_new.$assignMove(this.udiv(x_old).$add(x_old).udiv(two));
            if (x_old.ule(x_new)) break;
            x_old.$assign(x_new);
        }
        APInt square = x_old.$star(x_old);
        APInt nextSquare = x_old.$add(1L).$star(x_old.$add(1L));
        if (this.ult(square)) {
            return x_old;
        }
        assert (this.ule(nextSquare)) : "Error in APInt::sqrt computation";
        APInt midpoint = nextSquare.$sub(square).udiv(two);
        APInt offset = (APInt)Native.$Deref((Object)this.$sub(square));
        if (offset.ult(midpoint)) {
            return x_old;
        }
        return x_old.$add(1L);
    }

    public APInt abs() {
        if (this.isNegative()) {
            return this.$sub();
        }
        return new APInt<T>(this);
    }

    public APInt multiplicativeInverse(APInt modulo) {
        assert (this.ult(modulo)) : "This APInt must be smaller than the modulo";
        APInt[] r = new APInt[]{modulo, this};
        APInt[] t = new APInt[]{new APInt<T>(this.BitWidth, 0L), new APInt<T>(this.BitWidth, 1L)};
        APInt<T> q = new APInt<T>(this.BitWidth, 0L);
        int i = 0;
        while (r[i ^ 1].$noteq(0L)) {
            APInt.udivrem(r[i], r[i ^ 1], q, r[i]);
            t[i].$minusassign(t[i ^ 1].$star(q));
            i ^= 1;
        }
        if (r[i].$noteq(1L)) {
            return new APInt<T>(this.BitWidth, 0L);
        }
        return t[i].isNegative() ? t[i].$add(modulo) : new APInt<T>(t[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ms magic() {
        ms mag = null;
        try {
            APInt d = this;
            APInt<T> ad = new APInt<T>();
            APInt<T> anc = new APInt<T>();
            APInt<T> delta = new APInt<T>();
            APInt<T> q1 = new APInt<T>();
            APInt<T> r1 = new APInt<T>();
            APInt<T> q2 = new APInt<T>();
            APInt<T> r2 = new APInt<T>();
            APInt<T> t = new APInt<T>();
            APInt signedMin = APInt.getSignedMinValue(d.getBitWidth());
            mag = new ms();
            ad.$assignMove(d.abs());
            t.$assignMove(signedMin.$add(d.lshr(d.getBitWidth() - 1)));
            anc.$assignMove(t.$sub(1L).$sub(t.urem(ad)));
            int p = d.getBitWidth() - 1;
            q1.$assignMove(signedMin.udiv(anc));
            r1.$assignMove(signedMin.$sub(q1.$star(anc)));
            q2.$assignMove(signedMin.udiv(ad));
            r2.$assignMove(signedMin.$sub(q2.$star(ad)));
            do {
                ++p;
                q1.$assignMove(q1.$out(1));
                r1.$assignMove(r1.$out(1));
                if (r1.uge(anc)) {
                    q1.$assignMove(q1.$add(1L));
                    r1.$assignMove(r1.$sub(anc));
                }
                q2.$assignMove(q2.$out(1));
                r2.$assignMove(r2.$out(1));
                if (r2.uge(ad)) {
                    q2.$assignMove(q2.$add(1L));
                    r2.$assignMove(r2.$sub(ad));
                }
                delta.$assignMove(ad.$sub(r2));
            } while (q1.ult(delta) || q1.$eq(delta) && r1.$eq(0L));
            mag.m.$assignMove(q2.$add(1L));
            if (d.isNegative()) {
                mag.m.$assignMove(mag.m.$sub());
            }
            mag.s = p - d.getBitWidth();
            ms ms2 = new ms(JavaDifferentiators.JD.Move.INSTANCE, mag);
            return ms2;
        }
        finally {
            if (mag != null) {
                mag.$destroy();
            }
        }
    }

    public mu magicu() {
        return this.magicu(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public mu magicu(int LeadingZeros) {
        mu magu = null;
        try {
            APInt d = this;
            APInt<T> nc = new APInt<T>();
            APInt<T> delta = new APInt<T>();
            APInt<T> q1 = new APInt<T>();
            APInt<T> r1 = new APInt<T>();
            APInt<T> q2 = new APInt<T>();
            APInt<T> r2 = new APInt<T>();
            magu = new mu();
            magu.a = false;
            APInt allOnes = APInt.getAllOnesValue(d.getBitWidth()).lshr(LeadingZeros);
            APInt signedMin = APInt.getSignedMinValue(d.getBitWidth());
            APInt signedMax = APInt.getSignedMaxValue(d.getBitWidth());
            nc.$assignMove(allOnes.$sub(allOnes.$sub(d).urem(d)));
            int p = d.getBitWidth() - 1;
            q1.$assignMove(signedMin.udiv(nc));
            r1.$assignMove(signedMin.$sub(q1.$star(nc)));
            q2.$assignMove(signedMax.udiv(d));
            r2.$assignMove(signedMax.$sub(q2.$star(d)));
            do {
                ++p;
                if (r1.uge(nc.$sub(r1))) {
                    q1.$assignMove(q1.$add(q1).$add(1L));
                    r1.$assignMove(r1.$add(r1).$sub(nc));
                } else {
                    q1.$assignMove(q1.$add(q1));
                    r1.$assignMove(r1.$add(r1));
                }
                if (r2.$add(1L).uge(d.$sub(r2))) {
                    if (q2.uge(signedMax)) {
                        magu.a = true;
                    }
                    q2.$assignMove(q2.$add(q2).$add(1L));
                    r2.$assignMove(r2.$add(r2).$add(1L).$sub(d));
                } else {
                    if (q2.uge(signedMin)) {
                        magu.a = true;
                    }
                    q2.$assignMove(q2.$add(q2));
                    r2.$assignMove(r2.$add(r2).$add(1L));
                }
                delta.$assignMove(d.$sub(1L).$sub(r2));
            } while (Unsigned.$less_uint((int)p, (int)(d.getBitWidth() * 2)) && (q1.ult(delta) || q1.$eq(delta) && r1.$eq(0L)));
            magu.m.$assignMove(q2.$add(1L));
            magu.s = p - d.getBitWidth();
            mu mu2 = new mu(JavaDifferentiators.JD.Move.INSTANCE, magu);
            return mu2;
        }
        finally {
            if (magu != null) {
                magu.$destroy();
            }
        }
    }

    public static void tcSet(ulong.ptr dst, long part, int parts) {
        assert (Unsigned.$greater_uint((int)parts, (int)0));
        dst.$set(0, part);
        int i = 1;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set(i, 0L);
            ++i;
        }
    }

    public static void tcAssign(ulong.ptr dst, ulong.ptr src, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set(i, src.$at(i));
            ++i;
        }
    }

    public static boolean tcIsZero(ulong.ptr src, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            if (src.$at(i) != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int tcExtractBit(ulong.ptr parts, int bit) {
        return (parts.$at(Unsigned.$div_uint((int)bit, (int)llvm.integerPartWidth)) & 1L << Unsigned.$rem_uint((int)bit, (int)llvm.integerPartWidth)) != 0L ? 1 : 0;
    }

    public static void tcExtract(ulong.ptr dst, int dstCount, ulong.ptr src, int srcBits, int srcLSB) {
        int dstParts = Unsigned.$div_uint((int)(srcBits + llvm.integerPartWidth - 1), (int)llvm.integerPartWidth);
        assert (Unsigned.$lesseq_uint((int)dstParts, (int)dstCount));
        int firstSrcPart = Unsigned.$div_uint((int)srcLSB, (int)llvm.integerPartWidth);
        APInt.tcAssign(dst, (ulong.ptr)src.$add(firstSrcPart), dstParts);
        int shift = Unsigned.$rem_uint((int)srcLSB, (int)llvm.integerPartWidth);
        APInt.tcShiftRight(dst, dstParts, shift);
        int n = dstParts * llvm.integerPartWidth - shift;
        if (Unsigned.$less_uint((int)n, (int)srcBits)) {
            long mask = APIntStatics.lowBitMask(srcBits - n);
            dst.$set$orassign(dstParts - 1, (src.$at(firstSrcPart + dstParts) & mask) << Unsigned.$rem_uint((int)n, (int)llvm.integerPartWidth));
        } else if (Unsigned.$greater_uint((int)n, (int)srcBits) && Unsigned.$rem_uint((int)srcBits, (int)llvm.integerPartWidth) != 0) {
            dst.$set$andassign(dstParts - 1, APIntStatics.lowBitMask(Unsigned.$rem_uint((int)srcBits, (int)llvm.integerPartWidth)));
        }
        while (Unsigned.$less_uint((int)dstParts, (int)dstCount)) {
            dst.$set(dstParts++, 0L);
        }
    }

    public static void tcSetBit(ulong.ptr parts, int bit) {
        parts.$set$orassign(Unsigned.$div_uint((int)bit, (int)llvm.integerPartWidth), 1L << Unsigned.$rem_uint((int)bit, (int)llvm.integerPartWidth));
    }

    public static void tcClearBit(ulong.ptr parts, int bit) {
        parts.$set$andassign(Unsigned.$div_uint((int)bit, (int)llvm.integerPartWidth), 1L << Unsigned.$rem_uint((int)bit, (int)llvm.integerPartWidth) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int tcLSB(ulong.ptr parts, int n) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)n)) {
            if (parts.$at(i) != 0L) {
                int lsb = APIntStatics.partLSB(parts.$at(i));
                return lsb + i * llvm.integerPartWidth;
            }
            ++i;
        }
        return -1;
    }

    public static int tcMSB(ulong.ptr parts, int n) {
        do {
            if (parts.$at(--n) == 0L) continue;
            int msb = APIntStatics.partMSB(parts.$at(n));
            return msb + n * llvm.integerPartWidth;
        } while (n != 0);
        return -1;
    }

    public static void tcNegate(ulong.ptr dst, int parts) {
        APInt.tcComplement(dst, parts);
        APInt.tcIncrement(dst, parts);
    }

    public static long tcAdd(ulong.ptr dst, ulong.ptr rhs, long c, int parts) {
        assert (Unsigned.$lesseq_ulong_ullong((long)c, (long)1L));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            long l = dst.$at(i);
            if (c != 0L) {
                dst.$set$addassign(i, rhs.$at(i) + 1L);
                c = Unsigned.$lesseq_ulong((long)dst.$at(i), (long)l) ? 1 : 0;
            } else {
                dst.$set$addassign(i, rhs.$at(i));
                c = Unsigned.$less_ulong((long)dst.$at(i), (long)l) ? 1 : 0;
            }
            ++i;
        }
        return c;
    }

    public static long tcSubtract(ulong.ptr dst, ulong.ptr rhs, long c, int parts) {
        assert (Unsigned.$lesseq_ulong_ullong((long)c, (long)1L));
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            long l = dst.$at(i);
            if (c != 0L) {
                dst.$set$minusassign(i, rhs.$at(i) + 1L);
                c = Unsigned.$greatereq_ulong((long)dst.$at(i), (long)l) ? 1 : 0;
            } else {
                dst.$set$minusassign(i, rhs.$at(i));
                c = Unsigned.$greater_ulong((long)dst.$at(i), (long)l) ? 1 : 0;
            }
            ++i;
        }
        return c;
    }

    public static int tcMultiplyPart(ulong.ptr dst, ulong.ptr src, long multiplier, long carry, int srcParts, int dstParts, boolean add) {
        assert (!dst.isComparableTo((void.ptr)src) || dst.$lesseq((Object)src) || dst.$greatereq((Object)src.$add(srcParts)));
        assert (Unsigned.$lesseq_uint((int)dstParts, (int)(srcParts + 1)));
        int n = Unsigned.$less_uint((int)dstParts, (int)srcParts) ? dstParts : srcParts;
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)n)) {
            long high;
            long low;
            long srcPart = src.$at(i);
            if (multiplier == 0L || srcPart == 0L) {
                low = carry;
                high = 0L;
            } else {
                low = APIntStatics.lowHalf(srcPart) * APIntStatics.lowHalf(multiplier);
                high = APIntStatics.highHalf(srcPart) * APIntStatics.highHalf(multiplier);
                long mid = APIntStatics.lowHalf(srcPart) * APIntStatics.highHalf(multiplier);
                high += APIntStatics.highHalf(mid);
                if (Unsigned.$less_ullong_ulong((long)(low + (mid <<= Unsigned.$div_uint((int)llvm.integerPartWidth, (int)2))), (long)low)) {
                    ++high;
                }
                low += mid;
                mid = APIntStatics.highHalf(srcPart) * APIntStatics.lowHalf(multiplier);
                high += APIntStatics.highHalf(mid);
                if (Unsigned.$less_ullong_ulong((long)(low + (mid <<= Unsigned.$div_uint((int)llvm.integerPartWidth, (int)2))), (long)low)) {
                    ++high;
                }
                if (Unsigned.$less_ullong_ulong((long)((low += mid) + carry), (long)low)) {
                    ++high;
                }
                low += carry;
            }
            if (add) {
                if (Unsigned.$less_ullong_ulong((long)(low + dst.$at(i)), (long)low)) {
                    // empty if block
                }
                dst.$set$addassign(i, low);
            } else {
                dst.$set(i, low);
            }
            carry = ++high;
            ++i;
        }
        if (Unsigned.$less_uint((int)i, (int)dstParts)) {
            assert (i + 1 == dstParts);
            dst.$set(i, carry);
            return 0;
        }
        if (carry != 0L) {
            return 1;
        }
        if (multiplier != 0L) {
            while (Unsigned.$less_uint((int)i, (int)srcParts)) {
                if (src.$at(i) != 0L) {
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static int tcMultiply(ulong.ptr dst, ulong.ptr lhs, ulong.ptr rhs, int parts) {
        assert (Native.$noteq_ptr((void.ptr)dst, (void.ptr)lhs) && Native.$noteq_ptr((void.ptr)dst, (void.ptr)rhs));
        int overflow = 0;
        APInt.tcSet(dst, 0L, parts);
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            overflow |= APInt.tcMultiplyPart((ulong.ptr)dst.$add(i), lhs, rhs.$at(i), 0L, parts, parts - i, true);
            ++i;
        }
        return overflow;
    }

    public static int tcFullMultiply(ulong.ptr dst, ulong.ptr lhs, ulong.ptr rhs, int lhsParts, int rhsParts) {
        if (Unsigned.$greater_uint((int)lhsParts, (int)rhsParts)) {
            return APInt.tcFullMultiply(dst, rhs, lhs, rhsParts, lhsParts);
        }
        assert (Native.$noteq_ptr((void.ptr)dst, (void.ptr)lhs) && Native.$noteq_ptr((void.ptr)dst, (void.ptr)rhs));
        APInt.tcSet(dst, 0L, rhsParts);
        int n = 0;
        while (Unsigned.$less_uint((int)n, (int)lhsParts)) {
            APInt.tcMultiplyPart((ulong.ptr)dst.$add(n), rhs, lhs.$at(n), 0L, rhsParts, rhsParts + 1, true);
            ++n;
        }
        return n - (dst.$at((n = lhsParts + rhsParts) - 1) == 0L ? 1 : 0);
    }

    public static int tcDivide(ulong.ptr lhs, ulong.ptr rhs, ulong.ptr remainder, ulong.ptr srhs, int parts) {
        assert (Native.$noteq_ptr((void.ptr)lhs, (void.ptr)remainder) && Native.$noteq_ptr((void.ptr)lhs, (void.ptr)srhs) && Native.$noteq_ptr((void.ptr)remainder, (void.ptr)srhs));
        int shiftCount = APInt.tcMSB(rhs, parts) + 1;
        if (shiftCount == 0) {
            return 1;
        }
        shiftCount = parts * llvm.integerPartWidth - shiftCount;
        int n = Unsigned.$div_uint((int)shiftCount, (int)llvm.integerPartWidth);
        long mask = 1L << Unsigned.$rem_uint((int)shiftCount, (int)llvm.integerPartWidth);
        APInt.tcAssign(srhs, rhs, parts);
        APInt.tcShiftLeft(srhs, parts, shiftCount);
        APInt.tcAssign(remainder, lhs, parts);
        APInt.tcSet(lhs, 0L, parts);
        while (true) {
            int compare;
            if ((compare = APInt.tcCompare(remainder, srhs, parts)) >= 0) {
                APInt.tcSubtract(remainder, srhs, 0L, parts);
                lhs.$set$orassign(n, mask);
            }
            if (shiftCount == 0) break;
            --shiftCount;
            APInt.tcShiftRight(srhs, parts, 1);
            if ((mask >>>= 1) != 0L) continue;
            mask = 1L << llvm.integerPartWidth - 1;
            --n;
        }
        return 0;
    }

    public static void tcShiftLeft(ulong.ptr dst, int parts, int count) {
        if (count != 0) {
            int jump = Unsigned.$div_uint((int)count, (int)llvm.integerPartWidth);
            int shift = Unsigned.$rem_uint((int)count, (int)llvm.integerPartWidth);
            while (Unsigned.$greater_uint((int)parts, (int)jump)) {
                long part = dst.$at(--parts - jump);
                if (shift != 0) {
                    part <<= shift;
                    if (Unsigned.$greatereq_uint((int)parts, (int)(jump + 1))) {
                        part |= dst.$at(parts - jump - 1) >>> llvm.integerPartWidth - shift;
                    }
                }
                dst.$set(parts, part);
            }
            while (Unsigned.$greater_uint((int)parts, (int)0)) {
                dst.$set(--parts, 0L);
            }
        }
    }

    public static void tcShiftRight(ulong.ptr dst, int parts, int count) {
        if (count != 0) {
            int jump = Unsigned.$div_uint((int)count, (int)llvm.integerPartWidth);
            int shift = Unsigned.$rem_uint((int)count, (int)llvm.integerPartWidth);
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)parts)) {
                long part;
                if (Unsigned.$greatereq_uint((int)(i + jump), (int)parts)) {
                    part = 0L;
                } else {
                    part = dst.$at(i + jump);
                    if (shift != 0) {
                        part >>>= shift;
                        if (Unsigned.$less_uint((int)(i + jump + 1), (int)parts)) {
                            part |= dst.$at(i + jump + 1) << llvm.integerPartWidth - shift;
                        }
                    }
                }
                dst.$set(i, part);
                ++i;
            }
        }
    }

    public static void tcAnd(ulong.ptr dst, ulong.ptr rhs, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set$andassign(i, rhs.$at(i));
            ++i;
        }
    }

    public static void tcOr(ulong.ptr dst, ulong.ptr rhs, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set$orassign(i, rhs.$at(i));
            ++i;
        }
    }

    public static void tcXor(ulong.ptr dst, ulong.ptr rhs, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set$xorassign(i, rhs.$at(i));
            ++i;
        }
    }

    public static void tcComplement(ulong.ptr dst, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set(i, dst.$at(i) ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
    }

    public static int tcCompare(ulong.ptr lhs, ulong.ptr rhs, int parts) {
        while (parts != 0) {
            if (lhs.$at(--parts) == rhs.$at(parts)) continue;
            if (Unsigned.$greater_ulong((long)lhs.$at(parts), (long)rhs.$at(parts))) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public static long tcIncrement(ulong.ptr dst, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts) && dst.$set$preInc(i) == 0L) {
            ++i;
        }
        return i == parts ? 1 : 0;
    }

    public static long tcDecrement(ulong.ptr dst, int parts) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            if (dst.$set$postDec(i) != 0L) {
                return 0L;
            }
            ++i;
        }
        return 1L;
    }

    public static void tcSetLeastSignificantBits(ulong.ptr dst, int parts, int bits) {
        int i = 0;
        while (Unsigned.$greater_uint((int)bits, (int)llvm.integerPartWidth)) {
            dst.$set(i++, -1L);
            bits -= llvm.integerPartWidth;
        }
        if (bits != 0) {
            dst.$set(i++, -1L >>> llvm.integerPartWidth - bits);
        }
        while (Unsigned.$less_uint((int)i, (int)parts)) {
            dst.$set(i++, 0L);
        }
    }

    public void dump() {
        SmallString S2 = new SmallString(40);
        SmallString U = new SmallString(40);
        this.toStringUnsigned(U);
        this.toStringSigned(S2);
        llvm.dbgs().$out("APInt(").$out_uint(this.BitWidth).$out("b, ").$out(U).$out("u ").$out(S2).$out("s)");
    }

    public T clone() {
        assert (this.getClass() == APInt.class) : "why not overridden in " + this.getClass();
        return (T)new APInt<T>(this);
    }

    public T move() {
        assert (this.getClass() == APInt.class) : "why not overridden in " + this.getClass();
        return (T)new APInt<T>(JavaDifferentiators.JD.Move.INSTANCE, this);
    }

    public String toString() {
        String txtDecSigned = "";
        try {
            txtDecSigned = this.__toString(10, true).toJavaString();
        }
        catch (Throwable e) {
            txtDecSigned = "<ERROR-10Signed>";
        }
        String txtDecUnSigned = "";
        try {
            txtDecUnSigned = this.__toString(10, false).toJavaString();
        }
        catch (Throwable e) {
            txtDecUnSigned = "<ERROR-10Unsigned>";
        }
        String txtHex = "";
        try {
            txtHex = this.__toString(16, false).toJavaString();
        }
        catch (Throwable e) {
            txtHex = "<ERROR-HEXUnsigned>";
        }
        return "\nSgnd[" + txtDecSigned + "]\nUSgn[" + txtDecUnSigned + "]\nUHex[" + txtHex + "]\n[BitWidth=" + this.BitWidth + "[" + (this.pVal != null ? this.pVal : Long.valueOf(this.VAL)) + "]]";
    }

    public static class mu
    implements Destructors.ClassWithDestructor {
        public APInt m;
        public boolean a;
        public int s;

        public mu(JavaDifferentiators.JD.Move _dparam, mu $Prm0) {
            this.m = new APInt(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.m);
            this.a = $Prm0.a;
            this.s = $Prm0.s;
        }

        public void $destroy() {
            this.m.$destroy();
        }

        public mu() {
            this.m = new APInt();
        }

        public String toString() {
            return "m=" + this.m + ", a=" + this.a + ", s=" + this.s;
        }

        public mu(mu $Prm0) {
            this.m = new APInt($Prm0.m);
            this.a = $Prm0.a;
            this.s = $Prm0.s;
        }
    }

    public static class ms
    implements Destructors.ClassWithDestructor {
        public APInt m;
        public int s;

        public ms(JavaDifferentiators.JD.Move _dparam, ms $Prm0) {
            this.m = new APInt(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.m);
            this.s = $Prm0.s;
        }

        public void $destroy() {
            this.m.$destroy();
        }

        public ms() {
            this.m = new APInt();
        }

        public String toString() {
            return "m=" + this.m + ", s=" + this.s;
        }

        public ms(ms $Prm0) {
            this.m = new APInt($Prm0.m);
            this.s = $Prm0.s;
        }
    }
}

