/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.util.InternalUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001aK\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0000\u00a2\u0006\u0002\u0010\u0012\u001a\f\u0010\u0013\u001a\u00020\f*\u00020\u0001H\u0000\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0001*\u00020\u0001H\u0000\u00a8\u0006\u0016"}, d2={"toSystemDependentName", "", "path", "toSystemIndependentName", "addQueryParameter", "Ljava/net/URI;", "name", "value", "createExecCmd", "Lcom/intellij/docker/agent/DockerAgent;", "containerId", "withStdIn", "", "command", "", "workingDir", "environment", "", "(Lcom/intellij/docker/agent/DockerAgent;Ljava/lang/String;Z[Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)Ljava/lang/String;", "isQuoted", "nullize", "trimShaPrefix", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ninternalUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 internalUtils.kt\ncom/intellij/docker/agent/util/InternalUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class InternalUtilsKt {
    @Nullable
    public static final String nullize(@Nullable String $this$nullize) {
        CharSequence charSequence = $this$nullize;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : $this$nullize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String createExecCmd(@NotNull DockerAgent $this$createExecCmd, @NotNull String containerId, boolean withStdIn, @NotNull String[] command, @Nullable String workingDir, @NotNull List<String> environment) {
        Intrinsics.checkNotNullParameter((Object)$this$createExecCmd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Closeable closeable = (Closeable)$this$createExecCmd.getDockerClient().execCreateCmd(containerId);
        Throwable throwable = null;
        try {
            ExecCreateCmd execCreateCmd = (ExecCreateCmd)closeable;
            boolean bl = false;
            execCreateCmd.withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(withStdIn)).withTty(Boolean.valueOf(withStdIn)).withCmd(Arrays.copyOf(command, command.length));
            String string = workingDir;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                execCreateCmd.withWorkingDir(it);
            }
            if (!((Collection)environment).isEmpty()) {
                execCreateCmd.withEnv(environment);
            }
            String string2 = ((ExecCreateCmdResponse)execCreateCmd.exec()).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ String createExecCmd$default(DockerAgent dockerAgent, String string, boolean bl, String[] stringArray, String string2, List list, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        return InternalUtilsKt.createExecCmd(dockerAgent, string, bl, stringArray, string2, list);
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuoted, (String)"<this>");
        return $this$isQuoted.length() > 1 && ($this$isQuoted.charAt(0) == '\'' || $this$isQuoted.charAt(0) == '\"') && $this$isQuoted.charAt(0) == $this$isQuoted.charAt($this$isQuoted.length() - 1);
    }

    @NotNull
    public static final URI addQueryParameter(@NotNull URI $this$addQueryParameter, @NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$addQueryParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object[] objectArray = new String[]{$this$addQueryParameter.getQuery(), name + "=" + value};
        String newQuery2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"&", null, null, (int)0, null, (Function1)addQueryParameter.newQuery.1.INSTANCE, (int)30, null);
        return new URI($this$addQueryParameter.getScheme(), $this$addQueryParameter.getUserInfo(), $this$addQueryParameter.getHost(), $this$addQueryParameter.getPort(), $this$addQueryParameter.getPath(), newQuery2, $this$addQueryParameter.getFragment());
    }

    @NotNull
    public static final String trimShaPrefix(@NotNull String $this$trimShaPrefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$trimShaPrefix, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$trimShaPrefix, (String)"sha256:", (boolean)false, (int)2, null)) {
            String string2 = $this$trimShaPrefix.substring(7);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = $this$trimShaPrefix;
        }
        return string;
    }

    @NotNull
    public static final String toSystemDependentName(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)path, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null), (char)'\\', (char)File.separatorChar, (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String toSystemIndependentName(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.replace$default((String)path, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }
}

