/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeature;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureOrderResolver;
import com.intellij.docker.agent.devcontainers.feautures.DevcontainerFeatureSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver;", "", "featureSet", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureSet;", "(Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureSet;)V", "idToFeature", "", "", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeature;", "mergeWithStandalone", "", "features", "order", "prioritizeOverriden", "byDependency", "resolveDependencies", "idList", "CycleDetectionException", "Graph", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDevcontainerFeatureOrderResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatureOrderResolver.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1855#2:94\n1855#2,2:95\n1856#2:97\n766#2:98\n857#2,2:99\n1603#2,9:101\n1855#2:110\n1856#2:113\n1612#2:114\n766#2:115\n857#2,2:116\n1855#2,2:118\n1#3:111\n1#3:112\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatureOrderResolver.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver\n*L\n8#1:94\n11#1:95,2\n8#1:97\n26#1:98\n26#1:99,2\n36#1:101,9\n36#1:110\n36#1:113\n36#1:114\n37#1:115\n37#1:116,2\n44#1:118,2\n36#1:112\n*E\n"})
public final class DevcontainerFeatureOrderResolver {
    @NotNull
    private final DevcontainerFeatureSet featureSet;
    @NotNull
    private final Map<String, DevcontainerFeature> idToFeature;

    public DevcontainerFeatureOrderResolver(@NotNull DevcontainerFeatureSet featureSet) {
        Intrinsics.checkNotNullParameter((Object)featureSet, (String)"featureSet");
        this.featureSet = featureSet;
        this.idToFeature = new LinkedHashMap();
    }

    @NotNull
    public final List<DevcontainerFeature> order() {
        Graph graph = new Graph();
        Iterable $this$forEach$iv = this.featureSet.getFeatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DevcontainerFeature it = (DevcontainerFeature)element$iv;
            boolean bl = false;
            String sourceId = it.getRef().getDependencyId();
            this.idToFeature.put(sourceId, it);
            List<DevcontainerFeature.FeatureRef> list = it.getConfig().getInstallsAfter();
            if (list == null) continue;
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DevcontainerFeature.FeatureRef target = (DevcontainerFeature.FeatureRef)element$iv2;
                boolean bl2 = false;
                String targetId = target.getDependencyId();
                if (!this.idToFeature.containsKey(targetId)) {
                    this.idToFeature.put(targetId, new DevcontainerFeature(target, new DevcontainerFeature.FeatureConfig(target.getId(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, 262142, null)));
                }
                graph.addEdge(sourceId, targetId);
            }
        }
        return this.mergeWithStandalone(this.prioritizeOverriden(this.resolveDependencies(CollectionsKt.reversed((Iterable)graph.topologicalSortWithCycleDetection()))));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DevcontainerFeature> mergeWithStandalone(List<DevcontainerFeature> features) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List result2;
        List $this$mergeWithStandalone_u24lambda_u243 = result2 = (List)new ArrayList();
        boolean bl = false;
        Iterable iterable = this.featureSet.getFeatures();
        List list = $this$mergeWithStandalone_u24lambda_u243;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DevcontainerFeature it = (DevcontainerFeature)element$iv$iv;
            boolean bl2 = false;
            if (!(!features.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        $this$mergeWithStandalone_u24lambda_u243.addAll((Collection)features);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DevcontainerFeature> prioritizeOverriden(List<DevcontainerFeature> byDependency) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        if (this.featureSet.getOverrideFeatureInstallOrder().isEmpty()) {
            return byDependency;
        }
        List result2 = new ArrayList();
        Set overrideSet = CollectionsKt.toSet((Iterable)this.featureSet.getOverrideFeatureInstallOrder());
        Collection collection = result2;
        Iterable $this$mapNotNull$iv = this.featureSet.getOverrideFeatureInstallOrder();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DevcontainerFeature it$iv$iv;
            Object v0;
            block4: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String ovrId = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = byDependency;
                for (Object t : iterable2) {
                    DevcontainerFeature it = (DevcontainerFeature)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getRef().getDependencyId(), (Object)ovrId)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            if ((DevcontainerFeature)v0 == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)$this$mapNotNull$iv);
        collection = result2;
        Iterable $this$filter$iv = byDependency;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DevcontainerFeature it = (DevcontainerFeature)element$iv$iv;
            boolean bl = false;
            if (!(!overrideSet.contains(it.getRef().getDependencyId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable3);
        return result2;
    }

    private final List<DevcontainerFeature> resolveDependencies(List<String> idList) {
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = idList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DevcontainerFeature it;
            String id = (String)element$iv;
            boolean bl = false;
            if (this.idToFeature.get(id) == null) continue;
            boolean bl2 = false;
            if (!it.getConfig().isRequired()) continue;
            result2.add(it);
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver$CycleDetectionException;", "", "node", "", "(Ljava/lang/String;)V", "getNode", "()Ljava/lang/String;", "intellij.clouds.docker.agent"})
    public static final class CycleDetectionException
    extends Throwable {
        @NotNull
        private final String node;

        public CycleDetectionException(@NotNull String node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super(node);
            this.node = node;
        }

        @NotNull
        public final String getNode() {
            return this.node;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver$Graph;", "", "()V", "adjacencyList", "", "", "", "addEdge", "", "source", "destination", "topologicalSortWithCycleDetection", "", "intellij.clouds.docker.agent"})
    public static final class Graph {
        @NotNull
        private final Map<String, List<String>> adjacencyList = new LinkedHashMap();

        public final void addEdge(@NotNull String source, @NotNull String destination) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.adjacencyList.computeIfAbsent(source, arg_0 -> Graph.addEdge$lambda$0(addEdge.1.INSTANCE, arg_0)).add(destination);
        }

        @NotNull
        public final List<String> topologicalSortWithCycleDetection() {
            Map visited = new LinkedHashMap();
            Map recursionStack = new LinkedHashMap();
            List topologicalOrder = new ArrayList();
            for (String node : this.adjacencyList.keySet()) {
                if (visited.getOrDefault(node, false).booleanValue()) continue;
                Graph.topologicalSortWithCycleDetection$checkCyclicAndAdd(visited, recursionStack, this, topologicalOrder, node);
            }
            CollectionsKt.reverse((List)topologicalOrder);
            return topologicalOrder;
        }

        private static final List addEdge$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (List)$tmp0.invoke(p0);
        }

        private static final void topologicalSortWithCycleDetection$checkCyclicAndAdd(Map<String, Boolean> visited, Map<String, Boolean> recursionStack, Graph this$0, List<String> topologicalOrder, String node) {
            visited.put(node, true);
            recursionStack.put(node, true);
            List list = this$0.adjacencyList.get(node);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (String neighbor : list) {
                if (!visited.getOrDefault(neighbor, false).booleanValue()) {
                    Graph.topologicalSortWithCycleDetection$checkCyclicAndAdd(visited, recursionStack, this$0, topologicalOrder, neighbor);
                    continue;
                }
                if (!recursionStack.getOrDefault(neighbor, false).booleanValue()) continue;
                throw new CycleDetectionException(node);
            }
            recursionStack.put(node, false);
            topologicalOrder.add(node);
        }
    }
}

