/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.cli.model;

import com.github.dockerjava.api.command.BuildImageCmd;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.cli.model.CliParserBase;
import com.intellij.docker.agent.cli.model.DockerBuildCliParserBase;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBuildCliParser
extends DockerBuildCliParserBase<BuildImageCmd> {
    public void parse(BuildImageCmd cmd, String[] optionsLine) throws ApiTaskException {
        try {
            super.doParse(cmd, optionsLine);
        }
        catch (CliParserBase.IllegalOptionException | ParseException e) {
            throw new ApiTaskException((Exception)e);
        }
    }

    public static void withBuildArg(BuildImageCmd cmd, @NotNull String key, @Nullable String value) {
        if (key == null) {
            DockerBuildCliParser.$$$reportNull$$$0(0);
        }
        if (value != null && value.startsWith("$env:")) {
            String valueWithoutPrefix = StringsKt.removePrefix((String)value, (CharSequence)"$env:");
            value = valueWithoutPrefix.isBlank() ? Optional.ofNullable(System.getenv(key)).orElse("") : Optional.ofNullable(System.getenv(valueWithoutPrefix)).orElse("");
        }
        cmd.withBuildArg(key, value);
    }

    @Override
    protected CliParserBase.LabelListHandler<BuildImageCmd> buildArgs(Option option) {
        return new CliParserBase.LabelListHandler<BuildImageCmd>(option){

            @Override
            protected void handleLabelsMap(Map<String, String> parsedMap) {
                if (parsedMap == null) {
                    return;
                }
                for (Map.Entry<String, String> entry : parsedMap.entrySet()) {
                    DockerBuildCliParser.withBuildArg((BuildImageCmd)this.getCmd(), entry.getKey(), entry.getValue());
                }
            }
        };
    }

    @Override
    protected CliParserBase.ListHandler<BuildImageCmd> secrets(Option option) {
        return new CliParserBase.StringListHandler<BuildImageCmd>(option, (cmd, string) -> {
            throw new UnsupportedOperationException("'secret' argument does not supported in docker-java");
        });
    }

    @Override
    protected CliParserBase.SingleValueHandler<BuildImageCmd> progress(Option option) {
        return new CliParserBase.EachValueHandler<BuildImageCmd>(option, (cmd, value) -> {
            throw new UnsupportedOperationException("'progress' argument does not supported in docker-java");
        });
    }

    @Override
    protected CliParserBase.ListHandler<BuildImageCmd> ssh(Option option) {
        return new CliParserBase.StringListHandler<BuildImageCmd>(option, (cmd, string) -> {
            throw new UnsupportedOperationException("'ssh' argument does not supported in docker-java");
        });
    }

    @Override
    protected DockerBuildCliParserBase.CommaSeparatedListHandler<BuildImageCmd> cacheFrom(Option option) {
        return new DockerBuildCliParserBase.CommaSeparatedListHandler<BuildImageCmd>(option, (cmd, strings) -> cmd.withCacheFrom(new LinkedHashSet<String>(Arrays.asList(strings))));
    }

    @Override
    protected CliParserBase.EachValueHandler<BuildImageCmd> cpuShares(Option option) {
        return new CliParserBase.EachValueHandler<BuildImageCmd>(option, BuildImageCmd::withCpushares);
    }

    @Override
    protected CliParserBase.SingleValueHandler<BuildImageCmd> cpusetCpus(Option option) {
        return new CliParserBase.EachValueHandler<BuildImageCmd>(option, BuildImageCmd::withCpusetcpus);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> forceRm(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<BuildImageCmd>(option, BuildImageCmd::withForcerm);
    }

    @Override
    protected CliParserBase.LabelListHandler<BuildImageCmd> label(Option option) {
        return new CliParserBase.LabelListHandlerImpl<BuildImageCmd>(option, BuildImageCmd::getLabels, BuildImageCmd::withLabels);
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<BuildImageCmd> memory(Option option) {
        return new CliParserBase.MemoryOptionHandler<BuildImageCmd>(option, BuildImageCmd::withMemory);
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<BuildImageCmd> memorySwap(Option option) {
        return new CliParserBase.MemoryOptionHandler<BuildImageCmd>(option, BuildImageCmd::withMemswap);
    }

    @Override
    protected CliParserBase.MemoryOptionHandler<BuildImageCmd> shmSize(Option option) {
        return new CliParserBase.MemoryOptionHandler<BuildImageCmd>(option, BuildImageCmd::withShmsize);
    }

    @Override
    protected CliParserBase.SingleValueHandler<BuildImageCmd> network(Option option) {
        return new CliParserBase.EachValueHandler<BuildImageCmd>(option, BuildImageCmd::withNetworkMode);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> noCache(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<BuildImageCmd>(option, BuildImageCmd::withNoCache);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> pull(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<BuildImageCmd>(option, BuildImageCmd::withPull);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> quiet(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<BuildImageCmd>(option, BuildImageCmd::withQuiet);
    }

    @Override
    protected CliParserBase.BooleanOptionHandler<BuildImageCmd> rm(Option option) {
        return new CliParserBase.BooleanOptionHandlerImpl<BuildImageCmd>(option, BuildImageCmd::withRemove);
    }

    @Override
    protected CliParserBase.SingleValueHandler<BuildImageCmd> target(Option option) {
        return new CliParserBase.EachValueHandler<BuildImageCmd>(option, BuildImageCmd::withTarget);
    }

    @Override
    protected CliParserBase.SingleValueHandler<BuildImageCmd> platform(Option option) {
        return new CliParserBase.EachValueHandler<BuildImageCmd>(option, BuildImageCmd::withPlatform);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/docker/agent/cli/model/DockerBuildCliParser", "withBuildArg"));
    }
}

