/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public interface ValueTransfer<SRC, TRG> {
    public void transferFromTo(SRC var1, TRG var2);

    public static class ValuesMerge<PRI, SRC, TRG> {
        private final ValueTransfer<? super SRC, ? super TRG> mySecondaryTransfer;
        private final ValueTransfer<? super PRI, ? super TRG> myPriorityTransfer;

        public ValuesMerge(ValueTransfer<? super PRI, ? super TRG> priorityTransfer, ValueTransfer<? super SRC, ? super TRG> secondaryTransfer) {
            this.mySecondaryTransfer = secondaryTransfer;
            this.myPriorityTransfer = priorityTransfer;
        }

        public TRG mergeWithPriority(PRI prioritySource, SRC secondarySource, TRG target) {
            this.mySecondaryTransfer.transferFromTo(secondarySource, target);
            if (prioritySource != null) {
                this.myPriorityTransfer.transferFromTo(prioritySource, target);
            }
            return target;
        }
    }

    public static class CompositeTransfer<S, T>
    implements ValueTransfer<S, T> {
        private final List<ValueTransfer<S, T>> myValueTransfers = new LinkedList<ValueTransfer<S, T>>();

        public <V> void mapIfNotNull(Function<? super S, V> getter, BiConsumer<? super T, V> setter) {
            this.addValueTransfer(new NotNullTransfer<S, T, V>(getter, setter));
        }

        public <V> void mergeArrays(boolean replaceNotCombine, Class<? extends V> valueClass, Function<? super S, V[]> sourceGetter, Function<? super T, V[]> targetGetter, BiConsumer<? super T, V[]> setter) {
            if (replaceNotCombine) {
                this.addValueTransfer(new NotNullTransfer<S, T, V[]>(sourceGetter, setter));
            } else {
                this.addValueTransfer(new CombiningArrayTransfer<S, T, V>(valueClass, sourceGetter, targetGetter, setter));
            }
        }

        @Override
        public void transferFromTo(S source, T target) {
            for (ValueTransfer<S, T> next : this.myValueTransfers) {
                next.transferFromTo(source, target);
            }
        }

        protected void addValueTransfer(ValueTransfer<S, T> transfer) {
            this.myValueTransfers.add(transfer);
        }

        public int countValueTransfers() {
            return this.myValueTransfers.size();
        }
    }

    public static class CombiningArrayTransfer<SRC, TRG, VAL>
    implements ValueTransfer<SRC, TRG> {
        private final Function<? super SRC, VAL[]> mySourceGetter;
        private final Function<? super TRG, VAL[]> myTargetGetter;
        private final BiConsumer<? super TRG, VAL[]> mySetter;
        private final Class<? extends VAL> myValueClass;

        public CombiningArrayTransfer(Class<? extends VAL> valueClass, Function<? super SRC, VAL[]> sourceGetter, Function<? super TRG, VAL[]> targetGetter, BiConsumer<? super TRG, VAL[]> setter) {
            this.myValueClass = valueClass;
            this.mySourceGetter = sourceGetter;
            this.myTargetGetter = targetGetter;
            this.mySetter = setter;
        }

        @Override
        public void transferFromTo(SRC source, TRG target) {
            VAL[] fromSource = this.mySourceGetter.apply(source);
            if (fromSource == null || fromSource.length == 0) {
                return;
            }
            VAL[] existing = this.myTargetGetter.apply(target);
            VAL[] result2 = existing == null || existing.length == 0 ? fromSource : CombiningArrayTransfer.combineArrays(this.myValueClass, fromSource, existing);
            this.mySetter.accept(target, result2);
        }

        static <VAL> VAL[] combineArrays(Class<? extends VAL> valueClass, VAL[] left, VAL[] right) {
            IntFunction<A[]> arrayNew = size -> (Object[])Array.newInstance(valueClass, size);
            return Stream.concat(Stream.of(left), Stream.of(right)).toArray(arrayNew);
        }
    }

    public static class NotNullTransfer<SRC, TRG, VAL>
    implements ValueTransfer<SRC, TRG> {
        protected final Function<? super SRC, VAL> myGetter;
        protected final BiConsumer<? super TRG, VAL> mySetter;

        public NotNullTransfer(Function<? super SRC, VAL> getter, BiConsumer<? super TRG, VAL> setter) {
            this.myGetter = getter;
            this.mySetter = setter;
        }

        @Override
        public void transferFromTo(SRC source, TRG target) {
            VAL value = this.myGetter.apply(source);
            if (value != null) {
                this.mySetter.accept(target, value);
            }
        }
    }
}

