/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.modules;

import fleet.util.modules.FleetModuleFinderLogger;
import fleet.util.modules.ModuleInfo;
import fleet.util.modules.WithDescriptorModuleFinder;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class DebugProbesHack {
    public static final String fleetRuntimeModuleName = "fleet.kotlin.runtime";
    static final Set<String> kotlinRuntimeModuleNames = Set.of("kotlin.stdlib", "kotlinx.coroutines.core");
    static final Set<String> misdeclaredKotlinxCoroutinesDebugModules = Set.of("net.bytebuddy.agent", "net.bytebuddy");
    static final Set<String> unwantedKotlinxCoroutinesDebugModules = Set.of("org.junit.jupiter.api", "org.junit.platform.commons");

    static ModuleReference buildFleetKotlinRuntimeModuleReference(Map<String, ModuleInfo.WithDescriptor> moduleMap, FleetModuleFinderLogger logger) {
        ModuleInfo.WithDescriptor[] modules = (ModuleInfo.WithDescriptor[])kotlinRuntimeModuleNames.stream().map(name -> (ModuleInfo.WithDescriptor)moduleMap.get(name)).filter(module -> module != null).toArray(ModuleInfo.WithDescriptor[]::new);
        if (modules.length != kotlinRuntimeModuleNames.size()) {
            Set names = Arrays.stream(modules).map(m -> m.descriptor().name()).collect(Collectors.toSet());
            throw new IllegalStateException("fleet.kotlin.runtime module can only be created when the module layer has all three modules: " + kotlinRuntimeModuleNames + ", got " + names + ".\nProbably a bug in the build script put the missing module(s) in a parent module layer.");
        }
        ModuleDescriptor descriptorOfMergedModule = DebugProbesHack.bundleIntoAKotlinRuntimeModule(modules);
        return WithDescriptorModuleFinder.compositeJarModuleReference(descriptorOfMergedModule, logger, modules);
    }

    static ModuleDescriptor bundleIntoAKotlinRuntimeModule(ModuleInfo.WithDescriptor ... modulesToMerge) {
        Set moduleNames = Arrays.stream(modulesToMerge).map(ModuleInfo.WithDescriptor::descriptor).map(ModuleDescriptor::name).collect(Collectors.toSet());
        HashSet<String> toIgnore = new HashSet<String>();
        toIgnore.addAll(misdeclaredKotlinxCoroutinesDebugModules);
        toIgnore.addAll(unwantedKotlinxCoroutinesDebugModules);
        toIgnore.addAll(moduleNames);
        ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(fleetRuntimeModuleName);
        HashSet<String> alreadyAddedRequires = new HashSet<String>();
        for (ModuleInfo.WithDescriptor module : modulesToMerge) {
            DebugProbesHack.fillBuilderFromModule(builder, toIgnore, module.descriptor(), alreadyAddedRequires);
        }
        return builder.build();
    }

    static ModuleDescriptor substituteModules(ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor.isAutomatic()) {
            return moduleDescriptor;
        }
        ModuleDescriptor.Builder builder = moduleDescriptor.isOpen() ? ModuleDescriptor.newOpenModule(moduleDescriptor.name()) : ModuleDescriptor.newModule(moduleDescriptor.name());
        moduleDescriptor.version().ifPresent(v -> builder.version((ModuleDescriptor.Version)v));
        moduleDescriptor.mainClass().ifPresent(mc -> builder.mainClass((String)mc));
        for (String string : moduleDescriptor.uses()) {
            builder.uses(string);
        }
        for (ModuleDescriptor.Provides provides : moduleDescriptor.provides()) {
            builder.provides(provides);
        }
        HashSet<ModuleDescriptor.Requires> toSubstitute = new HashSet<ModuleDescriptor.Requires>();
        for (ModuleDescriptor.Requires req2 : moduleDescriptor.requires()) {
            if (kotlinRuntimeModuleNames.contains(req2.name())) {
                if (req2.compiledVersion().isPresent() || req2.rawCompiledVersion().isPresent()) {
                    throw new IllegalStateException(req2.name() + " cannot be declared with compiledVersion, found such declaration in module " + moduleDescriptor.name());
                }
                if (req2.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.MANDATED)) {
                    throw new IllegalStateException(req2.name() + " cannot be declared with " + ModuleDescriptor.Requires.Modifier.MANDATED + " modifier in module " + moduleDescriptor.name());
                }
                if (req2.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.SYNTHETIC)) {
                    throw new IllegalStateException(req2.name() + " cannot be declared with " + ModuleDescriptor.Requires.Modifier.SYNTHETIC + " modifier in module " + moduleDescriptor.name());
                }
                toSubstitute.add(req2);
                continue;
            }
            builder.requires(req2);
        }
        if (!toSubstitute.isEmpty()) {
            boolean bl = toSubstitute.stream().allMatch(req -> req.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
            boolean atLeastOneTransitive = toSubstitute.stream().anyMatch(req -> req.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE));
            HashSet<ModuleDescriptor.Requires.Modifier> modifiers = new HashSet<ModuleDescriptor.Requires.Modifier>();
            if (bl) {
                modifiers.add(ModuleDescriptor.Requires.Modifier.STATIC);
            }
            if (atLeastOneTransitive) {
                modifiers.add(ModuleDescriptor.Requires.Modifier.TRANSITIVE);
            }
            builder.requires(modifiers, fleetRuntimeModuleName);
        }
        for (ModuleDescriptor.Opens open : moduleDescriptor.opens()) {
            Set<String> targets = open.targets().stream().map(t -> kotlinRuntimeModuleNames.contains(t) ? fleetRuntimeModuleName : t).collect(Collectors.toSet());
            if (targets.isEmpty()) {
                builder.opens(open.modifiers(), open.source());
                continue;
            }
            builder.opens(open.modifiers(), open.source(), targets);
        }
        for (ModuleDescriptor.Exports export : moduleDescriptor.exports()) {
            Set<String> filteredTargets = export.targets().stream().filter(t -> !kotlinRuntimeModuleNames.contains(t)).collect(Collectors.toSet());
            if (filteredTargets.size() != export.targets().size()) {
                filteredTargets.add(fleetRuntimeModuleName);
                builder.exports(export.modifiers(), export.source(), filteredTargets);
                continue;
            }
            builder.exports(export);
        }
        builder.packages(moduleDescriptor.packages());
        return builder.build();
    }

    private static void fillBuilderFromModule(@NotNull ModuleDescriptor.Builder builder, @NotNull Set<String> requiresToIgnore, @NotNull ModuleDescriptor descriptor, @NotNull Set<String> alreadyAddedRequires) {
        if (builder == null) {
            DebugProbesHack.$$$reportNull$$$0(0);
        }
        if (requiresToIgnore == null) {
            DebugProbesHack.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            DebugProbesHack.$$$reportNull$$$0(2);
        }
        if (alreadyAddedRequires == null) {
            DebugProbesHack.$$$reportNull$$$0(3);
        }
        descriptor.requires().stream().filter(x -> !requiresToIgnore.contains(x.name())).forEach(req -> {
            if (alreadyAddedRequires.add(req.name())) {
                builder.requires((ModuleDescriptor.Requires)req);
            }
        });
        descriptor.exports().forEach(builder::exports);
        descriptor.opens().forEach(builder::opens);
        descriptor.uses().forEach(builder::uses);
        descriptor.provides().forEach(builder::provides);
        descriptor.version().ifPresent(builder::version);
        descriptor.mainClass().ifPresent(builder::mainClass);
        builder.packages(descriptor.packages());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "requiresToIgnore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "alreadyAddedRequires";
                break;
            }
        }
        objectArray[1] = "fleet/util/modules/DebugProbesHack";
        objectArray[2] = "fillBuilderFromModule";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

