/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff;

import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextLine;
import andel.text.TextRange;
import fleet.diff.MergeConflict;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"BASE_SPLITTER", "", "CONFLICT_END", "CONFLICT_SPLITTER", "CONFLICT_START", "parseConflicts", "", "Lfleet/diff/MergeConflict;", "text", "Landel/text/Text;", "fleet.diff"})
public final class ConflictParserKt {
    @NotNull
    private static final String CONFLICT_START = "<<<<<<<";
    @NotNull
    private static final String BASE_SPLITTER = "|||||||";
    @NotNull
    private static final String CONFLICT_SPLITTER = "=======";
    @NotNull
    private static final String CONFLICT_END = ">>>>>>>";

    @NotNull
    public static final List<MergeConflict> parseConflicts(@NotNull Text text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ArrayList<MergeConflict> conflicts = new ArrayList<MergeConflict>();
        long start = -1L;
        long splitterStart = -1L;
        long splitterEnd = -1L;
        for (TextLine line : Text.lines$default((Text)text, (boolean)false, (int)1, null)) {
            TextFragmentCharSequence lineText = line.asCharSequence();
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)lineText), (CharSequence)CONFLICT_START, (boolean)false, (int)2, null)) {
                start = line.getFromChar();
                continue;
            }
            if (StringsKt.startsWith$default((CharSequence)((CharSequence)lineText), (CharSequence)BASE_SPLITTER, (boolean)false, (int)2, null) && splitterStart < 0L) {
                splitterStart = line.getFromChar() - 1L;
                continue;
            }
            if (StringsKt.contentEquals((CharSequence)((CharSequence)lineText), (CharSequence)CONFLICT_SPLITTER)) {
                if (splitterStart < start) {
                    splitterStart = line.getFromChar() - 1L;
                }
                splitterEnd = line.getToCharExcludingSeparator() + 1L;
                continue;
            }
            if (!StringsKt.startsWith$default((CharSequence)((CharSequence)lineText), (CharSequence)CONFLICT_END, (boolean)false, (int)2, null)) continue;
            boolean bl = 0L <= start ? start < splitterStart : false;
            if (bl && splitterEnd > splitterStart) {
                conflicts.add(new MergeConflict(new TextRange(start, splitterStart), new TextRange(splitterEnd, line.getToCharExcludingSeparator())));
            }
            start = -1L;
            splitterStart = -1L;
            splitterEnd = -1L;
        }
        return conflicts;
    }
}

