/*
 * Decompiled with CFR 0.152.
 */
package fleet.java.workspace;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import fleet.api.FileAddress;
import fleet.api.ProjectRootId;
import fleet.common.download.FleetPartsS3ExtensionsKt;
import fleet.common.download.S3ArtifactArchiveType;
import fleet.common.download.S3ArtifactType;
import fleet.common.download.S3Version;
import fleet.common.fs.SharedProjectRootEntity;
import fleet.java.protocol.FleetJdkFinderKt;
import fleet.java.workspace.BuildJpsDependenciesPreprocessor;
import fleet.java.workspace.BuildWriteClassesOutputProcessor;
import fleet.java.workspace.JavaRuntimeComparator;
import fleet.java.workspace.JpsBuildLauncher;
import fleet.java.workspace.JpsBuildLauncherKt;
import fleet.kernel.Durable;
import fleet.kernel.plugins.ContributionScope;
import fleet.protocol.run.DownloadRunTask;
import fleet.toolchain.common.api.SharedRuntimeEntity;
import fleet.toolchain.common.api.ToolchainKt;
import fleet.toolchain.protocol.ToolchainDescription;
import fleet.util.StringKt;
import fleet.util.logging.KLogger;
import fleet.util.openmap.SerializableOpenMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a<\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\f\u0010%\u001a\u00020&*\u00020'H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\"\u001a\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u000b*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"JPS_STANDALONE_NAME", "", "JPS_WRAPPER_NAME", "KOTLIN_FOR_IDE_NAME", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "jpsBuildCompatible", "", "Lfleet/toolchain/protocol/ToolchainDescription;", "getJpsBuildCompatible", "(Lfleet/toolchain/protocol/ToolchainDescription;)Z", "jpsBuildCompatibleJavaVersion", "getJpsBuildCompatibleJavaVersion", "(Ljava/lang/String;)Z", "findJpsBuildCompatibleJavaRuntime", "projectDir", "Lfleet/api/FileAddress;", "projectRootId", "Lfleet/api/ProjectRootId;", "jpsStandaloneDependency", "Lfleet/protocol/run/DownloadRunTask;", "jpsStandaloneVersion", "jpsWrapperDependency", "jpsWrapperVersion", "kotlinForIdeDependency", "kotlinVersion", "uriByNotation", "repositoryUri", "group", "name", "version", "ext", "channel", "createJpsBuildExtensions", "", "Lfleet/kernel/plugins/ContributionScope;", "fleet.plugins.java.workspace"})
@SourceDebugExtension(value={"SMAP\nJpsBuildLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsBuildLauncher.kt\nfleet/java/workspace/JpsBuildLauncherKt\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,425:1\n9#2,2:426\n9#2,2:428\n9#2,2:437\n17#2,2:439\n1360#3:430\n1446#3,5:431\n1#4:436\n*S KotlinDebug\n*F\n+ 1 JpsBuildLauncher.kt\nfleet/java/workspace/JpsBuildLauncherKt\n*L\n255#1:426,2\n259#1:428,2\n264#1:437,2\n268#1:439,2\n261#1:430\n261#1:431,5\n*E\n"})
public final class JpsBuildLauncherKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    @NotNull
    public static final String KOTLIN_FOR_IDE_NAME = "kotlin-for-ide";
    @NotNull
    private static final String JPS_WRAPPER_NAME = "jps-wrapper";
    @NotNull
    private static final String JPS_STANDALONE_NAME = "jps-standalone";

    private static final KLogger getLogger() {
        Lazy lazy = logger$delegate;
        return (KLogger)lazy.getValue();
    }

    private static final ToolchainDescription findJpsBuildCompatibleJavaRuntime(FileAddress projectDir, ProjectRootId projectRootId) {
        ToolchainDescription runtimeDescription;
        ToolchainDescription $this$flatMapTo$iv$iv;
        KLogger kLogger;
        ToolchainDescription javaRuntime = ToolchainKt.queryProjectRootRuntimeDescriptor((FileAddress)projectDir, (String)"intellij", (String)"java.home");
        if (JpsBuildLauncherKt.getJpsBuildCompatible(javaRuntime)) {
            KLogger this_$iv = JpsBuildLauncherKt.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger2 = this_$iv;
                boolean bl = false;
                kLogger2.debug((Object)("Project java runtime is supported by build: projectDir: " + projectDir + ", projectRootId: " + projectRootId + " \n" + javaRuntime));
            }
            return javaRuntime;
        }
        KLogger this_$iv = JpsBuildLauncherKt.getLogger();
        boolean $i$f$debug = false;
        if (this_$iv.isDebugEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.debug((Object)("Project java runtime is not supported by build: projectDir: " + projectDir + ", projectRootId: " + projectRootId + " \n" + javaRuntime));
        }
        SharedProjectRootEntity projectRootEntity = (SharedProjectRootEntity)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)SharedProjectRootEntity.Companion.getIdAttr()), (Object)projectRootId);
        EntityAttribute entityAttribute = (EntityAttribute)SharedRuntimeEntity.Companion.getKindIndexAttr();
        SharedProjectRootEntity sharedProjectRootEntity = projectRootEntity;
        Intrinsics.checkNotNull((Object)sharedProjectRootEntity);
        Iterable $this$flatMap$iv = EntityAttributeKt.entities((EntityAttribute)entityAttribute, (Object)TuplesKt.to((Object)EntityAttributeKt.getRequired((Entity)((Entity)sharedProjectRootEntity), (Attributes.Required)Durable.INSTANCE.getId()), (Object)FleetJdkFinderKt.getJavaRuntimeKind()));
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SharedRuntimeEntity it = (SharedRuntimeEntity)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getRuntimes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List runtimes = (List)destination$iv$iv;
        ToolchainDescription toolchainDescription = (ToolchainDescription)CollectionsKt.maxWithOrNull((Iterable)runtimes, (Comparator)new JavaRuntimeComparator());
        if (toolchainDescription != null) {
            ToolchainDescription it = $this$flatMapTo$iv$iv = toolchainDescription;
            boolean bl = false;
            v3 = JpsBuildLauncherKt.getJpsBuildCompatible(it) ? $this$flatMapTo$iv$iv : null;
        } else {
            v3 = runtimeDescription = null;
        }
        if (runtimeDescription != null) {
            KLogger this_$iv2 = JpsBuildLauncherKt.getLogger();
            boolean $i$f$debug2 = false;
            if (this_$iv2.isDebugEnabled()) {
                kLogger = this_$iv2;
                boolean bl = false;
                kLogger.debug((Object)("Found another java runtime supported by build: projectDir: " + projectDir + ", projectRootId: " + projectRootId + " \n" + runtimeDescription));
            }
            return runtimeDescription;
        }
        this_$iv = JpsBuildLauncherKt.getLogger();
        boolean $i$f$warn = false;
        if (this_$iv.isWarnEnabled()) {
            kLogger = this_$iv;
            boolean bl = false;
            kLogger.warn((Object)("Java runtime supported by build is not found: projectDir: " + projectDir + ", projectRootId: " + projectRootId));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getJpsBuildCompatible(ToolchainDescription $this$jpsBuildCompatible) {
        if ($this$jpsBuildCompatible == null) return false;
        String string = FleetJdkFinderKt.getJavaVersion((SerializableOpenMap)$this$jpsBuildCompatible.getProperties());
        if (string == null) return false;
        boolean bl = JpsBuildLauncherKt.getJpsBuildCompatibleJavaVersion(string);
        if (!bl) return false;
        return true;
    }

    private static final boolean getJpsBuildCompatibleJavaVersion(String $this$jpsBuildCompatibleJavaVersion) {
        return StringKt.compareVersionNumbers((String)$this$jpsBuildCompatibleJavaVersion, (String)"11") >= 0;
    }

    private static final DownloadRunTask jpsWrapperDependency(String jpsWrapperVersion) {
        String jpsWrapperUri = JpsBuildLauncherKt.uriByNotation$default("https://cache-redirector.jetbrains.com/intellij-dependencies", "com.jetbrains.intellij.idea", JPS_WRAPPER_NAME, jpsWrapperVersion, "jar", null, 32, null);
        return new DownloadRunTask(JPS_WRAPPER_NAME, jpsWrapperVersion, jpsWrapperUri, false, null, 16, null);
    }

    private static final DownloadRunTask jpsStandaloneDependency(String jpsStandaloneVersion) {
        String jpsStandaloneUri = StringsKt.startsWith$default((String)jpsStandaloneVersion, (String)"2022.", (boolean)false, (int)2, null) ? JpsBuildLauncherKt.uriByNotation$default("https://cache-redirector.jetbrains.com/www.jetbrains.com/intellij-repository/releases", "com.jetbrains.intellij.idea", JPS_STANDALONE_NAME, jpsStandaloneVersion, "zip", null, 32, null) : FleetPartsS3ExtensionsKt.s3ArtifactUrl$default((String)"fleet-jps", (String)"fleet-jps-standalone", (S3ArtifactType)((S3ArtifactType)new S3ArtifactType.Archive(S3ArtifactArchiveType.ZIP)), null, (S3Version)((S3Version)new S3Version.Specific(jpsStandaloneVersion)), null, (int)32, null);
        return new DownloadRunTask(JPS_STANDALONE_NAME, jpsStandaloneVersion, jpsStandaloneUri, true, null, 16, null);
    }

    private static final DownloadRunTask kotlinForIdeDependency(String kotlinVersion) {
        String kotlinUri = JpsBuildLauncherKt.uriByNotation$default("https://cache-redirector.jetbrains.com/maven.pkg.jetbrains.space/kotlin/p/kotlin/kotlin-ide-plugin-dependencies", "org.jetbrains.kotlin", "kotlin-dist-for-ide", kotlinVersion, "jar", null, 32, null);
        return new DownloadRunTask(KOTLIN_FOR_IDE_NAME, kotlinVersion, kotlinUri, true, null, 16, null);
    }

    private static final String uriByNotation(String repositoryUri, String group, String name, String version2, String ext, String channel) {
        return channel == null ? repositoryUri + "/" + StringsKt.replace$default((String)group, (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + name + "/" + version2 + "/" + name + "-" + version2 + "." + ext : repositoryUri + "/" + channel + "/" + StringsKt.replace$default((String)group, (String)".", (String)"/", (boolean)false, (int)4, null) + "/" + name + "/" + version2 + "/" + name + "-" + version2 + "." + ext;
    }

    static /* synthetic */ String uriByNotation$default(String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        return JpsBuildLauncherKt.uriByNotation(string, string2, string3, string4, string5, string6);
    }

    public static final void createJpsBuildExtensions(@NotNull ContributionScope $this$createJpsBuildExtensions) {
        Intrinsics.checkNotNullParameter((Object)$this$createJpsBuildExtensions, (String)"<this>");
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$createJpsBuildExtensions), (KClass)Reflection.getOrCreateKotlinClass(JpsBuildLauncher.class), (int)0, (Function1)createJpsBuildExtensions.1.INSTANCE, (int)2, null);
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$createJpsBuildExtensions), (KClass)Reflection.getOrCreateKotlinClass(BuildJpsDependenciesPreprocessor.class), (int)0, (Function1)createJpsBuildExtensions.2.INSTANCE, (int)2, null);
        ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$createJpsBuildExtensions), (KClass)Reflection.getOrCreateKotlinClass(BuildWriteClassesOutputProcessor.class), (int)0, (Function1)createJpsBuildExtensions.3.INSTANCE, (int)2, null);
    }

    public static final /* synthetic */ boolean access$getJpsBuildCompatibleJavaVersion(String $receiver) {
        return JpsBuildLauncherKt.getJpsBuildCompatibleJavaVersion($receiver);
    }

    public static final /* synthetic */ ToolchainDescription access$findJpsBuildCompatibleJavaRuntime(FileAddress projectDir, ProjectRootId projectRootId) {
        return JpsBuildLauncherKt.findJpsBuildCompatibleJavaRuntime(projectDir, projectRootId);
    }

    public static final /* synthetic */ KLogger access$getLogger() {
        return JpsBuildLauncherKt.getLogger();
    }

    public static final /* synthetic */ DownloadRunTask access$kotlinForIdeDependency(String kotlinVersion) {
        return JpsBuildLauncherKt.kotlinForIdeDependency(kotlinVersion);
    }

    public static final /* synthetic */ DownloadRunTask access$jpsStandaloneDependency(String jpsStandaloneVersion) {
        return JpsBuildLauncherKt.jpsStandaloneDependency(jpsStandaloneVersion);
    }

    public static final /* synthetic */ DownloadRunTask access$jpsWrapperDependency(String jpsWrapperVersion) {
        return JpsBuildLauncherKt.jpsWrapperDependency(jpsWrapperVersion);
    }
}

