/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.settings;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.EntitiesKt;
import com.jetbrains.rhizomedb.Entity;
import com.jetbrains.rhizomedb.EntityAttribute;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.EntityType;
import com.jetbrains.rhizomedb.LegacyEntity;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.common.document.UnsharedHackKt;
import fleet.common.settings.ConfigProperty;
import fleet.common.settings.FileSettingsPropertyEntity;
import fleet.common.settings.ParsingResult;
import fleet.common.settings.SettingsEntityKt;
import fleet.common.settings.SettingsFileLocation;
import fleet.common.settings.SettingsFileParsingErrorEntity;
import fleet.common.settings.SettingsUpdaterKt;
import fleet.common.settings.SharedSettingsFile;
import fleet.kernel.Durable;
import fleet.kernel.SharedChangeScope;
import fleet.kernel.SharedEntity;
import fleet.kernel.SharedKt;
import fleet.kernel.StorageKey;
import fleet.util.logging.KLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0006\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0007\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0007*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a&\u0010\u0017\u001a\u00020\u0014*\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"log", "Lfleet/util/logging/KLogger;", "getLog", "()Lfleet/util/logging/KLogger;", "log$delegate", "Lkotlin/Lazy;", "flatten", "", "", "Lfleet/common/settings/ConfigProperty;", "mapping", "", "", "Lkotlinx/serialization/json/JsonElement;", "contexts", "", "toContext", "updateSettings", "Lcom/jetbrains/rhizomedb/ChangeScope;", "fileEntity", "Lfleet/common/settings/SharedSettingsFile;", "parsingResult", "Lfleet/common/settings/ParsingResult;", "updateSettingsForFileAddress", "location", "Lfleet/common/settings/SettingsFileLocation;", "storageKey", "Lfleet/kernel/StorageKey;", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nSettingsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsUpdater.kt\nfleet/common/settings/SettingsUpdaterKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,112:1\n1313#2:113\n1314#2:116\n17#3,2:114\n*S KotlinDebug\n*F\n+ 1 SettingsUpdater.kt\nfleet/common/settings/SettingsUpdaterKt\n*L\n93#1:113\n93#1:116\n98#1:114,2\n*E\n"})
public final class SettingsUpdaterKt {
    @NotNull
    private static final Lazy log$delegate = LazyKt.lazy((Function0)log.2.INSTANCE);

    private static final KLogger getLog() {
        Lazy lazy = log$delegate;
        return (KLogger)lazy.getValue();
    }

    @NotNull
    public static final SharedSettingsFile updateSettingsForFileAddress(@NotNull ChangeScope $this$updateSettingsForFileAddress, @NotNull SettingsFileLocation location, @NotNull ParsingResult parsingResult, @Nullable StorageKey storageKey) {
        SharedSettingsFile sharedSettingsFile2;
        Intrinsics.checkNotNullParameter((Object)$this$updateSettingsForFileAddress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)parsingResult, (String)"parsingResult");
        if (Intrinsics.areEqual((Object)location, (Object)SettingsFileLocation.Local.INSTANCE)) {
            sharedSettingsFile2 = (SharedSettingsFile)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)SharedSettingsFile.Companion.getLocationAttr()), (Object)location);
            if (sharedSettingsFile2 == null) {
                sharedSettingsFile2 = (SharedSettingsFile)$this$updateSettingsForFileAddress.new((EntityType)SharedSettingsFile.Companion, arg_0 -> SettingsUpdaterKt.updateSettingsForFileAddress$lambda$0(location, storageKey, arg_0));
            }
        } else {
            sharedSettingsFile2 = (SharedSettingsFile)SharedKt.shared((ChangeScope)$this$updateSettingsForFileAddress, (Function1)((Function1)new Function1<SharedChangeScope, SharedSettingsFile>(location, storageKey){
                final /* synthetic */ SettingsFileLocation $location;
                final /* synthetic */ StorageKey $storageKey;
                {
                    this.$location = $location;
                    this.$storageKey = $storageKey;
                    super(1);
                }

                @NotNull
                public final SharedSettingsFile invoke(@NotNull SharedChangeScope $this$shared) {
                    Intrinsics.checkNotNullParameter((Object)$this$shared, (String)"$this$shared");
                    SharedSettingsFile sharedSettingsFile2 = (SharedSettingsFile)EntityAttributeKt.entity((EntityAttribute)((EntityAttribute)SharedSettingsFile.Companion.getLocationAttr()), (Object)this.$location);
                    if (sharedSettingsFile2 == null) {
                        sharedSettingsFile2 = (SharedSettingsFile)$this$shared.new((EntityType)SharedSettingsFile.Companion, arg_0 -> updateSettingsForFileAddress.sharedSettingsFile.2.invoke$lambda$0(this.$location, this.$storageKey, arg_0));
                    }
                    return sharedSettingsFile2;
                }

                private static final void invoke$lambda$0(SettingsFileLocation $location, StorageKey $storageKey, EntityBuilder.Target it) {
                    Intrinsics.checkNotNullParameter((Object)$location, (String)"$location");
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.set(SharedSettingsFile.Companion.getLocationAttr(), (Object)$location);
                    it.set(Durable.INSTANCE.getStorageKeyAttr(), (Object)$storageKey);
                }
            }));
        }
        SharedSettingsFile sharedSettingsFile3 = sharedSettingsFile2;
        SettingsUpdaterKt.updateSettings($this$updateSettingsForFileAddress, sharedSettingsFile3, parsingResult);
        return sharedSettingsFile3;
    }

    public static /* synthetic */ SharedSettingsFile updateSettingsForFileAddress$default(ChangeScope changeScope, SettingsFileLocation settingsFileLocation, ParsingResult parsingResult, StorageKey storageKey, int n, Object object) {
        if ((n & 4) != 0) {
            storageKey = null;
        }
        return SettingsUpdaterKt.updateSettingsForFileAddress(changeScope, settingsFileLocation, parsingResult, storageKey);
    }

    public static final void updateSettings(@NotNull ChangeScope $this$updateSettings, @NotNull SharedSettingsFile fileEntity, @NotNull ParsingResult parsingResult) {
        Intrinsics.checkNotNullParameter((Object)$this$updateSettings, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileEntity, (String)"fileEntity");
        Intrinsics.checkNotNullParameter((Object)parsingResult, (String)"parsingResult");
        UnsharedHackKt.maybeShared($this$updateSettings, fileEntity, (Function1)new Function1<SharedChangeScope, Unit>(fileEntity, parsingResult){
            final /* synthetic */ SharedSettingsFile $fileEntity;
            final /* synthetic */ ParsingResult $parsingResult;
            {
                this.$fileEntity = $fileEntity;
                this.$parsingResult = $parsingResult;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull SharedChangeScope $this$maybeShared) {
                Intrinsics.checkNotNullParameter((Object)$this$maybeShared, (String)"$this$maybeShared");
                if (!EntitiesKt.exists((Entity)this.$fileEntity)) {
                    return;
                }
                ParsingResult parsingResult = this.$parsingResult;
                if (parsingResult instanceof ParsingResult.Success) {
                    Iterator<T> $this$associateTo$iv$iv;
                    ArrayList<E> configs = new ArrayList<E>();
                    SettingsUpdaterKt.flatten((List<ConfigProperty>)configs, ((ParsingResult.Success)this.$parsingResult).getProperties(), SetsKt.emptySet());
                    Iterable $this$associate$iv = configs;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                    boolean $i$f$associateTo = false;
                    Iterator<T> iterator = $this$associateTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv = iterator.next();
                        Map map2 = destination$iv$iv;
                        ConfigProperty it = (ConfigProperty)element$iv$iv;
                        boolean bl = false;
                        it = TuplesKt.to((Object)new Pair((Object)it.getKey(), it.getContexts()), (Object)it.getValue());
                        map2.put(it.getFirst(), it.getSecond());
                    }
                    Map propertyMap = MapsKt.toMutableMap((Map)destination$iv$iv);
                    Set dbProperties = EntityAttributeKt.entities((EntityAttribute)((EntityAttribute)FileSettingsPropertyEntity.Companion.getFileEntityAttr()), (Object)this.$fileEntity);
                    Iterable $this$forEach$iv = dbProperties;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        FileSettingsPropertyEntity dbProperty = (FileSettingsPropertyEntity)element$iv;
                        boolean bl = false;
                        Pair key = TuplesKt.to((Object)dbProperty.getKey(), dbProperty.getContexts());
                        JsonElement newValue = (JsonElement)propertyMap.remove(key);
                        if (newValue != null) {
                            if (Intrinsics.areEqual((Object)dbProperty.getValue(), (Object)newValue)) continue;
                            dbProperty.setValue(newValue);
                            continue;
                        }
                        $this$maybeShared.delete((Entity)dbProperty);
                    }
                    propertyMap.forEach((arg_0, arg_1) -> updateSettings.1.invoke$lambda$2((Function2)new Function2<Pair<? extends String, ? extends Set<? extends String>>, JsonElement, Unit>($this$maybeShared, this.$fileEntity){
                        final /* synthetic */ SharedChangeScope $this_maybeShared;
                        final /* synthetic */ SharedSettingsFile $fileEntity;
                        {
                            this.$this_maybeShared = $this_maybeShared;
                            this.$fileEntity = $fileEntity;
                            super(2);
                        }

                        public final void invoke(@NotNull Pair<String, ? extends Set<String>> pair, @NotNull JsonElement value) {
                            Intrinsics.checkNotNullParameter(pair, (String)"<name for destructuring parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            String key = (String)pair.component1();
                            Set contexts = (Set)pair.component2();
                            SharedKt.withKey((SharedChangeScope)this.$this_maybeShared, (Object)TuplesKt.to((Object)key, (Object)this.$fileEntity), (Function1)((Function1)new Function1<SharedChangeScope, Unit>(this.$fileEntity, key, value, (Set<String>)contexts){
                                final /* synthetic */ SharedSettingsFile $fileEntity;
                                final /* synthetic */ String $key;
                                final /* synthetic */ JsonElement $value;
                                final /* synthetic */ Set<String> $contexts;
                                {
                                    this.$fileEntity = $fileEntity;
                                    this.$key = $key;
                                    this.$value = $value;
                                    this.$contexts = $contexts;
                                    super(1);
                                }

                                public final void invoke(@NotNull SharedChangeScope $this$withKey) {
                                    Intrinsics.checkNotNullParameter((Object)$this$withKey, (String)"$this$withKey");
                                    $this$withKey.new((EntityType)FileSettingsPropertyEntity.Companion, arg_0 -> updateSettings.1.invoke$lambda$0(this.$fileEntity, this.$key, this.$value, this.$contexts, arg_0));
                                }

                                private static final void invoke$lambda$0(SharedSettingsFile $fileEntity, String $key, JsonElement $value, Set $contexts, EntityBuilder.Target it) {
                                    Intrinsics.checkNotNullParameter((Object)$fileEntity, (String)"$fileEntity");
                                    Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
                                    Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
                                    Intrinsics.checkNotNullParameter((Object)$contexts, (String)"$contexts");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    it.set(FileSettingsPropertyEntity.Companion.getIndexAttr(), (Object)TuplesKt.to((Object)$fileEntity.getLocation(), (Object)$key));
                                    it.set(FileSettingsPropertyEntity.Companion.getIdAttr(), (Object)TuplesKt.to((Object)EntityAttributeKt.getRequired((Entity)$fileEntity, (Attributes.Required)Durable.INSTANCE.getId()), (Object)$key));
                                    it.set(FileSettingsPropertyEntity.Companion.getKeyAttr(), (Object)$key);
                                    it.set(FileSettingsPropertyEntity.Companion.getValueAttr(), (Object)$value);
                                    it.set(FileSettingsPropertyEntity.Companion.getContextsAttr(), (Object)$contexts);
                                    it.set(FileSettingsPropertyEntity.Companion.getFileEntityAttr(), (Object)$fileEntity);
                                    it.set(Durable.INSTANCE.getStorageKeyAttr(), EntityAttributeKt.getOptional((Entity)$fileEntity, (Attributes.Optional)Durable.INSTANCE.getStorageKeyAttr()));
                                }
                            }));
                        }
                    }, arg_0, arg_1));
                    SettingsFileParsingErrorEntity settingsFileParsingErrorEntity = SettingsEntityKt.getParsingErrorEntity(this.$fileEntity);
                    if (settingsFileParsingErrorEntity != null) {
                        $this$maybeShared.delete((Entity)settingsFileParsingErrorEntity);
                    }
                } else if (parsingResult instanceof ParsingResult.Fail) {
                    void $this$singleOrNullOrThrowWithMessage$iv$iv$iv;
                    void value$iv;
                    void property$iv;
                    SharedChangeScope configs = $this$maybeShared;
                    KMutableProperty1 propertyMap = (KMutableProperty1)updateSettings.3.INSTANCE;
                    SharedSettingsFile dbProperties = this.$fileEntity;
                    Function1 f$iv = (Function1)new Function1<SettingsFileParsingErrorEntity, Unit>(this.$fileEntity, this.$parsingResult){
                        final /* synthetic */ SharedSettingsFile $fileEntity;
                        final /* synthetic */ ParsingResult $parsingResult;
                        {
                            this.$fileEntity = $fileEntity;
                            this.$parsingResult = $parsingResult;
                            super(1);
                        }

                        public final void invoke(@NotNull SettingsFileParsingErrorEntity $this$getOrCreate) {
                            Intrinsics.checkNotNullParameter((Object)$this$getOrCreate, (String)"$this$getOrCreate");
                            $this$getOrCreate.setSharedSettingsFile(this.$fileEntity);
                            $this$getOrCreate.setParsingError(((ParsingResult.Fail)this.$parsingResult).getMessage());
                        }
                    };
                    boolean $i$f$getOrCreate = false;
                    boolean $i$f$lookupOne = false;
                    Iterable element$iv = EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)((KProperty1)property$iv), (Object)value$iv, (KClass)Reflection.getOrCreateKotlinClass(SettingsFileParsingErrorEntity.class));
                    boolean $i$f$singleOrNullOrThrowWithMessage = false;
                    Object single$iv$iv$iv = null;
                    boolean found$iv$iv$iv = false;
                    for (T element$iv$iv$iv : $this$singleOrNullOrThrowWithMessage$iv$iv$iv) {
                        if (found$iv$iv$iv) {
                            T t = element$iv$iv$iv;
                            Object var16_32 = single$iv$iv$iv;
                            boolean bl = false;
                            String string = " searched prop " + (KMutableProperty1)property$iv + " and value " + value$iv;
                            String string2 = "Collection contains more than one matching element: " + var16_32 + ", " + t + " " + string;
                            throw new IllegalArgumentException(string2);
                        }
                        single$iv$iv$iv = element$iv$iv$iv;
                        found$iv$iv$iv = true;
                    }
                    SharedEntity sharedEntity = (SharedEntity)((LegacyEntity)single$iv$iv$iv);
                    if (sharedEntity == null) {
                        void $this$getOrCreate$iv;
                        sharedEntity = (SharedEntity)ChangeScope.DefaultImpls.new$default((ChangeScope)((ChangeScope)$this$getOrCreate$iv), (KClass)Reflection.getOrCreateKotlinClass(SettingsFileParsingErrorEntity.class), (int)0, (Function1)((Function1)new Function1<SettingsFileParsingErrorEntity, Unit>(f$iv){
                            final /* synthetic */ Function1 $f;
                            {
                                this.$f = $f;
                                super(1);
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void invoke(@NotNull SharedEntity $this$new) {
                                Intrinsics.checkNotNullParameter((Object)$this$new, (String)"$this$new");
                                this.$f.invoke((Object)$this$new);
                            }
                        }), (int)2, null);
                    }
                    ((SettingsFileParsingErrorEntity)sharedEntity).setParsingError(((ParsingResult.Fail)this.$parsingResult).getMessage());
                }
            }

            private static final void invoke$lambda$2(Function2 $tmp0, Object p0, Object p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0, p1);
            }
        });
    }

    @VisibleForTesting
    public static final void flatten(@NotNull List<ConfigProperty> $this$flatten, @NotNull Map<String, ? extends JsonElement> mapping, @NotNull Set<String> contexts) {
        Intrinsics.checkNotNullParameter($this$flatten, (String)"<this>");
        Intrinsics.checkNotNullParameter(mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        Sequence $this$forEach$iv = MapsKt.asSequence(mapping);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            String context = SettingsUpdaterKt.toContext(key);
            if (context == null) {
                $this$flatten.add(new ConfigProperty(key, value, contexts));
                continue;
            }
            if (value instanceof JsonObject) {
                SettingsUpdaterKt.flatten($this$flatten, (Map)value, SetsKt.plus(contexts, (Object)context));
                continue;
            }
            KLogger this_$iv = SettingsUpdaterKt.getLog();
            boolean $i$f$warn = false;
            if (!this_$iv.isWarnEnabled()) continue;
            KLogger kLogger = this_$iv;
            boolean bl2 = false;
            kLogger.warn((Object)("Key \"" + key + "\" should be an object!"));
        }
    }

    private static final String toContext(String $this$toContext) {
        String string;
        if (StringsKt.startsWith$default((CharSequence)$this$toContext, (char)'[', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)$this$toContext, (char)']', (boolean)false, (int)2, null)) {
            String string2 = $this$toContext.substring(1, $this$toContext.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    private static final void updateSettingsForFileAddress$lambda$0(SettingsFileLocation $location, StorageKey $storageKey, EntityBuilder.Target it) {
        Intrinsics.checkNotNullParameter((Object)$location, (String)"$location");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(SharedSettingsFile.Companion.getLocationAttr(), (Object)$location);
        it.set(Durable.INSTANCE.getStorageKeyAttr(), (Object)$storageKey);
    }
}

