/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.fs;

import com.jetbrains.rhizomedb.DbContext;
import com.jetbrains.rhizomedb.Q;
import com.jetbrains.rhizomedb.impl.EntitiesImplKt;
import fleet.api.FileAddress;
import fleet.api.FileAddressKt;
import fleet.api.HostId;
import fleet.api.Os;
import fleet.api.PlatformKt;
import fleet.api.ProtocolPath;
import fleet.api.Root;
import fleet.api.workspace.document.ContentStorageApi;
import fleet.api.workspace.document.FsApiWithHistory;
import fleet.common.ExecService;
import fleet.common.FsService;
import fleet.common.ServicesImplKt;
import fleet.common.backend.ExternalLibrariesKt;
import fleet.common.backend.ExternalLibraryEntity;
import fleet.common.backend.ExternalLibraryRootEntity;
import fleet.common.fs.FsdKt;
import fleet.common.fs.RelativePath;
import fleet.common.fs.SharedWorkspaceRootEntity;
import fleet.common.topology.Filesystem;
import fleet.common.topology.HostEntity;
import fleet.common.topology.HostKt;
import fleet.common.topology.HostServiceEntity;
import fleet.common.undo.ContentStorageService;
import fleet.common.undo.FsApiWithHistoryImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\t\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\t\u001a!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015\u001a!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0018\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\t\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\t\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\t\u001a\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b\u001a.\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\r\u001a\u00020\t2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020$2\b\b\u0002\u0010\f\u001a\u00020$\u001a&\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010\r\u001a\u00020\t2\b\b\u0002\u0010%\u001a\u00020$2\b\b\u0002\u0010\f\u001a\u00020$H\u0002\u001a(\u0010'\u001a\u0004\u0018\u0001H(\"\u000e\b\u0000\u0010(\u0018\u0001*\u0006\u0012\u0002\b\u00030)2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086\b\u00a2\u0006\u0002\u0010*\u001a1\u0010'\u001a\u0004\u0018\u0001H(\"\f\b\u0000\u0010(*\u0006\u0012\u0002\b\u00030)2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H(0,\u00a2\u0006\u0002\u0010-\u001a\u0018\u0010.\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020$\"#\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"convertGlobToRegEx", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "getConvertGlobToRegEx", "()Ljava/lang/reflect/Method;", "convertGlobToRegEx$delegate", "Lkotlin/Lazy;", "separator", "", "Lfleet/api/FileAddress;", "getSeparator", "(Lfleet/api/FileAddress;)Ljava/lang/String;", "collapseUserHome", "fileAddress", "execService", "Lfleet/common/ExecService;", "expandUserHome", "Lkotlin/Result;", "fsService", "Lfleet/common/FsService;", "path", "(Lfleet/common/FsService;Ljava/lang/String;)Ljava/lang/Object;", "fs", "Lfleet/common/topology/Filesystem;", "(Lfleet/common/topology/Filesystem;Ljava/lang/String;)Ljava/lang/Object;", "fsContentStorage", "Lfleet/api/workspace/document/ContentStorageApi;", "hostId", "Lfleet/api/HostId;", "fsServiceWithHistory", "Lfleet/api/workspace/document/FsApiWithHistory;", "globToRegex", "glob", "relativePath", "Lfleet/common/fs/RelativePath;", "includeFileName", "", "allowEmptyRelativePath", "relativePathInner", "service", "T", "Lfleet/common/topology/HostServiceEntity;", "(Lfleet/api/HostId;)Lfleet/common/topology/HostServiceEntity;", "kclass", "Lkotlin/reflect/KClass;", "(Lfleet/api/HostId;Lkotlin/reflect/KClass;)Lfleet/common/topology/HostServiceEntity;", "trimFileAddress", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nFsd.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fsd.kt\nfleet/common/fs/FsdKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Entities.kt\ncom/jetbrains/rhizomedb/EntitiesKt\n*L\n1#1,190:1\n39#1:191\n39#1:192\n39#1:193\n1549#2:194\n1620#2,3:195\n766#2:198\n857#2,2:199\n1603#2,9:201\n1855#2:210\n1856#2:212\n1612#2:213\n766#2:215\n857#2:216\n2624#2,3:217\n858#2:220\n1655#2,8:221\n1#3:211\n1#3:214\n179#4,2:229\n324#5:231\n243#5:232\n*S KotlinDebug\n*F\n+ 1 Fsd.kt\nfleet/common/fs/FsdKt\n*L\n22#1:191\n24#1:192\n36#1:193\n91#1:194\n91#1:195,3\n102#1:198\n102#1:199,2\n107#1:201,9\n107#1:210\n107#1:212\n107#1:213\n112#1:215\n112#1:216\n113#1:217,3\n112#1:220\n117#1:221,8\n107#1:211\n120#1:229,2\n131#1:231\n131#1:232\n*E\n"})
public final class FsdKt {
    @NotNull
    private static final Lazy convertGlobToRegEx$delegate = LazyKt.lazy((Function0)convertGlobToRegEx.2.INSTANCE);

    @Nullable
    public static final FsService fsService(@NotNull FileAddress fileAddress) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        HostId hostId$iv = fileAddress.getHostId();
        boolean $i$f$service = false;
        return (FsService)FsdKt.service(hostId$iv, Reflection.getOrCreateKotlinClass(FsService.class));
    }

    @Nullable
    public static final FsService fsService(@NotNull HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        boolean $i$f$service = false;
        return (FsService)FsdKt.service(hostId, Reflection.getOrCreateKotlinClass(FsService.class));
    }

    @Nullable
    public static final ContentStorageApi fsContentStorage(@NotNull FileAddress fileAddress) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        return ContentStorageService.Companion.service();
    }

    @Nullable
    public static final FsApiWithHistory fsServiceWithHistory(@NotNull FileAddress fileAddress) {
        FsApiWithHistoryImpl fsApiWithHistoryImpl;
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        Filesystem filesystem = Filesystem.Companion.lookup(fileAddress.getHostId());
        if (filesystem != null) {
            Filesystem fs2 = filesystem;
            boolean bl = false;
            ContentStorageApi contentStorageApi = FsdKt.fsContentStorage(fileAddress);
            if (contentStorageApi != null) {
                ContentStorageApi contentStorageService = contentStorageApi;
                boolean bl2 = false;
                fsApiWithHistoryImpl = new FsApiWithHistoryImpl(fs2.getFs(), fs2.getHostId(), contentStorageService);
            } else {
                fsApiWithHistoryImpl = null;
            }
        } else {
            fsApiWithHistoryImpl = null;
        }
        return fsApiWithHistoryImpl;
    }

    @Nullable
    public static final ExecService execService(@NotNull FileAddress fileAddress) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        HostId hostId$iv = fileAddress.getHostId();
        boolean $i$f$service = false;
        return (ExecService)FsdKt.service(hostId$iv, Reflection.getOrCreateKotlinClass(ExecService.class));
    }

    public static final /* synthetic */ <T extends HostServiceEntity<?>> T service(HostId hostId) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        boolean $i$f$service = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return FsdKt.service(hostId, Reflection.getOrCreateKotlinClass(HostServiceEntity.class));
    }

    @Nullable
    public static final <T extends HostServiceEntity<?>> T service(@NotNull HostId hostId, @NotNull KClass<T> kclass) {
        Intrinsics.checkNotNullParameter((Object)hostId, (String)"hostId");
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        HostEntity hostEntity = HostKt.hostOrNull(hostId);
        return (T)(hostEntity != null ? HostKt.service(hostEntity, kclass) : null);
    }

    @NotNull
    public static final String trimFileAddress(@NotNull FileAddress fileAddress, boolean collapseUserHome) {
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        Object object = FsdKt.relativePath$default(fileAddress, false, false, collapseUserHome, 6, null);
        if (object == null || (object = ((RelativePath)object).joinToString(collapseUserHome)) == null) {
            if (collapseUserHome) {
                object = FsdKt.collapseUserHome(fileAddress);
                if (object == null) {
                    object = "";
                }
            } else {
                object = fileAddress.getPath().joinToString();
            }
        }
        return object;
    }

    public static /* synthetic */ String trimFileAddress$default(FileAddress fileAddress, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return FsdKt.trimFileAddress(fileAddress, bl);
    }

    @NotNull
    public static final String getSeparator(@NotNull FileAddress $this$separator) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$separator, (String)"<this>");
        Root root = $this$separator.getPath().getRoot();
        if (root instanceof Root.Windows) {
            string = "\\";
        } else if (root instanceof Root.Unix) {
            string = "/";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public static final RelativePath relativePath(@NotNull FileAddress fileAddress, boolean includeFileName, boolean allowEmptyRelativePath, boolean collapseUserHome) {
        RelativePath relativePath;
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        RelativePath path = FsdKt.relativePathInner(fileAddress, allowEmptyRelativePath, collapseUserHome);
        if (includeFileName) {
            relativePath = path;
        } else {
            RelativePath relativePath2 = path;
            relativePath = relativePath2 != null ? RelativePath.copy$default(relativePath2, null, CollectionsKt.dropLast(path.getComponents(), (int)1), 1, null) : null;
        }
        return relativePath;
    }

    public static /* synthetic */ RelativePath relativePath$default(FileAddress fileAddress, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return FsdKt.relativePath(fileAddress, bl, bl2, bl3);
    }

    /*
     * Unable to fully structure code
     */
    private static final RelativePath relativePathInner(FileAddress fileAddress, boolean allowEmptyRelativePath, boolean collapseUserHome) {
        block25: {
            block24: {
                $this$map$iv = SharedWorkspaceRootEntity.Companion.all();
                $i$f$map = false;
                var6_7 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_16 = (SharedWorkspaceRootEntity)item$iv$iv;
                    var25_29 = destination$iv$iv;
                    $i$a$-map-FsdKt$relativePathInner$workspaceRoots$1 = false;
                    var25_29.add(root.getDirAddress());
                }
                workspaceRoots = (List)destination$iv$iv;
                v0 = pair = allowEmptyRelativePath != false ? FileAddressKt.maybeEmptyRelativePath((FileAddress)fileAddress, (List)workspaceRoots) : FileAddressKt.relativePath((FileAddress)fileAddress, (List)workspaceRoots);
                if (pair == null) break block25;
                if (workspaceRoots.size() == 1) {
                    return new RelativePath((FileAddress)pair.getFirst(), (List)pair.getSecond());
                }
                v1 = FileAddressKt.parent((FileAddress)((FileAddress)pair.getFirst()));
                if (v1 == null) {
                    return null;
                }
                parent = v1;
                $this$filter$iv = workspaceRoots;
                $i$f$filter = false;
                var9_12 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (FileAddress)element$iv$iv;
                    $i$a$-filter-FsdKt$relativePathInner$homonymousWorkspaces$1 = false;
                    if (!Intrinsics.areEqual((Object)((FileAddress)pair.getFirst()).getPath().getName(), (Object)it.getPath().getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                homonymousWorkspaces = (List)destination$iv$iv;
                if (homonymousWorkspaces.size() == 1) {
                    return new RelativePath(parent, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((FileAddress)pair.getFirst()).getPath().getName()), (Iterable)((Iterable)pair.getSecond())));
                }
                $this$mapNotNull$iv = homonymousWorkspaces;
                $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                $i$a$-filter-FsdKt$relativePathInner$homonymousWorkspaces$1 = $this$forEach$iv$iv$iv.iterator();
                while ($i$a$-filter-FsdKt$relativePathInner$homonymousWorkspaces$1.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = $i$a$-filter-FsdKt$relativePathInner$homonymousWorkspaces$1.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    it = (FileAddress)element$iv$iv;
                    $i$a$-mapNotNull-FsdKt$relativePathInner$workspaceParents$1 = false;
                    if (FileAddressKt.parent((FileAddress)it) == null) continue;
                    $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                workspaceParents = (List)destination$iv$iv;
                if (!collapseUserHome || PlatformKt.isWindows((Os)Os.Companion.local())) {
                    v2 = null;
                } else {
                    v3 = FsdKt.fsService(fileAddress);
                    if (v3 != null && (v3 = v3.getUserHome()) != null) {
                        it = v3;
                        $i$a$-let-FsdKt$relativePathInner$userHome$1 = false;
                        v2 = new FileAddress(fileAddress.getHostId(), (ProtocolPath)it);
                    } else {
                        v2 = null;
                    }
                }
                userHome = v2;
                $this$filter$iv = workspaceParents;
                $i$f$filter = false;
                it = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    block23: {
                        refDir = (FileAddress)element$iv$iv;
                        $i$a$-filter-FsdKt$relativePathInner$referenceDirectories$1 = false;
                        if (Intrinsics.areEqual((Object)refDir, (Object)userHome)) ** GOTO lbl-1000
                        $this$none$iv = workspaceParents;
                        $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            v4 = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                it = (FileAddress)element$iv;
                                $i$a$-none-FsdKt$relativePathInner$referenceDirectories$1$1 = false;
                                if (!SequencesKt.contains((Sequence)FileAddressKt.getParents((FileAddress)refDir), (Object)it)) continue;
                                v4 = false;
                                break block23;
                            }
                            v4 = true;
                        }
                    }
                    if (v4) {
                        v5 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = false;
                    }
                    if (!v5) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                referenceDirectories = (List)destination$iv$iv;
                $this$distinctBy$iv = referenceDirectories;
                $i$f$distinctBy = false;
                set$iv = new HashSet();
                list$iv = new ArrayList<T>();
                for (T e$iv : $this$distinctBy$iv) {
                    it = (FileAddress)e$iv;
                    $i$a$-distinctBy-FsdKt$relativePathInner$1 = false;
                    key$iv = FileAddressKt.getName((FileAddress)it);
                    if (!set$iv.add(key$iv)) continue;
                    list$iv.add(e$iv);
                }
                if (((List)list$iv).size() < referenceDirectories.size()) {
                    return null;
                }
                set$iv = FileAddressKt.getParents((FileAddress)((FileAddress)pair.getFirst()));
                $i$f$firstOrNull = false;
                for (E element$iv : $this$firstOrNull$iv) {
                    it = (FileAddress)element$iv;
                    $i$a$-firstOrNull-FsdKt$relativePathInner$outerParent$1 = false;
                    if (!(referenceDirectories.contains(it) != false || Intrinsics.areEqual((Object)it, (Object)userHome) != false)) continue;
                    v6 = element$iv;
                    break block24;
                }
                v6 = null;
            }
            $i$f$distinctBy = v6;
            if ($i$f$distinctBy == null || ($this$firstOrNull$iv = FileAddressKt.parent((FileAddress)$i$f$distinctBy)) == null) {
                return null;
            }
            outerParent = $this$firstOrNull$iv;
            v7 = FileAddressKt.relativePath((FileAddress)((FileAddress)pair.getFirst()), (FileAddress)outerParent);
            if (v7 == null) {
                return null;
            }
            relativePath = v7;
            return new RelativePath(outerParent, CollectionsKt.plus((Collection)relativePath, (Iterable)((Iterable)pair.getSecond())));
        }
        for (path = fileAddress.getPath(); path != null; path = path.parent()) {
            var6_7 = ExternalLibrariesKt.lookupLibraryRoots(new FileAddress(fileAddress.getHostId(), path)).iterator();
            while (var6_7.hasNext()) {
                referenceDirectories = libraryRoot = (ExternalLibraryRootEntity)var6_7.next();
                prop$iv = (KProperty1)relativePathInner.libraries.1.INSTANCE;
                $i$f$lookupInCollection = false;
                $i$f$lookupInCollection = false;
                v8 = CollectionsKt.toHashSet((Iterable)EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)prop$iv, (Object)$this$lookup$iv, (KClass)Reflection.getOrCreateKotlinClass(ExternalLibraryEntity.class)));
                $this$lookup$iv = libraryRoot;
                prop$iv = (KProperty1)relativePathInner.libraries.2.INSTANCE;
                $i$f$lookupInCollection = false;
                $i$f$lookupInCollection = false;
                libraries = SetsKt.plus((Set)v8, (Iterable)CollectionsKt.toHashSet((Iterable)EntitiesImplKt.lookupImpl((Q)DbContext.Companion.getThreadBound().getImpl(), (KProperty1)prop$iv, (Object)$this$lookup$iv, (KClass)Reflection.getOrCreateKotlinClass(ExternalLibraryEntity.class))));
                var9_12 = libraries.iterator();
                if (!var9_12.hasNext()) continue;
                library = (ExternalLibraryEntity)var9_12.next();
                root = libraryRoot.getFileAddress();
                v9 = fileAddress.getPath();
                v10 = root.getPath().parent();
                Intrinsics.checkNotNull((Object)v10);
                relativeSegments = v9.relativeSegmentsTo(v10);
                return new RelativePath(root, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)library.getName()), (Iterable)relativeSegments));
            }
        }
        return null;
    }

    static /* synthetic */ RelativePath relativePathInner$default(FileAddress fileAddress, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return FsdKt.relativePathInner(fileAddress, bl, bl2);
    }

    @Nullable
    public static final String collapseUserHome(@NotNull FileAddress fileAddress) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fileAddress, (String)"fileAddress");
        Os os = Os.Companion.local();
        if (!PlatformKt.isWindows((Os)os)) {
            FsService fsService2 = FsdKt.fsService(fileAddress);
            ProtocolPath userHome2 = fsService2 != null ? fsService2.getUserHome() : null;
            List relativeSegments = fileAddress.getPath().relativeSegmentsTo(userHome2);
            if (!((Collection)relativeSegments).isEmpty()) {
                char separator = PlatformKt.getSeparator((Os)os);
                return "~" + separator + ProtocolPath.Companion.joinToString(relativeSegments, separator);
            }
        }
        String it = string = fileAddress.getPath().joinToString();
        boolean bl = false;
        return !StringsKt.isBlank((CharSequence)it) ? string : null;
    }

    @NotNull
    public static final Object expandUserHome(@NotNull Filesystem fs2, @NotNull String path) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)fs2, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (PlatformKt.isUnix((Os)fs2.getOs()) && StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null)) {
            Object object3 = fs2.getUserHome();
            if (object3 == null || (object3 = object3.getPath()) == null || (object3 = object3.joinToString(PlatformKt.getSeparator((Os)fs2.getOs()))) == null) {
                object3 = "";
            }
            Object userhome = object3;
            object2 = (String)userhome + StringsKt.drop((String)path, (int)1);
        } else {
            object2 = path;
        }
        String expanded = object2;
        Object object4 = ProtocolPath.Companion.parsePath-gIAlu-s(fs2.getOs(), expanded);
        if (Result.isSuccess-impl((Object)object4)) {
            ProtocolPath it = (ProtocolPath)object4;
            boolean bl = false;
            object = Result.constructor-impl((Object)new FileAddress(fs2.getHostId(), it));
        } else {
            object = Result.constructor-impl((Object)object4);
        }
        return object;
    }

    @NotNull
    public static final Object expandUserHome(@NotNull FsService fsService2, @NotNull String path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fsService2, (String)"fsService");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        HostServiceEntity hostServiceEntity = fsService2;
        if (!PlatformKt.isWindows((Os)fsService2.getOs()) && StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null)) {
            Object object2 = fsService2.getUserHome();
            if (object2 == null || (object2 = object2.joinToString(PlatformKt.getSeparator((Os)fsService2.getOs()))) == null) {
                object2 = "";
            }
            Object userhome = object2;
            object = (String)userhome + StringsKt.drop((String)path, (int)1);
        } else {
            object = path;
        }
        return ServicesImplKt.fileAddress(hostServiceEntity, (String)object);
    }

    private static final Method getConvertGlobToRegEx() {
        Lazy lazy = convertGlobToRegEx$delegate;
        return (Method)lazy.getValue();
    }

    @NotNull
    public static final String globToRegex(@NotNull String glob) {
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        StringBuilder result2 = new StringBuilder();
        Object[] objectArray = new Object[]{StringsKt.startsWith$default((String)glob, (String)"**", (boolean)false, (int)2, null) ? glob : "**/" + glob, new ArrayList(), result2};
        FsdKt.getConvertGlobToRegEx().invoke(null, objectArray);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

