/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.download;

import fleet.api.Arch;
import fleet.api.Checksum;
import fleet.api.ChecksumAlgorithm;
import fleet.api.Os;
import fleet.api.Platform;
import fleet.common.download.S3ArtifactType;
import fleet.common.download.S3Version;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a<\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0013\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEFAULT_ARTIFACT_STORAGE_BASE_URL", "", "LATEST", "s3ArtifactChecksum", "Lfleet/api/Checksum$Url;", "artifactUrl", "s3ArtifactUrl", "name", "artifactName", "artifactType", "Lfleet/common/download/S3ArtifactType;", "platform", "Lfleet/api/Platform;", "version", "Lfleet/common/download/S3Version;", "baseUrl", "binaryExtension", "Lfleet/api/Os;", "toFleetPartString", "Lfleet/api/Arch;", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nFleetPartsS3Extensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetPartsS3Extensions.kt\nfleet/common/download/FleetPartsS3ExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
public final class FleetPartsS3ExtensionsKt {
    @NotNull
    private static final String DEFAULT_ARTIFACT_STORAGE_BASE_URL = "https://plugins.jetbrains.com/fleet-parts";
    @NotNull
    private static final String LATEST = "latest";

    @NotNull
    public static final String toFleetPartString(@NotNull Platform $this$toFleetPartString) {
        Intrinsics.checkNotNullParameter((Object)$this$toFleetPartString, (String)"<this>");
        return FleetPartsS3ExtensionsKt.toFleetPartString($this$toFleetPartString.getOs()) + "_" + FleetPartsS3ExtensionsKt.toFleetPartString($this$toFleetPartString.getArch());
    }

    @NotNull
    public static final String toFleetPartString(@NotNull Os $this$toFleetPartString) {
        Intrinsics.checkNotNullParameter((Object)$this$toFleetPartString, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toFleetPartString.ordinal()]) {
            case 1 -> "windows";
            case 2 -> "linux";
            case 3 -> "macos";
            default -> throw new IllegalStateException(("unsupported os type: " + $this$toFleetPartString).toString());
        };
    }

    @NotNull
    public static final String toFleetPartString(@NotNull Arch $this$toFleetPartString) {
        Intrinsics.checkNotNullParameter((Object)$this$toFleetPartString, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toFleetPartString.ordinal()]) {
            case 1 -> "x64";
            case 2, 3 -> "aarch64";
            default -> throw new IllegalStateException(("unsupported arch: " + $this$toFleetPartString).toString());
        };
    }

    @NotNull
    public static final String binaryExtension(@NotNull Os $this$binaryExtension) {
        Intrinsics.checkNotNullParameter((Object)$this$binaryExtension, (String)"<this>");
        return WhenMappings.$EnumSwitchMapping$0[$this$binaryExtension.ordinal()] == 1 ? ".exe" : "";
    }

    @NotNull
    public static final String s3ArtifactUrl(@NotNull String name, @NotNull String artifactName, @NotNull S3ArtifactType artifactType, @Nullable Platform platform, @NotNull S3Version version, @NotNull String baseUrl) {
        String string;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        S3ArtifactType s3ArtifactType = artifactType;
        if (s3ArtifactType instanceof S3ArtifactType.Archive) {
            string3 = ((S3ArtifactType.Archive)artifactType).getType().getExtension();
        } else if (Intrinsics.areEqual((Object)s3ArtifactType, (Object)S3ArtifactType.Binary.INSTANCE)) {
            if (platform == null) {
                boolean $i$a$-requireNotNull-FleetPartsS3ExtensionsKt$s3ArtifactUrl$extension$22 = false;
                String $i$a$-requireNotNull-FleetPartsS3ExtensionsKt$s3ArtifactUrl$extension$22 = "platform must be specified when `artifactType == S3ArtifactType.Binary`";
                throw new IllegalArgumentException($i$a$-requireNotNull-FleetPartsS3ExtensionsKt$s3ArtifactUrl$extension$22.toString());
            }
            string3 = FleetPartsS3ExtensionsKt.binaryExtension(platform.getOs());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String extension = string3;
        S3Version $i$a$-requireNotNull-FleetPartsS3ExtensionsKt$s3ArtifactUrl$extension$22 = version;
        if (Intrinsics.areEqual((Object)$i$a$-requireNotNull-FleetPartsS3ExtensionsKt$s3ArtifactUrl$extension$22, (Object)S3Version.Latest.INSTANCE)) {
            string2 = "/latest";
        } else if ($i$a$-requireNotNull-FleetPartsS3ExtensionsKt$s3ArtifactUrl$extension$22 instanceof S3Version.Specific) {
            string2 = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String latestPrefix = string2;
        S3Version s3Version = version;
        if (Intrinsics.areEqual((Object)s3Version, (Object)S3Version.Latest.INSTANCE)) {
            string = LATEST;
        } else if (s3Version instanceof S3Version.Specific) {
            string = ((S3Version.Specific)version).getVersion();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String versionUrl = string;
        String platformUrl = platform == null ? "" : "/" + FleetPartsS3ExtensionsKt.toFleetPartString(platform);
        return baseUrl + latestPrefix + "/" + name + platformUrl + "/" + artifactName + "-" + versionUrl + extension;
    }

    public static /* synthetic */ String s3ArtifactUrl$default(String string, String string2, S3ArtifactType s3ArtifactType, Platform platform, S3Version s3Version, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        if ((n & 0x20) != 0) {
            string3 = DEFAULT_ARTIFACT_STORAGE_BASE_URL;
        }
        return FleetPartsS3ExtensionsKt.s3ArtifactUrl(string, string2, s3ArtifactType, platform, s3Version, string3);
    }

    @NotNull
    public static final Checksum.Url s3ArtifactChecksum(@NotNull String artifactUrl) {
        Intrinsics.checkNotNullParameter((Object)artifactUrl, (String)"artifactUrl");
        return new Checksum.Url(artifactUrl + ".sha256", (ChecksumAlgorithm)ChecksumAlgorithm.Sha256.INSTANCE);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Os.values().length];
            try {
                nArray[Os.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Macos.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Arch.values().length];
            try {
                nArray[Arch.x86_64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.aarch64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.arm.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

