/*
 * Decompiled with CFR 0.152.
 */
package fleet.common.document;

import andel.EditLog;
import andel.operation.Operation;
import andel.undo.AbstractUndoGroup;
import andel.undo.CustomIndexedValue;
import andel.undo.DocumentUndoLogDataReference;
import andel.undo.UndoGroupReference;
import andel.undo.UndoLog;
import andel.undo.UndoLogData;
import andel.undo.UndoLogDataReference;
import fleet.api.FileAddress;
import fleet.common.document.FileUndoGroupView;
import fleet.common.document.FileViewLogDataReference;
import fleet.common.document.GlobalUndoGroup;
import fleet.common.document.UndoLogEntityKt;
import fleet.common.user.UserEntity;
import fleet.util.CollectionsUtilKt;
import fleet.util.UID;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u000e\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\u0002\u0010\u000eJ \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0016J4\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.\u0018\u00010-j\u0004\u0018\u0001`/2\n\u00100\u001a\u00060\fj\u0002`\r2\n\u00101\u001a\u00060\fj\u0002`\rH\u0002J$\u00102\u001a\u0012\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.0-j\u0002`/2\n\u00103\u001a\u00060\fj\u0002`\rH\u0002J\u001c\u00104\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.\u0018\u00010-j\u0004\u0018\u0001`/H\u0016J(\u00105\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.\u0018\u00010-j\u0004\u0018\u0001`/2\n\u00106\u001a\u00060\fj\u0002`\rH\u0002J$\u00107\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.\u0018\u00010-j\u0004\u0018\u0001`/2\u0006\u00108\u001a\u00020\u001dH\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u001dH\u0002J$\u0010<\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020.\u0018\u00010-j\u0004\u0018\u0001`/2\u0006\u00108\u001a\u00020\u001dH\u0016J\u0010\u0010=\u001a\u00020.2\u0006\u00108\u001a\u00020\u001dH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001b\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u00a2\u0006\n\n\u0002\u0010#\u001a\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006>"}, d2={"Lfleet/common/document/FileViewUndoLog;", "Landel/undo/UndoLog;", "user", "Lfleet/common/user/UserEntity;", "documentId", "Lfleet/util/UID;", "documentUndoLog", "Lkotlin/Function0;", "Landel/undo/UndoLogData;", "fileAddress", "Lfleet/api/FileAddress;", "openedAfter", "", "Landel/undo/GlobalUndoLogRef;", "(Lfleet/common/user/UserEntity;Lfleet/util/UID;Lkotlin/jvm/functions/Function0;Lfleet/api/FileAddress;Ljava/lang/Long;)V", "getDocumentId", "()Lfleet/util/UID;", "getDocumentUndoLog", "()Lkotlin/jvm/functions/Function0;", "getFileAddress", "()Lfleet/api/FileAddress;", "globalUndoLog", "Lfleet/util/bifurcan/List;", "Lfleet/common/document/GlobalUndoGroup;", "Lfleet/common/document/GlobalUndoLog;", "getGlobalUndoLog", "()Lfleet/util/bifurcan/List;", "indicesComparator", "Ljava/util/Comparator;", "Landel/undo/UndoGroupReference;", "Lkotlin/Comparator;", "getIndicesComparator", "()Ljava/util/Comparator;", "getOpenedAfter", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getUser", "()Lfleet/common/user/UserEntity;", "computeComposition", "Landel/operation/Operation;", "edits", "Landel/EditLog;", "fromTimestamp", "toTimestamp", "firstAfter", "Landel/undo/CustomIndexedValue;", "Landel/undo/AbstractUndoGroup;", "Landel/undo/IndexedUndoGroup;", "trimFrom", "trimTo", "getIndexed", "globalGroupRef", "last", "lastBefore", "trimAt", "next", "reference", "owns", "", "undoGroupReference", "previous", "resolve", "fleet.common"})
@SourceDebugExtension(value={"SMAP\nUndoLogEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UndoLogEntity.kt\nfleet/common/document/FileViewUndoLog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,731:1\n1#2:732\n205#3,8:733\n350#4,7:741\n*S KotlinDebug\n*F\n+ 1 UndoLogEntity.kt\nfleet/common/document/FileViewUndoLog\n*L\n223#1:733,8\n232#1:741,7\n*E\n"})
public final class FileViewUndoLog
implements UndoLog {
    @NotNull
    private final UserEntity user;
    @Nullable
    private final UID documentId;
    @NotNull
    private final Function0<UndoLogData> documentUndoLog;
    @Nullable
    private final FileAddress fileAddress;
    @Nullable
    private final Long openedAfter;

    public FileViewUndoLog(@NotNull UserEntity user, @Nullable UID documentId, @NotNull Function0<UndoLogData> documentUndoLog2, @Nullable FileAddress fileAddress, @Nullable Long openedAfter) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(documentUndoLog2, (String)"documentUndoLog");
        this.user = user;
        this.documentId = documentId;
        this.documentUndoLog = documentUndoLog2;
        this.fileAddress = fileAddress;
        this.openedAfter = openedAfter;
        if (this.documentId != null && this.fileAddress != null) {
            if (this.openedAfter == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final UserEntity getUser() {
        return this.user;
    }

    @Nullable
    public final UID getDocumentId() {
        return this.documentId;
    }

    @NotNull
    public final Function0<UndoLogData> getDocumentUndoLog() {
        return this.documentUndoLog;
    }

    @Nullable
    public final FileAddress getFileAddress() {
        return this.fileAddress;
    }

    @Nullable
    public final Long getOpenedAfter() {
        return this.openedAfter;
    }

    private final fleet.util.bifurcan.List<GlobalUndoGroup> getGlobalUndoLog() {
        return UndoLogEntityKt.getGlobalUndoLog(this.user);
    }

    @Nullable
    public CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> last() {
        UndoLogData undoLogData = (UndoLogData)this.documentUndoLog.invoke();
        if (undoLogData != null && (undoLogData = undoLogData.last()) != null) {
            UndoLogData it = undoLogData;
            boolean bl = false;
            return it;
        }
        if (this.fileAddress == null) {
            return null;
        }
        return this.lastBefore(this.getGlobalUndoLog().size());
    }

    /*
     * WARNING - void declaration
     */
    private final CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> lastBefore(long trimAt) {
        int n;
        long l;
        block5: {
            void $this$indexOfFirst$iv;
            if (this.fileAddress == null) {
                return null;
            }
            Sequence sequence = CollectionsUtilKt.asReversedSequence((fleet.util.bifurcan.List)this.getGlobalUndoLog().slice(0L, trimAt));
            l = trimAt - 1L;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                GlobalUndoGroup it = (GlobalUndoGroup)item$iv;
                boolean bl = false;
                if (it.fileBefore(this.fileAddress) != null && it.fileAfter(this.fileAddress) != null) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        long indexOfLast = l - (long)n2;
        if (indexOfLast >= trimAt) {
            return null;
        }
        return this.getIndexed(indexOfLast);
    }

    /*
     * WARNING - void declaration
     */
    private final CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> firstAfter(long trimFrom, long trimTo) {
        int n;
        long l;
        block4: {
            void $this$indexOfFirst$iv;
            if (this.fileAddress == null) {
                return null;
            }
            List list = (List)this.getGlobalUndoLog().slice(trimFrom, trimTo);
            l = trimFrom;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                GlobalUndoGroup it = (GlobalUndoGroup)item$iv;
                boolean bl = false;
                if (it.fileBefore(this.fileAddress) != null && it.fileAfter(this.fileAddress) != null) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        long indexOfFirst = l + (long)n2;
        if (indexOfFirst < trimFrom) {
            return null;
        }
        return this.getIndexed(indexOfFirst);
    }

    private final CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> getIndexed(long globalGroupRef) {
        if (this.fileAddress == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return new CustomIndexedValue((Object)new UndoGroupReference((UndoLogDataReference)new FileViewLogDataReference(this.fileAddress), globalGroupRef), (Object)new FileUndoGroupView((GlobalUndoGroup)this.getGlobalUndoLog().nth(globalGroupRef), this.fileAddress));
    }

    private final boolean owns(UndoGroupReference undoGroupReference) {
        UndoLogDataReference logData = undoGroupReference.getLogData();
        return logData instanceof DocumentUndoLogDataReference ? Intrinsics.areEqual((Object)((DocumentUndoLogDataReference)logData).getDocumentId(), (Object)this.documentId) : (logData instanceof FileViewLogDataReference ? Intrinsics.areEqual((Object)((FileViewLogDataReference)logData).getFileAddress(), (Object)this.fileAddress) : false);
    }

    @NotNull
    public Comparator<UndoGroupReference> getIndicesComparator() {
        Comparator comparator = new Comparator(this){
            final /* synthetic */ FileViewUndoLog this$0;
            {
                this.this$0 = fileViewUndoLog;
            }

            public final int compare(T a, T b) {
                UndoGroupReference it = (UndoGroupReference)a;
                boolean bl = false;
                if (!FileViewUndoLog.access$owns(this.this$0, it)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Object[] objectArray = new Class[]{FileViewLogDataReference.class, DocumentUndoLogDataReference.class};
                Comparable comparable = Long.valueOf(CollectionsKt.listOf((Object[])objectArray).indexOf(it.getLogData().getClass()));
                it = (UndoGroupReference)b;
                Comparable comparable2 = comparable;
                bl = false;
                if (!FileViewUndoLog.access$owns(this.this$0, it)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                objectArray = new Class[]{FileViewLogDataReference.class, DocumentUndoLogDataReference.class};
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(CollectionsKt.listOf((Object[])objectArray).indexOf(it.getLogData().getClass())));
            }
        };
        return new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    UndoGroupReference it = (UndoGroupReference)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getUndoGroupPosition());
                    it = (UndoGroupReference)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getUndoGroupPosition()));
                }
                return n;
            }
        };
    }

    @NotNull
    public AbstractUndoGroup resolve(@NotNull UndoGroupReference reference) {
        AbstractUndoGroup abstractUndoGroup;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (!this.owns(reference)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        UndoLogDataReference undoLogDataReference = reference.getLogData();
        if (undoLogDataReference instanceof DocumentUndoLogDataReference) {
            Object object = this.documentUndoLog.invoke();
            Intrinsics.checkNotNull((Object)object);
            abstractUndoGroup = (AbstractUndoGroup)((UndoLogData)object).resolve(reference);
        } else if (undoLogDataReference instanceof FileViewLogDataReference) {
            GlobalUndoGroup globalUndoGroup = (GlobalUndoGroup)this.getGlobalUndoLog().nth(reference.getUndoGroupPosition());
            FileAddress fileAddress = this.fileAddress;
            Intrinsics.checkNotNull((Object)fileAddress);
            abstractUndoGroup = new FileUndoGroupView(globalUndoGroup, fileAddress);
        } else {
            throw new UnsupportedOperationException();
        }
        return abstractUndoGroup;
    }

    @NotNull
    public Operation computeComposition(@NotNull EditLog edits, long fromTimestamp, long toTimestamp) {
        Intrinsics.checkNotNullParameter((Object)edits, (String)"edits");
        Object object = this.documentUndoLog.invoke();
        Intrinsics.checkNotNull((Object)object);
        return ((UndoLogData)object).computeComposition(edits, fromTimestamp, toTimestamp);
    }

    @Nullable
    public CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> previous(@NotNull UndoGroupReference reference) {
        CustomIndexedValue customIndexedValue;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (!this.owns(reference)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (reference.getLogData() instanceof DocumentUndoLogDataReference && reference.getUndoGroupPosition() > 0L) {
            Object object = this.documentUndoLog.invoke();
            Intrinsics.checkNotNull((Object)object);
            customIndexedValue = ((UndoLogData)object).previous(reference);
        } else if (reference.getLogData() instanceof FileViewLogDataReference) {
            customIndexedValue = this.lastBefore(reference.getUndoGroupPosition());
        } else {
            Long l = this.openedAfter;
            customIndexedValue = this.lastBefore(l != null ? l : Long.MAX_VALUE);
        }
        return customIndexedValue;
    }

    @Nullable
    public CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> next(@NotNull UndoGroupReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        if (!this.owns(reference)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        UndoLogData documentUndoLog2 = (UndoLogData)this.documentUndoLog.invoke();
        if (reference.getLogData() instanceof DocumentUndoLogDataReference) {
            UndoLogData undoLogData = documentUndoLog2;
            Intrinsics.checkNotNull((Object)undoLogData);
            return undoLogData.next(reference);
        }
        Long l = this.openedAfter;
        CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> customIndexedValue = this.firstAfter(reference.getUndoGroupPosition() + 1L, l != null ? l.longValue() : this.getGlobalUndoLog().size());
        if (customIndexedValue != null) {
            CustomIndexedValue<UndoGroupReference, AbstractUndoGroup> it = customIndexedValue;
            boolean bl = false;
            return it;
        }
        if (documentUndoLog2 == null || documentUndoLog2.getSize() <= 0L) {
            return null;
        }
        return new CustomIndexedValue((Object)new UndoGroupReference(documentUndoLog2.getId(), 0L), (Object)documentUndoLog2.get(0L));
    }

    public static final /* synthetic */ boolean access$owns(FileViewUndoLog $this, UndoGroupReference undoGroupReference) {
        return $this.owns(undoGroupReference);
    }
}

