/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.swift.lang.parser;

import fleet.com.intellij.lang.Language;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.openapi.util.NlsSafe;
import fleet.com.intellij.psi.ITokenSequence;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.IReparseableElementType;
import fleet.com.intellij.util.containers.ContainerUtil;
import fleet.com.jetbrains.swift.SwiftLanguage;
import fleet.com.jetbrains.swift.SwiftParserTypes;
import fleet.com.jetbrains.swift.lexer.SwiftLexer;
import fleet.com.jetbrains.swift.lexer.SwiftTokenTypes;
import fleet.com.jetbrains.swift.parser.SwiftParser;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwiftLazyCodeBlockElementType
extends IReparseableElementType {
    private static final Set<@NlsSafe String> modifierStarts = ContainerUtil.newHashSet((Object[])new String[]{"set", "get", "willSet", "didSet", "mutating", "nonmutating"});

    public SwiftLazyCodeBlockElementType(@NonNls String debugName) {
        super(debugName, (Language)SwiftLanguage.INSTANCE);
    }

    public boolean isParsable(@Nullable IElementType parentType, @NotNull CharSequence charSequence, @NotNull ITokenSequence tokenSequence, int startLexeme, int lexemeCount) {
        if (parentType == SwiftParserTypes.IMPLICIT_GETTER_CLAUSE && SwiftLazyCodeBlockElementType.checkModifierStart(charSequence)) {
            return false;
        }
        return SwiftLazyCodeBlockElementType.hasProperBraceBalance((ITokenSequence)tokenSequence, (int)startLexeme, (int)lexemeCount, (IElementType)SwiftParserTypes.L_CURLY, (IElementType)SwiftParserTypes.R_CURLY);
    }

    public void parse(@NotNull PsiBuilder builder) {
        new SwiftParser().parseLight((IElementType)this, builder);
    }

    private static boolean checkModifierStart(@NotNull CharSequence buffer) {
        String text;
        SwiftLexer lexer = new SwiftLexer();
        lexer.start(buffer);
        IElementType t1 = SwiftLazyCodeBlockElementType.nextToken(lexer);
        if (t1 != SwiftParserTypes.L_CURLY) {
            return false;
        }
        lexer.advance();
        IElementType t2 = SwiftLazyCodeBlockElementType.nextToken(lexer);
        if (t2 == SwiftParserTypes.AT) {
            return true;
        }
        return t2 == SwiftParserTypes.IDENTIFIER && modifierStarts.contains(text = lexer.getTokenText());
    }

    @Nullable
    private static IElementType nextToken(@NotNull SwiftLexer lexer) {
        IElementType type;
        while (SwiftTokenTypes.COMMENT_LEAVES_WHITESPACES_ERRORS.contains(type = lexer.getTokenType())) {
            lexer.advance();
        }
        return type;
    }
}

