/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.services;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimscriptExecutor;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/maddyhome/idea/vim/vimscript/services/VimRcService;", "", "()V", "HOME_VIMRC_PATHS", "", "", "[Ljava/lang/String;", "VIMRC_FILE_NAME", "XDG_VIMRC_PATH", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "executeIdeaVimRc", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "findIdeaVimRc", "Ljava/io/File;", "findOrCreateIdeaVimRc", "getNewIdeaVimRcTemplate", "vimrc", "isIdeaVimRcFile", "", "file", "sourceVimrc", "homeDirName", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimRcService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimRcService.kt\ncom/maddyhome/idea/vim/vimscript/services/VimRcService\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,148:1\n38#2:149\n*S KotlinDebug\n*F\n+ 1 VimRcService.kt\ncom/maddyhome/idea/vim/vimscript/services/VimRcService\n*L\n20#1:149\n*E\n"})
public final class VimRcService {
    @NotNull
    public static final VimRcService INSTANCE = new VimRcService();
    @NotNull
    private static final VimLogger logger;
    @NonNls
    @NotNull
    public static final String VIMRC_FILE_NAME = "ideavimrc";
    @NonNls
    @NotNull
    private static final String[] HOME_VIMRC_PATHS;
    @NonNls
    @NotNull
    private static final String XDG_VIMRC_PATH;

    private VimRcService() {
    }

    @JvmStatic
    @Nullable
    public static final File findIdeaVimRc() {
        File file;
        String xdgConfigHomeProperty;
        String homeDirName = System.getProperty("user.home");
        if (homeDirName != null) {
            for (String fileName : HOME_VIMRC_PATHS) {
                File file2 = new File(homeDirName, fileName);
                if (!file2.exists()) continue;
                return file2;
            }
        }
        if ((xdgConfigHomeProperty = System.getenv("XDG_CONFIG_HOME")) == null || Intrinsics.areEqual((Object)xdgConfigHomeProperty, (Object)"")) {
            String string = homeDirName;
            if (string != null) {
                String[] stringArray = new String[]{".config", XDG_VIMRC_PATH};
                file = Paths.get(string, stringArray).toFile();
            } else {
                file = null;
            }
        } else {
            file = new File(xdgConfigHomeProperty, XDG_VIMRC_PATH);
        }
        File xdgConfig = file;
        return xdgConfig != null && xdgConfig.exists() ? xdgConfig : null;
    }

    private final String getNewIdeaVimRcTemplate(String vimrc) {
        return StringsKt.trimMargin$default((String)("\n    |\" .ideavimrc is a configuration file for IdeaVim plugin. It uses\n    |\"   the same commands as the original .vimrc configuration.\n    |\" You can find a list of commands here: https://jb.gg/h38q75\n    |\" Find more examples here: https://jb.gg/share-ideavimrc\n\n    |" + vimrc + "\n    |\"\" -- Suggested options --\n    |\" Show a few lines of context around the cursor. Note that this makes the\n    |\" text scroll if you mouse-click near the start or end of the window.\n    |set scrolloff=5\n\n    |\" Do incremental searching.\n    |set incsearch\n\n    |\" Don't use Ex mode, use Q for formatting.\n    |map Q gq\n\n    |\" --- Enable IdeaVim plugins https://jb.gg/ideavim-plugins\n\n    |\" Highlight copied text\n    |Plug 'machakann/vim-highlightedyank'\n    |\" Commentary plugin\n    |Plug 'tpope/vim-commentary'\n\n\n    |\"\" -- Map IDE actions to IdeaVim -- https://jb.gg/abva4t\n    |\"\" Map \\r to the Reformat Code action\n    |\"map \\r <Action>(ReformatCode)\n\n    |\"\" Map <leader>d to start debug\n    |\"map <leader>d <Action>(Debug)\n\n    |\"\" Map \\b to toggle the breakpoint on the current line\n    |\"map \\b <Action>(ToggleLineBreakpoint)\n\n  "), null, (int)1, null);
    }

    @Nullable
    public final File findOrCreateIdeaVimRc() {
        File found;
        File file = found = VimRcService.findIdeaVimRc();
        if (file != null) {
            return file;
        }
        String homeDirName = System.getProperty("user.home");
        Intrinsics.checkNotNull((Object)homeDirName);
        String vimrc = this.sourceVimrc(homeDirName);
        for (String fileName : HOME_VIMRC_PATHS) {
            try {
                File file2 = new File(homeDirName, fileName);
                file2.createNewFile();
                FilesKt.writeText$default((File)file2, (String)this.getNewIdeaVimRcTemplate(vimrc), null, (int)2, null);
                VimInjectorKt.getInjector().getVimrcFileState().setFilePath(file2.getAbsolutePath());
                return file2;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private final String sourceVimrc(String homeDirName) {
        if (new File(homeDirName, ".vimrc").exists()) {
            return "\" Source your .vimrc\n|source ~/.vimrc\n";
        }
        if (new File(homeDirName, "_vimrc").exists()) {
            return "\" Source your _vimrc\n|source ~/_vimrc\n";
        }
        return "";
    }

    @JvmStatic
    public static final void executeIdeaVimRc(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        File ideaVimRc = INSTANCE.findIdeaVimRc();
        if (ideaVimRc != null) {
            logger.info("Execute ideavimrc file: " + ideaVimRc.getAbsolutePath());
            VimscriptExecutor.executeFile$default(VimInjectorKt.getInjector().getVimscriptExecutor(), ideaVimRc, editor, true, false, 8, null);
        } else {
            logger.info("ideavimrc file isn't found");
        }
    }

    public final boolean isIdeaVimRcFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = VimRcService.findIdeaVimRc();
        if (file2 == null) {
            return false;
        }
        File ideaVimRc = file2;
        return Intrinsics.areEqual((Object)ideaVimRc, (Object)file);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimRcService.class);
        String[] stringArray = new String[]{".ideavimrc", "_ideavimrc"};
        HOME_VIMRC_PATHS = stringArray;
        XDG_VIMRC_PATH = "ideavim" + File.separator + VIMRC_FILE_NAME;
    }
}

