/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.GoalCommand;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.InvalidCommandException;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0001&B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020\u001aH\u0002J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/UnknownCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "name", "", "argument", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "getName", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "processPossiblyAliasCommand", "aliasCountdown", "toString", "Constants", "vim-engine"})
public final class UnknownCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final String name;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public UnknownCommand(@NotNull Ranges ranges, @NotNull String name, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.name = name;
        this.argument = argument;
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.SELF_SYNCHRONIZED, new Command.Flag[0]);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        return this.processPossiblyAliasCommand(this.name + " " + this.argument, editor, context, 100);
    }

    private final ExecutionResult processPossiblyAliasCommand(String name, VimEditor editor, ExecutionContext context, int aliasCountdown) {
        if (VimInjectorKt.getInjector().getCommandGroup().isAlias(name)) {
            if (aliasCountdown > 0) {
                GoalCommand commandAlias = VimInjectorKt.getInjector().getCommandGroup().getAliasCommand(name, 1);
                GoalCommand goalCommand = commandAlias;
                if (goalCommand instanceof GoalCommand.Ex) {
                    ExecutionResult executionResult;
                    if (((CharSequence)((GoalCommand.Ex)commandAlias).getCommand()).length() == 0) {
                        Object[] objectArray = new Object[]{name};
                        String message = VimInjectorKt.getInjector().getMessages().message("notexcmd", objectArray);
                        throw new InvalidCommandException(message, null);
                    }
                    Command command2 = VimInjectorKt.getInjector().getVimscriptParser().parseCommand(((GoalCommand.Ex)commandAlias).getCommand());
                    if (command2 == null) {
                        throw new ExException("E492: Not an editor command: " + ((GoalCommand.Ex)commandAlias).getCommand());
                    }
                    Command parsedCommand = command2;
                    if (parsedCommand instanceof UnknownCommand) {
                        executionResult = this.processPossiblyAliasCommand(((GoalCommand.Ex)commandAlias).getCommand(), editor, context, aliasCountdown - 1);
                    } else {
                        parsedCommand.setVimContext(this.getVimContext());
                        parsedCommand.execute(editor, context);
                        executionResult = ExecutionResult.Success.INSTANCE;
                    }
                    return executionResult;
                }
                if (goalCommand instanceof GoalCommand.Call) {
                    ((GoalCommand.Call)commandAlias).getHandler().execute(name, this.ranges, editor, context);
                    return ExecutionResult.Success.INSTANCE;
                }
                throw new NoWhenBranchMatchedException();
            }
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("recursion.detected.maximum.alias.depth.reached", new Object[0]));
            VimInjectorKt.getInjector().getMessages().indicateError();
            return ExecutionResult.Error.INSTANCE;
        }
        throw new ExException("E492: Not an editor command: " + name);
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.argument;
    }

    @NotNull
    public final UnknownCommand copy(@NotNull Ranges ranges, @NotNull String name, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new UnknownCommand(ranges, name, argument);
    }

    public static /* synthetic */ UnknownCommand copy$default(UnknownCommand unknownCommand, Ranges ranges, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = unknownCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = unknownCommand.name;
        }
        if ((n & 4) != 0) {
            string2 = unknownCommand.argument;
        }
        return unknownCommand.copy(ranges, string, string2);
    }

    @NotNull
    public String toString() {
        return "UnknownCommand(ranges=" + this.ranges + ", name=" + this.name + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnknownCommand)) {
            return false;
        }
        UnknownCommand unknownCommand = (UnknownCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)unknownCommand.ranges)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)unknownCommand.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)unknownCommand.argument);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/UnknownCommand$Constants;", "", "()V", "MAX_RECURSION", "", "vim-engine"})
    private static final class Constants {
        @NotNull
        public static final Constants INSTANCE = new Constants();
        public static final int MAX_RECURSION = 100;

        private Constants() {
        }
    }
}

