/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.mark.Mark;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.commands.Command;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/NormalCommand;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgument", "()Ljava/lang/String;", "getRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "toString", "vim-engine"})
public final class NormalCommand
extends Command.SingleExecution {
    @NotNull
    private final Ranges ranges;
    @NotNull
    private final String argument;
    @NotNull
    private final Command.CommandHandlerFlags argFlags;

    public NormalCommand(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        super(ranges, argument);
        this.ranges = ranges;
        this.argument = argument;
        Command.Flag[] flagArray = new Command.Flag[]{Command.Flag.SAVE_VISUAL};
        this.argFlags = this.flags(Command.RangeFlag.RANGE_OPTIONAL, Command.ArgumentFlag.ARGUMENT_OPTIONAL, Command.Access.WRITABLE, flagArray);
    }

    @NotNull
    public final Ranges getRanges() {
        return this.ranges;
    }

    @NotNull
    public final String getArgument() {
        return this.argument;
    }

    @Override
    @NotNull
    public Command.CommandHandlerFlags getArgFlags() {
        return this.argFlags;
    }

    @Override
    @NotNull
    public ExecutionResult processCommand(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        boolean useMappings = true;
        String argument = this.argument;
        if (StringsKt.startsWith$default((String)argument, (String)"!", (boolean)false, (int)2, null)) {
            useMappings = false;
            String string = argument.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            argument = string;
        }
        VimStateMachine commandState = EngineHelperKt.getVimStateMachine(editor);
        boolean rangeUsed = this.ranges.size() != 0;
        Mode mode = editor.getMode();
        if (mode instanceof Mode.VISUAL) {
            EngineModeExtensionsKt.exitVisualMode(editor);
            if (!rangeUsed) {
                Mark mark = VimInjectorKt.getInjector().getMarkService().getMark(editor.primaryCaret(), '<');
                Intrinsics.checkNotNull((Object)mark);
                Mark selectionStart = mark;
                editor.currentCaret().moveToBufferPosition(new BufferPosition(selectionStart.getLine(), selectionStart.getCol(), false, 4, null));
            }
        } else if (mode instanceof Mode.CMD_LINE) {
            VimInjectorKt.getInjector().getProcessGroup().cancelExEntry(editor, false);
        } else if (Intrinsics.areEqual((Object)mode, (Object)Mode.INSERT.INSTANCE) ? true : Intrinsics.areEqual((Object)mode, (Object)Mode.REPLACE.INSTANCE)) {
            editor.exitInsertMode(context, new OperatorArguments(false, 1, commandState.getMode()));
        } else if (mode instanceof Mode.SELECT) {
            editor.exitSelectModeNative(false);
        } else if (mode instanceof Mode.OP_PENDING ? true : mode instanceof Mode.NORMAL) {
            // empty if block
        }
        LineRange range = Command.getLineRange$default(this, editor, editor.primaryCaret(), false, 4, null);
        int line = range.startLine;
        int n = range.endLine;
        if (line <= n) {
            while (true) {
                if (rangeUsed) {
                    if (editor.lineCount() < line) break;
                    int startOffset = editor.getLineStartOffset(line);
                    editor.currentCaret().moveToOffset(startOffset);
                }
                List<KeyStroke> keys = VimInjectorKt.getInjector().getParser().stringToKeys(argument);
                KeyHandler keyHandler = KeyHandler.Companion.getInstance();
                keyHandler.reset(editor);
                for (KeyStroke key : keys) {
                    keyHandler.handleKey(editor, key, context, useMappings, true, keyHandler.getKeyHandlerState());
                }
                Mode mode2 = commandState.getMode();
                if (mode2 instanceof Mode.CMD_LINE) {
                    VimInjectorKt.getInjector().getProcessGroup().cancelExEntry(editor, false);
                }
                if (mode2 instanceof Mode.INSERT || mode2 instanceof Mode.REPLACE) {
                    editor.exitInsertMode(context, new OperatorArguments(false, 1, commandState.getMode()));
                }
                if (line == n) break;
                ++line;
            }
        }
        return ExecutionResult.Success.INSTANCE;
    }

    @NotNull
    public final Ranges component1() {
        return this.ranges;
    }

    @NotNull
    public final String component2() {
        return this.argument;
    }

    @NotNull
    public final NormalCommand copy(@NotNull Ranges ranges, @NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return new NormalCommand(ranges, argument);
    }

    public static /* synthetic */ NormalCommand copy$default(NormalCommand normalCommand, Ranges ranges, String string, int n, Object object) {
        if ((n & 1) != 0) {
            ranges = normalCommand.ranges;
        }
        if ((n & 2) != 0) {
            string = normalCommand.argument;
        }
        return normalCommand.copy(ranges, string);
    }

    @NotNull
    public String toString() {
        return "NormalCommand(ranges=" + this.ranges + ", argument=" + this.argument + ")";
    }

    public int hashCode() {
        int result = this.ranges.hashCode();
        result = result * 31 + this.argument.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NormalCommand)) {
            return false;
        }
        NormalCommand normalCommand = (NormalCommand)other;
        if (!Intrinsics.areEqual((Object)this.ranges, (Object)normalCommand.ranges)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.argument, (Object)normalCommand.argument);
    }
}

