/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.vimscript.model.commands;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.MissingArgumentException;
import com.maddyhome.idea.vim.ex.MissingRangeException;
import com.maddyhome.idea.vim.ex.NoArgumentAllowedException;
import com.maddyhome.idea.vim.ex.NoRangeAllowedException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.ex.ranges.Ranges;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.vimscript.model.Executable;
import com.maddyhome.idea.vim.vimscript.model.ExecutionResult;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007HIJKLMNB\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0016J7\u00101\u001a\u00020\b2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020908\"\u000209\u00a2\u0006\u0002\u0010:J&\u0010;\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020@J\u001e\u0010;\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+J\u0016\u0010A\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010<\u001a\u00020=J\u000e\u0010B\u001a\u00020C2\u0006\u0010*\u001a\u00020+J \u0010B\u001a\u00020C2\u0006\u0010*\u001a\u00020+2\u0006\u0010<\u001a\u00020=2\b\b\u0002\u0010?\u001a\u00020@J\u001e\u0010D\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010<\u001a\u00020=2\u0006\u0010?\u001a\u00020@J\u0016\u0010D\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010?\u001a\u00020@J \u0010E\u001a\u00020.2\u0006\u0010*\u001a\u00020+2\u0006\u0010/\u001a\u0002002\u0006\u0010F\u001a\u00020GH\u0002R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u0082\u0001\u0002OP\u00a8\u0006Q"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "Lcom/maddyhome/idea/vim/vimscript/model/Executable;", "commandRanges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "commandArgument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "argFlags", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getArgFlags", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getCommandArgument", "()Ljava/lang/String;", "getCommandRanges", "()Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "setCommandRanges", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;)V", "countArgument", "", "getCountArgument", "()I", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "optFlags", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/command/CommandFlags;", "getOptFlags", "()Ljava/util/EnumSet;", "rangeInScript", "Lcom/maddyhome/idea/vim/common/TextRange;", "getRangeInScript", "()Lcom/maddyhome/idea/vim/common/TextRange;", "setRangeInScript", "(Lcom/maddyhome/idea/vim/common/TextRange;)V", "vimContext", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "getVimContext", "()Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "setVimContext", "(Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;)V", "checkArgument", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "checkRanges", "execute", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "flags", "rangeFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "argumentFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "access", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;", "(Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;[Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;)Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "getCount", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "defaultCount", "checkCount", "", "getLine", "getLineRange", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "getTextRange", "runCommand", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "Access", "ArgumentFlag", "CommandHandlerFlags", "Flag", "ForEachCaret", "RangeFlag", "SingleExecution", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/Command\n+ 2 EngineHelper.kt\ncom/maddyhome/idea/vim/helper/EngineHelperKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n24#2:244\n38#3:245\n1747#4,3:246\n*S KotlinDebug\n*F\n+ 1 Command.kt\ncom/maddyhome/idea/vim/vimscript/model/commands/Command\n*L\n39#1:244\n40#1:245\n63#1:246,3\n*E\n"})
public abstract class Command
implements Executable {
    @NotNull
    private Ranges commandRanges;
    @NotNull
    private final String commandArgument;
    public VimLContext vimContext;
    public TextRange rangeInScript;
    @NotNull
    private final EnumSet<CommandFlags> optFlags;
    @NotNull
    private final VimLogger logger;

    private Command(Ranges commandRanges, String commandArgument) {
        this.commandRanges = commandRanges;
        this.commandArgument = commandArgument;
        boolean $i$f$noneOfEnum = false;
        EnumSet<CommandFlags> enumSet = EnumSet.noneOf(CommandFlags.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        this.optFlags = enumSet;
        boolean $i$f$vimLogger = false;
        this.logger = VimInjectorKt.getInjector().getLogger(Command.class);
    }

    @NotNull
    public final Ranges getCommandRanges() {
        return this.commandRanges;
    }

    public final void setCommandRanges(@NotNull Ranges ranges) {
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"<set-?>");
        this.commandRanges = ranges;
    }

    @NotNull
    public final String getCommandArgument() {
        return this.commandArgument;
    }

    @Override
    @NotNull
    public VimLContext getVimContext() {
        VimLContext vimLContext = this.vimContext;
        if (vimLContext != null) {
            return vimLContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"vimContext");
        return null;
    }

    @Override
    public void setVimContext(@NotNull VimLContext vimLContext) {
        Intrinsics.checkNotNullParameter((Object)vimLContext, (String)"<set-?>");
        this.vimContext = vimLContext;
    }

    @Override
    @NotNull
    public TextRange getRangeInScript() {
        TextRange textRange = this.rangeInScript;
        if (textRange != null) {
            return textRange;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rangeInScript");
        return null;
    }

    @Override
    public void setRangeInScript(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.rangeInScript = textRange;
    }

    @NotNull
    public abstract CommandHandlerFlags getArgFlags();

    @NotNull
    protected EnumSet<CommandFlags> getOptFlags() {
        return this.optFlags;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull VimEditor editor, @NotNull ExecutionContext context) throws ExException {
        ExecutionResult executionResult;
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.checkRanges(editor);
            this.checkArgument(editor);
            Iterable $this$any$iv = editor.nativeCarets();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VimCaret it = (VimCaret)element$iv;
                    boolean bl2 = false;
                    if (!it.hasSelection()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl && !this.getArgFlags().getFlags().contains((Object)Flag.SAVE_VISUAL)) {
            editor.removeSelection();
            editor.removeSecondaryCarets();
        }
        if (this.getArgFlags().getAccess() == Access.WRITABLE && !editor.isDocumentWritable()) {
            this.logger.info("Trying to modify readonly document");
            return ExecutionResult.Error.INSTANCE;
        }
        OperatorArguments operatorArguments = new OperatorArguments(EngineHelperKt.getVimStateMachine(editor).isOperatorPending(editor.getMode()), 0, editor.getMode());
        Function0 runCommand2 = (Function0)new Function0<ExecutionResult>(this, editor, context, operatorArguments){
            final /* synthetic */ Command this$0;
            final /* synthetic */ VimEditor $editor;
            final /* synthetic */ ExecutionContext $context;
            final /* synthetic */ OperatorArguments $operatorArguments;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$context = $context;
                this.$operatorArguments = $operatorArguments;
                super(0);
            }

            @NotNull
            public final ExecutionResult invoke() {
                return Command.access$runCommand(this.this$0, this.$editor, this.$context, this.$operatorArguments);
            }
        };
        switch (WhenMappings.$EnumSwitchMapping$0[this.getArgFlags().getAccess().ordinal()]) {
            case 1: {
                executionResult = (ExecutionResult)VimInjectorKt.getInjector().getApplication().runWriteAction(runCommand2);
                break;
            }
            case 2: {
                executionResult = (ExecutionResult)VimInjectorKt.getInjector().getApplication().runReadAction(runCommand2);
                break;
            }
            case 3: {
                executionResult = (ExecutionResult)runCommand2.invoke();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return executionResult;
    }

    private final ExecutionResult runCommand(VimEditor editor, ExecutionContext context, OperatorArguments operatorArguments) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = ExecutionResult.Success.INSTANCE;
        Command command2 = this;
        if (command2 instanceof ForEachCaret) {
            editor.forEachNativeCaret((Function1<? super VimCaret, Unit>)((Function1)new Function1<VimCaret, Unit>((Ref.ObjectRef<ExecutionResult>)result, this, editor, context, operatorArguments){
                final /* synthetic */ Ref.ObjectRef<ExecutionResult> $result;
                final /* synthetic */ Command this$0;
                final /* synthetic */ VimEditor $editor;
                final /* synthetic */ ExecutionContext $context;
                final /* synthetic */ OperatorArguments $operatorArguments;
                {
                    this.$result = $result;
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$context = $context;
                    this.$operatorArguments = $operatorArguments;
                    super(1);
                }

                public final void invoke(@NotNull VimCaret caret) {
                    Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                    if (this.$result.element instanceof ExecutionResult.Success) {
                        this.$result.element = ((ForEachCaret)this.this$0).processCommand(this.$editor, caret, this.$context, this.$operatorArguments);
                    }
                }
            }), true);
        } else if (command2 instanceof SingleExecution) {
            result.element = ((SingleExecution)this).processCommand(editor, context, operatorArguments);
        }
        return (ExecutionResult)result.element;
    }

    private final void checkRanges(VimEditor editor) {
        if (RangeFlag.RANGE_FORBIDDEN == this.getArgFlags().getRangeFlag() && this.commandRanges.size() != 0) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("e_norange", new Object[0]));
            throw new NoRangeAllowedException();
        }
        if (RangeFlag.RANGE_REQUIRED == this.getArgFlags().getRangeFlag() && this.commandRanges.size() == 0) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("e_rangereq", new Object[0]));
            throw new MissingRangeException();
        }
        if (RangeFlag.RANGE_IS_COUNT == this.getArgFlags().getRangeFlag()) {
            this.commandRanges.setDefaultLine(1);
        }
    }

    private final void checkArgument(VimEditor editor) {
        if (ArgumentFlag.ARGUMENT_FORBIDDEN == this.getArgFlags().getArgumentFlag() && !StringsKt.isBlank((CharSequence)this.commandArgument)) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("e_argforb", new Object[0]));
            throw new NoArgumentAllowedException();
        }
        if (ArgumentFlag.ARGUMENT_REQUIRED == this.getArgFlags().getArgumentFlag() && StringsKt.isBlank((CharSequence)this.commandArgument)) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, VimInjectorKt.getInjector().getMessages().message("e_argreq", new Object[0]));
            throw new MissingArgumentException();
        }
    }

    @NotNull
    public final CommandHandlerFlags flags(@NotNull RangeFlag rangeFlag, @NotNull ArgumentFlag argumentFlag, @NotNull Access access, Flag ... flags) {
        Intrinsics.checkNotNullParameter((Object)((Object)rangeFlag), (String)"rangeFlag");
        Intrinsics.checkNotNullParameter((Object)((Object)argumentFlag), (String)"argumentFlag");
        Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        return new CommandHandlerFlags(rangeFlag, argumentFlag, access, ArraysKt.toSet((Object[])flags));
    }

    public final int getLine(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.commandRanges.getLine(editor);
    }

    public final int getLine(@NotNull VimEditor editor, @NotNull VimCaret caret) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.commandRanges.getLine(editor, caret);
    }

    public final int getCount(@NotNull VimEditor editor, int defaultCount, boolean checkCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int count = checkCount ? this.getCountArgument() : -1;
        int res2 = this.commandRanges.getCount(editor, count);
        return res2 == -1 ? defaultCount : res2;
    }

    public final int getCount(@NotNull VimEditor editor, @NotNull VimCaret caret, int defaultCount, boolean checkCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int count = this.commandRanges.getCount(editor, caret, checkCount ? this.getCountArgument() : -1);
        return count == -1 ? defaultCount : count;
    }

    @NotNull
    public final LineRange getLineRange(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.commandRanges.getLineRange(editor, -1);
    }

    @NotNull
    public final LineRange getLineRange(@NotNull VimEditor editor, @NotNull VimCaret caret, boolean checkCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.commandRanges.getLineRange(editor, caret, checkCount ? this.getCountArgument() : -1);
    }

    public static /* synthetic */ LineRange getLineRange$default(Command command2, VimEditor vimEditor, VimCaret vimCaret, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLineRange");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return command2.getLineRange(vimEditor, vimCaret, bl);
    }

    @NotNull
    public final TextRange getTextRange(@NotNull VimEditor editor, boolean checkCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int count = checkCount ? this.getCountArgument() : -1;
        return this.commandRanges.getTextRange(editor, count);
    }

    @NotNull
    public final TextRange getTextRange(@NotNull VimEditor editor, @NotNull VimCaret caret, boolean checkCount) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.commandRanges.getTextRange(editor, caret, checkCount ? this.getCountArgument() : -1);
    }

    private final int getCountArgument() {
        Integer n = StringsKt.toIntOrNull((String)this.commandArgument);
        return n != null ? n : -1;
    }

    public /* synthetic */ Command(Ranges commandRanges, String commandArgument, DefaultConstructorMarker $constructor_marker) {
        this(commandRanges, commandArgument);
    }

    public static final /* synthetic */ ExecutionResult access$runCommand(Command $this, VimEditor editor, ExecutionContext context, OperatorArguments operatorArguments) {
        return $this.runCommand(editor, context, operatorArguments);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "", "(Ljava/lang/String;I)V", "WRITABLE", "READ_ONLY", "SELF_SYNCHRONIZED", "vim-engine"})
    public static final class Access
    extends Enum<Access> {
        public static final /* enum */ Access WRITABLE = new Access();
        public static final /* enum */ Access READ_ONLY = new Access();
        public static final /* enum */ Access SELF_SYNCHRONIZED = new Access();
        private static final /* synthetic */ Access[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Access[] values() {
            return (Access[])$VALUES.clone();
        }

        public static Access valueOf(String value) {
            return Enum.valueOf(Access.class, value);
        }

        @NotNull
        public static EnumEntries<Access> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = accessArray = new Access[]{Access.WRITABLE, Access.READ_ONLY, Access.SELF_SYNCHRONIZED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "", "(Ljava/lang/String;I)V", "ARGUMENT_REQUIRED", "ARGUMENT_OPTIONAL", "ARGUMENT_FORBIDDEN", "vim-engine"})
    public static final class ArgumentFlag
    extends Enum<ArgumentFlag> {
        public static final /* enum */ ArgumentFlag ARGUMENT_REQUIRED = new ArgumentFlag();
        public static final /* enum */ ArgumentFlag ARGUMENT_OPTIONAL = new ArgumentFlag();
        public static final /* enum */ ArgumentFlag ARGUMENT_FORBIDDEN = new ArgumentFlag();
        private static final /* synthetic */ ArgumentFlag[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ArgumentFlag[] values() {
            return (ArgumentFlag[])$VALUES.clone();
        }

        public static ArgumentFlag valueOf(String value) {
            return Enum.valueOf(ArgumentFlag.class, value);
        }

        @NotNull
        public static EnumEntries<ArgumentFlag> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = argumentFlagArray = new ArgumentFlag[]{ArgumentFlag.ARGUMENT_REQUIRED, ArgumentFlag.ARGUMENT_OPTIONAL, ArgumentFlag.ARGUMENT_FORBIDDEN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$CommandHandlerFlags;", "", "rangeFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "argumentFlag", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "access", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "flags", "", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;", "(Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;Ljava/util/Set;)V", "getAccess", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Access;", "getArgumentFlag", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ArgumentFlag;", "getFlags", "()Ljava/util/Set;", "getRangeFlag", "()Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "vim-engine"})
    public static final class CommandHandlerFlags {
        @NotNull
        private final RangeFlag rangeFlag;
        @NotNull
        private final ArgumentFlag argumentFlag;
        @NotNull
        private final Access access;
        @NotNull
        private final Set<Flag> flags;

        public CommandHandlerFlags(@NotNull RangeFlag rangeFlag, @NotNull ArgumentFlag argumentFlag, @NotNull Access access, @NotNull Set<? extends Flag> flags) {
            Intrinsics.checkNotNullParameter((Object)((Object)rangeFlag), (String)"rangeFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)argumentFlag), (String)"argumentFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            Intrinsics.checkNotNullParameter(flags, (String)"flags");
            this.rangeFlag = rangeFlag;
            this.argumentFlag = argumentFlag;
            this.access = access;
            this.flags = flags;
        }

        @NotNull
        public final RangeFlag getRangeFlag() {
            return this.rangeFlag;
        }

        @NotNull
        public final ArgumentFlag getArgumentFlag() {
            return this.argumentFlag;
        }

        @NotNull
        public final Access getAccess() {
            return this.access;
        }

        @NotNull
        public final Set<Flag> getFlags() {
            return this.flags;
        }

        @NotNull
        public final RangeFlag component1() {
            return this.rangeFlag;
        }

        @NotNull
        public final ArgumentFlag component2() {
            return this.argumentFlag;
        }

        @NotNull
        public final Access component3() {
            return this.access;
        }

        @NotNull
        public final Set<Flag> component4() {
            return this.flags;
        }

        @NotNull
        public final CommandHandlerFlags copy(@NotNull RangeFlag rangeFlag, @NotNull ArgumentFlag argumentFlag, @NotNull Access access, @NotNull Set<? extends Flag> flags) {
            Intrinsics.checkNotNullParameter((Object)((Object)rangeFlag), (String)"rangeFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)argumentFlag), (String)"argumentFlag");
            Intrinsics.checkNotNullParameter((Object)((Object)access), (String)"access");
            Intrinsics.checkNotNullParameter(flags, (String)"flags");
            return new CommandHandlerFlags(rangeFlag, argumentFlag, access, flags);
        }

        public static /* synthetic */ CommandHandlerFlags copy$default(CommandHandlerFlags commandHandlerFlags, RangeFlag rangeFlag, ArgumentFlag argumentFlag, Access access, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                rangeFlag = commandHandlerFlags.rangeFlag;
            }
            if ((n & 2) != 0) {
                argumentFlag = commandHandlerFlags.argumentFlag;
            }
            if ((n & 4) != 0) {
                access = commandHandlerFlags.access;
            }
            if ((n & 8) != 0) {
                set = commandHandlerFlags.flags;
            }
            return commandHandlerFlags.copy(rangeFlag, argumentFlag, access, set);
        }

        @NotNull
        public String toString() {
            return "CommandHandlerFlags(rangeFlag=" + this.rangeFlag + ", argumentFlag=" + this.argumentFlag + ", access=" + this.access + ", flags=" + this.flags + ")";
        }

        public int hashCode() {
            int result = this.rangeFlag.hashCode();
            result = result * 31 + this.argumentFlag.hashCode();
            result = result * 31 + this.access.hashCode();
            result = result * 31 + ((Object)this.flags).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandHandlerFlags)) {
                return false;
            }
            CommandHandlerFlags commandHandlerFlags = (CommandHandlerFlags)other;
            if (this.rangeFlag != commandHandlerFlags.rangeFlag) {
                return false;
            }
            if (this.argumentFlag != commandHandlerFlags.argumentFlag) {
                return false;
            }
            if (this.access != commandHandlerFlags.access) {
                return false;
            }
            return Intrinsics.areEqual(this.flags, commandHandlerFlags.flags);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$Flag;", "", "(Ljava/lang/String;I)V", "SAVE_VISUAL", "vim-engine"})
    public static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag SAVE_VISUAL = new Flag();
        private static final /* synthetic */ Flag[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String value) {
            return Enum.valueOf(Flag.class, value);
        }

        @NotNull
        public static EnumEntries<Flag> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = flagArray = new Flag[]{Flag.SAVE_VISUAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$ForEachCaret;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class ForEachCaret
    extends Command {
        public ForEachCaret(@NotNull Ranges ranges, @NotNull String argument) {
            Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            super(ranges, argument, null);
        }

        public /* synthetic */ ForEachCaret(Ranges ranges, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "";
            }
            this(ranges, string);
        }

        @NotNull
        public abstract ExecutionResult processCommand(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull OperatorArguments var4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$RangeFlag;", "", "(Ljava/lang/String;I)V", "RANGE_REQUIRED", "RANGE_OPTIONAL", "RANGE_FORBIDDEN", "RANGE_IS_COUNT", "vim-engine"})
    public static final class RangeFlag
    extends Enum<RangeFlag> {
        public static final /* enum */ RangeFlag RANGE_REQUIRED = new RangeFlag();
        public static final /* enum */ RangeFlag RANGE_OPTIONAL = new RangeFlag();
        public static final /* enum */ RangeFlag RANGE_FORBIDDEN = new RangeFlag();
        public static final /* enum */ RangeFlag RANGE_IS_COUNT = new RangeFlag();
        private static final /* synthetic */ RangeFlag[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RangeFlag[] values() {
            return (RangeFlag[])$VALUES.clone();
        }

        public static RangeFlag valueOf(String value) {
            return Enum.valueOf(RangeFlag.class, value);
        }

        @NotNull
        public static EnumEntries<RangeFlag> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rangeFlagArray = new RangeFlag[]{RangeFlag.RANGE_REQUIRED, RangeFlag.RANGE_OPTIONAL, RangeFlag.RANGE_FORBIDDEN, RangeFlag.RANGE_IS_COUNT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f"}, d2={"Lcom/maddyhome/idea/vim/vimscript/model/commands/Command$SingleExecution;", "Lcom/maddyhome/idea/vim/vimscript/model/commands/Command;", "ranges", "Lcom/maddyhome/idea/vim/ex/ranges/Ranges;", "argument", "", "(Lcom/maddyhome/idea/vim/ex/ranges/Ranges;Ljava/lang/String;)V", "processCommand", "Lcom/maddyhome/idea/vim/vimscript/model/ExecutionResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class SingleExecution
    extends Command {
        public SingleExecution(@NotNull Ranges ranges, @NotNull String argument) {
            Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            super(ranges, argument, null);
        }

        public /* synthetic */ SingleExecution(Ranges ranges, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = "";
            }
            this(ranges, string);
        }

        @NotNull
        public abstract ExecutionResult processCommand(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull OperatorArguments var3);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Access.values().length];
            try {
                nArray[Access.WRITABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Access.READ_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Access.SELF_SYNCHRONIZED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

