/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp.parser;

import com.maddyhome.idea.vim.regexp.parser.CaseSensitivitySettings;
import com.maddyhome.idea.vim.regexp.parser.VimRegexParserResult;
import com.maddyhome.idea.vim.regexp.parser.error.BailErrorLexer;
import com.maddyhome.idea.vim.regexp.parser.error.VimRegexParserErrorStrategy;
import com.maddyhome.idea.vim.regexp.parser.error.VimRegexParserException;
import com.maddyhome.idea.vim.regexp.parser.generated.RegexLexer;
import com.maddyhome.idea.vim.regexp.parser.generated.RegexParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/maddyhome/idea/vim/regexp/parser/VimRegexParser;", "", "()V", "getCaseSensitivitySettings", "Lcom/maddyhome/idea/vim/regexp/parser/CaseSensitivitySettings;", "lexer", "Lcom/maddyhome/idea/vim/regexp/parser/generated/RegexLexer;", "parse", "Lcom/maddyhome/idea/vim/regexp/parser/VimRegexParserResult;", "pattern", "", "vim-engine"})
public final class VimRegexParser {
    @NotNull
    public static final VimRegexParser INSTANCE = new VimRegexParser();

    private VimRegexParser() {
    }

    @NotNull
    public final VimRegexParserResult parse(@NotNull String pattern) {
        VimRegexParserResult vimRegexParserResult;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            CodePointCharStream codePointCharStream = CharStreams.fromString((String)pattern);
            Intrinsics.checkNotNullExpressionValue((Object)codePointCharStream, (String)"fromString(...)");
            BailErrorLexer regexLexer = new BailErrorLexer((CharStream)codePointCharStream);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)regexLexer);
            RegexParser parser2 = new RegexParser((TokenStream)tokens);
            parser2.setErrorHandler((ANTLRErrorStrategy)new VimRegexParserErrorStrategy());
            parser2.getErrorListeners().clear();
            RegexParser.PatternContext tree = parser2.pattern();
            Intrinsics.checkNotNull((Object)((Object)tree));
            vimRegexParserResult = new VimRegexParserResult.Success((ParseTree)tree, this.getCaseSensitivitySettings(regexLexer));
        }
        catch (VimRegexParserException e) {
            vimRegexParserResult = new VimRegexParserResult.Failure(e.getErrorCode());
        }
        return vimRegexParserResult;
    }

    private final CaseSensitivitySettings getCaseSensitivitySettings(RegexLexer lexer) {
        Boolean bl = lexer.ignoreCase;
        return Intrinsics.areEqual((Object)bl, (Object)true) ? CaseSensitivitySettings.IGNORE_CASE : (Intrinsics.areEqual((Object)bl, (Object)false) ? CaseSensitivitySettings.NO_IGNORE_CASE : CaseSensitivitySettings.DEFAULT);
    }
}

