/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp.engine.nfa.matcher;

import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.regexp.engine.nfa.matcher.Matcher;
import com.maddyhome.idea.vim.regexp.engine.nfa.matcher.MatcherResult;
import com.maddyhome.idea.vim.regexp.match.VimMatchGroup;
import com.maddyhome.idea.vim.regexp.match.VimMatchGroupCollection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/maddyhome/idea/vim/regexp/engine/nfa/matcher/BackreferenceMatcher;", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/matcher/Matcher;", "groupNumber", "", "(I)V", "isEpsilon", "", "matches", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/matcher/MatcherResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "index", "groups", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchGroupCollection;", "isCaseInsensitive", "possibleCursors", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "vim-engine"})
public final class BackreferenceMatcher
implements Matcher {
    private final int groupNumber;

    public BackreferenceMatcher(int groupNumber) {
        this.groupNumber = groupNumber;
    }

    @Override
    @NotNull
    public MatcherResult matches(@NotNull VimEditor editor, int index, @NotNull VimMatchGroupCollection groups, boolean isCaseInsensitive, @NotNull List<VimCaret> possibleCursors) {
        String string;
        String capturedString;
        String string2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)groups, (String)"groups");
        Intrinsics.checkNotNullParameter(possibleCursors, (String)"possibleCursors");
        if (groups.get(this.groupNumber) == null) {
            return MatcherResult.Failure.INSTANCE;
        }
        if (isCaseInsensitive) {
            VimMatchGroup vimMatchGroup = groups.get(this.groupNumber);
            Intrinsics.checkNotNull((Object)vimMatchGroup);
            String string3 = vimMatchGroup.getValue().toLowerCase(Locale.ROOT);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            VimMatchGroup vimMatchGroup = groups.get(this.groupNumber);
            Intrinsics.checkNotNull((Object)vimMatchGroup);
            string2 = capturedString = vimMatchGroup.getValue();
        }
        if (editor.text().length() - index < capturedString.length()) {
            return MatcherResult.Failure.INSTANCE;
        }
        if (isCaseInsensitive) {
            String string4 = StringsKt.substring((CharSequence)editor.text(), (IntRange)RangesKt.until((int)index, (int)(index + capturedString.length()))).toLowerCase(Locale.ROOT);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string = StringsKt.substring((CharSequence)editor.text(), (IntRange)RangesKt.until((int)index, (int)(index + capturedString.length())));
        }
        String editorString = string;
        return Intrinsics.areEqual((Object)capturedString, (Object)editorString) ? (MatcherResult)new MatcherResult.Success(capturedString.length()) : (MatcherResult)MatcherResult.Failure.INSTANCE;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }
}

