/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.regexp;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.regexp.VimRegexErrors;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.engine.VimRegexEngine;
import com.maddyhome.idea.vim.regexp.engine.nfa.NFA;
import com.maddyhome.idea.vim.regexp.engine.nfa.matcher.DotMatcher;
import com.maddyhome.idea.vim.regexp.match.VimMatchGroup;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.regexp.parser.CaseSensitivitySettings;
import com.maddyhome.idea.vim.regexp.parser.VimRegexParser;
import com.maddyhome.idea.vim.regexp.parser.VimRegexParserResult;
import com.maddyhome.idea.vim.regexp.parser.visitors.PatternVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J*\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\bH\u0002J\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ8\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ0\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020 2\b\b\u0002\u0010%\u001a\u00020 2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ0\u0010&\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J(\u0010'\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ(\u0010(\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ&\u0010)\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020 2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u001e\u0010+\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u001e\u0010,\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ&\u0010-\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020 2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0016\u0010.\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J(\u0010/\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J(\u00100\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010*\u001a\u00020 2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002JX\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0003\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010$\u001a\u00020 2\b\b\u0002\u0010%\u001a\u00020 2\b\b\u0002\u00102\u001a\u00020\b2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/maddyhome/idea/vim/regexp/VimRegex;", "", "pattern", "", "(Ljava/lang/String;)V", "caseSensitivitySettings", "Lcom/maddyhome/idea/vim/regexp/parser/CaseSensitivitySettings;", "hasUpperCase", "", "nfa", "Lcom/maddyhome/idea/vim/regexp/engine/nfa/NFA;", "nonExactNFA", "buildLiteralChar", "Lkotlin/Pair;", "", "Lcom/maddyhome/idea/vim/regexp/VimRegex$SubstituteCase;", "char", "caseSettings", "buildSubstituteString", "matchResult", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult$Success;", "substituteString", "lastSubstituteString", "magic", "containsMatchIn", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "options", "", "Lcom/maddyhome/idea/vim/regexp/VimRegexOptions;", "findAll", "startIndex", "", "maxIndex", "findInLine", "Lcom/maddyhome/idea/vim/regexp/match/VimMatchResult;", "line", "column", "findLastMatchInLine", "findNext", "findPrevious", "matchAt", "index", "matchEntire", "matches", "matchesAt", "shouldIgnoreCase", "simulateNFA", "simulateNonExactNFA", "substitute", "takeLiterally", "SubstituteCase", "vim-engine"})
public final class VimRegex {
    @NotNull
    private final CaseSensitivitySettings caseSensitivitySettings;
    @NotNull
    private final NFA nfa;
    @NotNull
    private final NFA nonExactNFA;
    private final boolean hasUpperCase;

    public VimRegex(@NotNull String pattern) {
        VimRegexParserResult parseResult;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        VimRegexParserResult vimRegexParserResult = parseResult = VimRegexParser.INSTANCE.parse(pattern);
        if (vimRegexParserResult instanceof VimRegexParserResult.Failure) {
            throw new VimRegexException(((VimRegexParserResult.Failure)parseResult).getErrorCode().toString());
        }
        if (!(vimRegexParserResult instanceof VimRegexParserResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        Object object = PatternVisitor.INSTANCE.visit(((VimRegexParserResult.Success)parseResult).getTree());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"visit(...)");
        this.nfa = (NFA)object;
        this.hasUpperCase = PatternVisitor.INSTANCE.getHasUpperCase$vim_engine();
        this.nonExactNFA = NFA.Companion.fromMatcher$vim_engine(new DotMatcher(false)).closure$vim_engine(false).concatenate$vim_engine(this.nfa);
        this.caseSensitivitySettings = ((VimRegexParserResult.Success)parseResult).getCaseSensitivitySettings();
    }

    public final boolean containsMatchIn(@NotNull VimEditor editor, @NotNull List<? extends VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int n = editor.lineCount();
        for (int line = 0; line < n; ++line) {
            VimMatchResult result = this.simulateNonExactNFA(editor, editor.getLineStartOffset(line), options);
            if (!(result instanceof VimMatchResult.Success)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean containsMatchIn$default(VimRegex vimRegex, VimEditor vimEditor, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.containsMatchIn(vimEditor, list);
    }

    @NotNull
    public final VimMatchResult findNext(@NotNull VimEditor editor, int startIndex, @NotNull List<? extends VimRegexOptions> options) {
        int nextLine;
        VimMatchResult vimMatchResult;
        VimMatchResult result;
        int lineStartIndex;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int newStartIndex = startIndex + 1 == editor.getLineEndOffset(editor.offsetToBufferPosition(startIndex).getLine()) ? startIndex + 1 : startIndex;
        int index = lineStartIndex = editor.getLineStartOffset(editor.offsetToBufferPosition(newStartIndex).getLine());
        while (index <= editor.text().length()) {
            int n;
            result = this.simulateNonExactNFA(editor, index, options);
            vimMatchResult = result;
            if (vimMatchResult instanceof VimMatchResult.Success) {
                if (((VimMatchResult.Success)result).getRange().getStartOffset() > newStartIndex) {
                    return result;
                }
                n = ((VimMatchResult.Success)result).getRange().getEndOffset() + (((VimMatchResult.Success)result).getRange().getStartOffset() == ((VimMatchResult.Success)result).getRange().getEndOffset() ? 1 : 0);
            } else if (vimMatchResult instanceof VimMatchResult.Failure) {
                nextLine = editor.offsetToBufferPosition(index).getLine() + 1;
                if (nextLine >= editor.lineCount()) break;
                n = editor.getLineStartOffset(nextLine);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            index = n;
        }
        if (options.contains((Object)VimRegexOptions.WRAP_SCAN)) {
            index = 0;
            while (index <= startIndex) {
                result = this.simulateNonExactNFA(editor, index, options);
                vimMatchResult = result;
                if (vimMatchResult instanceof VimMatchResult.Success) {
                    return result;
                }
                if (!(vimMatchResult instanceof VimMatchResult.Failure)) continue;
                nextLine = editor.offsetToBufferPosition(index).getLine() + 1;
                if (nextLine >= editor.lineCount()) break;
                index = editor.getLineStartOffset(nextLine);
            }
        }
        return new VimMatchResult.Failure(VimRegexErrors.E486);
    }

    public static /* synthetic */ VimMatchResult findNext$default(VimRegex vimRegex, VimEditor vimEditor, int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.findNext(vimEditor, n, list);
    }

    @NotNull
    public final VimMatchResult findPrevious(@NotNull VimEditor editor, int startIndex, @NotNull List<? extends VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int startLine = editor.offsetToBufferPosition(startIndex).getLine();
        VimMatchResult result = this.findLastMatchInLine(editor, startLine, startIndex - 1, options);
        if (result instanceof VimMatchResult.Success && ((VimMatchResult.Success)result).getRange().getStartOffset() < startIndex) {
            return result;
        }
        int currentLine = startLine - 1;
        boolean wrappedAround = false;
        while (!wrappedAround || currentLine >= startLine && options.contains((Object)VimRegexOptions.WRAP_SCAN)) {
            if (currentLine < 0) {
                currentLine = editor.lineCount() - 1;
                wrappedAround = true;
                continue;
            }
            VimMatchResult previous = VimRegex.findLastMatchInLine$default(this, editor, currentLine, 0, options, 4, null);
            if (previous instanceof VimMatchResult.Success) {
                return previous;
            }
            --currentLine;
        }
        return new VimMatchResult.Failure(VimRegexErrors.E486);
    }

    public static /* synthetic */ VimMatchResult findPrevious$default(VimRegex vimRegex, VimEditor vimEditor, int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.findPrevious(vimEditor, n, list);
    }

    private final VimMatchResult findLastMatchInLine(VimEditor editor, int line, int maxIndex, List<? extends VimRegexOptions> options) {
        VimMatchResult result;
        VimMatchResult vimMatchResult;
        int index = editor.getLineStartOffset(line);
        VimMatchResult prevResult = new VimMatchResult.Failure(VimRegexErrors.E486);
        boolean returnEndPosition = options.contains((Object)VimRegexOptions.WANT_END_POSITION);
        while (index <= maxIndex && !((vimMatchResult = (result = this.simulateNonExactNFA(editor, index, options))) instanceof VimMatchResult.Failure)) {
            if (!(vimMatchResult instanceof VimMatchResult.Success)) continue;
            if (!returnEndPosition && ((VimMatchResult.Success)result).getRange().getStartOffset() > maxIndex || returnEndPosition && ((VimMatchResult.Success)result).getRange().getEndOffset() > maxIndex) break;
            prevResult = result;
            index = ((VimMatchResult.Success)result).getRange().getStartOffset() == ((VimMatchResult.Success)result).getRange().getEndOffset() ? ((VimMatchResult.Success)result).getRange().getEndOffset() + 1 : ((VimMatchResult.Success)result).getRange().getEndOffset();
        }
        return prevResult;
    }

    static /* synthetic */ VimMatchResult findLastMatchInLine$default(VimRegex vimRegex, VimEditor vimEditor, int n, int n2, List list, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = vimEditor.getLineEndOffset(n);
        }
        return vimRegex.findLastMatchInLine(vimEditor, n, n2, list);
    }

    @NotNull
    public final List<VimMatchResult.Success> findAll(@NotNull VimEditor editor, int startIndex, int maxIndex, @NotNull List<? extends VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        int index = startIndex;
        List foundMatches = CollectionsKt.toMutableList((Collection)CollectionsKt.emptyList());
        while (index < maxIndex) {
            VimMatchResult result = this.simulateNonExactNFA(editor, index, options);
            VimMatchResult vimMatchResult = result;
            if (vimMatchResult instanceof VimMatchResult.Success) {
                foundMatches.add(result);
                index = ((VimMatchResult.Success)result).getRange().getStartOffset() == ((VimMatchResult.Success)result).getRange().getEndOffset() ? ((VimMatchResult.Success)result).getRange().getEndOffset() + 1 : ((VimMatchResult.Success)result).getRange().getEndOffset();
                continue;
            }
            if (!(vimMatchResult instanceof VimMatchResult.Failure)) continue;
            int nextLine = editor.offsetToBufferPosition(index).getLine() + 1;
            if (nextLine >= editor.lineCount()) break;
            index = editor.getLineStartOffset(nextLine);
        }
        return foundMatches;
    }

    public static /* synthetic */ List findAll$default(VimRegex vimRegex, VimEditor vimEditor, int n, int n2, List list, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = vimEditor.text().length();
        }
        if ((n3 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.findAll(vimEditor, n, n2, list);
    }

    @NotNull
    public final VimMatchResult findInLine(@NotNull VimEditor editor, int line, int column, @NotNull List<? extends VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.simulateNonExactNFA(editor, editor.getLineStartOffset(line) + column, options);
    }

    public static /* synthetic */ VimMatchResult findInLine$default(VimRegex vimRegex, VimEditor vimEditor, int n, int n2, List list, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.findInLine(vimEditor, n, n2, list);
    }

    @Nullable
    public final Pair<VimMatchResult.Success, String> substitute(@NotNull VimEditor editor, @NotNull String substituteString, @NotNull String lastSubstituteString, int line, int column, boolean takeLiterally, @NotNull List<? extends VimRegexOptions> options) {
        Pair pair;
        VimMatchResult match;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)substituteString, (String)"substituteString");
        Intrinsics.checkNotNullParameter((Object)lastSubstituteString, (String)"lastSubstituteString");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult = match = this.findInLine(editor, line, column, options);
        if (vimMatchResult instanceof VimMatchResult.Failure) {
            pair = null;
        } else if (vimMatchResult instanceof VimMatchResult.Success) {
            pair = new Pair((Object)match, (Object)(takeLiterally ? substituteString : VimRegex.buildSubstituteString$default(this, (VimMatchResult.Success)match, substituteString, lastSubstituteString, false, 8, null)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    public static /* synthetic */ Pair substitute$default(VimRegex vimRegex, VimEditor vimEditor, String string, String string2, int n, int n2, boolean bl, List list, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.substitute(vimEditor, string, string2, n, n2, bl, list);
    }

    private final String buildSubstituteString(VimMatchResult.Success matchResult, String substituteString, String lastSubstituteString, boolean magic) {
        StringBuilder result = new StringBuilder();
        SubstituteCase caseSettings = SubstituteCase.DEFAULT;
        for (int index = 0; index < substituteString.length(); ++index) {
            if (substituteString.charAt(index) == '\\') {
                if (++index >= substituteString.length()) {
                    result.append('\\');
                    break;
                }
                char c = substituteString.charAt(index);
                if (c == '&') {
                    result.append(magic ? Character.valueOf('&') : matchResult.getValue());
                    continue;
                }
                if (c == '~') {
                    result.append(magic ? Character.valueOf('~') : this.buildSubstituteString(matchResult, lastSubstituteString, "", false));
                    continue;
                }
                if (c == '0') {
                    result.append(matchResult.getValue());
                    continue;
                }
                if (c == '1') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(1);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '2') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(2);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '3') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(3);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '4') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(4);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '5') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(5);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '6') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(6);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '7') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(7);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '8') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(8);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == '9') {
                    VimMatchGroup vimMatchGroup = matchResult.getGroups().get(9);
                    result.append(vimMatchGroup != null ? vimMatchGroup.getValue() : null);
                    continue;
                }
                if (c == 'u') {
                    caseSettings = SubstituteCase.UPPER;
                    continue;
                }
                if (c == 'U') {
                    caseSettings = SubstituteCase.UPPER_PERSISTENT;
                    continue;
                }
                if (c == 'l') {
                    caseSettings = SubstituteCase.LOWER;
                    continue;
                }
                if (c == 'L') {
                    caseSettings = SubstituteCase.LOWER_PERSISTENT;
                    continue;
                }
                if (c == 'e') {
                    caseSettings = SubstituteCase.DEFAULT;
                    continue;
                }
                if (c == 'E') {
                    caseSettings = SubstituteCase.DEFAULT;
                    continue;
                }
                if (c == 'r') {
                    result.append('\n');
                    continue;
                }
                if (c == 'n') {
                    result.append('\u0000');
                    continue;
                }
                if (c == 'b') {
                    result.append('\b');
                    continue;
                }
                if (c == 't') {
                    result.append('\t');
                    continue;
                }
                if (c == '\\') {
                    result.append('\\');
                    continue;
                }
                Pair<Character, SubstituteCase> buildResult = this.buildLiteralChar(substituteString.charAt(index), caseSettings);
                caseSettings = (SubstituteCase)((Object)buildResult.getSecond());
                result.append(((Character)buildResult.getFirst()).charValue());
                continue;
            }
            if (substituteString.charAt(index) == '&' && magic) {
                result.append(matchResult.getValue());
                continue;
            }
            if (substituteString.charAt(index) == '~' && magic) {
                result.append(this.buildSubstituteString(matchResult, lastSubstituteString, "", true));
                continue;
            }
            Pair<Character, SubstituteCase> buildResult = this.buildLiteralChar(substituteString.charAt(index), caseSettings);
            caseSettings = (SubstituteCase)((Object)buildResult.getSecond());
            result.append(((Character)buildResult.getFirst()).charValue());
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static /* synthetic */ String buildSubstituteString$default(VimRegex vimRegex, VimMatchResult.Success success, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return vimRegex.buildSubstituteString(success, string, string2, bl);
    }

    private final Pair<Character, SubstituteCase> buildLiteralChar(char c, SubstituteCase caseSettings) {
        Pair pair;
        switch (WhenMappings.$EnumSwitchMapping$0[caseSettings.ordinal()]) {
            case 1: {
                pair = new Pair((Object)Character.valueOf(c), (Object)caseSettings);
                break;
            }
            case 2: {
                pair = new Pair((Object)Character.valueOf(Character.toUpperCase(c)), (Object)SubstituteCase.DEFAULT);
                break;
            }
            case 3: {
                pair = new Pair((Object)Character.valueOf(Character.toUpperCase(c)), (Object)caseSettings);
                break;
            }
            case 4: {
                pair = new Pair((Object)Character.valueOf(Character.toLowerCase(c)), (Object)SubstituteCase.DEFAULT);
                break;
            }
            case 5: {
                pair = new Pair((Object)Character.valueOf(Character.toLowerCase(c)), (Object)caseSettings);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    @NotNull
    public final VimMatchResult matchAt(@NotNull VimEditor editor, int index, @NotNull List<? extends VimRegexOptions> options) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return this.simulateNFA(editor, index, options);
    }

    public static /* synthetic */ VimMatchResult matchAt$default(VimRegex vimRegex, VimEditor vimEditor, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.matchAt(vimEditor, n, list);
    }

    @NotNull
    public final VimMatchResult matchEntire(@NotNull VimEditor editor, @NotNull List<? extends VimRegexOptions> options) {
        VimMatchResult vimMatchResult;
        VimMatchResult result;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult2 = result = VimRegex.simulateNFA$default(this, editor, 0, options, 2, null);
        if (vimMatchResult2 instanceof VimMatchResult.Failure) {
            vimMatchResult = result;
        } else if (vimMatchResult2 instanceof VimMatchResult.Success) {
            vimMatchResult = ((VimMatchResult.Success)result).getRange().getEndOffset() == editor.text().length() ? result : (VimMatchResult)new VimMatchResult.Failure(VimRegexErrors.E486);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return vimMatchResult;
    }

    public static /* synthetic */ VimMatchResult matchEntire$default(VimRegex vimRegex, VimEditor vimEditor, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.matchEntire(vimEditor, list);
    }

    public final boolean matches(@NotNull VimEditor editor, @NotNull List<? extends VimRegexOptions> options) {
        boolean bl;
        VimMatchResult result;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult = result = VimRegex.simulateNFA$default(this, editor, 0, options, 2, null);
        if (vimMatchResult instanceof VimMatchResult.Failure) {
            bl = false;
        } else if (vimMatchResult instanceof VimMatchResult.Success) {
            bl = ((VimMatchResult.Success)result).getRange().getEndOffset() == editor.text().length();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static /* synthetic */ boolean matches$default(VimRegex vimRegex, VimEditor vimEditor, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.matches(vimEditor, list);
    }

    public final boolean matchesAt(@NotNull VimEditor editor, int index, @NotNull List<? extends VimRegexOptions> options) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        VimMatchResult vimMatchResult = this.simulateNFA(editor, index, options);
        if (vimMatchResult instanceof VimMatchResult.Success) {
            bl = true;
        } else if (vimMatchResult instanceof VimMatchResult.Failure) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static /* synthetic */ boolean matchesAt$default(VimRegex vimRegex, VimEditor vimEditor, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return vimRegex.matchesAt(vimEditor, n, list);
    }

    private final VimMatchResult simulateNFA(VimEditor editor, int index, List<? extends VimRegexOptions> options) {
        return VimRegexEngine.INSTANCE.simulate$vim_engine(this.nfa, editor, index, this.shouldIgnoreCase(options));
    }

    static /* synthetic */ VimMatchResult simulateNFA$default(VimRegex vimRegex, VimEditor vimEditor, int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vimRegex.simulateNFA(vimEditor, n, list);
    }

    private final VimMatchResult simulateNonExactNFA(VimEditor editor, int index, List<? extends VimRegexOptions> options) {
        return VimRegexEngine.INSTANCE.simulate$vim_engine(this.nonExactNFA, editor, index, this.shouldIgnoreCase(options));
    }

    static /* synthetic */ VimMatchResult simulateNonExactNFA$default(VimRegex vimRegex, VimEditor vimEditor, int n, List list, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return vimRegex.simulateNonExactNFA(vimEditor, n, list);
    }

    private final boolean shouldIgnoreCase(List<? extends VimRegexOptions> options) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$1[this.caseSensitivitySettings.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                if (!(!options.contains((Object)VimRegexOptions.IGNORE_CASE) || options.contains((Object)VimRegexOptions.SMART_CASE) && this.hasUpperCase)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/regexp/VimRegex$SubstituteCase;", "", "(Ljava/lang/String;I)V", "DEFAULT", "UPPER", "UPPER_PERSISTENT", "LOWER", "LOWER_PERSISTENT", "vim-engine"})
    private static final class SubstituteCase
    extends Enum<SubstituteCase> {
        public static final /* enum */ SubstituteCase DEFAULT = new SubstituteCase();
        public static final /* enum */ SubstituteCase UPPER = new SubstituteCase();
        public static final /* enum */ SubstituteCase UPPER_PERSISTENT = new SubstituteCase();
        public static final /* enum */ SubstituteCase LOWER = new SubstituteCase();
        public static final /* enum */ SubstituteCase LOWER_PERSISTENT = new SubstituteCase();
        private static final /* synthetic */ SubstituteCase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SubstituteCase[] values() {
            return (SubstituteCase[])$VALUES.clone();
        }

        public static SubstituteCase valueOf(String value) {
            return Enum.valueOf(SubstituteCase.class, value);
        }

        @NotNull
        public static EnumEntries<SubstituteCase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = substituteCaseArray = new SubstituteCase[]{SubstituteCase.DEFAULT, SubstituteCase.UPPER, SubstituteCase.UPPER_PERSISTENT, SubstituteCase.LOWER, SubstituteCase.LOWER_PERSISTENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SubstituteCase.values().length];
            try {
                nArray[SubstituteCase.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.UPPER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.UPPER_PERSISTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.LOWER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SubstituteCase.LOWER_PERSISTENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CaseSensitivitySettings.values().length];
            try {
                nArray[CaseSensitivitySettings.NO_IGNORE_CASE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaseSensitivitySettings.IGNORE_CASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaseSensitivitySettings.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

