/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key.consumers;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.KeyProcessResult;
import com.maddyhome.idea.vim.action.change.LazyVimCommand;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.CommandBuilder;
import com.maddyhome.idea.vim.command.CommandFlags;
import com.maddyhome.idea.vim.common.ArgumentCapturerKt;
import com.maddyhome.idea.vim.common.CurrentCommandState;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.key.CommandNode;
import com.maddyhome.idea.vim.key.CommandPartNode;
import com.maddyhome.idea.vim.key.KeyConsumer;
import com.maddyhome.idea.vim.key.Node;
import com.maddyhome.idea.vim.key.consumers.CommandConsumer;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ReturnableFromCmd;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J8\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J@\u0010 \u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\n\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a8\u0006)"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandConsumer;", "Lcom/maddyhome/idea/vim/key/KeyConsumer;", "()V", "checkArgumentCompatibility", "", "expectedArgumentType", "Lcom/maddyhome/idea/vim/command/Argument$Type;", "action", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "consumeKey", "key", "Ljavax/swing/KeyStroke;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "allowKeyMappings", "mappingCompleted", "keyProcessResultBuilder", "Lcom/maddyhome/idea/vim/KeyProcessResult$KeyProcessResultBuilder;", "shouldRecord", "Lcom/maddyhome/idea/vim/KeyHandler$MutableBoolean;", "handleCommandNode", "", "node", "Lcom/maddyhome/idea/vim/key/CommandNode;", "Lcom/maddyhome/idea/vim/action/change/LazyVimCommand;", "processBuilder", "mapOpCommand", "Lcom/maddyhome/idea/vim/key/Node;", "mode", "Lcom/maddyhome/idea/vim/state/mode/Mode;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "startWaitingForArgument", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "", "argument", "editorState", "Lcom/maddyhome/idea/vim/state/VimStateMachine;", "stopMacroRecord", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nCommandConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,217:1\n1#2:218\n38#3:219\n*S KotlinDebug\n*F\n+ 1 CommandConsumer.kt\ncom/maddyhome/idea/vim/key/consumers/CommandConsumer\n*L\n38#1:219\n*E\n"})
public final class CommandConsumer
implements KeyConsumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public boolean consumeKey(@NotNull KeyStroke key, @NotNull VimEditor editor, boolean allowKeyMappings, boolean mappingCompleted, @NotNull KeyProcessResult.KeyProcessResultBuilder keyProcessResultBuilder, @NotNull KeyHandler.MutableBoolean shouldRecord) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)keyProcessResultBuilder, (String)"keyProcessResultBuilder");
        Intrinsics.checkNotNullParameter((Object)shouldRecord, (String)"shouldRecord");
        CommandBuilder commandBuilder = keyProcessResultBuilder.getState().getCommandBuilder();
        Node<LazyVimCommand> node = this.mapOpCommand(key, commandBuilder.getChildNode(key), editor.getMode(), keyProcessResultBuilder.getState());
        logger.trace("Get the node for the current mode");
        Node<LazyVimCommand> node2 = node;
        if (node2 instanceof CommandNode) {
            logger.trace("Node is a command node");
            this.handleCommandNode(key, (CommandNode)node, keyProcessResultBuilder);
            keyProcessResultBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(key){
                final /* synthetic */ KeyStroke $key;
                {
                    this.$key = $key;
                    super(3);
                }

                public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor vimEditor, @NotNull ExecutionContext executionContext) {
                    Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                    Intrinsics.checkNotNullParameter((Object)vimEditor, (String)"<anonymous parameter 1>");
                    Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<anonymous parameter 2>");
                    lambdaKeyState.getCommandBuilder().addKey(this.$key);
                }
            }));
            return true;
        }
        if (node2 instanceof CommandPartNode) {
            logger.trace("Node is a command part node");
            commandBuilder.setCurrentCommandPartNode((CommandPartNode)node);
            commandBuilder.addKey(key);
            return true;
        }
        return false;
    }

    private final Node<LazyVimCommand> mapOpCommand(KeyStroke key, Node<LazyVimCommand> node, Mode mode, KeyHandlerState keyState) {
        Node<LazyVimCommand> node2;
        if (KeyHandler.Companion.getInstance().isDuplicateOperatorKeyStroke(key, mode, keyState)) {
            CommandBuilder commandBuilder = keyState.getCommandBuilder();
            KeyStroke keyStroke = KeyStroke.getKeyStroke('_');
            Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"getKeyStroke(...)");
            node2 = commandBuilder.getChildNode(keyStroke);
        } else {
            node2 = node;
        }
        return node2;
    }

    private final void handleCommandNode(KeyStroke key, CommandNode<LazyVimCommand> node, KeyProcessResult.KeyProcessResultBuilder processBuilder) {
        logger.trace("Handle command node");
        EditorActionHandlerBase action2 = (EditorActionHandlerBase)node.getActionHolder().getInstance();
        KeyHandlerState keyState = processBuilder.getState();
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        Argument.Type expectedArgumentType = commandBuilder.getExpectedArgumentType();
        commandBuilder.pushCommandPart(action2);
        if (!this.checkArgumentCompatibility(expectedArgumentType, action2)) {
            logger.trace("Return from command node handling");
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)handleCommandNode.1.INSTANCE));
            return;
        }
        if (action2.getArgumentType() == null || this.stopMacroRecord(node)) {
            logger.trace("Set command state to READY");
            commandBuilder.setCommandState(CurrentCommandState.READY);
        } else {
            processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(action2, this, key){
                final /* synthetic */ EditorActionHandlerBase $action;
                final /* synthetic */ CommandConsumer this$0;
                final /* synthetic */ KeyStroke $key;
                {
                    this.$action = $action;
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(3);
                }

                public final void invoke(@NotNull KeyHandlerState lambdaKeyState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext lambdaContext) {
                    Intrinsics.checkNotNullParameter((Object)lambdaKeyState, (String)"lambdaKeyState");
                    Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                    Intrinsics.checkNotNullParameter((Object)lambdaContext, (String)"lambdaContext");
                    CommandConsumer.access$getLogger$cp().trace("Set waiting for the argument");
                    Argument.Type argumentType = this.$action.getArgumentType();
                    VimStateMachine editorState = EngineHelperKt.getVimStateMachine(lambdaEditor);
                    char c = this.$key.getKeyChar();
                    Argument.Type type = argumentType;
                    Intrinsics.checkNotNull((Object)((Object)type));
                    CommandConsumer.access$startWaitingForArgument(this.this$0, lambdaEditor, lambdaContext, c, this.$action, type, lambdaKeyState, editorState);
                    lambdaKeyState.partialReset(editorState.getMode());
                }
            }));
        }
        processBuilder.addExecutionStep((Function3<? super KeyHandlerState, ? super VimEditor, ? super ExecutionContext, Unit>)((Function3)new Function3<KeyHandlerState, VimEditor, ExecutionContext, Unit>(expectedArgumentType, action2, commandBuilder){
            final /* synthetic */ Argument.Type $expectedArgumentType;
            final /* synthetic */ EditorActionHandlerBase $action;
            final /* synthetic */ CommandBuilder $commandBuilder;
            {
                this.$expectedArgumentType = $expectedArgumentType;
                this.$action = $action;
                this.$commandBuilder = $commandBuilder;
                super(3);
            }

            public final void invoke(@NotNull KeyHandlerState keyHandlerState, @NotNull VimEditor lambdaEditor, @NotNull ExecutionContext executionContext) {
                Intrinsics.checkNotNullParameter((Object)keyHandlerState, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)lambdaEditor, (String)"lambdaEditor");
                Intrinsics.checkNotNullParameter((Object)executionContext, (String)"<anonymous parameter 2>");
                if (this.$expectedArgumentType == Argument.Type.EX_STRING && this.$action.getFlags().contains((Object)((Object)CommandFlags.FLAG_COMPLETE_EX))) {
                    CommandConsumer.access$getLogger$cp().trace("Processing ex_string");
                    String text2 = VimInjectorKt.getInjector().getProcessGroup().endSearchCommand();
                    this.$commandBuilder.popCommandPart();
                    this.$commandBuilder.completeCommandPart(new Argument(text2));
                    lambdaEditor.setMode(ModeExtensionsKt.returnTo(lambdaEditor.getMode()));
                }
            }
        }));
    }

    private final boolean stopMacroRecord(CommandNode<LazyVimCommand> node) {
        return VimInjectorKt.getInjector().getRegisterGroup().isRecording() && Intrinsics.areEqual((Object)((EditorActionHandlerBase)node.getActionHolder().getInstance()).getId(), (Object)"VimToggleRecordingAction");
    }

    private final void startWaitingForArgument(VimEditor editor, ExecutionContext context, char key, EditorActionHandlerBase action2, Argument.Type argument, KeyHandlerState keyState, VimStateMachine editorState) {
        CommandBuilder commandBuilder = keyState.getCommandBuilder();
        switch (WhenMappings.$EnumSwitchMapping$0[argument.ordinal()]) {
            case 1: {
                if (editorState.isDotRepeatInProgress() && ArgumentCapturerKt.getArgumentCaptured() != null) {
                    Argument argument2 = ArgumentCapturerKt.getArgumentCaptured();
                    Intrinsics.checkNotNull((Object)argument2);
                    commandBuilder.completeCommandPart(argument2);
                }
                editor.setMode(new Mode.OP_PENDING(ModeExtensionsKt.getReturnTo(editorState.getMode()), null, 2, null));
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)action2.getId(), (Object)"VimInsertCompletedDigraphAction")) {
                    keyState.getDigraphSequence().startDigraphSequence();
                    KeyHandler.Companion.getInstance().setPromptCharacterEx('?');
                    break;
                }
                if (!Intrinsics.areEqual((Object)action2.getId(), (Object)"VimInsertCompletedLiteralAction")) break;
                keyState.getDigraphSequence().startLiteralSequence();
                KeyHandler.Companion.getInstance().setPromptCharacterEx('^');
                break;
            }
            case 3: {
                VimInjectorKt.getInjector().getProcessGroup().startSearchCommand(editor, context, commandBuilder.getCount(), key);
                commandBuilder.setCommandState(CurrentCommandState.NEW_COMMAND);
                Mode currentMode = editorState.getMode();
                if (!(currentMode instanceof ReturnableFromCmd)) {
                    boolean bl = false;
                    String string = "Cannot enable command line mode " + currentMode;
                    throw new IllegalStateException(string.toString());
                }
                editor.setMode(new Mode.CMD_LINE((ReturnableFromCmd)((Object)currentMode)));
                break;
            }
        }
        if (Intrinsics.areEqual((Object)action2.getId(), (Object)"VimChangeCharacterAction") || Intrinsics.areEqual((Object)action2.getId(), (Object)"VimChangeVisualCharacterAction")) {
            editor.setReplaceCharacter(true);
        }
    }

    private final boolean checkArgumentCompatibility(Argument.Type expectedArgumentType, EditorActionHandlerBase action2) {
        return expectedArgumentType != Argument.Type.MOTION || action2.getType() == Command.Type.MOTION;
    }

    public static final /* synthetic */ VimLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$startWaitingForArgument(CommandConsumer $this, VimEditor editor, ExecutionContext context, char key, EditorActionHandlerBase action2, Argument.Type argument, KeyHandlerState keyState, VimStateMachine editorState) {
        $this.startWaitingForArgument(editor, context, key, action2, argument, keyState, editorState);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(CommandConsumer.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/key/consumers/CommandConsumer$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Argument.Type.values().length];
            try {
                nArray[Argument.Type.MOTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Argument.Type.DIGRAPH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Argument.Type.EX_STRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

