/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.key;

import com.maddyhome.idea.vim.KeyHandler;
import com.maddyhome.idea.vim.action.change.Extension;
import com.maddyhome.idea.vim.action.change.VimRepeater;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Argument;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.common.ArgumentCapturerKt;
import com.maddyhome.idea.vim.common.Offset;
import com.maddyhome.idea.vim.common.VimRangeKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.extension.ExtensionHandler;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.key.MappingInfo;
import com.maddyhome.idea.vim.key.MappingOwner;
import com.maddyhome.idea.vim.state.KeyHandlerState;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/key/ToHandlerMappingInfo;", "Lcom/maddyhome/idea/vim/key/MappingInfo;", "extensionHandler", "Lcom/maddyhome/idea/vim/extension/ExtensionHandler;", "fromKeys", "", "Ljavax/swing/KeyStroke;", "isRecursive", "", "owner", "Lcom/maddyhome/idea/vim/key/MappingOwner;", "(Lcom/maddyhome/idea/vim/extension/ExtensionHandler;Ljava/util/List;ZLcom/maddyhome/idea/vim/key/MappingOwner;)V", "execute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "getPresentableString", "", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nMappingInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MappingInfo.kt\ncom/maddyhome/idea/vim/key/ToHandlerMappingInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,268:1\n1271#2,2:269\n1285#2,4:271\n38#3:275\n*S KotlinDebug\n*F\n+ 1 MappingInfo.kt\ncom/maddyhome/idea/vim/key/ToHandlerMappingInfo\n*L\n162#1:269,2\n162#1:271,4\n208#1:275\n*E\n"})
public final class ToHandlerMappingInfo
extends MappingInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionHandler extensionHandler;
    @NotNull
    private static final VimLogger LOG;

    public ToHandlerMappingInfo(@NotNull ExtensionHandler extensionHandler, @NotNull List<? extends KeyStroke> fromKeys, boolean isRecursive, @NotNull MappingOwner owner) {
        Intrinsics.checkNotNullParameter((Object)extensionHandler, (String)"extensionHandler");
        Intrinsics.checkNotNullParameter(fromKeys, (String)"fromKeys");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(fromKeys, isRecursive, owner, null);
        this.extensionHandler = extensionHandler;
    }

    @Override
    @NotNull
    public String getPresentableString() {
        return "call " + this.extensionHandler.getClass().getCanonicalName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull KeyHandlerState keyState) {
        ExtensionHandler handler;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyState, (String)"keyState");
        LOG.debug("Executing 'ToHandler' mapping info...");
        VimStateMachine vimStateMachine = VimStateMachine.Companion.getInstance(editor);
        boolean shouldCalculateOffsets = vimStateMachine.isOperatorPending(editor.getMode());
        Iterable $this$associateWith$iv = editor.carets();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ImmutableVimCaret immutableVimCaret = (ImmutableVimCaret)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Offset offset = it.getOffset();
            map.put(t, offset);
        }
        Map startOffsets = result$iv;
        if (this.extensionHandler.isRepeatable()) {
            Extension.INSTANCE.clean();
        }
        if ((handler = this.extensionHandler) instanceof ExtensionHandler.WithCallback) {
            ((ExtensionHandler.WithCallback)handler).set_backingFunction(() -> ToHandlerMappingInfo.execute$lambda$1(shouldCalculateOffsets, editor, startOffsets, keyState, context));
        }
        OperatorArguments operatorArguments = new OperatorArguments(vimStateMachine.isOperatorPending(editor.getMode()), keyState.getCommandBuilder().getCount(), vimStateMachine.getMode());
        VimInjectorKt.getInjector().getActionExecutor().executeCommand(editor, () -> ToHandlerMappingInfo.execute$lambda$2(this, editor, context, operatorArguments), "Vim " + this.extensionHandler.getClass().getSimpleName(), null);
        if (this.extensionHandler.isRepeatable()) {
            Extension.INSTANCE.setLastExtensionHandler(this.extensionHandler);
            ArgumentCapturerKt.setArgumentCaptured(null);
            VimRepeater.INSTANCE.setRepeatHandler(true);
        }
        if (!(handler instanceof ExtensionHandler.WithCallback)) {
            ToHandlerMappingInfo.Companion.myFun(shouldCalculateOffsets, editor, startOffsets, keyState);
        }
    }

    private static final void execute$lambda$1(boolean $shouldCalculateOffsets, VimEditor $editor, Map $startOffsets, KeyHandlerState $keyState, ExecutionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$startOffsets, (String)"$startOffsets");
        Intrinsics.checkNotNullParameter((Object)$keyState, (String)"$keyState");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        ToHandlerMappingInfo.Companion.myFun($shouldCalculateOffsets, $editor, $startOffsets, $keyState);
        if ($shouldCalculateOffsets) {
            VimInjectorKt.getInjector().getApplication().invokeLater((Function0<Unit>)((Function0)new Function0<Unit>($editor, $context, $keyState){
                final /* synthetic */ VimEditor $editor;
                final /* synthetic */ ExecutionContext $context;
                final /* synthetic */ KeyHandlerState $keyState;
                {
                    this.$editor = $editor;
                    this.$context = $context;
                    this.$keyState = $keyState;
                    super(0);
                }

                public final void invoke() {
                    KeyHandler keyHandler = KeyHandler.Companion.getInstance();
                    keyHandler.finishedCommandPreparation$vim_engine(this.$editor, this.$context, null, new KeyHandler.MutableBoolean(false), this.$keyState);
                }
            }));
        }
    }

    private static final void execute$lambda$2(ToHandlerMappingInfo this$0, VimEditor $editor, ExecutionContext $context, OperatorArguments $operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$operatorArguments, (String)"$operatorArguments");
        this$0.extensionHandler.execute($editor, $context, $operatorArguments);
    }

    static {
        boolean $i$f$vimLogger = false;
        LOG = VimInjectorKt.getInjector().getLogger(ToHandlerMappingInfo.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/key/ToHandlerMappingInfo$Companion;", "", "()V", "LOG", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "myFun", "", "shouldCalculateOffsets", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "startOffsets", "", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "Lcom/maddyhome/idea/vim/common/Offset;", "keyState", "Lcom/maddyhome/idea/vim/state/KeyHandlerState;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        private final void myFun(boolean shouldCalculateOffsets, VimEditor editor, Map<ImmutableVimCaret, Offset> startOffsets, KeyHandlerState keyState) {
            if (shouldCalculateOffsets && !keyState.getCommandBuilder().hasCurrentCommandPartArgument()) {
                Map offsets = new HashMap();
                for (VimCaret caret : editor.carets()) {
                    Offset startOffset = startOffsets.get(caret);
                    if (caret.hasSelection()) {
                        int n = caret.getVimSelectionStart();
                        int n2 = caret.getOffset().getPoint();
                        SelectionType selectionType = ModeExtensionsKt.getSelectionType(editor.getMode());
                        if (selectionType == null) {
                            selectionType = SelectionType.CHARACTER_WISE;
                        }
                        VimSelection vimSelection = VimSelection.Companion.create(n, n2, selectionType, editor);
                        offsets.put(caret, vimSelection);
                        editor.setMode(new Mode.NORMAL(null, 1, null));
                        continue;
                    }
                    if (startOffset == null || startOffset.getPoint() == caret.getOffset().getPoint()) continue;
                    Offset endOffset = caret.getOffset();
                    if (startOffset.getPoint() < endOffset.getPoint()) {
                        endOffset = VimRangeKt.getOffset(endOffset.getPoint() - 1);
                    } else {
                        startOffset = VimRangeKt.getOffset(startOffset.getPoint() - 1);
                    }
                    VimSelection vimSelection = VimSelection.Companion.create(startOffset.getPoint(), endOffset.getPoint(), SelectionType.CHARACTER_WISE, editor);
                    offsets.put(caret, vimSelection);
                    editor.currentCaret().moveToOffset(startOffset.getPoint());
                }
                if (!offsets.isEmpty()) {
                    keyState.getCommandBuilder().completeCommandPart(new Argument(offsets));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

