/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.history;

import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.history.HistoryBlock;
import com.maddyhome.idea.vim.history.HistoryEntry;
import com.maddyhome.idea.vim.history.VimHistory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/maddyhome/idea/vim/history/VimHistoryBase;", "Lcom/maddyhome/idea/vim/history/VimHistory;", "()V", "histories", "", "", "Lcom/maddyhome/idea/vim/history/HistoryBlock;", "getHistories", "()Ljava/util/Map;", "addEntry", "", "key", "text", "blocks", "getEntries", "", "Lcom/maddyhome/idea/vim/history/HistoryEntry;", "first", "", "last", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimHistoryBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimHistoryBase.kt\ncom/maddyhome/idea/vim/history/VimHistoryBase\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,70:1\n33#2,4:71\n33#2,4:75\n38#2:86\n372#3,7:79\n*S KotlinDebug\n*F\n+ 1 VimHistoryBase.kt\ncom/maddyhome/idea/vim/history/VimHistoryBase\n*L\n19#1:71,4\n51#1:75,4\n67#1:86\n63#1:79,7\n*E\n"})
public class VimHistoryBase
implements VimHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, HistoryBlock> histories = new HashMap();
    @NotNull
    private static final VimLogger logger;

    @NotNull
    public final Map<String, HistoryBlock> getHistories() {
        return this.histories;
    }

    @Override
    public void addEntry(@NotNull String key, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("Add entry '" + text2 + "' to " + key);
        }
        HistoryBlock block = this.blocks(key);
        block.addEntry(text2);
    }

    @Override
    @NotNull
    public List<HistoryEntry> getEntries(@NotNull String key, int first, int last) {
        HistoryEntry entry;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int myFirst = 0;
        myFirst = first;
        int myLast = 0;
        myLast = last;
        HistoryBlock block = this.blocks(key);
        List<HistoryEntry> entries = block.getEntries();
        ArrayList<HistoryEntry> res2 = new ArrayList<HistoryEntry>();
        if (myFirst < 0) {
            int n;
            if (-myFirst > entries.size()) {
                n = Integer.MAX_VALUE;
            } else {
                entry = entries.get(entries.size() + myFirst);
                n = myFirst = entry.getNumber();
            }
        }
        if (myLast < 0) {
            int n;
            if (-myLast > entries.size()) {
                n = Integer.MIN_VALUE;
            } else {
                entry = entries.get(entries.size() + myLast);
                n = entry.getNumber();
            }
            myLast = n;
        } else if (myLast == 0) {
            myLast = Integer.MAX_VALUE;
        }
        VimLogger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebug()) {
            VimLogger vimLogger = $this$debug$iv;
            boolean bl = false;
            vimLogger.debug("first=" + myFirst + "\nlast=" + myLast);
        }
        for (HistoryEntry entry2 : entries) {
            int n = entry2.getNumber();
            boolean bl = myFirst <= n ? n <= myLast : false;
            if (!bl) continue;
            res2.add(entry2);
        }
        return res2;
    }

    private final HistoryBlock blocks(String key) {
        HistoryBlock historyBlock;
        Map<String, HistoryBlock> $this$getOrPut$iv = this.histories;
        boolean $i$f$getOrPut = false;
        HistoryBlock value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            HistoryBlock answer$iv = new HistoryBlock();
            $this$getOrPut$iv.put(key, answer$iv);
            historyBlock = answer$iv;
        } else {
            historyBlock = value$iv;
        }
        return historyBlock;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimHistoryBase.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/history/VimHistoryBase$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

