/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.action.change.VimRepeater;
import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.group.visual.VimBlockSelection;
import com.maddyhome.idea.vim.group.visual.VimSelection;
import com.maddyhome.idea.vim.group.visual.VimSimpleSelection;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.group.visual.VisualOperation;
import com.maddyhome.idea.vim.handler.EditorActionHandlerBase;
import com.maddyhome.idea.vim.handler.VisualOperatorActionHandler;
import com.maddyhome.idea.vim.helper.EngineHelperKt;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.Mode;
import com.maddyhome.idea.vim.state.mode.ModeExtensionsKt;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u0006H\u0002\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler;", "Lcom/maddyhome/idea/vim/handler/EditorActionHandlerBase;", "()V", "baseExecute", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "collectSelections", "", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "Companion", "ForEachCaret", "SingleExecution", "VisualStartFinishWrapper", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$SingleExecution;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVisualOperatorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,277:1\n33#2,4:278\n33#2,4:282\n38#2:294\n1855#3,2:286\n1271#3,2:288\n1285#3,4:290\n*S KotlinDebug\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler\n*L\n124#1:278,4\n125#1:282,4\n274#1:294\n194#1:286,2\n213#1:288,2\n213#1:290,4\n*E\n"})
public abstract class VisualOperatorActionHandler
extends EditorActionHandlerBase {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    private VisualOperatorActionHandler() {
        super(false);
    }

    @Override
    public final boolean baseExecute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Boolean[] res2;
        block10: {
            VimLogger vimLogger;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
            logger.info("Execute visual command " + cmd);
            editor.setVimChangeActionSwitchMode(null);
            Map<VimCaret, VimSelection> map = this.collectSelections(editor);
            if (map == null) {
                return false;
            }
            Map<VimCaret, VimSelection> selections = map;
            VimLogger $this$debug$iv = logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug("Count of selection segments: " + selections.size());
            }
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug(CollectionsKt.joinToString$default((Iterable)selections.values(), (CharSequence)"\n", null, null, (int)0, null, (Function1)baseExecute.2.1.INSTANCE, (int)30, null));
            }
            VisualStartFinishWrapper commandWrapper = new VisualStartFinishWrapper(editor, cmd);
            commandWrapper.start();
            Object object = new Boolean[]{true};
            res2 = object;
            object = this;
            if (object instanceof SingleExecution) {
                res2[0] = ((SingleExecution)this).executeForAllCarets(editor, context, cmd, selections, operatorArguments);
            } else if (object instanceof ForEachCaret) {
                logger.debug("Calling 'before execution'");
                if (!((ForEachCaret)this).beforeExecution(editor, context, cmd, selections)) {
                    logger.debug("Before execution block returned false. Stop further processing");
                    return false;
                }
                if (selections.keySet().isEmpty()) {
                    return false;
                }
                if (selections.keySet().size() == 1) {
                    res2[0] = ((ForEachCaret)this).executeAction(editor, (VimCaret)CollectionsKt.first((Iterable)selections.keySet()), context, cmd, (VimSelection)CollectionsKt.first((Iterable)selections.values()), operatorArguments);
                } else {
                    editor.forEachNativeCaret((Function1<? super VimCaret, Unit>)((Function1)new Function1<VimCaret, Unit>(selections, this, editor, context, cmd, operatorArguments, res2){
                        final /* synthetic */ Map<VimCaret, VimSelection> $selections;
                        final /* synthetic */ VisualOperatorActionHandler this$0;
                        final /* synthetic */ VimEditor $editor;
                        final /* synthetic */ ExecutionContext $context;
                        final /* synthetic */ Command $cmd;
                        final /* synthetic */ OperatorArguments $operatorArguments;
                        final /* synthetic */ Boolean[] $res;
                        {
                            this.$selections = $selections;
                            this.this$0 = $receiver;
                            this.$editor = $editor;
                            this.$context = $context;
                            this.$cmd = $cmd;
                            this.$operatorArguments = $operatorArguments;
                            this.$res = $res;
                            super(1);
                        }

                        public final void invoke(@NotNull VimCaret currentCaret) {
                            Intrinsics.checkNotNullParameter((Object)currentCaret, (String)"currentCaret");
                            VimSelection range = (VimSelection)MapsKt.getValue(this.$selections, (Object)currentCaret);
                            boolean loopRes = ((ForEachCaret)this.this$0).executeAction(this.$editor, currentCaret, this.$context, this.$cmd, range, this.$operatorArguments);
                            this.$res[0] = loopRes & this.$res[0];
                        }
                    }), true);
                }
                logger.debug("Calling 'after execution'");
                ((ForEachCaret)this).afterExecution(editor, context, cmd, res2[0]);
            }
            commandWrapper.finish(res2[0]);
            Mode mode = editor.getVimChangeActionSwitchMode();
            if (mode == null) break block10;
            Mode it = mode;
            boolean bl = false;
            VimInjectorKt.getInjector().getChangeGroup().processPostChangeModeSwitch(editor, context, it);
        }
        return res2[0];
    }

    /*
     * WARNING - void declaration
     */
    private final Map<VimCaret, VimSelection> collectSelections(VimEditor $this$collectSelections) {
        Map map;
        if (!EditorExtensionsKt.getInVisualMode($this$collectSelections) && EngineHelperKt.getInRepeatMode($this$collectSelections)) {
            if ($this$collectSelections.getVimLastSelectionType() == SelectionType.BLOCK_WISE) {
                VimCaret primaryCaret = $this$collectSelections.primaryCaret();
                VisualChange visualChange = primaryCaret.getVimLastVisualOperatorRange();
                if (visualChange == null) {
                    return null;
                }
                VisualChange range = visualChange;
                int end = VisualOperation.INSTANCE.calculateRange($this$collectSelections, range, 1, primaryCaret);
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)primaryCaret, (Object)new VimBlockSelection(primaryCaret.getOffset().getPoint(), end, $this$collectSelections, range.getColumns() >= 9999)));
            } else {
                Map carets = new LinkedHashMap();
                Iterable $this$forEach$iv = $this$collectSelections.nativeCarets();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VisualChange range;
                    VimCaret caret = (VimCaret)element$iv;
                    boolean bl = false;
                    if (caret.getVimLastVisualOperatorRange() == null) continue;
                    int end = VisualOperation.INSTANCE.calculateRange($this$collectSelections, range, 1, caret);
                    Map map2 = carets;
                    Pair pair = TuplesKt.to((Object)caret, (Object)VimSelection.Companion.create(caret.getOffset().getPoint(), end, range.getType(), $this$collectSelections));
                    map2.put(pair.getFirst(), pair.getSecond());
                }
                map = MapsKt.toMap((Map)carets);
            }
        } else if (EditorExtensionsKt.getInBlockSelection($this$collectSelections)) {
            VimCaret primaryCaret = $this$collectSelections.primaryCaret();
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)primaryCaret, (Object)new VimBlockSelection(primaryCaret.getVimSelectionStart(), primaryCaret.getOffset().getPoint(), $this$collectSelections, primaryCaret.getVimLastColumn() >= 9999)));
        } else {
            Iterable $this$associateWith$iv = $this$collectSelections.nativeCarets();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void caret;
                VimCaret range = (VimCaret)element$iv$iv;
                Object t = element$iv$iv;
                Map map3 = result$iv;
                boolean bl = false;
                Mode mode = EngineHelperKt.getVimStateMachine($this$collectSelections).getMode();
                int n = caret.getVimSelectionStart();
                int n2 = caret.getOffset().getPoint();
                int n3 = caret.getSelectionStart();
                int n4 = caret.getSelectionEnd();
                SelectionType selectionType = ModeExtensionsKt.getSelectionType(mode);
                if (selectionType == null) {
                    selectionType = SelectionType.CHARACTER_WISE;
                }
                VimSimpleSelection vimSimpleSelection = VimSimpleSelection.Companion.createWithNative(n, n2, n3, n4, selectionType, $this$collectSelections);
                map3.put(t, vimSimpleSelection);
            }
            map = result$iv;
        }
        return map;
    }

    public /* synthetic */ VisualOperatorActionHandler(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VisualOperatorActionHandler.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "getLogger", "()Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VimLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0016J8\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a8\u0006\u0017"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$ForEachCaret;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler;", "()V", "afterExecution", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "res", "", "beforeExecution", "caretsAndSelections", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "executeAction", "caret", "range", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class ForEachCaret
    extends VisualOperatorActionHandler {
        public ForEachCaret() {
            super(null);
        }

        public abstract boolean executeAction(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull Command var4, @NotNull VimSelection var5, @NotNull OperatorArguments var6);

        public boolean beforeExecution(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull Map<VimCaret, ? extends VimSelection> caretsAndSelections) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter(caretsAndSelections, (String)"caretsAndSelections");
            return true;
        }

        public void afterExecution(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, boolean res2) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a8\u0006\u0011"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$SingleExecution;", "Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler;", "()V", "executeForAllCarets", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "caretsAndSelections", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/group/visual/VimSelection;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "vim-engine"})
    public static abstract class SingleExecution
    extends VisualOperatorActionHandler {
        public SingleExecution() {
            super(null);
        }

        public abstract boolean executeForAllCarets(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull Command var3, @NotNull Map<VimCaret, ? extends VimSelection> var4, @NotNull OperatorArguments var5);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$VisualStartFinishWrapper;", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/command/Command;)V", "visualChanges", "", "Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "finish", "", "res", "", "start", "vim-engine"})
    @SourceDebugExtension(value={"SMAP\nVisualOperatorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$VisualStartFinishWrapper\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,277:1\n33#2,4:278\n*S KotlinDebug\n*F\n+ 1 VisualOperatorActionHandler.kt\ncom/maddyhome/idea/vim/handler/VisualOperatorActionHandler$VisualStartFinishWrapper\n*L\n245#1:278,4\n*E\n"})
    private static final class VisualStartFinishWrapper {
        @NotNull
        private final VimEditor editor;
        @NotNull
        private final Command cmd;
        @NotNull
        private final Map<VimCaret, VisualChange> visualChanges;

        public VisualStartFinishWrapper(@NotNull VimEditor editor, @NotNull Command cmd) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            this.editor = editor;
            this.cmd = cmd;
            this.visualChanges = new LinkedHashMap();
        }

        public final void start() {
            Companion.getLogger().debug("Preparing visual command");
            this.editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)new Function1<VimCaret, Unit>(this){
                final /* synthetic */ VisualStartFinishWrapper this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VimCaret it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    VisualChange change = EditorExtensionsKt.getInVisualMode(VisualStartFinishWrapper.access$getEditor$p(this.this$0)) && !EngineHelperKt.getInRepeatMode(VisualStartFinishWrapper.access$getEditor$p(this.this$0)) ? VisualOperation.INSTANCE.getRange(VisualStartFinishWrapper.access$getEditor$p(this.this$0), it, VisualStartFinishWrapper.access$getCmd$p(this.this$0).getFlags()) : null;
                    VisualStartFinishWrapper.access$getVisualChanges$p(this.this$0).put(it, change);
                }
            }));
            VimLogger $this$debug$iv = Companion.getLogger();
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebug()) {
                VimLogger vimLogger = $this$debug$iv;
                boolean bl = false;
                vimLogger.debug(CollectionsKt.joinToString$default((Iterable)this.visualChanges.values(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<VisualChange, CharSequence>(this){
                    final /* synthetic */ VisualStartFinishWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@Nullable VisualChange it) {
                        return "Caret: " + VisualStartFinishWrapper.access$getVisualChanges$p(this.this$0);
                    }
                }), (int)30, null));
            }
            Companion.getLogger().debug("Exit visual before command executing");
            EngineModeExtensionsKt.exitVisualMode(this.editor);
        }

        public final void finish(boolean res2) {
            Companion.getLogger().debug("Finish visual command. Result: " + res2);
            if (res2) {
                VimRepeater.INSTANCE.saveLastChange(this.cmd);
                VimRepeater.INSTANCE.setRepeatHandler(false);
                this.editor.forEachCaret((Function1<? super VimCaret, Unit>)((Function1)new Function1<VimCaret, Unit>(this){
                    final /* synthetic */ VisualStartFinishWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VimCaret caret) {
                        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
                        VisualChange visualChange = (VisualChange)VisualStartFinishWrapper.access$getVisualChanges$p(this.this$0).get(caret);
                        if (visualChange != null) {
                            caret.setVimLastVisualOperatorRange(visualChange);
                        }
                    }
                }));
            }
        }

        public static final /* synthetic */ VimEditor access$getEditor$p(VisualStartFinishWrapper $this) {
            return $this.editor;
        }

        public static final /* synthetic */ Command access$getCmd$p(VisualStartFinishWrapper $this) {
            return $this.cmd;
        }

        public static final /* synthetic */ Map access$getVisualChanges$p(VisualStartFinishWrapper $this) {
            return $this.visualChanges;
        }
    }
}

