/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.handler;

import com.maddyhome.idea.vim.api.ExecutionContext;
import com.maddyhome.idea.vim.api.StringListOptionValue;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualMotionGroup;
import com.maddyhome.idea.vim.command.Command;
import com.maddyhome.idea.vim.command.OperatorArguments;
import com.maddyhome.idea.vim.handler.VimActionHandler;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.state.mode.ReturnTo;
import com.maddyhome.idea.vim.state.mode.SelectionType;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ0\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J(\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/maddyhome/idea/vim/handler/ShiftedArrowKeyHandler;", "Lcom/maddyhome/idea/vim/handler/VimActionHandler$ConditionalMulticaret;", "runBothCommandsAsMulticaret", "", "(Z)V", "execute", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "context", "Lcom/maddyhome/idea/vim/api/ExecutionContext;", "cmd", "Lcom/maddyhome/idea/vim/command/Command;", "operatorArguments", "Lcom/maddyhome/idea/vim/command/OperatorArguments;", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "motionWithKeyModel", "", "motionWithoutKeyModel", "runAsMulticaret", "withKeyOrNot", "Lkotlin/Triple;", "vim-engine"})
public abstract class ShiftedArrowKeyHandler
extends VimActionHandler.ConditionalMulticaret {
    private final boolean runBothCommandsAsMulticaret;

    public ShiftedArrowKeyHandler(boolean runBothCommandsAsMulticaret) {
        this.runBothCommandsAsMulticaret = runBothCommandsAsMulticaret;
    }

    @Override
    public boolean runAsMulticaret(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        Triple<Boolean, Boolean, Boolean> triple = this.withKeyOrNot(editor);
        boolean inVisualMode = (Boolean)triple.component1();
        boolean inSelectMode = (Boolean)triple.component2();
        boolean withKey = (Boolean)triple.component3();
        if (withKey) {
            if (!inVisualMode && !inSelectMode) {
                if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSelectmode().contains((Object)"key")) {
                    VimInjectorKt.getInjector().getVisualMotionGroup().enterSelectMode(editor, SelectionType.CHARACTER_WISE);
                } else if (EditorExtensionsKt.isInsertionAllowed(editor)) {
                    VimInjectorKt.getInjector().getVisualMotionGroup().toggleVisual(editor, 1, 0, SelectionType.CHARACTER_WISE, ReturnTo.INSERT.INSTANCE);
                } else {
                    VimVisualMotionGroup.toggleVisual$default(VimInjectorKt.getInjector().getVisualMotionGroup(), editor, 1, 0, SelectionType.CHARACTER_WISE, null, 16, null);
                }
            }
            return true;
        }
        return this.runBothCommandsAsMulticaret;
    }

    private final Triple<Boolean, Boolean, Boolean> withKeyOrNot(VimEditor editor) {
        StringListOptionValue keymodelOption = VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getKeymodel();
        boolean startSel = keymodelOption.contains((Object)"startsel");
        boolean inVisualMode = EditorExtensionsKt.getInVisualMode(editor);
        boolean inSelectMode = EditorExtensionsKt.getInSelectMode(editor);
        boolean continueSelectSelection = keymodelOption.contains((Object)"continueselect") && inSelectMode;
        boolean continueVisualSelection = keymodelOption.contains((Object)"continuevisual") && inVisualMode;
        boolean withKey = startSel || continueSelectSelection || continueVisualSelection;
        return new Triple((Object)inVisualMode, (Object)inSelectMode, (Object)withKey);
    }

    @Override
    public boolean execute(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        if (this.runBothCommandsAsMulticaret) {
            boolean withKey = (Boolean)this.withKeyOrNot(editor).component3();
            if (withKey) {
                this.motionWithKeyModel(editor, caret, context, cmd);
            } else {
                this.motionWithoutKeyModel(editor, context, cmd);
            }
        } else {
            this.motionWithKeyModel(editor, caret, context, cmd);
        }
        return true;
    }

    @Override
    public final boolean execute(@NotNull VimEditor editor, @NotNull ExecutionContext context, @NotNull Command cmd, @NotNull OperatorArguments operatorArguments) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)operatorArguments, (String)"operatorArguments");
        this.motionWithoutKeyModel(editor, context, cmd);
        return true;
    }

    public abstract void motionWithKeyModel(@NotNull VimEditor var1, @NotNull VimCaret var2, @NotNull ExecutionContext var3, @NotNull Command var4);

    public abstract void motionWithoutKeyModel(@NotNull VimEditor var1, @NotNull ExecutionContext var2, @NotNull Command var3);
}

