/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.common;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.common.DigraphResult;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import java.util.Arrays;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u0000H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/maddyhome/idea/vim/common/DigraphSequence;", "", "()V", "codeChars", "", "codeCnt", "", "codeMax", "codeType", "digraphChar", "", "digraphState", "clone", "equals", "", "other", "", "hashCode", "isDigraphStart", "key", "Ljavax/swing/KeyStroke;", "isLiteralStart", "processKey", "Lcom/maddyhome/idea/vim/common/DigraphResult;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "reset", "", "specialKeyToKeyCode", "startDigraphSequence", "startLiteralSequence", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nDigraphSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DigraphSequence.kt\ncom/maddyhome/idea/vim/common/DigraphSequence\n+ 2 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,280:1\n38#2:281\n*S KotlinDebug\n*F\n+ 1 DigraphSequence.kt\ncom/maddyhome/idea/vim/common/DigraphSequence\n*L\n277#1:281\n*E\n"})
public final class DigraphSequence
implements Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int digraphState = 1;
    private char digraphChar;
    private char[] codeChars;
    private int codeCnt;
    private int codeType;
    private int codeMax;
    private static final int DIG_STATE_PENDING = 1;
    private static final int DIG_STATE_DIG_ONE = 2;
    private static final int DIG_STATE_DIG_TWO = 3;
    private static final int DIG_STATE_CODE_START = 10;
    private static final int DIG_STATE_CODE_CHAR = 11;
    private static final int DIG_STATE_BACK_SPACE = 20;
    @NotNull
    private static final VimLogger logger;

    public final boolean isDigraphStart(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.digraphState == 1 && key.getKeyCode() == 75 && (key.getModifiers() & 0x80) != 0;
    }

    public final boolean isLiteralStart(@NotNull KeyStroke key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.digraphState == 1 && (key.getKeyCode() == 86 || key.getKeyCode() == 81) && (key.getModifiers() & 0x80) != 0;
    }

    @NotNull
    public final DigraphResult startDigraphSequence() {
        logger.debug("startDigraphSequence");
        this.digraphState = 2;
        return DigraphResult.HANDLED_DIGRAPH;
    }

    @NotNull
    public final DigraphResult startLiteralSequence() {
        logger.debug("startLiteralSequence");
        this.digraphState = 10;
        this.codeChars = new char[8];
        this.codeCnt = 0;
        return DigraphResult.HANDLED_LITERAL;
    }

    @NotNull
    public final DigraphResult processKey(@NotNull KeyStroke key, @NotNull VimEditor editor) {
        DigraphResult digraphResult;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        switch (this.digraphState) {
            case 1: {
                logger.debug("DIG_STATE_PENDING");
                if (key.getKeyCode() == 8 && VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getDigraph()) {
                    this.digraphState = 20;
                } else if (key.getKeyChar() != '\uffff') {
                    this.digraphChar = key.getKeyChar();
                }
                digraphResult = DigraphResult.UNHANDLED;
                break;
            }
            case 20: {
                logger.debug("DIG_STATE_BACK_SPACE");
                this.digraphState = 1;
                if (key.getKeyChar() != '\uffff') {
                    char ch = VimInjectorKt.getInjector().getDigraphGroup().getDigraph(this.digraphChar, key.getKeyChar());
                    this.digraphChar = '\u0000';
                    return DigraphResult.Companion.done(KeyStroke.getKeyStroke(ch));
                }
                digraphResult = DigraphResult.UNHANDLED;
                break;
            }
            case 2: {
                logger.debug("DIG_STATE_DIG_ONE");
                if (key.getKeyChar() != '\uffff') {
                    this.digraphChar = key.getKeyChar();
                    this.digraphState = 3;
                    return DigraphResult.Companion.handled(this.digraphChar);
                }
                this.digraphState = 1;
                digraphResult = DigraphResult.BAD;
                break;
            }
            case 3: {
                logger.debug("DIG_STATE_DIG_TWO");
                this.digraphState = 1;
                if (key.getKeyChar() != '\uffff') {
                    char ch = VimInjectorKt.getInjector().getDigraphGroup().getDigraph(this.digraphChar, key.getKeyChar());
                    return DigraphResult.Companion.done(KeyStroke.getKeyStroke(ch));
                }
                digraphResult = DigraphResult.BAD;
                break;
            }
            case 10: {
                logger.debug("DIG_STATE_CODE_START");
                char ch = key.getKeyChar();
                if (ch == 'o' ? true : ch == 'O') {
                    this.codeMax = 3;
                    this.digraphState = 11;
                    this.codeType = 8;
                    logger.debug("Octal");
                    digraphResult = DigraphResult.HANDLED_LITERAL;
                    break;
                }
                if (ch == 'x' ? true : ch == 'X') {
                    this.codeMax = 2;
                    this.digraphState = 11;
                    this.codeType = 16;
                    logger.debug("hex2");
                    digraphResult = DigraphResult.HANDLED_LITERAL;
                    break;
                }
                if (ch == 'u') {
                    this.codeMax = 4;
                    this.digraphState = 11;
                    this.codeType = 16;
                    logger.debug("hex4");
                    digraphResult = DigraphResult.HANDLED_LITERAL;
                    break;
                }
                if (ch == 'U') {
                    this.codeMax = 8;
                    this.digraphState = 11;
                    this.codeType = 16;
                    logger.debug("hex8");
                    digraphResult = DigraphResult.HANDLED_LITERAL;
                    break;
                }
                if (((((((((ch == '0' ? true : ch == '1') ? true : ch == '2') ? true : ch == '3') ? true : ch == '4') ? true : ch == '5') ? true : ch == '6') ? true : ch == '7') ? true : ch == '8') ? true : ch == '9') {
                    this.codeMax = 3;
                    this.digraphState = 11;
                    this.codeType = 10;
                    char[] cArray = this.codeChars;
                    if (this.codeChars == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                        cArray = null;
                    }
                    int n = this.codeCnt;
                    this.codeCnt = n + 1;
                    cArray[n] = key.getKeyChar();
                    logger.debug("decimal");
                    digraphResult = DigraphResult.HANDLED_LITERAL;
                    break;
                }
                if (key.getKeyCode() == 9) {
                    KeyStroke code = KeyStroke.getKeyStroke('\t');
                    this.digraphState = 1;
                    return DigraphResult.Companion.done(code);
                }
                KeyStroke ks = this.specialKeyToKeyCode(key);
                if (ks != null) {
                    return DigraphResult.Companion.done(ks);
                }
                logger.debug("unknown");
                this.digraphState = 1;
                digraphResult = DigraphResult.Companion.done(key);
                break;
            }
            case 11: {
                logger.debug("DIG_STATE_CODE_CHAR");
                boolean valid = false;
                switch (this.codeType) {
                    case 10: {
                        char c = key.getKeyChar();
                        boolean bl = '0' <= c ? c < ':' : false;
                        if (!bl) break;
                        valid = true;
                        break;
                    }
                    case 8: {
                        char c = key.getKeyChar();
                        boolean bl = '0' <= c ? c < '8' : false;
                        if (!bl) break;
                        valid = true;
                        break;
                    }
                    case 16: {
                        char c = key.getKeyChar();
                        if (!('0' <= c ? c < ':' : false)) {
                            c = key.getKeyChar();
                            if (!('a' <= c ? c < 'g' : false)) {
                                c = key.getKeyChar();
                                boolean bl = 'A' <= c ? c < 'G' : false;
                                if (!bl) break;
                            }
                        }
                        valid = true;
                    }
                }
                if (valid) {
                    DigraphResult digraphResult2;
                    logger.debug("valid");
                    char[] cArray = this.codeChars;
                    if (this.codeChars == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                        cArray = null;
                    }
                    int ks = this.codeCnt;
                    this.codeCnt = ks + 1;
                    cArray[ks] = key.getKeyChar();
                    if (this.codeCnt == this.codeMax) {
                        char[] cArray2 = this.codeChars;
                        if (this.codeChars == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                            cArray2 = null;
                        }
                        char[] cArray3 = cArray2;
                        int n = 0;
                        int n2 = this.codeCnt;
                        String digits = new String(cArray3, n, n2);
                        int val = Integer.parseInt(digits, CharsKt.checkRadix((int)this.codeType));
                        KeyStroke code = KeyStroke.getKeyStroke((char)val);
                        this.digraphState = 1;
                        digraphResult2 = DigraphResult.Companion.done(code);
                    } else {
                        digraphResult2 = DigraphResult.HANDLED_LITERAL;
                    }
                    return digraphResult2;
                }
                if (this.codeCnt > 0) {
                    logger.debug("invalid");
                    char[] cArray = this.codeChars;
                    if (this.codeChars == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                        cArray = null;
                    }
                    char[] val = cArray;
                    int code = 0;
                    int n = this.codeCnt;
                    String digits = new String(val, code, n);
                    int val2 = Integer.parseInt(digits, CharsKt.checkRadix((int)this.codeType));
                    this.digraphState = 1;
                    KeyStroke code2 = KeyStroke.getKeyStroke((char)val2);
                    if (!VimInjectorKt.getInjector().getApplication().isUnitTest()) {
                        VimInjectorKt.getInjector().getApplication().postKey(key, editor);
                    }
                    return DigraphResult.Companion.done(code2);
                }
                if (this.codeCnt == 0) {
                    this.digraphState = 1;
                    return this.specialKeyToKeyCode(key) != null ? DigraphResult.Companion.done(this.specialKeyToKeyCode(key)) : DigraphResult.Companion.done(key);
                }
                digraphResult = DigraphResult.BAD;
                break;
            }
            default: {
                digraphResult = DigraphResult.BAD;
            }
        }
        return digraphResult;
    }

    private final KeyStroke specialKeyToKeyCode(KeyStroke key) {
        if ((key.getModifiers() & 0x80) != 0) {
            String specialKeyCode = VimInjectorKt.getInjector().getParser().parseVimScriptString("\\" + VimInjectorKt.getInjector().getParser().toKeyNotation(key));
            if (specialKeyCode.length() == 1) {
                return specialKeyCode.charAt(0) == '\n' ? KeyStroke.getKeyStroke('\u0000') : KeyStroke.getKeyStroke(specialKeyCode.charAt(0));
            }
        } else {
            KeyStroke keyStroke;
            switch (key.getKeyCode()) {
                case 10: {
                    keyStroke = KeyStroke.getKeyStroke('\r');
                    break;
                }
                case 27: {
                    keyStroke = KeyStroke.getKeyStroke('\u001b');
                    break;
                }
                default: {
                    keyStroke = null;
                }
            }
            return keyStroke;
        }
        logger.error("Digraph char was recognized as multiple chars");
        return null;
    }

    public final void reset() {
        this.digraphState = 1;
        this.codeChars = new char[8];
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.common.DigraphSequence");
        DigraphSequence cfr_ignored_0 = (DigraphSequence)other;
        if (this.digraphState != ((DigraphSequence)other).digraphState) {
            return false;
        }
        if (this.digraphChar != ((DigraphSequence)other).digraphChar) {
            return false;
        }
        if (this.codeCnt != ((DigraphSequence)other).codeCnt) {
            return false;
        }
        if (this.codeType != ((DigraphSequence)other).codeType) {
            return false;
        }
        if (this.codeMax != ((DigraphSequence)other).codeMax) {
            return false;
        }
        if (this.codeChars != null && ((DigraphSequence)other).codeChars != null) {
            char[] cArray = this.codeChars;
            if (this.codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray = null;
            }
            char[] cArray2 = cArray;
            char[] cArray3 = ((DigraphSequence)other).codeChars;
            if (((DigraphSequence)other).codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray3 = null;
            }
            if (!Arrays.equals(cArray2, cArray3)) {
                return false;
            }
        } else if (this.codeChars != null != (((DigraphSequence)other).codeChars != null)) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int result = this.digraphState;
        result = 31 * result + Character.hashCode(this.digraphChar);
        if (this.codeChars != null) {
            char[] cArray = this.codeChars;
            if (this.codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray = null;
            }
            n = Arrays.hashCode(cArray);
        } else {
            n = 0;
        }
        result = 31 * result + n;
        result = 31 * result + this.codeCnt;
        result = 31 * result + this.codeType;
        result = 31 * result + this.codeMax;
        return result;
    }

    @NotNull
    public DigraphSequence clone() {
        DigraphSequence result = new DigraphSequence();
        result.digraphState = this.digraphState;
        result.digraphChar = this.digraphChar;
        if (this.codeChars != null) {
            char[] cArray = this.codeChars;
            if (this.codeChars == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"codeChars");
                cArray = null;
            }
            char[] cArray2 = cArray;
            char[] cArray3 = Arrays.copyOf(cArray2, cArray2.length);
            Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"copyOf(...)");
            result.codeChars = cArray3;
        }
        result.codeCnt = this.codeCnt;
        result.codeType = this.codeType;
        result.codeMax = this.codeMax;
        return result;
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(DigraphSequence.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/maddyhome/idea/vim/common/DigraphSequence$Companion;", "", "()V", "DIG_STATE_BACK_SPACE", "", "DIG_STATE_CODE_CHAR", "DIG_STATE_CODE_START", "DIG_STATE_DIG_ONE", "DIG_STATE_DIG_TWO", "DIG_STATE_PENDING", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

