/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchHelper;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.diagnostic.VimLogger;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.regexp.VimRegex;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.state.VimStateMachine;
import com.maddyhome.idea.vim.state.mode.Mode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b&\b&\u0018\u0000 x2\u00020\u0001:\u0001xB\u0005\u00a2\u0006\u0002\u0010\u0002J\u00ad\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2{\u0010\f\u001aw\u0012\u0004\u0012\u00020\u0006\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00040\rH\u0002J6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\nH\u0016J*\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0016J*\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\nH\u0016J'\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010)J/\u0010#\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010*J'\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010)J/\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010*J?\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u00101J.\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J=\u00105\u001a\u001f0\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0003J'\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010:J'\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010:J(\u0010<\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u001fH\u0016JL\u0010>\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\nH\u0017\u00a2\u0006\u0002\u0010@JE\u0010>\u001a\u001f0\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010?\u001a\u00020\nH\u0003JL\u0010A\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010?\u001a\u00020\nH\u0003\u00a2\u0006\u0002\u0010BJL\u0010A\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\nH\u0003\u00a2\u0006\u0002\u0010CJT\u0010D\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\nH\u0017\u00a2\u0006\u0002\u0010GJT\u0010H\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\nH\u0017\u00a2\u0006\u0002\u0010GJ0\u0010I\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J0\u0010J\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J8\u0010K\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J8\u0010L\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J.\u0010M\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u0001032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0003J*\u0010N\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\nH\u0017J<\u0010O\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010P\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u000e\u0010Q\u001a\n\u0012\u0004\u0012\u00020S\u0018\u00010RH\u0016J'\u0010T\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010U\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010:J'\u0010V\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010U\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010:J0\u0010W\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0016J\\\u0010Y\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020(2\u0006\u0010E\u001a\u00020\nH\u0003\u00a2\u0006\u0002\u0010]J(\u0010^\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\nH\u0017J]\u0010_\u001a\u001f0\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010`\u001a\u00020\nH\u0003J\\\u0010a\u001a!\u0018\u00010\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020(2\u0006\u0010E\u001a\u00020\nH\u0003\u00a2\u0006\u0002\u0010]J.\u0010b\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0017\u0018\u0001032\u0006\u0010c\u001a\u00020%2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0002J\"\u0010e\u001a\u0004\u0018\u00010\u00152\u0006\u0010c\u001a\u00020%2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u0017H\u0002J@\u0010g\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010h\u001a\u00020\n2\u0006\u0010i\u001a\u00020\nH\u0016J \u0010j\u001a\u00020\u00042\u0006\u0010k\u001a\u00020%2\u0006\u0010l\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J \u0010m\u001a\u00020\n2\u0006\u0010c\u001a\u00020%2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010n\u001a\u00020\nH\u0002J \u0010o\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fH\u0002JE\u0010p\u001a\u001f0\u0004\u00a2\u0006\u001a\b6\u0012\b\b7\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b8\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010?\u001a\u00020\nH\u0003J0\u0010q\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010r\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J5\u0010s\u001a\u0004\u0018\u00010\u0004*\u00020%2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010tJ5\u0010u\u001a\u0004\u0018\u00010\u0004*\u00020%2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010U\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010tJ.\u0010v\u001a\u00020\u0004*\u00020%2\u0006\u0010.\u001a\u00020\u001f2\u0006\u0010w\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\n2\b\b\u0002\u00100\u001a\u00020\nH\u0002\u00a8\u0006y"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchHelperBase;", "Lcom/maddyhome/idea/vim/api/VimSearchHelper;", "()V", "doFindNext", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "searchFrom", "countDirection", "bigWord", "", "spaceWords", "action", "Lkotlin/Function6;", "Lkotlin/ParameterName;", "name", "pos", "size", "step", "findAll", "", "Lcom/maddyhome/idea/vim/common/TextRange;", "pattern", "", "startLine", "endLine", "ignoreCase", "findBlockQuoteInLineRange", "caret", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "quote", "", "isOuter", "findBlockTagRange", "count", "findCamelEnd", "chars", "", "startIndex", "direction", "Lcom/maddyhome/idea/vim/common/Direction;", "(Ljava/lang/CharSequence;ILcom/maddyhome/idea/vim/common/Direction;)Ljava/lang/Integer;", "(Ljava/lang/CharSequence;IILcom/maddyhome/idea/vim/common/Direction;)Ljava/lang/Integer;", "findCamelStart", "findCharacterPosition", "charSequence", "char", "currentLineOnly", "searchEscaped", "(Ljava/lang/CharSequence;CILcom/maddyhome/idea/vim/common/Direction;ZZ)Ljava/lang/Integer;", "findInnerParagraphRange", "Lkotlin/Pair;", "line", "findLastEmptyLine", "Lorg/jetbrains/annotations/Range;", "from", "to", "findNextCamelEnd", "(Ljava/lang/CharSequence;II)Ljava/lang/Integer;", "findNextCamelStart", "findNextCharacterOnLine", "ch", "findNextParagraph", "allowBlanks", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;IZ)Ljava/lang/Integer;", "findNextParagraphLine", "(Lcom/maddyhome/idea/vim/api/VimEditor;ILcom/maddyhome/idea/vim/common/Direction;Z)Ljava/lang/Integer;", "(Lcom/maddyhome/idea/vim/api/VimEditor;IIZ)Ljava/lang/Integer;", "findNextSentenceEnd", "countCurrent", "requireAll", "(Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;IZZ)Ljava/lang/Integer;", "findNextSentenceStart", "findNextWord", "findNextWordEnd", "findNextWordEndOne", "findNextWordOne", "findOuterParagraphRange", "findParagraphRange", "findPattern", "startOffset", "searchOptions", "Ljava/util/EnumSet;", "Lcom/maddyhome/idea/vim/helper/SearchOptions;", "findPreviousCamelEnd", "endIndex", "findPreviousCamelStart", "findSection", "type", "findSentenceEnd", "start", "max", "dir", "(Lcom/maddyhome/idea/vim/api/VimEditor;Ljava/lang/CharSequence;IILcom/maddyhome/idea/vim/common/Direction;Z)Ljava/lang/Integer;", "findSentenceRange", "findSentenceRangeEnd", "oneway", "findSentenceStart", "findUnmatchedClosingTag", "sequence", "position", "findUnmatchedOpeningTag", "tagName", "findWordUnderCursor", "isBig", "hasSelection", "ignoreWhitespaceAtLineStart", "seq", "lineStart", "isInHTMLTag", "isEndtag", "isQuoteWithoutEscape", "skipEmptyLines", "skipSpace", "offset", "indexOfNext", "(Ljava/lang/CharSequence;CIZZ)Ljava/lang/Integer;", "indexOfPrevious", "occurrencesBeforeOffset", "endOffset", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimSearchHelperBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimSearchHelperBase.kt\ncom/maddyhome/idea/vim/api/VimSearchHelperBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VimLogger.kt\ncom/maddyhome/idea/vim/diagnostic/VimLoggerKt\n*L\n1#1,1531:1\n1549#2:1532\n1620#2,3:1533\n1#3:1536\n38#4:1537\n*S KotlinDebug\n*F\n+ 1 VimSearchHelperBase.kt\ncom/maddyhome/idea/vim/api/VimSearchHelperBase\n*L\n186#1:1532\n186#1:1533,3\n35#1:1537\n*E\n"})
public abstract class VimSearchHelperBase
implements VimSearchHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VimLogger logger;

    @Override
    public int findSection(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, char type, int direction, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        CharSequence documentText = editor.text();
        int currentLine = caret.getBufferPosition().getLine() + direction;
        int resultOffset = -1;
        int remainingTargets = count;
        while (true) {
            char currentChar;
            boolean bl = 1 <= currentLine ? currentLine < editor.lineCount() : false;
            if (!bl || remainingTargets <= 0) break;
            int lineStartOffset = editor.getLineStartOffset(currentLine);
            if (lineStartOffset < documentText.length() && ((currentChar = documentText.charAt(lineStartOffset)) == type || currentChar == '\f')) {
                resultOffset = lineStartOffset;
                --remainingTargets;
            }
            currentLine += direction;
        }
        if (resultOffset == -1) {
            resultOffset = direction < 0 ? 0 : documentText.length() - 1;
        }
        return resultOffset;
    }

    @Override
    public int findNextCharacterOnLine(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, char ch) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line = caret.getBufferPosition().getLine();
        int start2 = editor.getLineStartOffset(line);
        int end = EngineEditorHelperKt.getLineEndOffset(editor, line, true);
        CharSequence chars = editor.text();
        int found = 0;
        int step = count >= 0 ? 1 : -1;
        int pos = caret.getOffset().getPoint() + step;
        while (true) {
            boolean bl = start2 <= pos ? pos < end : false;
            if (!bl || pos >= chars.length() || chars.charAt(pos) == ch && ++found == Math.abs(count)) break;
            pos += step;
        }
        return found == Math.abs(count) ? pos : -1;
    }

    @Override
    public int findNextWord(@NotNull VimEditor editor, int searchFrom, int count, boolean bigWord, boolean spaceWords) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.doFindNext(editor, searchFrom, count, bigWord, spaceWords, (Function6<? super VimEditor, ? super Integer, ? super Integer, ? super Integer, ? super Boolean, ? super Boolean, Integer>)((Function6)new Function6<VimEditor, Integer, Integer, Integer, Boolean, Boolean, Integer>((Object)this){

            @NotNull
            public final Integer invoke(@NotNull VimEditor p0, int p1, int p2, int p3, boolean p4, boolean p5) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return VimSearchHelperBase.access$findNextWordOne((VimSearchHelperBase)this.receiver, p0, p1, p2, p3, p4, p5);
            }
        }));
    }

    @Override
    public int findNextWordEnd(@NotNull VimEditor editor, int searchFrom, int count, boolean bigWord, boolean spaceWords) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.doFindNext(editor, searchFrom, count, bigWord, spaceWords, (Function6<? super VimEditor, ? super Integer, ? super Integer, ? super Integer, ? super Boolean, ? super Boolean, Integer>)((Function6)new Function6<VimEditor, Integer, Integer, Integer, Boolean, Boolean, Integer>((Object)this){

            @NotNull
            public final Integer invoke(@NotNull VimEditor p0, int p1, int p2, int p3, boolean p4, boolean p5) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return VimSearchHelperBase.access$findNextWordEndOne((VimSearchHelperBase)this.receiver, p0, p1, p2, p3, p4, p5);
            }
        }));
    }

    @Override
    @Nullable
    public TextRange findPattern(@NotNull VimEditor editor, @Nullable String pattern, int startOffset, int count, @Nullable EnumSet<SearchOptions> searchOptions) {
        TextRange textRange;
        VimMatchResult result;
        VimRegex vimRegex;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        CharSequence charSequence = pattern;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        EnumSet<SearchOptions> enumSet = searchOptions;
        Intrinsics.checkNotNull(enumSet);
        Direction dir = enumSet.contains((Object)SearchOptions.BACKWARDS) ? Direction.BACKWARDS : Direction.FORWARDS;
        List options = new ArrayList();
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase() && !searchOptions.contains((Object)SearchOptions.IGNORE_SMARTCASE)) {
            options.add(VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add(VimRegexOptions.IGNORE_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getWrapscan()) {
            options.add(VimRegexOptions.WRAP_SCAN);
        }
        if (searchOptions.contains((Object)SearchOptions.WANT_ENDPOS)) {
            options.add(VimRegexOptions.WANT_END_POSITION);
        }
        try {
            vimRegex = new VimRegex(pattern);
        }
        catch (VimRegexException e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            return null;
        }
        VimRegex regex = vimRegex;
        VimMatchResult vimMatchResult = result = dir == Direction.FORWARDS ? regex.findNext(editor, startOffset, options) : regex.findPrevious(editor, startOffset, options);
        if (result instanceof VimMatchResult.Failure) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, "Pattern not found: " + pattern);
            return null;
        }
        for (int i = 1; i < count; ++i) {
            VimMatchResult vimMatchResult2 = result;
            Intrinsics.checkNotNull((Object)vimMatchResult2, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.regexp.match.VimMatchResult.Success");
            int nextOffset = ((VimMatchResult.Success)vimMatchResult2).getRange().getStartOffset();
            result = dir == Direction.FORWARDS ? regex.findNext(editor, nextOffset, options) : regex.findPrevious(editor, nextOffset, options);
        }
        if (result instanceof VimMatchResult.Success) {
            textRange = ((VimMatchResult.Success)result).getRange();
        } else {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, "Pattern not found: " + pattern);
            textRange = null;
        }
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<TextRange> findAll(@NotNull VimEditor editor, @NotNull String pattern, int startLine, int endLine, boolean ignoreCase) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object newPattern;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        List options = new ArrayList();
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase()) {
            options.add(VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add(VimRegexOptions.IGNORE_CASE);
        }
        try {
            newPattern = (ignoreCase ? "\\c" : "\\C") + pattern;
            newPattern = new VimRegex((String)newPattern);
        }
        catch (VimRegexException e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            return CollectionsKt.emptyList();
        }
        Object regex = newPattern;
        newPattern = ((VimRegex)regex).findAll(editor, editor.getLineStartOffset(startLine), editor.getLineEndOffset(endLine == -1 ? editor.lineCount() - 1 : endLine) + 1, options);
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VimMatchResult.Success success = (VimMatchResult.Success)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRange());
        }
        return (List)destination$iv$iv;
    }

    private final int doFindNext(VimEditor editor, int searchFrom, int countDirection, boolean bigWord, boolean spaceWords, Function6<? super VimEditor, ? super Integer, ? super Integer, ? super Integer, ? super Boolean, ? super Boolean, Integer> action2) {
        int count = countDirection;
        int step = count >= 0 ? 1 : -1;
        count = Math.abs(count);
        int size = (int)editor.fileSize();
        int pos = searchFrom;
        int n = count;
        for (int i = 0; i < n && (pos = ((Number)action2.invoke((Object)editor, (Object)pos, (Object)size, (Object)step, (Object)bigWord, (Object)spaceWords)).intValue()) != searchFrom && pos != 0 && pos != size - 1; ++i) {
        }
        return pos;
    }

    private final int findNextWordOne(VimEditor editor, int pos, int size, int step, boolean bigWord, boolean spaceWords) {
        int _pos;
        CharSequence chars = editor.text();
        boolean found = false;
        int n = _pos = pos < size ? pos : Math.min(size, chars.length() - 1);
        if (step < 0 && _pos > 0) {
            if (CharacterHelper.charType(editor, chars.charAt(_pos - 1), bigWord) == CharacterHelper.CharacterType.WHITESPACE && !spaceWords) {
                _pos = this.skipSpace(editor, chars, _pos - 1, step, size) + 1;
            }
            if (_pos > 0 && CharacterHelper.charType(editor, chars.charAt(_pos), bigWord) != CharacterHelper.charType(editor, chars.charAt(_pos - 1), bigWord)) {
                _pos += step;
            }
        }
        int res2 = _pos;
        if (_pos < 0 || _pos >= size) {
            return _pos;
        }
        CharacterHelper.CharacterType type = CharacterHelper.charType(editor, chars.charAt(_pos), bigWord);
        if (type == CharacterHelper.CharacterType.WHITESPACE && step < 0 && _pos > 0 && !spaceWords) {
            type = CharacterHelper.charType(editor, chars.charAt(_pos - 1), bigWord);
        }
        _pos += step;
        while (true) {
            boolean bl = 0 <= _pos ? _pos < size : false;
            if (!bl || found) break;
            CharacterHelper.CharacterType newType = CharacterHelper.charType(editor, chars.charAt(_pos), bigWord);
            if (newType != type) {
                res2 = newType == CharacterHelper.CharacterType.WHITESPACE && step >= 0 && !spaceWords ? (_pos = this.skipSpace(editor, chars, _pos, step, size)) : (step < 0 ? _pos + 1 : _pos);
                type = CharacterHelper.charType(editor, chars.charAt(res2), bigWord);
                found = true;
            }
            _pos += step;
        }
        if (found) {
            if (res2 < 0) {
                res2 = 0;
            } else if (res2 >= size) {
                res2 = size - 1;
            }
        } else if (_pos <= 0) {
            res2 = 0;
        } else if (_pos >= size) {
            res2 = size;
        }
        return res2;
    }

    private final int findNextWordEndOne(VimEditor editor, int pos, int size, int step, boolean bigWord, boolean spaceWords) {
        CharSequence chars = editor.text();
        int pos2 = pos;
        boolean found = false;
        if (step > 0 && pos2 < size - 1) {
            if (CharacterHelper.charType(editor, chars.charAt(pos2 + 1), bigWord) == CharacterHelper.CharacterType.WHITESPACE && !spaceWords) {
                pos2 = this.skipSpace(editor, chars, pos2 + 1, step, size) - 1;
            }
            if (pos2 < size - 1 && CharacterHelper.charType(editor, chars.charAt(pos2), bigWord) != CharacterHelper.charType(editor, chars.charAt(pos2 + 1), bigWord)) {
                pos2 += step;
            }
        }
        int res2 = pos2;
        if (pos2 < 0 || pos2 >= size) {
            return pos2;
        }
        CharacterHelper.CharacterType type = CharacterHelper.charType(editor, chars.charAt(pos2), bigWord);
        if (type == CharacterHelper.CharacterType.WHITESPACE && step >= 0 && pos2 < size - 1 && !spaceWords) {
            type = CharacterHelper.charType(editor, chars.charAt(pos2 + 1), bigWord);
        }
        pos2 += step;
        while (pos2 >= 0 && pos2 < size && !found) {
            CharacterHelper.CharacterType newType = CharacterHelper.charType(editor, chars.charAt(pos2), bigWord);
            if (newType != type) {
                res2 = step >= 0 ? pos2 - 1 : (newType == CharacterHelper.CharacterType.WHITESPACE && step < 0 && !spaceWords ? (pos2 = this.skipSpace(editor, chars, pos2, step, size)) : pos2);
                found = true;
            }
            pos2 += step;
        }
        if (found) {
            if (res2 < 0) {
                res2 = 0;
            } else if (res2 >= size) {
                res2 = size - 1;
            }
        } else if (pos2 == size) {
            res2 = size - 1;
        }
        return res2;
    }

    private final int skipSpace(VimEditor editor, CharSequence chars, int offset, int step, int size) {
        int _offset = offset;
        char prev = '\u0000';
        while (true) {
            char c;
            boolean bl = 0 <= _offset ? _offset < size : false;
            if (!bl || (c = chars.charAt(_offset)) == '\n' && c == prev || CharacterHelper.charType(editor, c, false) != CharacterHelper.CharacterType.WHITESPACE) break;
            prev = c;
            _offset += step;
        }
        return _offset < size ? _offset : size - 1;
    }

    @Override
    @Nullable
    public Integer findNextCamelStart(@NotNull CharSequence chars, int startIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelStart(chars, startIndex, count, Direction.FORWARDS);
    }

    @Override
    @Nullable
    public Integer findPreviousCamelStart(@NotNull CharSequence chars, int endIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelStart(chars, endIndex - 1, count, Direction.BACKWARDS);
    }

    @Override
    @Nullable
    public Integer findNextCamelEnd(@NotNull CharSequence chars, int startIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelEnd(chars, startIndex, count, Direction.FORWARDS);
    }

    @Override
    @Nullable
    public Integer findPreviousCamelEnd(@NotNull CharSequence chars, int endIndex, int count) {
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        return this.findCamelEnd(chars, endIndex - 1, count, Direction.BACKWARDS);
    }

    private final Integer findCamelStart(CharSequence chars, int startIndex, int count, Direction direction) {
        boolean bl;
        boolean bl2 = bl = count >= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int offset = startIndex;
        for (int counter = 0; counter < count; ++counter) {
            int searchFrom = counter == 0 ? offset : offset + direction.toInt();
            Integer n = this.findCamelStart(chars, searchFrom, direction);
            if (n == null) {
                return null;
            }
            offset = n;
        }
        return offset;
    }

    private final Integer findCamelEnd(CharSequence chars, int startIndex, int count, Direction direction) {
        boolean bl;
        boolean bl2 = bl = count >= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int offset = startIndex;
        for (int counter = 0; counter < count; ++counter) {
            int searchFrom = counter == 0 ? offset : offset + direction.toInt();
            Integer n = this.findCamelEnd(chars, searchFrom, direction);
            if (n == null) {
                return null;
            }
            offset = n;
        }
        return offset;
    }

    private final Integer findCamelStart(CharSequence chars, int startIndex, Direction direction) {
        int pos = startIndex;
        int size = chars.length();
        if (pos < 0 || pos >= size) {
            return null;
        }
        while (true) {
            boolean bl = 0 <= pos ? pos < size : false;
            if (!bl) break;
            if (Character.isUpperCase(chars.charAt(pos)) ? pos == 0 || !Character.isUpperCase(chars.charAt(pos - 1)) || pos == size - 1 || Character.isLowerCase(chars.charAt(pos + 1)) : (Character.isLowerCase(chars.charAt(pos)) ? pos == 0 || !Character.isLetter(chars.charAt(pos - 1)) : Character.isDigit(chars.charAt(pos)) && (pos == 0 || !Character.isDigit(chars.charAt(pos - 1))))) {
                return pos;
            }
            pos += direction.toInt();
        }
        return null;
    }

    private final Integer findCamelEnd(CharSequence chars, int startIndex, Direction direction) {
        int pos = startIndex;
        int size = chars.length();
        if (pos < 0 || pos >= size) {
            return pos;
        }
        while (true) {
            boolean bl = 0 <= pos ? pos < size : false;
            if (!bl) break;
            if (Character.isUpperCase(chars.charAt(pos)) ? pos == size - 1 || !Character.isLetter(chars.charAt(pos + 1)) || Character.isUpperCase(chars.charAt(pos + 1)) && pos < size - 2 && Character.isLowerCase(chars.charAt(pos + 2)) : (Character.isLowerCase(chars.charAt(pos)) ? pos == size - 1 || !Character.isLowerCase(chars.charAt(pos + 1)) : Character.isDigit(chars.charAt(pos)) && (pos == size - 1 || !Character.isDigit(chars.charAt(pos + 1))))) {
                return pos;
            }
            pos += direction.toInt();
        }
        return null;
    }

    @Override
    @Nullable
    public TextRange findBlockQuoteInLineRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, char quote, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int leftQuote = 0;
        int rightQuote = 0;
        int caretOffset = caret.getOffset().getPoint();
        Integer n = VimSearchHelperBase.indexOfNext$default(this, editor.text(), quote, caretOffset, true, false, 8, null);
        if (n == null) {
            return null;
        }
        int quoteAfterCaret = n;
        Integer quoteBeforeCaret = VimSearchHelperBase.indexOfPrevious$default(this, editor.text(), quote, caretOffset, true, false, 8, null);
        int quotesBeforeCaret = VimSearchHelperBase.occurrencesBeforeOffset$default(this, editor.text(), quote, caretOffset, true, false, 8, null);
        if (caretOffset == quoteAfterCaret && quotesBeforeCaret % 2 == 0 || quoteBeforeCaret == null) {
            leftQuote = quoteAfterCaret;
            Integer n2 = VimSearchHelperBase.indexOfNext$default(this, editor.text(), quote, leftQuote + 1, true, false, 8, null);
            if (n2 == null) {
                return null;
            }
            rightQuote = n2;
        } else {
            leftQuote = quoteBeforeCaret;
            rightQuote = quoteAfterCaret;
        }
        if (!isOuter) {
            ++leftQuote;
            --rightQuote;
        }
        return new TextRange(leftQuote, rightQuote + 1);
    }

    private final int occurrencesBeforeOffset(CharSequence $this$occurrencesBeforeOffset, char c, int endOffset, boolean currentLineOnly, boolean searchEscaped) {
        int counter = 0;
        int i = endOffset;
        while (i > 0 && $this$occurrencesBeforeOffset.charAt(i + Direction.BACKWARDS.toInt()) != '\n') {
            Integer n = this.indexOfPrevious($this$occurrencesBeforeOffset, c, i, currentLineOnly, searchEscaped);
            if (n == null) {
                break;
            }
            i = n;
            ++counter;
        }
        return counter;
    }

    static /* synthetic */ int occurrencesBeforeOffset$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, char c, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: occurrencesBeforeOffset");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.occurrencesBeforeOffset(charSequence, c, n, bl, bl2);
    }

    private final Integer indexOfNext(CharSequence $this$indexOfNext, char c, int startIndex, boolean currentLineOnly, boolean searchEscaped) {
        return this.findCharacterPosition($this$indexOfNext, c, startIndex, Direction.FORWARDS, currentLineOnly, searchEscaped);
    }

    static /* synthetic */ Integer indexOfNext$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, char c, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOfNext");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.indexOfNext(charSequence, c, n, bl, bl2);
    }

    private final Integer indexOfPrevious(CharSequence $this$indexOfPrevious, char c, int endIndex, boolean currentLineOnly, boolean searchEscaped) {
        if (endIndex == 0 || currentLineOnly && $this$indexOfPrevious.charAt(endIndex - 1) == '\n') {
            return null;
        }
        return this.findCharacterPosition($this$indexOfPrevious, c, endIndex - 1, Direction.BACKWARDS, currentLineOnly, searchEscaped);
    }

    static /* synthetic */ Integer indexOfPrevious$default(VimSearchHelperBase vimSearchHelperBase, CharSequence charSequence, char c, int n, boolean bl, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: indexOfPrevious");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return vimSearchHelperBase.indexOfPrevious(charSequence, c, n, bl, bl2);
    }

    private final Integer findCharacterPosition(CharSequence charSequence, char c, int startIndex, Direction direction, boolean currentLineOnly, boolean searchEscaped) {
        for (int pos = startIndex; !(pos < 0 || pos >= charSequence.length() || currentLineOnly && charSequence.charAt(pos) == '\n'); pos += direction.toInt()) {
            if (charSequence.charAt(pos) != c || pos != 0 && !searchEscaped && !this.isQuoteWithoutEscape(charSequence, pos, c)) continue;
            return pos;
        }
        return null;
    }

    private final boolean isQuoteWithoutEscape(CharSequence chars, int position, char quote) {
        int i = position;
        if (chars.charAt(i) != quote) {
            return false;
        }
        int backslashCounter = 0;
        while (i-- > 0 && chars.charAt(i) == '\\') {
            ++backslashCounter;
        }
        return backslashCounter % 2 == 0;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextSentenceStart(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean countCurrent, boolean requireAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int count2 = count;
        Direction dir = count2 > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        int total = count2 = Math.abs(count2);
        CharSequence chars = editor.text();
        int start2 = caret.getOffset().getPoint();
        int max = (int)editor.fileSize();
        Integer res2 = start2;
        while (count2 > 0 && res2 != null && res2 >= 0 && res2 <= max - 1) {
            block10: {
                block9: {
                    Integer n = res2 = this.findSentenceStart(editor, chars, res2, max, dir, countCurrent);
                    if (n != null && n == 0) break block9;
                    Integer n2 = res2;
                    int n3 = max - 1;
                    if (n2 == null || n2 != n3) break block10;
                }
                --count2;
                break;
            }
            --count2;
        }
        if (!(res2 != null || requireAll && total != 1)) {
            res2 = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && !requireAll) {
            res2 = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && requireAll) {
            res2 = null;
        }
        return res2;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextSentenceEnd(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean countCurrent, boolean requireAll) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int count2 = count;
        Direction dir = count2 > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        int total = count2 = Math.abs(count2);
        CharSequence chars = editor.text();
        int start2 = caret.getOffset().getPoint();
        int max = (int)editor.fileSize();
        Integer res2 = start2;
        while (count2 > 0 && res2 != null && res2 >= 0 && res2 <= max - 1) {
            block10: {
                block9: {
                    Integer n = res2 = this.findSentenceEnd(editor, chars, res2, max, dir, countCurrent && count2 == total);
                    if (n != null && n == 0) break block9;
                    Integer n2 = res2;
                    int n3 = max - 1;
                    if (n2 == null || n2 != n3) break block10;
                }
                --count2;
                break;
            }
            --count2;
        }
        if (!(res2 != null || requireAll && total != 1)) {
            res2 = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && !requireAll) {
            res2 = dir == Direction.FORWARDS ? Integer.valueOf(max - 1) : Integer.valueOf(0);
        } else if (count2 > 0 && total > 1 && requireAll) {
            res2 = null;
        }
        return res2;
    }

    @Contract(pure=true)
    private final Integer findSentenceStart(VimEditor editor, CharSequence chars, int start2, int max, Direction dir, boolean countCurrent) {
        Integer n;
        char ch;
        int lline = editor.offsetToBufferPosition(start2).getLine();
        int np = this.findNextParagraph(editor, lline, dir, false);
        Integer end = null;
        Integer n2 = end = start2 < max && chars.charAt(start2) == '\n' && !countCurrent ? this.findSentenceEnd(editor, chars, start2, max, Direction.BACKWARDS, false) : this.findSentenceEnd(editor, chars, start2, max, Direction.BACKWARDS, true);
        int n3 = start2;
        if (n2 != null && n2 == n3 && countCurrent && chars.charAt(end) == '\n') {
            return end;
        }
        if (end != null && end >= 0) {
            int offset;
            for (offset = end + 1; offset < max && Character.isWhitespace(ch = chars.charAt(offset)); ++offset) {
            }
            if (dir == Direction.FORWARDS) {
                if (offset == start2 && countCurrent) {
                    return offset;
                }
                if (offset > start2) {
                    return offset;
                }
            } else {
                if (offset == start2 && countCurrent) {
                    return offset;
                }
                if (offset < start2) {
                    return offset;
                }
            }
        }
        if (dir == Direction.FORWARDS) {
            n = this.findSentenceEnd(editor, chars, start2, max, dir, true);
        } else {
            Integer n4 = end;
            if (n4 != null) {
                int it = ((Number)n4).intValue();
                boolean bl = false;
                n = this.findSentenceEnd(editor, chars, it - 1, max, dir, countCurrent);
            } else {
                n = null;
            }
        }
        end = n;
        Integer res2 = null;
        if (!(end == null || end >= chars.length() || chars.charAt(end) == '\n' && countCurrent)) {
            res2 = end + 1;
            while (res2 < max && Character.isWhitespace(ch = chars.charAt(res2))) {
                Integer n5 = res2;
                res2 = n5 + 1;
            }
        }
        if (res2 != null && np >= 0) {
            if (dir == Direction.FORWARDS) {
                if (np < res2 || res2 < start2) {
                    res2 = np;
                }
            } else if (np > res2 || res2 >= start2 && !countCurrent) {
                res2 = np;
            }
        } else if (res2 == null && np >= 0) {
            res2 = np;
        }
        return res2;
    }

    @Contract(pure=true)
    private final Integer findSentenceEnd(VimEditor editor, CharSequence chars, int start2, int max, Direction dir, boolean countCurrent) {
        if (dir == Direction.BACKWARDS && start2 <= 0 || dir == Direction.FORWARDS && start2 >= (int)editor.fileSize()) {
            return null;
        }
        int lline = editor.offsetToBufferPosition(start2).getLine();
        int np = this.findNextParagraph(editor, lline, dir, false);
        Integer res2 = null;
        boolean found = false;
        for (int offset = start2; offset >= 0 && offset < max && !found; offset += dir.toInt()) {
            int end;
            char ch = chars.charAt(offset);
            if (StringsKt.indexOf$default((CharSequence)".!?", (char)ch, (int)0, (boolean)false, (int)6, null) >= 0) {
                end = offset++;
                while (offset < max && StringsKt.indexOf$default((CharSequence)")]\"'", (char)(ch = chars.charAt(offset)), (int)0, (boolean)false, (int)6, null) != -1) {
                    ++offset;
                }
                if (offset >= max || Character.isWhitespace(ch)) {
                    if (offset - 1 == start2 && !countCurrent) {
                        offset = end;
                        continue;
                    }
                    res2 = offset - 1;
                    found = true;
                    continue;
                }
                offset = end;
                continue;
            }
            if (ch == '\n') {
                end = offset++;
                if (dir == Direction.FORWARDS) {
                    while (offset < max) {
                        ch = chars.charAt(offset);
                        if (ch != '\n') {
                            --offset;
                            break;
                        }
                        if (offset == np && (end - 1 != start2 || countCurrent)) break;
                        ++offset;
                    }
                    if (offset == np && (end - 1 != start2 || countCurrent)) {
                        res2 = end - 1;
                        found = true;
                    } else if (offset > end) {
                        res2 = offset;
                        np = res2;
                        found = true;
                    } else if (offset == end && offset > 0 && chars.charAt(offset - 1) == '\n' && countCurrent) {
                        res2 = end;
                        np = res2;
                        found = true;
                    }
                } else {
                    if (offset > 0) {
                        --offset;
                        while (offset > 0) {
                            ch = chars.charAt(offset);
                            if (ch != '\n') {
                                ++offset;
                                break;
                            }
                            --offset;
                        }
                    }
                    if (offset < end) {
                        res2 = end == start2 && countCurrent ? Integer.valueOf(end) : Integer.valueOf(offset - 1);
                        found = true;
                    }
                }
                offset = end;
                continue;
            }
            if (ch != '\f') continue;
            res2 = offset;
            found = true;
        }
        if (res2 != null && np >= 0) {
            if (dir == Direction.FORWARDS) {
                if (np < res2 || res2 < start2) {
                    res2 = np;
                }
            } else if (np > res2 || res2 >= start2 && !countCurrent) {
                res2 = np;
            }
        }
        return res2;
    }

    @Contract(pure=true)
    private final int findSentenceRangeEnd(VimEditor editor, CharSequence chars, int start2, int max, int count, boolean isOuter, boolean oneway) {
        int n;
        int count2 = count;
        Direction dir = count2 > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        int total = count2 = Math.abs(count2);
        boolean toggle = !isOuter;
        boolean findend = dir == Direction.BACKWARDS;
        int which = 0;
        Integer eprev = this.findSentenceEnd(editor, chars, start2, max, Direction.BACKWARDS, true);
        Integer enext = this.findSentenceEnd(editor, chars, start2, max, Direction.FORWARDS, true);
        Integer sprev = this.findSentenceStart(editor, chars, start2, max, Direction.BACKWARDS, true);
        Integer snext = this.findSentenceStart(editor, chars, start2, max, Direction.FORWARDS, true);
        if (Intrinsics.areEqual((Object)snext, (Object)eprev)) {
            if (dir == Direction.BACKWARDS && !oneway) {
                return start2;
            }
            which = 0;
            if (oneway) {
                findend = dir == Direction.FORWARDS;
            } else if (dir == Direction.FORWARDS && start2 < max - 1 && !Character.isSpaceChar(chars.charAt(start2 + 1))) {
                findend = true;
            }
        } else {
            Integer n2 = snext;
            if (n2 != null && start2 == n2) {
                if (dir == Direction.BACKWARDS && !oneway) {
                    return start2;
                }
                int n3 = which = dir == Direction.FORWARDS ? 1 : 0;
                if (dir == Direction.BACKWARDS && oneway) {
                    findend = false;
                }
            } else {
                Integer n4 = enext;
                if (n4 != null && start2 == n4) {
                    if (dir == Direction.FORWARDS && !oneway) {
                        return start2;
                    }
                    which = 0;
                    if (dir == Direction.FORWARDS && oneway) {
                        findend = true;
                    }
                } else if ((sprev == null || start2 >= sprev) && (enext == null || start2 <= enext && snext != null && enext < snext)) {
                    which = dir == Direction.FORWARDS ? 1 : 0;
                } else {
                    int n5 = which = dir == Direction.FORWARDS ? 0 : 1;
                    if (dir == Direction.FORWARDS) {
                        if (oneway) {
                            if (snext != null && start2 < snext - 1) {
                                findend = true;
                            } else if (snext != null && start2 == snext - 1) {
                                ++count2;
                            }
                        } else {
                            findend = true;
                        }
                    } else if (oneway) {
                        if (eprev != null && start2 > eprev + 1) {
                            findend = false;
                        } else if (eprev != null && start2 == eprev + 1) {
                            ++count2;
                        }
                    } else {
                        findend = true;
                    }
                }
            }
        }
        Integer res2 = start2;
        while (count2 > 0 && res2 >= 0 && res2 <= max - 1) {
            block43: {
                block42: {
                    Integer n6 = res2 = toggle && which % 2 == 1 || isOuter && findend ? this.findSentenceEnd(editor, chars, res2, max, dir, false) : this.findSentenceStart(editor, chars, res2, max, dir, false);
                    if (n6 != null && n6 == 0) break block42;
                    Integer n7 = res2;
                    n = max - 1;
                    if ((n7 == null || n7 != n) && res2 != null) break block43;
                }
                --count2;
                break;
            }
            if (toggle) {
                if (which % 2 == 1 && dir == Direction.BACKWARDS) {
                    Integer n8 = res2;
                    res2 = n8 + 1;
                } else if (which % 2 == 0 && dir == Direction.FORWARDS) {
                    Integer n9 = res2;
                    res2 = n9 + -1;
                }
            }
            ++which;
            --count2;
        }
        if (res2 == null || count2 > 0) {
            res2 = dir == Direction.FORWARDS ? Integer.valueOf(max > 0 ? max - 1 : 0) : Integer.valueOf(0);
        } else if (isOuter && (dir == Direction.BACKWARDS && findend || dir == Direction.FORWARDS && !findend) && res2 != 0) {
            n = max - 1;
            if (res2 != n) {
                res2 = res2 - dir.toInt();
            }
        }
        if (chars.charAt(res2) == '\n' && res2 > 0 && chars.charAt(res2 - 1) != '\n') {
            Integer n10 = res2;
            res2 = n10 + -1;
        }
        return res2;
    }

    @Override
    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public TextRange findSentenceRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        CharSequence chars = editor.text();
        if (chars.length() == 0) {
            return new TextRange(0, 0);
        }
        int max = (int)editor.fileSize();
        int offset = caret.getOffset().getPoint();
        int ssel = caret.getSelectionStart();
        int esel = caret.getSelectionEnd();
        if (Math.abs(esel - ssel) > 1) {
            int start2 = 0;
            int end = 0;
            if (offset == esel - 1) {
                start2 = ssel;
                end = this.findSentenceRangeEnd(editor, chars, offset, max, count, isOuter, true);
                textRange = new TextRange(start2, end + 1);
            } else {
                end = esel - 1;
                start2 = this.findSentenceRangeEnd(editor, chars, offset, max, -count, isOuter, true);
                textRange = new TextRange(end, start2 + 1);
            }
        } else {
            int end = this.findSentenceRangeEnd(editor, chars, offset, max, count, isOuter, false);
            boolean space = isOuter;
            if (Character.isSpaceChar(chars.charAt(end))) {
                space = false;
            }
            int start3 = this.findSentenceRangeEnd(editor, chars, offset, max, -1, space, false);
            textRange = new TextRange(start3, end + 1);
        }
        return textRange;
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public Integer findNextParagraph(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean allowBlanks) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Integer n = this.findNextParagraphLine(editor, caret.getBufferPosition().getLine(), count, allowBlanks);
        if (n == null) {
            return null;
        }
        int line = n;
        int lineCount = editor.nativeLineCount();
        return line == lineCount - 1 ? Integer.valueOf(count > 0 ? (int)editor.fileSize() - 1 : 0) : Integer.valueOf(editor.getLineStartOffset(line));
    }

    @Contract(pure=true)
    private final int findNextParagraph(VimEditor editor, int startLine, Direction direction, boolean allowBlanks) {
        Integer line = this.findNextParagraphLine(editor, startLine, direction, allowBlanks);
        return line == null ? (direction == Direction.FORWARDS ? (int)editor.fileSize() - 1 : 0) : editor.getLineStartOffset(line);
    }

    @Override
    @Contract(pure=true)
    @Nullable
    public TextRange findParagraphRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int line = caret.getBufferPosition().getLine();
        if (logger.isDebug()) {
            logger.debug("Starting paragraph range search on line " + line);
        }
        Pair<Integer, Integer> pair = isOuter ? this.findOuterParagraphRange(editor, line, count) : this.findInnerParagraphRange(editor, line, count);
        if (pair == null) {
            return null;
        }
        Pair<Integer, Integer> rangeInfo = pair;
        int startLine = ((Number)rangeInfo.getFirst()).intValue();
        int endLine = ((Number)rangeInfo.getSecond()).intValue();
        if (logger.isDebug()) {
            logger.debug("final start line= " + startLine);
            logger.debug("final end line= " + endLine);
        }
        int start2 = editor.getLineStartOffset(startLine);
        int end = editor.getLineStartOffset(endLine);
        return new TextRange(start2, end + 1);
    }

    @Contract(pure=true)
    private final Pair<Integer, Integer> findOuterParagraphRange(VimEditor editor, int line, int count) {
        int n;
        boolean expandStart = false;
        boolean expandEnd = false;
        if (EngineEditorHelperKt.isLineEmpty(editor, line, true)) {
            n = line;
        } else {
            Integer n2 = this.findNextParagraphLine(editor, line, -1, true);
            if (n2 != null) {
                n = n2;
            } else {
                return null;
            }
        }
        int startLine = n;
        Integer n3 = this.findNextParagraphLine(editor, line, count, true);
        if (n3 == null) {
            return null;
        }
        int endLine = n3;
        if (EngineEditorHelperKt.isLineEmpty(editor, startLine, true) && EngineEditorHelperKt.isLineEmpty(editor, endLine, true)) {
            if (startLine == line) {
                --endLine;
                expandStart = true;
            } else {
                ++startLine;
                expandEnd = true;
            }
        } else if (!EngineEditorHelperKt.isLineEmpty(editor, endLine, true) && !EngineEditorHelperKt.isLineEmpty(editor, startLine, true) && startLine > 0) {
            --startLine;
            expandStart = true;
        } else {
            expandStart = EngineEditorHelperKt.isLineEmpty(editor, startLine, true);
            expandEnd = EngineEditorHelperKt.isLineEmpty(editor, endLine, true);
        }
        if (expandStart) {
            int n4 = startLine = EngineEditorHelperKt.isLineEmpty(editor, startLine, true) ? this.findLastEmptyLine(editor, startLine, Direction.BACKWARDS) : startLine;
        }
        if (expandEnd) {
            endLine = EngineEditorHelperKt.isLineEmpty(editor, endLine, true) ? this.findLastEmptyLine(editor, endLine, Direction.FORWARDS) : endLine;
        }
        return new Pair((Object)startLine, (Object)endLine);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Pair<Integer, Integer> findInnerParagraphRange(VimEditor editor, int line, int count) {
        int lineCount = editor.lineCount();
        int startLine = line;
        int endLine = 0;
        if (!EngineEditorHelperKt.isLineEmpty(editor, startLine, true)) {
            Integer n = this.findNextParagraphLine(editor, line, -1, true);
            if (n == null) {
                return null;
            }
            startLine = n;
            if (EngineEditorHelperKt.isLineEmpty(editor, startLine, true)) {
                ++startLine;
            }
            endLine = line;
        } else {
            endLine = line - 1;
        }
        int which = EngineEditorHelperKt.isLineEmpty(editor, startLine, true) ? 0 : 1;
        for (int i = 0; i < count; ++i) {
            if (which % 2 == 1) {
                int n;
                Integer nextParagraphLine = this.findNextParagraphLine(editor, endLine, Direction.FORWARDS, true);
                if (nextParagraphLine == null || nextParagraphLine == 0) {
                    if (i != count - 1) return null;
                    n = lineCount - 1;
                } else {
                    n = nextParagraphLine - 1;
                }
                endLine = n;
            } else {
                ++endLine;
            }
            ++which;
        }
        startLine = EngineEditorHelperKt.isLineEmpty(editor, startLine, true) ? this.findLastEmptyLine(editor, startLine, Direction.BACKWARDS) : startLine;
        endLine = EngineEditorHelperKt.isLineEmpty(editor, endLine, true) ? this.findLastEmptyLine(editor, endLine, Direction.FORWARDS) : endLine;
        return new Pair((Object)startLine, (Object)endLine);
    }

    @Contract(pure=true)
    private final int findLastEmptyLine(VimEditor editor, int line, Direction direction) {
        int n;
        if (!EngineEditorHelperKt.isLineEmpty(editor, line, true)) {
            logger.error("Method findLastEmptyLine was called for non-empty line");
            return line;
        }
        if (direction == Direction.BACKWARDS) {
            int previousNonEmptyLine = this.skipEmptyLines(editor, line, Direction.BACKWARDS, true);
            n = previousNonEmptyLine + 1;
        } else {
            int nextNonEmptyLine = this.skipEmptyLines(editor, line, Direction.FORWARDS, true);
            n = nextNonEmptyLine - 1;
        }
        return n;
    }

    @Contract(pure=true)
    private final Integer findNextParagraphLine(VimEditor editor, int startLine, int count, boolean allowBlanks) {
        int i;
        Integer line = startLine;
        int lineCount = editor.lineCount();
        Direction direction = count > 0 ? Direction.FORWARDS : Direction.BACKWARDS;
        for (i = Math.abs(count); i > 0 && line != null; --i) {
            line = this.findNextParagraphLine(editor, (int)line, direction, allowBlanks);
        }
        if (count != 0 && i == 0 && line == null) {
            line = direction == Direction.FORWARDS ? Integer.valueOf(lineCount - 1) : Integer.valueOf(0);
        }
        return line;
    }

    @Contract(pure=true)
    private final Integer findNextParagraphLine(VimEditor editor, int startLine, Direction direction, boolean allowBlanks) {
        int line = this.skipEmptyLines(editor, startLine, direction, allowBlanks);
        while (true) {
            boolean bl = 0 <= line ? line < editor.nativeLineCount() : false;
            if (!bl) break;
            if (EngineEditorHelperKt.isLineEmpty(editor, line, allowBlanks)) {
                return line;
            }
            line += direction.toInt();
        }
        return null;
    }

    @Contract(pure=true)
    private final int skipEmptyLines(VimEditor editor, int startLine, Direction direction, boolean allowBlanks) {
        int i = startLine;
        while (true) {
            boolean bl = 0 <= i ? i < editor.nativeLineCount() : false;
            if (!bl || !EngineEditorHelperKt.isLineEmpty(editor, i, allowBlanks)) break;
            i += direction.toInt();
        }
        return i;
    }

    @Override
    @NotNull
    public TextRange findWordUnderCursor(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, int dir, boolean isOuter, boolean isBig, boolean hasSelection) {
        boolean goForward;
        boolean goBack;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        logger.debug("count=" + count);
        logger.debug("dir=" + dir);
        logger.debug("isOuter=" + isOuter);
        logger.debug("isBig=" + isBig);
        logger.debug("hasSelection=" + hasSelection);
        CharSequence chars = editor.text();
        int min = 0;
        int max = (int)editor.fileSize();
        if (max == 0) {
            return new TextRange(0, 0);
        }
        logger.debug("min=" + min);
        logger.debug("max=" + max);
        int pos = caret.getOffset().getPoint();
        if (chars.length() <= pos) {
            return new TextRange(chars.length() - 1, chars.length() - 1);
        }
        boolean startSpace = CharacterHelper.charType(editor, chars.charAt(pos), isBig) == CharacterHelper.CharacterType.WHITESPACE;
        boolean onWordStart = pos == 0 || CharacterHelper.charType(editor, chars.charAt(pos - 1), isBig) != CharacterHelper.charType(editor, chars.charAt(pos), isBig);
        int start2 = pos;
        logger.debug("pos=" + pos);
        logger.debug("onWordStart=" + onWordStart);
        if (!onWordStart && (!startSpace || !isOuter) || hasSelection || count > 1 && dir == -1) {
            start2 = dir == 1 ? this.findNextWord(editor, pos, -1, isBig, !isOuter) : this.findNextWord(editor, pos, -(count - (onWordStart && !hasSelection ? 1 : 0)), isBig, !isOuter);
            start2 = EngineEditorHelperKt.normalizeOffset(editor, start2, false);
        }
        logger.debug("start=" + start2);
        boolean onWordEnd = pos >= max - 1 || CharacterHelper.charType(editor, chars.charAt(pos + 1), isBig) != CharacterHelper.charType(editor, chars.charAt(pos), isBig);
        logger.debug("onWordEnd=" + onWordEnd);
        int end = pos;
        if (!onWordEnd || hasSelection || count > 1 && dir == 1 || startSpace && isOuter) {
            int n;
            if (dir == 1) {
                int c = count - (onWordEnd && !hasSelection && (!startSpace || !isOuter || startSpace && !isOuter) ? 1 : 0);
                n = this.findNextWordEnd(editor, pos, c, isBig, !isOuter);
            } else {
                n = this.findNextWordEnd(editor, pos, 1, isBig, !isOuter);
            }
            end = n;
        }
        logger.debug("end=" + end);
        boolean bl = goBack = startSpace && !hasSelection || !startSpace && hasSelection && !onWordStart;
        if (dir == 1 && isOuter) {
            int firstEnd = end;
            if (count > 1) {
                firstEnd = this.findNextWordEnd(editor, pos, 1, isBig, false);
            }
            if (firstEnd < max - 1 && CharacterHelper.charType(editor, chars.charAt(firstEnd + 1), false) != CharacterHelper.CharacterType.WHITESPACE) {
                goBack = true;
            }
        }
        if (dir == -1 && isOuter && startSpace && pos > 0 && CharacterHelper.charType(editor, chars.charAt(pos - 1), false) != CharacterHelper.CharacterType.WHITESPACE) {
            goBack = true;
        }
        boolean bl2 = goForward = dir == 1 && isOuter && (!startSpace && !onWordEnd || startSpace && onWordEnd && hasSelection);
        if (!goForward && dir == 1 && isOuter) {
            int firstEnd = end;
            if (count > 1) {
                firstEnd = this.findNextWordEnd(editor, pos, 1, isBig, false);
            }
            if (firstEnd < max - 1 && CharacterHelper.charType(editor, chars.charAt(firstEnd + 1), false) != CharacterHelper.CharacterType.WHITESPACE) {
                goForward = true;
            }
        }
        if (!goForward && dir == 1 && isOuter && !startSpace && !hasSelection && end < max - 1 && CharacterHelper.charType(editor, chars.charAt(end + 1), !isBig) != CharacterHelper.charType(editor, chars.charAt(end), !isBig)) {
            goForward = true;
        }
        logger.debug("goBack=" + goBack);
        logger.debug("goForward=" + goForward);
        if (goForward && EngineEditorHelperKt.anyNonWhitespace(editor, end, 1)) {
            while (end + 1 < max && CharacterHelper.charType(editor, chars.charAt(end + 1), false) == CharacterHelper.CharacterType.WHITESPACE) {
                ++end;
            }
        }
        if (goBack && EngineEditorHelperKt.anyNonWhitespace(editor, start2, -1)) {
            while (start2 > 0 && CharacterHelper.charType(editor, chars.charAt(start2 - 1), false) == CharacterHelper.CharacterType.WHITESPACE) {
                --start2;
            }
        }
        logger.debug("start=" + start2);
        logger.debug("end=" + end);
        return new TextRange(start2, end + 1);
    }

    @Override
    @Nullable
    public TextRange findBlockTagRange(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean isOuter) {
        int selectionEndWithoutNewline;
        TextRange openingTag;
        TextRange closingTagTextRange;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        int counter = count;
        boolean isOuterVariable = isOuter;
        int position = caret.getOffset().getPoint();
        CharSequence sequence = editor.text();
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        boolean isRangeSelection = selectionEnd - selectionStart > 1;
        int searchStartPosition = 0;
        if (!isRangeSelection) {
            int line = caret.getBufferPosition().getLine();
            int lineBegin = editor.getLineStartOffset(line);
            n = this.ignoreWhitespaceAtLineStart(sequence, lineBegin, position);
        } else {
            n = searchStartPosition = selectionEnd;
        }
        if (this.isInHTMLTag(sequence, searchStartPosition, false)) {
            while (searchStartPosition < sequence.length() && sequence.charAt(searchStartPosition) != '>') {
                ++searchStartPosition;
            }
        } else if (this.isInHTMLTag(sequence, searchStartPosition, true)) {
            while (searchStartPosition > 0 && sequence.charAt(searchStartPosition) != '<') {
                --searchStartPosition;
            }
        }
        while (true) {
            Pair<TextRange, String> pair;
            if (this.findUnmatchedClosingTag(sequence, searchStartPosition, counter) == null) {
                return null;
            }
            closingTagTextRange = (TextRange)pair.component1();
            String tagName = (String)pair.component2();
            if (this.findUnmatchedOpeningTag(sequence, closingTagTextRange.getStartOffset(), tagName) == null) {
                return null;
            }
            if (!isRangeSelection || openingTag.getEndOffset() - 1 < selectionStart) break;
            searchStartPosition = closingTagTextRange.getEndOffset();
            counter = 1;
        }
        for (selectionEndWithoutNewline = selectionEnd; selectionEndWithoutNewline < sequence.length() && sequence.charAt(selectionEndWithoutNewline) == '\n'; ++selectionEndWithoutNewline) {
        }
        Mode mode = VimStateMachine.Companion.getInstance(editor).getMode();
        if (mode instanceof Mode.VISUAL) {
            if (closingTagTextRange.getStartOffset() == selectionEndWithoutNewline && openingTag.getEndOffset() == selectionStart) {
                isOuterVariable = true;
            } else if (openingTag.getEndOffset() == closingTagTextRange.getStartOffset() && selectionStart == openingTag.getEndOffset()) {
                isOuterVariable = true;
            }
        }
        return isOuterVariable ? new TextRange(openingTag.getStartOffset(), closingTagTextRange.getEndOffset()) : new TextRange(openingTag.getEndOffset(), closingTagTextRange.getStartOffset());
    }

    private final int ignoreWhitespaceAtLineStart(CharSequence seq, int lineStart, int pos) {
        int position = pos;
        if (seq.subSequence(lineStart, position).chars().allMatch(VimSearchHelperBase::ignoreWhitespaceAtLineStart$lambda$2)) {
            while (position < seq.length() && seq.charAt(position) != '\n' && Character.isWhitespace(seq.charAt(position))) {
                ++position;
            }
        }
        return position;
    }

    private final boolean isInHTMLTag(CharSequence sequence, int position, boolean isEndtag) {
        boolean hasSlashAfterOpening;
        int openingBracket = 0;
        openingBracket = -1;
        VimSearchHelperBase $this$isInHTMLTag_u24lambda_u243 = this;
        boolean bl = false;
        for (int i = position; i >= 0 && i < sequence.length(); --i) {
            if (sequence.charAt(i) == '<') {
                openingBracket = i;
                break;
            }
            if (sequence.charAt(i) != '>' || i == position) continue;
            return false;
        }
        if (openingBracket == -1) {
            return false;
        }
        boolean bl2 = hasSlashAfterOpening = openingBracket + 1 < sequence.length() && sequence.charAt(openingBracket + 1) == '/';
        if (isEndtag && !hasSlashAfterOpening || !isEndtag && hasSlashAfterOpening) {
            return false;
        }
        int closingBracket = -1;
        int n = sequence.length();
        for (int i = openingBracket; i < n; ++i) {
            if (sequence.charAt(i) != '>') continue;
            closingBracket = i;
            break;
        }
        return closingBracket != -1 && sequence.charAt(closingBracket - 1) != '/';
    }

    private final TextRange findUnmatchedOpeningTag(CharSequence sequence, int position, String tagName) {
        String quotedTagName = Pattern.quote(tagName);
        String patternString = "(</%s>)|(<%s(\\s([^>]*[^/])?)?>)";
        Object[] objectArray = new Object[]{quotedTagName, quotedTagName};
        String string = String.format(patternString, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        Pattern tagPattern = Pattern.compile(string, 2);
        Matcher matcher = tagPattern.matcher(sequence.subSequence(0, position + 1));
        Deque openTags = new ArrayDeque();
        while (matcher.find()) {
            TextRange match = new TextRange(matcher.start(), matcher.end());
            if (sequence.charAt(matcher.start() + 1) == '/') {
                if (openTags.isEmpty()) continue;
                openTags.pop();
                continue;
            }
            openTags.push(match);
        }
        return openTags.isEmpty() ? null : (TextRange)openTags.pop();
    }

    private final Pair<TextRange, String> findUnmatchedClosingTag(CharSequence sequence, int position, int count) {
        int counter = count;
        String tagNamePattern = "([^/\\s>]+)";
        String string = "<%s(?:\\s[^>]*)?>";
        Object object = new Object[]{tagNamePattern};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String openingTagPattern = string2;
        object = "</%s>";
        Object object2 = new Object[]{tagNamePattern};
        String string3 = String.format((String)object, Arrays.copyOf(object2, ((Object[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String closingTagPattern = string3;
        object2 = "(?:%s)|(?:%s)";
        Object[] objectArray = new Object[]{openingTagPattern, closingTagPattern};
        String string4 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        Pattern tagPattern = Pattern.compile(string4);
        Matcher matcher = tagPattern.matcher(sequence.subSequence(position, sequence.length()));
        Deque openTags = new ArrayDeque();
        while (matcher.find()) {
            String tagName;
            boolean isClosingTag;
            boolean bl = isClosingTag = matcher.group(1) == null;
            if (isClosingTag) {
                tagName = matcher.group(2);
                while (!openTags.isEmpty() && !StringsKt.equals((String)((String)openTags.peek()), (String)tagName, (boolean)true)) {
                    openTags.pop();
                }
                if (openTags.isEmpty()) {
                    if (counter <= 1) {
                        return new Pair((Object)new TextRange(position + matcher.start(), position + matcher.end()), (Object)tagName);
                    }
                    --counter;
                    continue;
                }
                openTags.pop();
                continue;
            }
            tagName = matcher.group(1);
            openTags.push(tagName);
        }
        return null;
    }

    private static final boolean ignoreWhitespaceAtLineStart$lambda$2(int codePoint) {
        return Character.isWhitespace(codePoint);
    }

    public static final /* synthetic */ int access$findNextWordOne(VimSearchHelperBase $this, VimEditor editor, int pos, int size, int step, boolean bigWord, boolean spaceWords) {
        return $this.findNextWordOne(editor, pos, size, step, bigWord, spaceWords);
    }

    public static final /* synthetic */ int access$findNextWordEndOne(VimSearchHelperBase $this, VimEditor editor, int pos, int size, int step, boolean bigWord, boolean spaceWords) {
        return $this.findNextWordEndOne(editor, pos, size, step, bigWord, spaceWords);
    }

    static {
        boolean $i$f$vimLogger = false;
        logger = VimInjectorKt.getInjector().getLogger(VimSearchHelperBase.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchHelperBase$Companion;", "", "()V", "logger", "Lcom/maddyhome/idea/vim/diagnostic/VimLogger;", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

